/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.BasicBufferStrategy;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IRootBlockView;
import java.io.File;
import java.nio.ByteBuffer;

public class TransientBufferStrategy
extends BasicBufferStrategy {
    private final IRootBlockView[] rootBlocks = new IRootBlockView[2];
    private int currentRootBlock = 0;

    TransientBufferStrategy(int offsetBits, long initialExtent, long maximumExtent, boolean useDirectBuffers) {
        super(maximumExtent, offsetBits, 0L, 0, initialExtent, BufferMode.Transient, useDirectBuffers ? ByteBuffer.allocateDirect((int)initialExtent) : ByteBuffer.allocate((int)initialExtent), false);
    }

    @Override
    public void deleteResources() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void force(boolean metadata) {
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public final boolean isStable() {
        return false;
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        this.currentRootBlock = rootBlock.isRootBlock0() ? 0 : 1;
        this.rootBlocks[this.currentRootBlock] = rootBlock;
    }

    @Override
    public final int getHeaderSize() {
        return 0;
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        return this.rootBlocks[rootBlock0 ? 0 : 1].asReadOnlyBuffer();
    }

    public void setNextOffset(long lastOffset) {
    }
}

