/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.ICounter;
import com.bigdata.htree.HTree;

public class Counter
implements ICounter {
    private final HTree htree;

    public Counter(HTree btree) {
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        this.htree = btree;
    }

    @Override
    public long get() {
        return this.htree.counter.get();
    }

    @Override
    public long incrementAndGet() {
        long counter = this.htree.counter.incrementAndGet();
        if (counter == this.htree.getCheckpoint().getCounter() + 1L) {
            this.htree.fireDirtyEvent();
        }
        if (counter == 0L) {
            throw new RuntimeException("Counter overflow");
        }
        return counter;
    }
}

