/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.halog;

import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.journal.IRootBlockView;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;

public interface IHALogReader {
    public static final String HA_LOG_EXT = ".ha-log";
    public static final FileFilter HALOG_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(IHALogReader.HA_LOG_EXT);
        }
    };

    public void close() throws IOException;

    public boolean isEmpty();

    public boolean isOpen();

    public IRootBlockView getOpeningRootBlock() throws IOException;

    public IRootBlockView getClosingRootBlock() throws IOException;

    public boolean hasMoreBuffers() throws IOException;

    public IHAWriteMessage processNextBuffer(ByteBuffer var1) throws IOException;

    public void computeDigest(MessageDigest var1) throws DigestException, IOException;

    public boolean isLive();
}

