/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.HAReadGlue;
import com.bigdata.ha.QuorumRead;
import com.bigdata.ha.msg.HAReadRequest;
import com.bigdata.ha.msg.IHAReadResponse;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.quorum.QuorumStateChangeListenerBase;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class QuorumReadImpl<S extends HAReadGlue>
extends QuorumStateChangeListenerBase
implements QuorumRead<S> {
    private static final transient Logger log = Logger.getLogger(QuorumReadImpl.class);
    protected final QuorumMember<S> member;
    private final AtomicInteger nextIndex = new AtomicInteger();

    public QuorumReadImpl(QuorumMember<S> member) {
        this.member = member;
    }

    protected UUID getNextBadReadServiceId(UUID[] joinedServiceIds) {
        int i;
        UUID serviceId = this.member.getServiceId();
        while (serviceId.equals(joinedServiceIds[i = this.nextIndex.incrementAndGet() % joinedServiceIds.length])) {
        }
        return joinedServiceIds[i];
    }

    @Override
    public byte[] readFromQuorum(UUID storeId, long addr) throws InterruptedException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("storeId=" + storeId + ", addr=" + addr));
        }
        if (storeId == null) {
            throw new IllegalArgumentException();
        }
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.member.getQuorum().isHighlyAvailable()) {
            throw new IllegalStateException();
        }
        long token = this.member.getQuorum().awaitQuorum();
        UUID[] joinedServiceIds = this.member.getQuorum().getJoined();
        UUID otherId = this.getNextBadReadServiceId(joinedServiceIds);
        HAReadGlue otherService = (HAReadGlue)this.member.getService(otherId);
        HAReadRequest msg = new HAReadRequest(token, storeId, addr);
        try {
            Future<IHAReadResponse> rf = otherService.readFromDisk(msg);
            byte[] a = rf.get().getData();
            this.member.getQuorum().assertQuorum(token);
            return a;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

