/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Pattern;

public abstract class AbstractCounterSet
implements ICounterSet {
    protected final String name;
    protected AbstractCounterSet parent;

    protected AbstractCounterSet(String name, CounterSet parent) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parent = parent;
    }

    @Override
    public AbstractCounterSet getRoot() {
        AbstractCounterSet t = this;
        while (t.parent != null) {
            t = t.parent;
        }
        return t;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ICounterSet[] getPathComponents() {
        int depth = 0;
        AbstractCounterSet t = this;
        while (t.parent != null) {
            t = t.parent;
            ++depth;
        }
        ICounterSet[] a = new CounterSet[depth + 1];
        int index = a.length - 1;
        AbstractCounterSet t2 = this;
        while (t2.parent != null) {
            a[index--] = t2;
            t2 = t2.parent;
        }
        a[index] = t2;
        return a;
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return "/";
        }
        if (this.parent.parent == null) {
            return this.parent.getPath() + this.name;
        }
        return this.parent.getPath() + "/" + this.name;
    }

    @Override
    public int getDepth() {
        int depth = 0;
        ICounterSet t = this;
        while (!t.isRoot()) {
            t = t.getParent();
            ++depth;
        }
        return depth;
    }

    @Override
    public ICounterNode getPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (path.equals("/")) {
            return this.getRoot();
        }
        if (path.contains("//")) {
            throw new IllegalArgumentException(path);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
            if (this.parent != null) {
                return this.getRoot().getPath(path);
            }
        }
        String[] a = path.split("/");
        ICounterNode t = this;
        for (int i = 0; i < a.length; ++i) {
            String name = a[i];
            if ((t = t.getChild(name)) != null) continue;
            return null;
        }
        return t;
    }

    @Override
    public ICounterSet getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Pattern filter) {
        StringBuilder sb = new StringBuilder();
        Iterator<ICounter> itr = this.getCounters(filter);
        while (itr.hasNext()) {
            ICounter c = itr.next();
            sb.append("\n" + c.getPath() + "=" + c.getValue());
        }
        return sb.toString();
    }

    @Override
    public final boolean isCounterSet() {
        return true;
    }

    @Override
    public final boolean isCounter() {
        return false;
    }

    @Override
    public void asXML(OutputStream os, String encoding, Pattern filter) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os, encoding);
        this.asXML(w, encoding, filter);
    }

    public void asXML(Writer w, String encoding, Pattern filter) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>");
        this.asXML(w, filter);
    }

    @Override
    public String asXML(Pattern filter) {
        StringWriter w = new StringWriter();
        try {
            this.asXML(w, filter);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected exception: " + ex, ex);
        }
        return w.toString();
    }
}

