/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.config;

import com.bigdata.config.ConfigurationException;
import com.bigdata.config.IValidator;

public class IntegerValidator
implements IValidator<Integer> {
    public static final transient IValidator<Integer> DEFAULT = new IntegerValidator();
    public static final transient IValidator<Integer> GTE_ZERO = new IntegerValidator(){

        @Override
        public void accept(String key, String val, Integer arg) {
            if (arg < 0) {
                throw new ConfigurationException(key, val, "Must be non-negative");
            }
        }
    };
    public static final transient IValidator<Integer> GT_ZERO = new IntegerValidator(){

        @Override
        public void accept(String key, String val, Integer arg) {
            if (arg <= 0) {
                throw new ConfigurationException(key, val, "Must be positive");
            }
        }
    };

    @Override
    public Integer parse(String key, String val) {
        return Integer.parseInt(val);
    }

    @Override
    public void accept(String key, String val, Integer arg) throws ConfigurationException {
    }
}

