/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.NoSuccessorException;

public class SuccessorUtil {
    public static final float FPOS_ZERO = Float.intBitsToFloat(0);
    public static final float FNEG_ZERO = Float.intBitsToFloat(Integer.MIN_VALUE);
    public static final float FPOS_MIN = Float.intBitsToFloat(1);
    public static final float FNEG_MIN = Float.intBitsToFloat(-2147483647);
    public static final float FPOS_ONE = 1.0f;
    public static final float FNEG_ONE = -1.0f;
    public static final float FPOS_MAX = Float.MAX_VALUE;
    public static final float FNEG_MAX = Float.intBitsToFloat(-8388609);
    public static final double DPOS_ZERO = Double.longBitsToDouble(0L);
    public static final double DNEG_ZERO = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final double DPOS_MIN = Double.longBitsToDouble(1L);
    public static final double DNEG_MIN = Double.longBitsToDouble(-9223372036854775807L);
    public static final double DPOS_ONE = 1.0;
    public static final double DNEG_ONE = -1.0;
    public static final double DPOS_MAX = Double.MAX_VALUE;
    public static final double DNEG_MAX = Double.longBitsToDouble(-4503599627370497L);

    public static byte successor(byte n) throws NoSuccessorException {
        if (127 == n) {
            throw new NoSuccessorException();
        }
        return (byte)(n + 1);
    }

    public static char successor(char n) throws NoSuccessorException {
        if ('\uffff' == n) {
            throw new NoSuccessorException();
        }
        return (char)(n + '\u0001');
    }

    public static short successor(short n) throws NoSuccessorException {
        if (Short.MAX_VALUE == n) {
            throw new NoSuccessorException();
        }
        return (short)(n + 1);
    }

    public static int successor(int n) throws NoSuccessorException {
        if (Integer.MAX_VALUE == n) {
            throw new NoSuccessorException();
        }
        return n + 1;
    }

    public static long successor(long n) throws NoSuccessorException {
        if (Long.MAX_VALUE == n) {
            throw new NoSuccessorException();
        }
        return n + 1L;
    }

    public static float successor(float f) throws NoSuccessorException {
        if (f == Float.MAX_VALUE) {
            return Float.POSITIVE_INFINITY;
        }
        if (Float.isNaN(f)) {
            throw new NoSuccessorException("NaN");
        }
        if (Float.isInfinite(f)) {
            if (f > 0.0f) {
                throw new NoSuccessorException("Positive Infinity");
            }
            throw new NoSuccessorException("Negative Infinity");
        }
        int bits = Float.floatToIntBits(f);
        if (bits == Integer.MIN_VALUE) {
            return 0.0f;
        }
        bits = f >= 0.0f ? ++bits : --bits;
        float nxt = Float.intBitsToFloat(bits);
        return nxt;
    }

    public static double successor(double d) throws NoSuccessorException {
        if (d == Double.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(d)) {
            throw new NoSuccessorException("Nan");
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                throw new NoSuccessorException("Positive Infinity");
            }
            return Double.MIN_VALUE;
        }
        long bits = Double.doubleToLongBits(d);
        if (bits == Long.MIN_VALUE) {
            return 0.0;
        }
        bits = d >= 0.0 ? ++bits : --bits;
        double nxt = Double.longBitsToDouble(bits);
        return nxt;
    }

    public static String successor(String s) {
        if (s == null) {
            return "\u0000";
        }
        return s + "\u0000";
    }

    public static byte[] successor(byte[] b) {
        return SuccessorUtil.successor(b, 0, b.length);
    }

    public static byte[] successor(byte[] b, int off, int len) {
        if (len == 0) {
            throw new NoSuccessorException("Empty byte[]");
        }
        boolean overflow = false;
        int i = off + len - 1;
        while (i >= off) {
            overflow = b[i] == -1;
            int n = i--;
            b[n] = (byte)(b[n] + 1);
            if (overflow) continue;
            return b;
        }
        throw new NoSuccessorException("Overflow");
    }
}

