/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.INodeIterator;
import com.bigdata.btree.Node;
import java.lang.ref.Reference;
import java.util.NoSuchElementException;

class DirtyChildIterator
implements INodeIterator {
    private final Node node;
    private int index = 0;
    private int lastVisited = -1;
    private AbstractNode<?> child = null;

    public DirtyChildIterator(Node node) {
        assert (node != null);
        this.node = node;
    }

    @Override
    public boolean hasNext() {
        if (this.child != null && this.child.isDirty()) {
            return true;
        }
        int nkeys = this.node.getKeyCount();
        while (this.index <= nkeys) {
            Reference<AbstractNode<?>> childRef = this.node.getChildRef(this.index);
            if (childRef != null) {
                this.child = childRef.get();
                if (this.child != null && this.child.isDirty()) break;
            }
            ++this.index;
        }
        return this.index <= nkeys;
    }

    @Override
    public AbstractNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.child != null);
        assert (this.child.isDirty());
        AbstractNode<?> tmp = this.child;
        this.lastVisited = this.index++;
        this.child = null;
        return tmp;
    }

    @Override
    public AbstractNode getNode() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        return this.node.getChild(this.lastVisited);
    }

    @Override
    public Object getKey() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        return this.node.getKeys().get(this.lastVisited);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

