/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.paths;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.IDistinctFilter;
import com.bigdata.bop.join.JVMDistinctFilter;
import com.bigdata.bop.paths.ArbitraryLengthPathOp;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ArbitraryLengthPathTask
implements Callable<Void> {
    private static final Logger log = Logger.getLogger(ArbitraryLengthPathOp.class);
    private final BOpContext<IBindingSet> context;
    private final PipelineOp subquery;
    private final Gearing forwardGearing;
    private final Gearing reverseGearing;
    private final long lowerBound;
    private final long upperBound;
    private final UnsynchronizedArrayBuffer<IBindingSet> out;
    private IDistinctFilter distinctVarFilter;
    private final Set<IVariable<?>> varsToRetain;
    private Set<IVariable<?>> projectInVars;
    private final IVariableOrConstant<?> middleTerm;
    private final IVariable<?> edgeVar;
    private final List<IVariable<?>> dropVars;

    public ArbitraryLengthPathTask(ArbitraryLengthPathOp controllerOp, BOpContext<IBindingSet> context) {
        if (controllerOp == null) {
            throw new IllegalArgumentException();
        }
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
        this.subquery = (PipelineOp)controllerOp.getRequiredProperty(ArbitraryLengthPathOp.Annotations.SUBQUERY);
        IVariableOrConstant leftTerm = (IVariableOrConstant)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.LEFT_TERM);
        IVariable leftVar = leftTerm.isVar() ? (IVariable)leftTerm : null;
        IConstant leftConst = leftTerm.isConstant() ? (IConstant)leftTerm : null;
        IVariableOrConstant rightTerm = (IVariableOrConstant)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.RIGHT_TERM);
        IVariable rightVar = rightTerm.isVar() ? (IVariable)rightTerm : null;
        IConstant rightConst = rightTerm.isConstant() ? (IConstant)rightTerm : null;
        IVariable tVarLeft = (IVariable)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.TRANSITIVITY_VAR_LEFT);
        IVariable tVarRight = (IVariable)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.TRANSITIVITY_VAR_RIGHT);
        this.forwardGearing = new Gearing(leftVar, rightVar, leftConst, rightConst, tVarLeft, tVarRight);
        this.reverseGearing = this.forwardGearing.reverse();
        this.lowerBound = (Long)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.LOWER_BOUND);
        this.upperBound = (Long)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.UPPER_BOUND);
        this.projectInVars = new LinkedHashSet();
        this.projectInVars.addAll(Arrays.asList((IVariable[])controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.PROJECT_IN_VARS)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("project in vars: " + this.projectInVars));
        }
        this.out = new UnsynchronizedArrayBuffer<IBindingSet>(context.getSink(), IBindingSet.class, controllerOp.getChunkCapacity());
        this.edgeVar = (IVariable)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.EDGE_VAR);
        this.middleTerm = (IVariableOrConstant)controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.MIDDLE_TERM);
        if (log.isDebugEnabled()) {
            log.debug((Object)("predVar: " + this.edgeVar));
            log.debug((Object)("middleTerm: " + this.middleTerm));
        }
        if (this.edgeVar != null && this.middleTerm == null) {
            throw new IllegalArgumentException("Must provide a middle term when edge var is present");
        }
        this.varsToRetain = new LinkedHashSet();
        if (leftVar != null) {
            this.varsToRetain.add(leftVar);
        } else {
            IVariable<?> leftVarInConst = this.getConstantHybridVariable(leftConst);
            if (leftVarInConst != null) {
                this.varsToRetain.add(leftVarInConst);
            }
        }
        if (rightVar != null) {
            this.varsToRetain.add(rightVar);
        } else {
            IVariable<?> rightVarInConst = this.getConstantHybridVariable(rightConst);
            if (rightVarInConst != null) {
                this.varsToRetain.add(rightVarInConst);
            }
        }
        if (this.edgeVar != null) {
            this.varsToRetain.add(this.edgeVar);
        }
        this.varsToRetain.addAll(this.projectInVars);
        IVariable[] varsToRetainList = this.varsToRetain.toArray(new IVariable[this.varsToRetain.size()]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("vars to retain: " + this.varsToRetain));
        }
        this.distinctVarFilter = new JVMDistinctFilter(varsToRetainList, controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.INITIAL_CAPACITY, 16), controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue(), 16);
        this.dropVars = controllerOp.getProperty(ArbitraryLengthPathOp.Annotations.DROP_VARS, new ArrayList());
        if (log.isDebugEnabled()) {
            log.debug((Object)("vars to drop: " + this.dropVars));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            ICloseableIterator<IBindingSet[]> sitr = this.context.getSource();
            if (!sitr.hasNext()) {
                this.processChunk(new IBindingSet[0]);
            } else {
                while (sitr.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])sitr.next();
                    this.processChunk(chunk);
                }
            }
            if (!this.out.isEmpty()) {
                this.out.flush();
            }
            this.context.getSink().flush();
            Void void_ = null;
            return void_;
        }
        finally {
            this.context.getSource().close();
            this.context.getSink().close();
            if (this.context.getSink2() != null) {
                this.context.getSink2().close();
            }
        }
    }

    private void processChunk(IBindingSet[] chunkIn) throws Exception {
        LinkedHashMap<SolutionKey, IBindingSet> solutions = new LinkedHashMap<SolutionKey, IBindingSet>();
        QueryEngine queryEngine = this.context.getRunningQuery().getQueryEngine();
        LinkedHashSet<IBindingSet> nextRoundInput = new LinkedHashSet<IBindingSet>();
        Gearing gearing = this.chooseGearing(chunkIn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("gearing: " + gearing));
        }
        for (IBindingSet parentSolutionIn : chunkIn) {
            IConstant seed;
            if (log.isDebugEnabled()) {
                log.debug((Object)("parent solution in: " + parentSolutionIn));
            }
            IBindingSet childSolutionIn = parentSolutionIn.clone();
            IConstant iConstant = seed = gearing.inConst != null ? gearing.inConst : childSolutionIn.get(gearing.inVar);
            if (log.isDebugEnabled()) {
                log.debug((Object)("seed: " + seed));
            }
            if (seed != null) {
                childSolutionIn.set(gearing.tVarIn, seed);
                if (this.lowerBound == 0L && this.canBind(gearing, childSolutionIn, seed)) {
                    IBindingSet bs = parentSolutionIn.clone();
                    bs.set(gearing.tVarIn, seed);
                    bs.set(gearing.tVarOut, seed);
                    this.storeAndEmit(bs, gearing, solutions);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("added a zero length path: " + bs));
                    }
                }
            }
            nextRoundInput.add(childSolutionIn);
        }
        if (log.isDebugEnabled()) {
            for (IBindingSet childSolutionIn : nextRoundInput) {
                log.debug((Object)("first round input: " + childSolutionIn));
            }
        }
        this.doIterate(solutions, queryEngine, nextRoundInput, gearing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIterate(Map<SolutionKey, IBindingSet> solutions, QueryEngine queryEngine, Set<IBindingSet> nextRoundInput, Gearing gearing) {
        boolean bonusRound = this.upperBound < Long.MAX_VALUE && this.edgeVar != null;
        long n = this.upperBound + (long)(bonusRound ? 1 : 0);
        LinkedHashSet<IConstant> visited = bonusRound ? new LinkedHashSet<IConstant>() : null;
        int i = 0;
        while ((long)i < n) {
            long sizeBefore = solutions.size();
            IHaltable runningSubquery = null;
            ICloseableIterator<IBindingSet[]> subquerySolutionItr = null;
            try {
                runningSubquery = queryEngine.eval((BOp)this.subquery, nextRoundInput.toArray(new IBindingSet[nextRoundInput.size()]));
                long subqueryChunksOut = 0L;
                long subquerySolutionsOut = 0L;
                try {
                    ((AbstractRunningQuery)this.context.getRunningQuery()).addChild((IRunningQuery)runningSubquery);
                    nextRoundInput.clear();
                    subquerySolutionItr = runningSubquery.iterator();
                    while (subquerySolutionItr.hasNext()) {
                        IBindingSet[] chunk = (IBindingSet[])subquerySolutionItr.next();
                        ++subqueryChunksOut;
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        for (IBindingSet bs : chunk) {
                            if (subquerySolutionsOut++ % 10L == 0L && Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("round " + i + " solution: " + bs));
                            }
                            if (gearing.inVar != null && !bs.isBound(gearing.inVar)) {
                                bs.set(gearing.inVar, bs.get(gearing.tVarIn));
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("adding binding for inVar: " + bs));
                                }
                            }
                            if (this.edgeVar != null && bs.get(this.edgeVar) != null) {
                                IConstant edge;
                                IConstant iConstant = edge = this.middleTerm.isConstant() ? (IConstant)this.middleTerm : bs.get((IVariable)this.middleTerm);
                                if (!bs.get(this.edgeVar).equals((IVariableOrConstant)edge)) continue;
                            }
                            if (bonusRound) {
                                IConstant out = bs.get(gearing.tVarOut);
                                if ((long)(i + 1) == n && !visited.contains(out)) continue;
                                visited.add(out);
                            }
                            this.storeAndEmit(bs, gearing, solutions);
                            if ((long)(i + 1) == n) continue;
                            IBindingSet input = bs.clone();
                            input.set(gearing.tVarIn, bs.get(gearing.tVarOut));
                            input.clear(gearing.tVarOut);
                            for (IVariable<?> var : this.dropVars) {
                                if (this.projectInVars.contains(var) || this.varsToRetain.contains(var) || var.equals((Object)gearing.inVar) || var.equals((Object)gearing.tVarIn)) continue;
                                input.clear(var);
                            }
                            nextRoundInput.add(input);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("remapped as input for next round: " + input));
                        }
                    }
                    subquerySolutionItr.close();
                    runningSubquery.get();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("done with round " + i + ", count=" + subqueryChunksOut + ", totalBefore=" + sizeBefore + ", totalAfter=" + solutions.size() + ", totalNew=" + ((long)solutions.size() - sizeBefore)));
                    }
                    if ((long)solutions.size() == sizeBefore) break;
                }
                catch (InterruptedException ex) {
                    runningSubquery.cancel(true);
                    throw ex;
                }
            }
            catch (Throwable t) {
                Throwable cause = runningSubquery != null && runningSubquery.getCause() != null ? runningSubquery.getCause() : t;
                throw new RuntimeException(this.context.getRunningQuery().halt(cause));
            }
            finally {
                try {
                    if (runningSubquery != null) {
                        runningSubquery.cancel(true);
                    }
                }
                finally {
                    if (subquerySolutionItr != null) {
                        subquerySolutionItr.close();
                    }
                }
            }
            ++i;
        }
        if (gearing.outConst != null) {
            Iterator<Map.Entry<SolutionKey, IBindingSet>> it = solutions.entrySet().iterator();
            while (it.hasNext()) {
                IBindingSet bs = it.next().getValue();
                if (bs.get(gearing.tVarOut).equals((IVariableOrConstant)gearing.outConst)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"transitive output does not match output const, dropping");
                    log.debug((Object)bs.get(gearing.tVarOut));
                    log.debug((Object)gearing.outConst);
                }
                it.remove();
            }
        }
        if (this.lowerBound == 0L && gearing.inVar != null && gearing.outVar != null) {
            LinkedHashMap<SolutionKey, IBindingSet> zlps = new LinkedHashMap<SolutionKey, IBindingSet>();
            for (IBindingSet bs : solutions.values()) {
                if (bs.isBound(gearing.outVar)) continue;
                IBindingSet zlp = bs.clone();
                zlp.set(gearing.tVarOut, zlp.get(gearing.inVar));
                SolutionKey key = this.newSolutionKey(gearing, zlp);
                if (!solutions.containsKey(key)) {
                    zlps.put(key, zlp);
                }
                zlp = bs.clone();
                zlp.set(gearing.inVar, zlp.get(gearing.tVarOut));
                key = this.newSolutionKey(gearing, zlp);
                if (solutions.containsKey(key)) continue;
                zlps.put(key, zlp);
            }
            for (SolutionKey key : zlps.keySet()) {
                this.storeAndEmit(key, (IBindingSet)zlps.get(key), gearing, solutions);
            }
        }
    }

    private boolean canBind(Gearing gearing, IBindingSet childSolutionIn, IConstant<?> seed) {
        if (gearing.outVar == null) {
            return seed.equals((Object)gearing.outConst);
        }
        if (!childSolutionIn.isBound(gearing.outVar)) {
            return true;
        }
        return seed.equals((IVariableOrConstant)childSolutionIn.get(gearing.outVar));
    }

    private Gearing chooseGearing(IBindingSet[] bsets) {
        EmptyBindingSet bs;
        EmptyBindingSet emptyBindingSet = bs = bsets != null && bsets.length > 0 ? bsets[0] : EmptyBindingSet.INSTANCE;
        if (this.forwardGearing.inConst != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"forward gear");
            }
            return this.forwardGearing;
        }
        if (this.forwardGearing.outConst != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"reverse gear");
            }
            return this.reverseGearing;
        }
        if (bs.isBound(this.forwardGearing.inVar)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"forward gear");
            }
            return this.forwardGearing;
        }
        if (bs.isBound(this.forwardGearing.outVar)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"reverse gear");
            }
            return this.reverseGearing;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"forward gear");
        }
        return this.forwardGearing;
    }

    private SolutionKey newSolutionKey(Gearing gearing, IBindingSet bs) {
        IConstant edge;
        if (this.edgeVar == null || this.middleTerm.isConstant()) {
            if (gearing.inVar != null && gearing.outVar != null) {
                return new SolutionKey(new IConstant[]{bs.get(gearing.inVar), bs.get(gearing.outVar), bs.get(gearing.tVarOut)});
            }
            if (gearing.inVar != null) {
                return new SolutionKey(new IConstant[]{bs.get(gearing.inVar), bs.get(gearing.tVarOut)});
            }
            if (gearing.outVar != null) {
                return new SolutionKey(new IConstant[]{bs.get(gearing.outVar), bs.get(gearing.tVarOut)});
            }
            return new SolutionKey(new IConstant[]{bs.get(gearing.tVarOut)});
        }
        IConstant iConstant = edge = this.middleTerm.isConstant() ? (IConstant)this.middleTerm : bs.get((IVariable)this.middleTerm);
        if (gearing.inVar != null && gearing.outVar != null) {
            return new SolutionKey(new IConstant[]{bs.get(gearing.inVar), bs.get(gearing.outVar), bs.get(gearing.tVarOut), edge});
        }
        if (gearing.inVar != null) {
            return new SolutionKey(new IConstant[]{bs.get(gearing.inVar), bs.get(gearing.tVarOut), edge});
        }
        if (gearing.outVar != null) {
            return new SolutionKey(new IConstant[]{bs.get(gearing.outVar), bs.get(gearing.tVarOut), edge});
        }
        return new SolutionKey(new IConstant[]{bs.get(gearing.tVarOut), edge});
    }

    private void storeAndEmit(IBindingSet bs, Gearing gearing, Map<SolutionKey, IBindingSet> solutions) {
        SolutionKey solutionKey = this.newSolutionKey(gearing, bs);
        if (log.isDebugEnabled()) {
            log.debug((Object)("solution key: " + solutionKey));
        }
        this.storeAndEmit(solutionKey, bs, gearing, solutions);
    }

    private void storeAndEmit(SolutionKey solutionKey, IBindingSet bs, Gearing gearing, Map<SolutionKey, IBindingSet> solutions) {
        solutions.put(solutionKey, bs);
        this.emitSolutions(bs, gearing);
    }

    private void emitSolutions(IBindingSet bs, Gearing gearing) {
        IConstant out;
        IVariable<?> constantHybridVar;
        IBindingSet bset = bs.clone();
        if (gearing.inVar == null && (constantHybridVar = this.getConstantHybridVariable(gearing.inConst)) != null) {
            bset.set(constantHybridVar, gearing.inConst);
        }
        if (gearing.outVar == null && (constantHybridVar = this.getConstantHybridVariable(gearing.outConst)) != null) {
            bset.set(constantHybridVar, gearing.outConst);
        }
        if (gearing.outVar != null && (out = bset.get(gearing.tVarOut)) != null) {
            bset.set(gearing.outVar, out);
        }
        if (this.edgeVar != null) {
            IConstant edge;
            IConstant iConstant = edge = this.middleTerm.isConstant() ? (IConstant)this.middleTerm : bs.get((IVariable)this.middleTerm);
            if (edge != null) {
                bset.set(this.edgeVar, edge);
            }
        }
        if ((bset = this.distinctVarFilter.accept(bset)) != null) {
            this.out.add(bset);
        }
    }

    private IVariable<?> getConstantHybridVariable(IConstant c) {
        return c instanceof Constant ? ((Constant)c).getVar() : null;
    }

    private static final class SolutionKey {
        private final int hash;
        private final IConstant<?>[] vals;

        public SolutionKey(IConstant<?>[] vals) {
            this.vals = vals;
            this.hash = Arrays.hashCode(vals);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SolutionKey)) {
                return false;
            }
            SolutionKey t = (SolutionKey)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.toString(this.vals);
        }
    }

    private static final class Gearing {
        private final IVariable<?> inVar;
        private final IVariable<?> outVar;
        private final IConstant<?> inConst;
        private final IConstant<?> outConst;
        private final IVariable<?> tVarIn;
        private final IVariable<?> tVarOut;

        public Gearing(IVariable<?> inVar, IVariable<?> outVar, IConstant<?> inConst, IConstant<?> outConst, IVariable<?> tVarIn, IVariable<?> tVarOut) {
            if (inVar == null && inConst == null || inVar != null && inConst != null) {
                throw new IllegalArgumentException();
            }
            if (outVar == null && outConst == null || outVar != null && outConst != null) {
                throw new IllegalArgumentException();
            }
            if (tVarIn == null || tVarOut == null) {
                throw new IllegalArgumentException();
            }
            this.inVar = inVar;
            this.outVar = outVar;
            this.inConst = inConst;
            this.outConst = outConst;
            this.tVarIn = tVarIn;
            this.tVarOut = tVarOut;
        }

        public Gearing reverse() {
            return new Gearing(this.outVar, this.inVar, this.outConst, this.inConst, this.tVarOut, this.tVarIn);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append(" [");
            sb.append("inVar=").append(this.inVar);
            sb.append(", outVar=").append(this.outVar);
            sb.append(", inConst=").append(this.inConst);
            sb.append(", outConst=").append(this.outConst);
            sb.append(", tVarIn=").append(this.suffix(this.tVarIn, 8));
            sb.append(", tVarOut=").append(this.suffix(this.tVarOut, 8));
            sb.append("]");
            return sb.toString();
        }

        public String suffix(Object o, int len) {
            String s = o.toString();
            return s.substring(s.length() - len, s.length());
        }
    }
}

