/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.NV;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.join.AbstractMergeJoin;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.bop.join.HTreeSolutionSetHashJoinOp;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.JVMHashJoinAnnotations;
import com.bigdata.bop.join.JVMHashJoinUtility;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class JVMMergeJoin
extends AbstractMergeJoin {
    private static final long serialVersionUID = 1L;

    public JVMMergeJoin(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (!this.isLastPassRequested()) {
            throw new UnsupportedOperationException("Requires " + Annotations.LAST_PASS);
        }
    }

    public JVMMergeJoin(JVMMergeJoin op) {
        super(op);
    }

    public JVMMergeJoin(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask<E>
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final JVMMergeJoin op;
        private final JVMHashJoinUtility[] state;
        private final IConstraint[] constraints;
        private final boolean release;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> sink2;

        public ChunkTask(BOpContext<IBindingSet> context, JVMMergeJoin op) {
            this.context = context;
            this.constraints = (IConstraint[])op.getProperty(Annotations.CONSTRAINTS);
            this.release = op.getProperty(Annotations.RELEASE, true);
            this.sink = context.getSink();
            this.sink2 = context.getSink2();
            this.op = op;
            INamedSolutionSetRef[] namedSetRef = (INamedSolutionSetRef[])op.getRequiredProperty("namedSetRef");
            this.state = new JVMHashJoinUtility[namedSetRef.length];
            if (this.state.length < 2) {
                throw new RuntimeException("Merge join requires at least 2 sources.");
            }
            for (int i = 0; i < this.state.length; ++i) {
                IQueryAttributes attrs = context.getQueryAttributes(namedSetRef[i].getQueryId());
                this.state[i] = (JVMHashJoinUtility)attrs.get(namedSetRef[i]);
                if (this.state[i] != null) continue;
                throw new RuntimeException("Not found: " + namedSetRef[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                if (this.context.isLastInvocation()) {
                    UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), this.sink);
                    IHashJoinUtility[] others = new IHashJoinUtility[this.state.length - 1];
                    for (int i = 1; i < this.state.length; ++i) {
                        others[i - 1] = this.state[i];
                    }
                    this.state[0].mergeJoin(others, unsyncBuffer, this.constraints, this.state[0].getJoinType().isOptional());
                    unsyncBuffer.flush();
                    this.sink.flush();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.release && this.context.isLastInvocation()) {
                    for (JVMHashJoinUtility h : this.state) {
                        h.release();
                    }
                }
                this.sink.close();
                if (this.sink2 != null) {
                    this.sink2.close();
                }
            }
        }
    }

    public static interface Annotations
    extends AccessPathJoinAnnotations,
    JVMHashJoinAnnotations,
    NamedSetAnnotations {
        public static final String CONSTRAINTS = JoinAnnotations.CONSTRAINTS;
        public static final String JOIN_TYPE = JoinAnnotations.JOIN_TYPE;
        public static final String RELEASE = HTreeSolutionSetHashJoinOp.class + ".release";
        public static final boolean DEFAULT_RELEASE = true;
    }
}

