/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SmallSet<T>
extends AbstractSet<T> {
    @Nullable
    T element1;
    @Nullable
    T element2;
    @Nullable
    T element3;

    public SmallSet(Collection<T> collection) {
        if (collection.size() > 3) {
            throw new IllegalArgumentException("Trying to create a small set with too many elements - max 3, requested: " + collection.size());
        }
        for (T t : collection) {
            this.add(t);
        }
    }

    @Override
    public boolean add(@Nullable T t) {
        OWLAPIPreconditions.checkNotNull(t, "SmallSet cannot store null values");
        if (this.contains(t)) {
            return false;
        }
        if (this.element1 == null) {
            this.element1 = t;
            return true;
        }
        if (this.element2 == null) {
            this.element2 = t;
            return true;
        }
        if (this.element3 == null) {
            this.element3 = t;
            return true;
        }
        throw new IllegalStateException("cannot store more than 3 elements in a small set");
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        int oHash = o.hashCode();
        if (this.checkMatch(o, oHash, this.element1)) {
            this.element1 = null;
            return true;
        }
        if (this.checkMatch(o, oHash, this.element2)) {
            this.element2 = null;
            return true;
        }
        if (this.checkMatch(o, oHash, this.element3)) {
            this.element3 = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        int oHash = o.hashCode();
        return this.checkMatch(o, oHash, this.element1) || this.checkMatch(o, oHash, this.element2) || this.checkMatch(o, oHash, this.element3);
    }

    protected boolean checkMatch(Object o, int oHash, @Nullable T element) {
        return element != null && oHash == element.hashCode() && o.equals(element);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int cp = 1;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public boolean hasNext() {
                switch (this.cp) {
                    case 1: {
                        if (SmallSet.this.element1 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                    case 2: {
                        if (SmallSet.this.element2 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                    case 3: {
                        if (SmallSet.this.element3 != null) {
                            return true;
                        }
                        ++this.cp;
                    }
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No Next Element");
                }
                switch (this.cp++) {
                    case 1: {
                        return OWLAPIPreconditions.verifyNotNull(SmallSet.this.element1);
                    }
                    case 2: {
                        return OWLAPIPreconditions.verifyNotNull(SmallSet.this.element2);
                    }
                    case 3: {
                        return OWLAPIPreconditions.verifyNotNull(SmallSet.this.element3);
                    }
                }
                throw new IllegalStateException("Iterator pointing past end of virtual array");
            }
        };
    }

    @Override
    public Stream<T> stream() {
        Stream stream = Stream.empty();
        if (this.element1 != null) {
            stream = Stream.of(this.element1);
        }
        if (this.element2 != null) {
            stream = Stream.concat(stream, Stream.of(this.element2));
        }
        if (this.element3 != null) {
            stream = Stream.concat(stream, Stream.of(this.element3));
        }
        return stream;
    }

    @Override
    public int size() {
        int count = 0;
        if (this.element1 != null) {
            ++count;
        }
        if (this.element2 != null) {
            ++count;
        }
        if (this.element3 != null) {
            ++count;
        }
        return count;
    }

    @Override
    public String toString() {
        return String.format("#<SmallSet: %s,%s,%s>", this.element1, this.element2, this.element3);
    }
}

