/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousNodeCheckerImpl
implements AnonymousNodeChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousNodeCheckerImpl.class);

    @Override
    public boolean isAnonymousNode(IRI iri) {
        boolean value = NodeID.isAnonymousNodeIRI(iri);
        if (value) {
            LOGGER.trace("anonymous iri {}", (Object)iri);
        }
        return value;
    }

    @Override
    public boolean isAnonymousNode(String iri) {
        boolean value = NodeID.isAnonymousNodeIRI(iri);
        if (value) {
            LOGGER.trace("anonymous string {}", (Object)iri);
        }
        return value;
    }

    @Override
    public boolean isAnonymousSharedNode(String iri) {
        boolean value = NodeID.isAnonymousNodeID(iri);
        if (value) {
            LOGGER.trace("anonymous shared id {}", (Object)iri);
        }
        return value;
    }
}

