/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.xloader;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Hex;

public class WriteRows {
    private OutputStream output;
    boolean atStartOfRow = true;
    private int itemsPerRow;
    private int rowBlock;
    private byte[] b;
    private int idx;
    private int rows;
    private int rowLength;

    WriteRows(OutputStream output, int itemsPerRow, int rowBlock) {
        this.output = output;
        this.itemsPerRow = itemsPerRow;
        this.rowLength = 16 * itemsPerRow + itemsPerRow;
        this.rowBlock = rowBlock;
        this.b = new byte[this.rowLength * rowBlock];
        this.idx = 0;
        this.rows = 0;
    }

    public void write(long value) {
        if (!this.atStartOfRow) {
            this.b[this.idx] = 32;
            ++this.idx;
        } else {
            this.atStartOfRow = false;
        }
        Hex.formatUnsignedLongHex((byte[])this.b, (int)this.idx, (long)value, (int)16);
        this.idx += 16;
    }

    public void endOfRow() {
        this.b[this.idx] = 10;
        ++this.idx;
        this.atStartOfRow = true;
        ++this.rows;
        if (this.rows == this.rowBlock) {
            this.flush();
        }
    }

    public void flush() {
        try {
            this.output.write(this.b, 0, this.rows * this.rowLength);
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        this.idx = 0;
        this.rows = 0;
    }

    public void close() {
        this.flush();
        try {
            this.output.flush();
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

