/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.customconverter;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public class ConvertSplitOnWhitespace<T>
extends AbstractBeanField<T> {
    @Override
    protected Object convert(String value) {
        ArrayList<String> l = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            l = new ArrayList<String>(Arrays.asList(value.split("\\s+")));
        }
        return l;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result = "";
        try {
            if (value != null) {
                List values = (List)value;
                result = StringUtils.join((Iterable)values, (char)' ');
            }
        }
        catch (ClassCastException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("convertSplitOnWhitespace", this.errorLocale).getString("wrong.type"));
            csve.initCause(e);
            throw csve;
        }
        return result;
    }
}

