/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.properties;

import info.aduna.lang.FileFormat;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public class PropertiesFormat
extends FileFormat
implements Iterable<PropertiesFormat> {
    private static final CopyOnWriteArraySet<PropertiesFormat> formats = new CopyOnWriteArraySet();
    public static final PropertiesFormat TEXT = new PropertiesFormat("text/plain", Arrays.asList("text/plain"), Charset.forName("UTF-8"), Arrays.asList("properties"));
    public static final PropertiesFormat XML = new PropertiesFormat("application/xml", Arrays.asList("application/xml"), Charset.forName("UTF-8"), Arrays.asList("xml"));

    @Override
    public Iterator<PropertiesFormat> iterator() {
        return formats.iterator();
    }

    public static Iterator<PropertiesFormat> getFormats() {
        return formats.iterator();
    }

    public static void register(PropertiesFormat format) {
        formats.add(format);
    }

    public PropertiesFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions) {
        super(name, mimeTypes, charset, fileExtensions);
    }

    public static PropertiesFormat forMIMEType(String mimeType) {
        return PropertiesFormat.forMIMEType(mimeType, null);
    }

    public static PropertiesFormat forMIMEType(String mimeType, PropertiesFormat fallback) {
        return (PropertiesFormat)PropertiesFormat.matchMIMEType((String)mimeType, formats, (FileFormat)fallback);
    }

    static {
        PropertiesFormat.register(TEXT);
        PropertiesFormat.register(XML);
    }
}

