/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.connection;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.mux.MuxClient;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public final class ConnectionManager {
    private static final long TIMEOUT;
    private static final Logger logger;
    private static final Executor systemThreadPool;
    private final ConnectionEndpoint ep;
    private final List muxes = new ArrayList(1);
    private final List active = new ArrayList(1);
    private final Collection roactive = Collections.unmodifiableCollection(this.active);
    private final List idle = new ArrayList(1);
    private final Collection roidle = Collections.unmodifiableCollection(this.idle);
    private int pendingConnects = 0;
    private Reaper reaper = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionManager(ConnectionEndpoint ep) {
        this.ep = ep;
    }

    synchronized void connectPending() {
        ++this.pendingConnects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutboundMux connect(OutboundRequestHandle handle) throws IOException {
        Object object;
        block28: {
            OutboundMux outboundMux;
            block27: {
                ConnectionManager connectionManager;
                OutboundMux outboundMux2;
                block26: {
                    try {
                        ConnectionManager connectionManager2 = this;
                        synchronized (connectionManager2) {
                            this.active.clear();
                            this.idle.clear();
                            int i = this.muxes.size();
                            while (--i >= 0) {
                                OutboundMux mux = (OutboundMux)this.muxes.get(i);
                                try {
                                    int n = mux.requestsInProgress();
                                    if (n == 0) {
                                        this.idle.add(mux.getConnection());
                                        continue;
                                    }
                                    if (n >= 128) continue;
                                    this.active.add(mux.getConnection());
                                }
                                catch (IOException e) {
                                    this.muxes.remove(i);
                                }
                            }
                            Connection c = this.ep.connect(handle, this.roactive, this.roidle);
                            if (c != null) {
                                int i2 = this.muxes.size();
                                while (--i2 >= 0) {
                                    OutboundMux mux = (OutboundMux)this.muxes.get(i2);
                                    if (c != mux.getConnection()) continue;
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.log(Level.FINEST, "using {0}", c);
                                    }
                                    mux.newRequestPending();
                                    outboundMux2 = mux;
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 7, 25] lbl33 : MonitorExitStatement: MONITOREXIT : var2_2
                                    Object var10_13 = null;
                                    connectionManager = this;
                                    break block26;
                                }
                                OutboundMux mux = OutboundMux.create(c);
                                mux.newRequestPending();
                                if (this.reaper == null) {
                                    this.reaper = new Reaper();
                                    systemThreadPool.execute(this.reaper, "ConnectionManager[" + this.ep + "].Reaper");
                                }
                                this.muxes.add(mux);
                                outboundMux = mux;
                                // MONITOREXIT @DISABLED, blocks:[0, 7, 25] lbl46 : MonitorExitStatement: MONITOREXIT : var2_2
                                break block27;
                            }
                        }
                        Connection c = this.ep.connect(handle);
                        OutboundMux mux = OutboundMux.create(c);
                        mux.newRequestPending();
                        object = this;
                        synchronized (object) {
                            if (this.reaper == null) {
                                this.reaper = new Reaper();
                                systemThreadPool.execute(this.reaper, "ConnectionManager[" + this.ep + "].Reaper");
                            }
                            this.muxes.add(mux);
                        }
                        object = mux;
                        break block28;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        ConnectionManager connectionManager3 = this;
                        synchronized (connectionManager3) {
                            if (!$assertionsDisabled && this.pendingConnects <= 0) {
                                throw new AssertionError();
                            }
                            --this.pendingConnects;
                            throw throwable;
                        }
                    }
                }
                synchronized (connectionManager) {
                    if (!$assertionsDisabled && this.pendingConnects <= 0) {
                        throw new AssertionError();
                    }
                    --this.pendingConnects;
                    return outboundMux2;
                }
            }
            Object var10_14 = null;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!$assertionsDisabled && this.pendingConnects <= 0) {
                    throw new AssertionError();
                }
                --this.pendingConnects;
                return outboundMux;
            }
        }
        Object var10_15 = null;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (!$assertionsDisabled && this.pendingConnects <= 0) {
                throw new AssertionError();
            }
            --this.pendingConnects;
            return object;
        }
    }

    synchronized boolean checkIdle(long now, List idle) {
        int i = this.muxes.size();
        while (--i >= 0) {
            OutboundMux mux = (OutboundMux)this.muxes.get(i);
            if (!mux.checkIdle(now)) continue;
            this.muxes.remove(i);
            idle.add(mux);
        }
        return this.pendingConnects == 0 && this.muxes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(OutboundMux mux) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.muxes.remove(mux);
        }
        mux.shutdown("writeRequestData failed");
    }

    public OutboundRequestIterator newRequest(OutboundRequestHandle handle) {
        return new ReqIterator(handle);
    }

    static {
        $assertionsDisabled = !ConnectionManager.class.desiredAssertionStatus();
        TIMEOUT = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.connectionTimeout", 15000L));
        logger = Logger.getLogger("net.jini.jeri.connection.ConnectionManager");
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    }

    private final class ReqIterator
    implements OutboundRequestIterator {
        private final OutboundRequestHandle handle;
        private boolean first = true;
        private OutboundMux mux;

        ReqIterator(OutboundRequestHandle handle) {
            this.handle = handle;
        }

        public synchronized boolean hasNext() {
            return this.first || this.mux != null && this.mux.shouldRetry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized OutboundRequest next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.mux = null;
            ConnectionManager.this.connectPending();
            this.mux = ConnectionManager.this.connect(this.handle);
            OutboundRequest req = this.mux.newRequest();
            Outbound sreq = null;
            try {
                Connection c = this.mux.getConnection();
                c.writeRequestData(this.handle, req.getRequestOutputStream());
                sreq = new Outbound(req, c, this.handle);
                Object var5_4 = null;
                if (sreq == null) {
                    ConnectionManager.this.remove(this.mux);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (sreq == null) {
                    ConnectionManager.this.remove(this.mux);
                }
                throw throwable;
            }
            return sreq;
        }
    }

    private final class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done;
            ArrayList idle = new ArrayList(1);
            do {
                try {
                    Thread.sleep(TIMEOUT);
                }
                catch (InterruptedException e) {
                    return;
                }
                long now = System.currentTimeMillis();
                ConnectionManager connectionManager = ConnectionManager.this;
                synchronized (connectionManager) {
                    ConnectionManager.this.checkIdle(now, idle);
                    done = ConnectionManager.this.muxes.isEmpty();
                    if (done) {
                        ConnectionManager.this.reaper = null;
                    }
                }
                int i = idle.size();
                while (--i >= 0) {
                    ((OutboundMux)idle.get(i)).shutdown("idle");
                }
                idle.clear();
            } while (!done);
        }
    }

    private static final class Outbound
    implements OutboundRequest {
        private final OutboundRequest req;
        private final Connection c;
        private final OutboundRequestHandle handle;
        private final InputStream in;
        private boolean status = true;

        Outbound(OutboundRequest req, Connection c, OutboundRequestHandle handle) {
            this.req = req;
            this.c = c;
            this.handle = handle;
            this.in = new Input(handle);
        }

        public OutputStream getRequestOutputStream() {
            return this.req.getRequestOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.in;
        }

        public void populateContext(Collection context) {
            this.c.populateContext(this.handle, context);
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            return this.c.getUnfulfilledConstraints(this.handle);
        }

        public boolean getDeliveryStatus() {
            return this.status && this.req.getDeliveryStatus();
        }

        public void abort() {
            this.req.abort();
        }

        private final class Input
        extends InputStream {
            private final InputStream in;
            private OutboundRequestHandle handle;

            Input(OutboundRequestHandle handle) {
                this.in = Outbound.this.req.getResponseInputStream();
                this.handle = handle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void readFirst() throws IOException {
                if (this.handle != null) {
                    try {
                        IOException e = Outbound.this.c.readResponseData(this.handle, this.in);
                        if (e != null) {
                            Outbound.this.status = false;
                            throw e;
                        }
                    }
                    finally {
                        this.handle = null;
                    }
                }
            }

            public int read() throws IOException {
                this.readFirst();
                return this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.readFirst();
                return this.in.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                this.readFirst();
                return this.in.skip(n);
            }

            public int available() throws IOException {
                this.readFirst();
                return this.in.available();
            }

            public void close() throws IOException {
                this.in.close();
            }
        }
    }

    private static final class OutboundMux
    extends MuxClient {
        private final Connection c;
        private boolean pendingStart = true;
        private int pendingNewRequests = 0;
        private long idleTime = 0L;
        static final /* synthetic */ boolean $assertionsDisabled;

        private OutboundMux(Connection c) throws IOException {
            super(c.getOutputStream(), c.getInputStream());
            this.c = c;
        }

        private OutboundMux(Connection c, boolean ignore) throws IOException {
            super(c.getChannel());
            this.c = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static OutboundMux create(Connection c) throws IOException {
            logger.log(Level.FINEST, "opened {0}", c);
            OutboundMux mux = null;
            try {
                mux = c.getChannel() == null ? new OutboundMux(c) : new OutboundMux(c, true);
                Object var3_2 = null;
                if (mux != null) return mux;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (mux != null) throw throwable;
                try {
                    c.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                c.close();
                return mux;
            }
            catch (IOException e) {}
            return mux;
        }

        Connection getConnection() {
            return this.c;
        }

        synchronized void newRequestPending() {
            ++this.pendingNewRequests;
        }

        public synchronized OutboundRequest newRequest() throws IOException {
            if (!$assertionsDisabled && this.pendingNewRequests <= 0) {
                throw new AssertionError();
            }
            --this.pendingNewRequests;
            if (this.pendingStart) {
                this.pendingStart = false;
                this.start();
            }
            this.idleTime = 0L;
            return super.newRequest();
        }

        public synchronized int requestsInProgress() throws IOException {
            return super.requestsInProgress() + this.pendingNewRequests;
        }

        synchronized boolean checkIdle(long now) {
            try {
                if (this.requestsInProgress() == 0) {
                    if (this.idleTime == 0L) {
                        this.idleTime = now;
                    } else {
                        return now - this.idleTime > TIMEOUT;
                    }
                }
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }

        protected void handleDown() {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        boolean shouldRetry() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$connection$ConnectionManager == null ? (class$net$jini$jeri$connection$ConnectionManager = ConnectionManager.class$("net.jini.jeri.connection.ConnectionManager")) : class$net$jini$jeri$connection$ConnectionManager).desiredAssertionStatus();
        }
    }
}

