/*
 * Decompiled with CFR 0.152.
 */
package cutthecrap.utils.striterators;

import cutthecrap.utils.striterators.IFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class FilterBase
implements IFilter,
Cloneable {
    private static final long serialVersionUID = 1L;
    volatile List<IFilter> filterChain = null;
    volatile Map<String, Object> annotations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FilterBase addFilter(IFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        if (this.filterChain == null) {
            FilterBase filterBase = this;
            synchronized (filterBase) {
                if (this.filterChain == null) {
                    this.filterChain = Collections.synchronizedList(new LinkedList());
                }
            }
        }
        this.filterChain.add(filter);
        return this;
    }

    @Override
    public final Iterator filter(Iterator src, Object context) {
        src = this.filterOnce(src, context);
        if (this.filterChain != null) {
            for (IFilter filter : this.filterChain) {
                src = filter.filter(src, context);
            }
        }
        return src;
    }

    protected abstract Iterator filterOnce(Iterator var1, Object var2);

    @Override
    public final Object getProperty(String name) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(name);
    }

    protected final Object getRequiredProperty(String name) {
        Object value = this.getProperty(name);
        if (value == null) {
            throw new IllegalStateException(name);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.annotations == null) {
            FilterBase filterBase = this;
            synchronized (filterBase) {
                if (this.annotations == null) {
                    this.annotations = Collections.synchronizedMap(new LinkedHashMap());
                }
            }
        }
        return this.annotations.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{annotations=" + this.annotations);
        sb.append(",filterChain=" + this.filterChain);
        sb.append("}");
        return sb.toString();
    }
}

