# semaphore_client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.8.34
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/VitexSoftware/libpython-semaphore-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/VitexSoftware/libpython-semaphore-client.git`)

Then import the package:
```python
import semaphore_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import semaphore_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import semaphore_client
from pprint import pprint
from semaphore import authentication_api
from semaphore_client.model.api_token import APIToken
from semaphore_client.model.login import Login
# Defining the host is optional and defaults to https://demo.ansible-semaphore.com/api
# See configuration.py for a list of all supported configuration parameters.
configuration = semaphore_client.Configuration(
    host = "https://demo.ansible-semaphore.com/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: bearer
configuration.api_key['bearer'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['bearer'] = 'Bearer'

# Configure API key authorization: cookie
configuration.api_key['cookie'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookie'] = 'Bearer'


# Enter a context with an instance of the API client
with semaphore_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = authentication_api.AuthenticationApi(api_client)
    login_body = Login(
        auth="auth_example",
        password="password_example",
    ) # Login | 

    try:
        # Performs Login
        api_instance.auth_login_post(login_body)
    except semaphore_client.ApiException as e:
        print("Exception when calling AuthenticationApi->auth_login_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://demo.ansible-semaphore.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**auth_login_post**](docs/AuthenticationApi.md#auth_login_post) | **POST** /auth/login | Performs Login
*AuthenticationApi* | [**auth_logout_post**](docs/AuthenticationApi.md#auth_logout_post) | **POST** /auth/logout | Destroys current session
*AuthenticationApi* | [**user_tokens_api_token_id_delete**](docs/AuthenticationApi.md#user_tokens_api_token_id_delete) | **DELETE** /user/tokens/{api_token_id} | Expires API token
*AuthenticationApi* | [**user_tokens_get**](docs/AuthenticationApi.md#user_tokens_get) | **GET** /user/tokens | Fetch API tokens for user
*AuthenticationApi* | [**user_tokens_post**](docs/AuthenticationApi.md#user_tokens_post) | **POST** /user/tokens | Create an API token
*DefaultApi* | [**events_get**](docs/DefaultApi.md#events_get) | **GET** /events | Get Events related to Semaphore and projects you are part of
*DefaultApi* | [**events_last_get**](docs/DefaultApi.md#events_last_get) | **GET** /events/last | Get last 200 Events related to Semaphore and projects you are part of
*DefaultApi* | [**info_get**](docs/DefaultApi.md#info_get) | **GET** /info | Fetches information about semaphore
*DefaultApi* | [**ping_get**](docs/DefaultApi.md#ping_get) | **GET** /ping | PING test
*DefaultApi* | [**ws_get**](docs/DefaultApi.md#ws_get) | **GET** /ws | Websocket handler
*ProjectApi* | [**project_project_id_delete**](docs/ProjectApi.md#project_project_id_delete) | **DELETE** /project/{project_id}/ | Delete project
*ProjectApi* | [**project_project_id_environment_environment_id_delete**](docs/ProjectApi.md#project_project_id_environment_environment_id_delete) | **DELETE** /project/{project_id}/environment/{environment_id} | Removes environment
*ProjectApi* | [**project_project_id_environment_environment_id_put**](docs/ProjectApi.md#project_project_id_environment_environment_id_put) | **PUT** /project/{project_id}/environment/{environment_id} | Update environment
*ProjectApi* | [**project_project_id_environment_get**](docs/ProjectApi.md#project_project_id_environment_get) | **GET** /project/{project_id}/environment | Get environment
*ProjectApi* | [**project_project_id_environment_post**](docs/ProjectApi.md#project_project_id_environment_post) | **POST** /project/{project_id}/environment | Add environment
*ProjectApi* | [**project_project_id_events_get**](docs/ProjectApi.md#project_project_id_events_get) | **GET** /project/{project_id}/events | Get Events related to this project
*ProjectApi* | [**project_project_id_get**](docs/ProjectApi.md#project_project_id_get) | **GET** /project/{project_id}/ | Fetch project
*ProjectApi* | [**project_project_id_inventory_get**](docs/ProjectApi.md#project_project_id_inventory_get) | **GET** /project/{project_id}/inventory | Get inventory
*ProjectApi* | [**project_project_id_inventory_inventory_id_delete**](docs/ProjectApi.md#project_project_id_inventory_inventory_id_delete) | **DELETE** /project/{project_id}/inventory/{inventory_id} | Removes inventory
*ProjectApi* | [**project_project_id_inventory_inventory_id_put**](docs/ProjectApi.md#project_project_id_inventory_inventory_id_put) | **PUT** /project/{project_id}/inventory/{inventory_id} | Updates inventory
*ProjectApi* | [**project_project_id_inventory_post**](docs/ProjectApi.md#project_project_id_inventory_post) | **POST** /project/{project_id}/inventory | create inventory
*ProjectApi* | [**project_project_id_keys_get**](docs/ProjectApi.md#project_project_id_keys_get) | **GET** /project/{project_id}/keys | Get access keys linked to project
*ProjectApi* | [**project_project_id_keys_key_id_delete**](docs/ProjectApi.md#project_project_id_keys_key_id_delete) | **DELETE** /project/{project_id}/keys/{key_id} | Removes access key
*ProjectApi* | [**project_project_id_keys_key_id_put**](docs/ProjectApi.md#project_project_id_keys_key_id_put) | **PUT** /project/{project_id}/keys/{key_id} | Updates access key
*ProjectApi* | [**project_project_id_keys_post**](docs/ProjectApi.md#project_project_id_keys_post) | **POST** /project/{project_id}/keys | Add access key
*ProjectApi* | [**project_project_id_put**](docs/ProjectApi.md#project_project_id_put) | **PUT** /project/{project_id}/ | Update project
*ProjectApi* | [**project_project_id_repositories_get**](docs/ProjectApi.md#project_project_id_repositories_get) | **GET** /project/{project_id}/repositories | Get repositories
*ProjectApi* | [**project_project_id_repositories_post**](docs/ProjectApi.md#project_project_id_repositories_post) | **POST** /project/{project_id}/repositories | Add repository
*ProjectApi* | [**project_project_id_repositories_repository_id_delete**](docs/ProjectApi.md#project_project_id_repositories_repository_id_delete) | **DELETE** /project/{project_id}/repositories/{repository_id} | Removes repository
*ProjectApi* | [**project_project_id_tasks_get**](docs/ProjectApi.md#project_project_id_tasks_get) | **GET** /project/{project_id}/tasks | Get Tasks related to current project
*ProjectApi* | [**project_project_id_tasks_last_get**](docs/ProjectApi.md#project_project_id_tasks_last_get) | **GET** /project/{project_id}/tasks/last | Get last 200 Tasks related to current project
*ProjectApi* | [**project_project_id_tasks_post**](docs/ProjectApi.md#project_project_id_tasks_post) | **POST** /project/{project_id}/tasks | Starts a job
*ProjectApi* | [**project_project_id_tasks_task_id_delete**](docs/ProjectApi.md#project_project_id_tasks_task_id_delete) | **DELETE** /project/{project_id}/tasks/{task_id} | Deletes task (including output)
*ProjectApi* | [**project_project_id_tasks_task_id_get**](docs/ProjectApi.md#project_project_id_tasks_task_id_get) | **GET** /project/{project_id}/tasks/{task_id} | Get a single task
*ProjectApi* | [**project_project_id_tasks_task_id_output_get**](docs/ProjectApi.md#project_project_id_tasks_task_id_output_get) | **GET** /project/{project_id}/tasks/{task_id}/output | Get task output
*ProjectApi* | [**project_project_id_templates_get**](docs/ProjectApi.md#project_project_id_templates_get) | **GET** /project/{project_id}/templates | Get template
*ProjectApi* | [**project_project_id_templates_post**](docs/ProjectApi.md#project_project_id_templates_post) | **POST** /project/{project_id}/templates | create template
*ProjectApi* | [**project_project_id_templates_template_id_delete**](docs/ProjectApi.md#project_project_id_templates_template_id_delete) | **DELETE** /project/{project_id}/templates/{template_id} | Removes template
*ProjectApi* | [**project_project_id_templates_template_id_get**](docs/ProjectApi.md#project_project_id_templates_template_id_get) | **GET** /project/{project_id}/templates/{template_id} | Get template
*ProjectApi* | [**project_project_id_templates_template_id_put**](docs/ProjectApi.md#project_project_id_templates_template_id_put) | **PUT** /project/{project_id}/templates/{template_id} | Updates template
*ProjectApi* | [**project_project_id_users_get**](docs/ProjectApi.md#project_project_id_users_get) | **GET** /project/{project_id}/users | Get users linked to project
*ProjectApi* | [**project_project_id_users_post**](docs/ProjectApi.md#project_project_id_users_post) | **POST** /project/{project_id}/users | Link user to project
*ProjectApi* | [**project_project_id_users_user_id_admin_delete**](docs/ProjectApi.md#project_project_id_users_user_id_admin_delete) | **DELETE** /project/{project_id}/users/{user_id}/admin | Revoke admin privileges
*ProjectApi* | [**project_project_id_users_user_id_admin_post**](docs/ProjectApi.md#project_project_id_users_user_id_admin_post) | **POST** /project/{project_id}/users/{user_id}/admin | Makes user admin
*ProjectApi* | [**project_project_id_users_user_id_delete**](docs/ProjectApi.md#project_project_id_users_user_id_delete) | **DELETE** /project/{project_id}/users/{user_id} | Removes user from project
*ProjectApi* | [**project_project_id_views_get**](docs/ProjectApi.md#project_project_id_views_get) | **GET** /project/{project_id}/views | Get view
*ProjectApi* | [**project_project_id_views_post**](docs/ProjectApi.md#project_project_id_views_post) | **POST** /project/{project_id}/views | create view
*ProjectApi* | [**project_project_id_views_view_id_delete**](docs/ProjectApi.md#project_project_id_views_view_id_delete) | **DELETE** /project/{project_id}/views/{view_id} | Removes view
*ProjectApi* | [**project_project_id_views_view_id_get**](docs/ProjectApi.md#project_project_id_views_view_id_get) | **GET** /project/{project_id}/views/{view_id} | Get view
*ProjectApi* | [**project_project_id_views_view_id_put**](docs/ProjectApi.md#project_project_id_views_view_id_put) | **PUT** /project/{project_id}/views/{view_id} | Updates view
*ProjectsApi* | [**projects_get**](docs/ProjectsApi.md#projects_get) | **GET** /projects | Get projects
*ProjectsApi* | [**projects_post**](docs/ProjectsApi.md#projects_post) | **POST** /projects | Create a new project
*ScheduleApi* | [**project_project_id_schedules_post**](docs/ScheduleApi.md#project_project_id_schedules_post) | **POST** /project/{project_id}/schedules | create schedule
*ScheduleApi* | [**project_project_id_schedules_schedule_id_delete**](docs/ScheduleApi.md#project_project_id_schedules_schedule_id_delete) | **DELETE** /project/{project_id}/schedules/{schedule_id} | Deletes schedule
*ScheduleApi* | [**project_project_id_schedules_schedule_id_get**](docs/ScheduleApi.md#project_project_id_schedules_schedule_id_get) | **GET** /project/{project_id}/schedules/{schedule_id} | Get schedule
*ScheduleApi* | [**project_project_id_schedules_schedule_id_put**](docs/ScheduleApi.md#project_project_id_schedules_schedule_id_put) | **PUT** /project/{project_id}/schedules/{schedule_id} | Updates schedule
*UserApi* | [**user_get**](docs/UserApi.md#user_get) | **GET** /user/ | Fetch logged in user
*UserApi* | [**user_tokens_api_token_id_delete**](docs/UserApi.md#user_tokens_api_token_id_delete) | **DELETE** /user/tokens/{api_token_id} | Expires API token
*UserApi* | [**user_tokens_get**](docs/UserApi.md#user_tokens_get) | **GET** /user/tokens | Fetch API tokens for user
*UserApi* | [**user_tokens_post**](docs/UserApi.md#user_tokens_post) | **POST** /user/tokens | Create an API token
*UserApi* | [**users_get**](docs/UserApi.md#users_get) | **GET** /users | Fetches all users
*UserApi* | [**users_post**](docs/UserApi.md#users_post) | **POST** /users | Creates a user
*UserApi* | [**users_user_id_delete**](docs/UserApi.md#users_user_id_delete) | **DELETE** /users/{user_id}/ | Deletes user
*UserApi* | [**users_user_id_get**](docs/UserApi.md#users_user_id_get) | **GET** /users/{user_id}/ | Fetches a user profile
*UserApi* | [**users_user_id_password_post**](docs/UserApi.md#users_user_id_password_post) | **POST** /users/{user_id}/password | Updates user password
*UserApi* | [**users_user_id_put**](docs/UserApi.md#users_user_id_put) | **PUT** /users/{user_id}/ | Updates user details


## Documentation For Models

 - [APIToken](docs/APIToken.md)
 - [AccessKey](docs/AccessKey.md)
 - [AccessKeyRequest](docs/AccessKeyRequest.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentRequest](docs/EnvironmentRequest.md)
 - [Event](docs/Event.md)
 - [InfoType](docs/InfoType.md)
 - [InfoTypeUpdate](docs/InfoTypeUpdate.md)
 - [Inventory](docs/Inventory.md)
 - [InventoryRequest](docs/InventoryRequest.md)
 - [Login](docs/Login.md)
 - [Project](docs/Project.md)
 - [ProjectProjectIdDeleteRequest](docs/ProjectProjectIdDeleteRequest.md)
 - [ProjectProjectIdTasksGetRequest](docs/ProjectProjectIdTasksGetRequest.md)
 - [ProjectProjectIdUsersGetRequest](docs/ProjectProjectIdUsersGetRequest.md)
 - [ProjectRequest](docs/ProjectRequest.md)
 - [Repository](docs/Repository.md)
 - [RepositoryRequest](docs/RepositoryRequest.md)
 - [Schedule](docs/Schedule.md)
 - [ScheduleRequest](docs/ScheduleRequest.md)
 - [Task](docs/Task.md)
 - [TaskOutput](docs/TaskOutput.md)
 - [Template](docs/Template.md)
 - [TemplateRequest](docs/TemplateRequest.md)
 - [User](docs/User.md)
 - [UserPutRequest](docs/UserPutRequest.md)
 - [UserRequest](docs/UserRequest.md)
 - [UsersUserIdPasswordPostRequest](docs/UsersUserIdPasswordPostRequest.md)
 - [View](docs/View.md)
 - [ViewRequest](docs/ViewRequest.md)


## Documentation For Authorization


## bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## cookie

- **Type**: API key
- **API key parameter name**: Cookie
- **Location**: HTTP header


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in semaphore_client.apis and semaphore_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from semaphore_client.api.default_api import DefaultApi`
- `from semaphore_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import semaphore_client
from semaphore_client.apis import *
from semaphore_client.models import *
```

