# InstandDL: An easy and convenient deep learning pipeline for image segmentation and classification

[![Build Status](https://travis-ci.com/marrlab/InstantDL.svg?branch=develop-test)](https://travis-ci.com/marrlab/InstantDL)

InstantDL enables experts and non-experts to use state-of-the art deep learning methods on biomedical image data. InstantDL offers the four most common tasks in medical image processing: Semantic segmentation, instance segmentation, pixel-wise regression and classification. For more in depth discussion on the methods, as well as comparing the results and bechmarks using this package, please refer to our preprint on bioRxiv [here](https://doi.org/10.1101/2020.06.22.164103)

<p align="center">
<img src="docs/Instand_DL_farbig_RGB.png"  width="400" />
</p>

---------------------------------------------------------------------

## Documentation

For documentation please refere to [docs](docs)

For a short video introducing InstantDL please see:

<a href="http://www.youtube.com/watch?v=Wy4wlEyE2fA">
<p align="center">
<img href="InstantDL" src="http://img.youtube.com/vi/Wy4wlEyE2fA/0.jpg"
width="500" align="center">
</p>
<a>

## Contributing

We are happy about any contributions. For any suggested changes, please send a pull request to the *develop* branch.

## Citation

If you use InstantDL, please cite this paper:

```
@article {
author = {Waibel, Dominik Jens Elias and Shetab Boushehri, Sayedali and Marr, Carsten},
title = {InstantDL - An easy-to-use deep learning pipeline for image segmentation and classification},
year = {2021},
doi = {10.1186/s12859-021-04037-3},
URL = {https://bmcbioinformatics.biomedcentral.com/articles/10.1186/s12859-021-04037-3#article-info},
eprint = {https://doi.org/10.1186/s12859-021-04037-3},
journal = {BMC Bioinformatics}
}
```
