"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const manifest_writer_1 = require("./manifest-writer");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
class IntegTestCase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        core_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const snapshotDir = session.assembly.outdir;
                const manifest = {
                    version: '',
                    testCases: { [id]: toTestCase(props) },
                };
                manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
            },
        });
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests.IntegTestCase", version: "1.153.0" };
function toTestCase(props) {
    return {
        ...props,
        stacks: props.stacks.map(s => s.artifactId),
    };
}
//# sourceMappingURL=data:application/json;base64,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