import { TestOptions } from '@aws-cdk/cloud-assembly-schema';
import { Stack } from '@aws-cdk/core';
import { Construct } from '@aws-cdk/core';
/**
 * Properties of an integration test case
 */
export interface IntegTestCaseProps extends TestOptions {
    /**
     * Stacks to be deployed during the test
     */
    readonly stacks: Stack[];
}
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
export declare class IntegTestCase extends Construct {
    constructor(scope: Construct, id: string, props: IntegTestCaseProps);
}
