import { Construct } from 'constructs';
import { INextable } from '../types';
import { State } from './state';
/**
 * Properties for defining a Succeed state.
 *
 * @stability stable
 */
export interface SucceedProps {
    /**
     * An optional description for this state.
     *
     * @default No comment
     * @stability stable
     */
    readonly comment?: string;
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly inputPath?: string;
    /**
     * JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @stability stable
     */
    readonly outputPath?: string;
}
/**
 * Define a Succeed state in the state machine.
 *
 * Reaching a Succeed state terminates the state execution in success.
 *
 * @stability stable
 */
export declare class Succeed extends State {
    /**
     * Continuable states of this Chainable.
     *
     * @stability stable
     */
    readonly endStates: INextable[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: SucceedProps);
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson(): object;
}
