/* File: atomic_programmodule.c
 * This file is auto-generated with f2py (version:1.21.0).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Jul 13 18:59:59 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>
#include <setjmp.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *atomic_program_error;
static PyObject *atomic_program_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;
typedef signed char signed_char;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
typedef void(*cb_ps_generator_in_pseudo__user__routines_typedef)(int *,double *,double *);

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define PRINTPYOBJERR(obj)\
    fprintf(stderr,"atomic_program.error is related to ");\
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");

\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#define pyobj_from_int1(v) (PyLong_FromLong(v))
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef F2PY_THREAD_LOCAL_DECL
#if defined(_MSC_VER) \
      || defined(_WIN32) || defined(_WIN64) \
      || defined(__MINGW32__) || defined(__MINGW64__)
#define F2PY_THREAD_LOCAL_DECL __declspec(thread)
#elif defined(__STDC_VERSION__) \
      && (__STDC_VERSION__ >= 201112L) \
      && !defined(__STDC_NO_THREADS__) \
      && (!defined(__GLIBC__) || __GLIBC__ > 2 || (__GLIBC__ == 2 && __GLIBC_MINOR__ > 12))
/* __STDC_NO_THREADS__ was first defined in a maintenance release of glibc 2.12,
   see https://lists.gnu.org/archive/html/commit-hurd/2012-07/msg00180.html,
   so `!defined(__STDC_NO_THREADS__)` may give false positive for the existence
   of `threads.h` when using an older release of glibc 2.12 */
#include <threads.h>
#define F2PY_THREAD_LOCAL_DECL thread_local
#elif defined(__GNUC__) \
      && (__GNUC__ > 4 || (__GNUC__ == 4 && (__GNUC_MINOR__ >= 4)))
#define F2PY_THREAD_LOCAL_DECL __thread
#endif
#endif

#define GETSCALARFROMPYTUPLE(tuple,index,var,ctype,mess) {\
        if ((capi_tmp = PyTuple_GetItem((tuple),(index)))==NULL) goto capi_fail;\
        if (!(ctype ## _from_pyobj((var),capi_tmp,mess)))\
            goto capi_fail;\
    }

#define pyobj_from_double1(v) (PyFloat_FromDouble(v))
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define SWAP(a,b,t) {\
    t *c;\
    c = a;\
    a = b;\
    b = c;}

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(atomic_program_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
double_from_pyobj(double* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
        *v = PyFloat_AsDouble(obj);
        return !(*v == -1.0 && PyErr_Occurred());
    }

    tmp = PyNumber_Float(obj);
    if (tmp) {
        *v = PyFloat_AsDouble(tmp);
        Py_DECREF(tmp);
        return !(*v == -1.0 && PyErr_Occurred());
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = atomic_program_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int
string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess)
{
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyBytes_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyBytes_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyBytes_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = atomic_program_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = atomic_program_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}

static int
create_cb_arglist(PyObject* fun, PyTupleObject* xa , const int maxnofargs,
                  const int nofoptargs, int *nofargs, PyTupleObject **args,
                  const char *errmess)
{
    PyObject *tmp = NULL;
    PyObject *tmp_fun = NULL;
    Py_ssize_t tot, opt, ext, siz, i, di = 0;
    CFUNCSMESS("create_cb_arglist\n");
    tot=opt=ext=siz=0;
    /* Get the total number of arguments */
    if (PyFunction_Check(fun)) {
        tmp_fun = fun;
        Py_INCREF(tmp_fun);
    }
    else {
        di = 1;
        if (PyObject_HasAttrString(fun,"im_func")) {
            tmp_fun = PyObject_GetAttrString(fun,"im_func");
        }
        else if (PyObject_HasAttrString(fun,"__call__")) {
            tmp = PyObject_GetAttrString(fun,"__call__");
            if (PyObject_HasAttrString(tmp,"im_func"))
                tmp_fun = PyObject_GetAttrString(tmp,"im_func");
            else {
                tmp_fun = fun; /* built-in function */
                Py_INCREF(tmp_fun);
                tot = maxnofargs;
                if (PyCFunction_Check(fun)) {
                    /* In case the function has a co_argcount (like on PyPy) */
                    di = 0;
                }
                if (xa != NULL)
                    tot += PyTuple_Size((PyObject *)xa);
            }
            Py_XDECREF(tmp);
        }
        else if (PyFortran_Check(fun) || PyFortran_Check1(fun)) {
            tot = maxnofargs;
            if (xa != NULL)
                tot += PyTuple_Size((PyObject *)xa);
            tmp_fun = fun;
            Py_INCREF(tmp_fun);
        }
        else if (F2PyCapsule_Check(fun)) {
            tot = maxnofargs;
            if (xa != NULL)
                ext = PyTuple_Size((PyObject *)xa);
            if(ext>0) {
                fprintf(stderr,"extra arguments tuple cannot be used with CObject call-back\n");
                goto capi_fail;
            }
            tmp_fun = fun;
            Py_INCREF(tmp_fun);
        }
    }

    if (tmp_fun == NULL) {
        fprintf(stderr,
                "Call-back argument must be function|instance|instance.__call__|f2py-function "
                "but got %s.\n",
                ((fun == NULL) ? "NULL" : Py_TYPE(fun)->tp_name));
        goto capi_fail;
    }

    if (PyObject_HasAttrString(tmp_fun,"__code__")) {
        if (PyObject_HasAttrString(tmp = PyObject_GetAttrString(tmp_fun,"__code__"),"co_argcount")) {
            PyObject *tmp_argcount = PyObject_GetAttrString(tmp,"co_argcount");
            Py_DECREF(tmp);
            if (tmp_argcount == NULL) {
                goto capi_fail;
            }
            tot = PyLong_AsSsize_t(tmp_argcount) - di;
            Py_DECREF(tmp_argcount);
        }
    }
    /* Get the number of optional arguments */
    if (PyObject_HasAttrString(tmp_fun,"__defaults__")) {
        if (PyTuple_Check(tmp = PyObject_GetAttrString(tmp_fun,"__defaults__")))
            opt = PyTuple_Size(tmp);
        Py_XDECREF(tmp);
    }
    /* Get the number of extra arguments */
    if (xa != NULL)
        ext = PyTuple_Size((PyObject *)xa);
    /* Calculate the size of call-backs argument list */
    siz = MIN(maxnofargs+ext,tot);
    *nofargs = MAX(0,siz-ext);

#ifdef DEBUGCFUNCS
    fprintf(stderr,
            "debug-capi:create_cb_arglist:maxnofargs(-nofoptargs),"
            "tot,opt,ext,siz,nofargs = %d(-%d), %zd, %zd, %zd, %zd, %d\n",
            maxnofargs, nofoptargs, tot, opt, ext, siz, *nofargs);
#endif

    if (siz < tot-opt) {
        fprintf(stderr,
                "create_cb_arglist: Failed to build argument list "
                "(siz) with enough arguments (tot-opt) required by "
                "user-supplied function (siz,tot,opt=%zd, %zd, %zd).\n",
                siz, tot, opt);
        goto capi_fail;
    }

    /* Initialize argument list */
    *args = (PyTupleObject *)PyTuple_New(siz);
    for (i=0;i<*nofargs;i++) {
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM((PyObject *)(*args),i,Py_None);
    }
    if (xa != NULL)
        for (i=(*nofargs);i<siz;i++) {
            tmp = PyTuple_GetItem((PyObject *)xa,i-(*nofargs));
            Py_INCREF(tmp);
            PyTuple_SET_ITEM(*args,i,tmp);
        }
    CFUNCSMESS("create_cb_arglist-end\n");
    Py_DECREF(tmp_fun);
    return 1;

capi_fail:
    if (PyErr_Occurred() == NULL)
        PyErr_SetString(atomic_program_error, errmess);
    Py_XDECREF(tmp_fun);
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(run,RUN)(void);
extern void F_WRAPPEDFUNC_US(nucl_z,NUCL_Z)(double*,string,size_t);
extern void F_FUNC(difnrl,DIFNRL)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*);
extern void F_FUNC(difrel,DIFREL)(int*,int*,double*,double*,double*,int*,int*,double*,double*);
extern void F_FUNC(dmixp,DMIXP)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(dsolv1,DSOLV1)(int*,int*,int*);
extern void F_FUNC(pseudo,PSEUDO)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t);
extern void F_FUNC(wf,WF)(int*,double*,double*);
extern void F_FUNC(hsc,HSC)(int*,double*,double*);
extern void F_FUNC(excorr,EXCORR)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t);
extern void F_FUNC(tm2,TM2)(int*,double*,double*);
extern void F_FUNC(ker,KER)(int*,double*,double*);
extern void F_FUNC(wrapup,WRAPUP)(string,size_t);
extern void F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION)(double*,double*);
extern void F_FUNC(splift,SPLIFT)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*);
extern void F_FUNC(spliq,SPLIQ)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*);
extern void F_FUNC(velect,VELECT)(int*,int*,string,double*,size_t);
extern void F_FUNC(vionic,VIONIC)(void);
extern void F_FUNC(wtrans,WTRANS)(double*,double*,int*,int*,int*);
extern void F_WRAPPEDFUNC(v0pp,V0PP)(double*,double*);
extern void F_WRAPPEDFUNC_US(chg_mism,CHG_MISM)(double*,double*);
extern void F_FUNC(dsolv2,DSOLV2)(int*,int*,string,int*,int*,int*,int*,size_t);
extern void F_FUNC(etotal,ETOTAL)(int*,int*);
extern void F_FUNC(ext,EXT)(int*);
extern void F_FUNC(input,INPUT)(int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/

/***************** cb_ps_generator_in_pseudo__user__routines *****************/
typedef struct {
    PyObject *capi;
    PyTupleObject *args_capi;
    int nofargs;
    jmp_buf jmpbuf;
} cb_ps_generator_in_pseudo__user__routines_t;

#if defined(F2PY_THREAD_LOCAL_DECL) && !defined(F2PY_USE_PYTHON_TLS)

static F2PY_THREAD_LOCAL_DECL cb_ps_generator_in_pseudo__user__routines_t *_active_cb_ps_generator_in_pseudo__user__routines = NULL;

static cb_ps_generator_in_pseudo__user__routines_t *swap_active_cb_ps_generator_in_pseudo__user__routines(cb_ps_generator_in_pseudo__user__routines_t *ptr) {
    cb_ps_generator_in_pseudo__user__routines_t *prev = _active_cb_ps_generator_in_pseudo__user__routines;
    _active_cb_ps_generator_in_pseudo__user__routines = ptr;
    return prev;
}

static cb_ps_generator_in_pseudo__user__routines_t *get_active_cb_ps_generator_in_pseudo__user__routines(void) {
    return _active_cb_ps_generator_in_pseudo__user__routines;
}

#else

static cb_ps_generator_in_pseudo__user__routines_t *swap_active_cb_ps_generator_in_pseudo__user__routines(cb_ps_generator_in_pseudo__user__routines_t *ptr) {
    char *key = "__f2py_cb_cb_ps_generator_in_pseudo__user__routines";
    return (cb_ps_generator_in_pseudo__user__routines_t *)F2PySwapThreadLocalCallbackPtr(key, ptr);
}

static cb_ps_generator_in_pseudo__user__routines_t *get_active_cb_ps_generator_in_pseudo__user__routines(void) {
    char *key = "__f2py_cb_cb_ps_generator_in_pseudo__user__routines";
    return (cb_ps_generator_in_pseudo__user__routines_t *)F2PyGetThreadLocalCallbackPtr(key);
}

#endif

/*typedef void(*cb_ps_generator_in_pseudo__user__routines_typedef)(int *,double *,double *);*/
static void cb_ps_generator_in_pseudo__user__routines (int *i_cb_capi,double *ar,double *br) {
    cb_ps_generator_in_pseudo__user__routines_t cb_local = { NULL, NULL, 0 };
    cb_ps_generator_in_pseudo__user__routines_t *cb = NULL;
    PyTupleObject *capi_arglist = NULL;
    PyObject *capi_return = NULL;
    PyObject *capi_tmp = NULL;
    PyObject *capi_arglist_list = NULL;
    int capi_j,capi_i = 0;
    int capi_longjmp_ok = 1;
/*decl*/
    int i=(*i_cb_capi);
    npy_intp ar_Dims[1] = {-1};
    npy_intp br_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
    cb = get_active_cb_ps_generator_in_pseudo__user__routines();
    if (cb == NULL) {
        capi_longjmp_ok = 0;
        cb = &cb_local;
    }
    capi_arglist = cb->args_capi;
    CFUNCSMESS("cb:Call-back function cb_ps_generator_in_pseudo__user__routines (maxnofargs=3(-0))\n");
    CFUNCSMESSPY("cb:cb_ps_generator_in_pseudo__user__routines_capi=",cb->capi);
    if (cb->capi==NULL) {
        capi_longjmp_ok = 0;
        cb->capi = PyObject_GetAttrString(atomic_program_module,"ps_generator");
        CFUNCSMESSPY("cb:cb_ps_generator_in_pseudo__user__routines_capi=",cb->capi);
    }
    if (cb->capi==NULL) {
        PyErr_SetString(atomic_program_error,"cb: Callback ps_generator not defined (as an argument or module atomic_program attribute).\n");
        goto capi_fail;
    }
    if (F2PyCapsule_Check(cb->capi)) {
    cb_ps_generator_in_pseudo__user__routines_typedef cb_ps_generator_in_pseudo__user__routines_cptr;
    cb_ps_generator_in_pseudo__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb->capi);
    (*cb_ps_generator_in_pseudo__user__routines_cptr)(i_cb_capi,ar,br);
    return;
    }
    if (capi_arglist==NULL) {
        capi_longjmp_ok = 0;
        capi_tmp = PyObject_GetAttrString(atomic_program_module,"ps_generator_extra_args");
        if (capi_tmp) {
            capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
            if (capi_arglist==NULL) {
                PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.ps_generator_extra_args to tuple.\n");
                goto capi_fail;
            }
        } else {
            PyErr_Clear();
            capi_arglist = (PyTupleObject *)Py_BuildValue("()");
        }
    }
    if (capi_arglist == NULL) {
        PyErr_SetString(atomic_program_error,"Callback ps_generator argument list is not set.\n");
        goto capi_fail;
    }
/*setdims*/
    ar_Dims[0]=1500;
    br_Dims[0]=1500;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
    capi_arglist_list = PySequence_List(capi_arglist);
    if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
    if (cb->nofargs>capi_i)
        if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_int1(i)))
            goto capi_fail;
    if (cb->nofargs>capi_i) {
        int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
        /*XXX: Hmm, what will destroy this array??? */
        PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,ar_Dims,NPY_DOUBLE,NULL,(char*)ar,itemsize_,NPY_ARRAY_FARRAY,NULL);


        if (tmp_arr==NULL)
            goto capi_fail;
        if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
            goto capi_fail;
}
    if (cb->nofargs>capi_i) {
        int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
        /*XXX: Hmm, what will destroy this array??? */
        PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,br_Dims,NPY_DOUBLE,NULL,(char*)br,itemsize_,NPY_ARRAY_FARRAY,NULL);


        if (tmp_arr==NULL)
            goto capi_fail;
        if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
            goto capi_fail;
}
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
    CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
    CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
    CFUNCSMESS("cb:Call-back calling Python function ps_generator.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
    capi_return = PyObject_CallObject(cb->capi,(PyObject *)capi_arglist_list);
    Py_DECREF(capi_arglist_list);
    capi_arglist_list = NULL;
#else
    capi_return = PyObject_CallObject(cb->capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
    CFUNCSMESSPY("cb:capi_return=",capi_return);
    if (capi_return == NULL) {
        fprintf(stderr,"capi_return is NULL\n");
        goto capi_fail;
    }
    if (capi_return == Py_None) {
        Py_DECREF(capi_return);
        capi_return = Py_BuildValue("()");
    }
    else if (!PyTuple_Check(capi_return)) {
        capi_return = Py_BuildValue("(N)",capi_return);
    }
    capi_j = PyTuple_Size(capi_return);
    capi_i = 0;
/*frompyobj*/
    CFUNCSMESS("cb:cb_ps_generator_in_pseudo__user__routines:successful\n");
    Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
    goto capi_return_pt;
capi_fail:
    fprintf(stderr,"Call-back cb_ps_generator_in_pseudo__user__routines failed.\n");
    Py_XDECREF(capi_return);
    Py_XDECREF(capi_arglist_list);
    if (capi_longjmp_ok) {
        longjmp(cb->jmpbuf,-1);
    }
capi_return_pt:
    ;
return;
}
/************** end of cb_ps_generator_in_pseudo__user__routines **************/


/*********************** See f2py2e/rules.py: buildapi ***********************/

/************************************ run ************************************/
static char doc_f2py_rout_atomic_program_run[] = "\
run()\n\nWrapper for ``run``.\
\n";
/* extern void F_FUNC(run,RUN)(void); */
static PyObject *f2py_rout_atomic_program_run(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

    static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "|:atomic_program.run",\
        capi_kwlist))
        return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of run *********************************/

/*********************************** nucl_z ***********************************/
static char doc_f2py_rout_atomic_program_nucl_z[] = "\
nucl_z = nucl_z(name)\n\nWrapper for ``nucl_z``.\
\n\nParameters\n----------\n"
"name : input string(len=2)\n"
"\nReturns\n-------\n"
"nucl_z : float";
/* extern void F_WRAPPEDFUNC_US(nucl_z,NUCL_Z)(double*,string,size_t); */
static PyObject *f2py_rout_atomic_program_nucl_z(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,string,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double nucl_z = 0;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
    static char *capi_kwlist[] = {"name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.nucl_z",\
        capi_kwlist,&name_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable name */
  slen(name) = 2;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 1st argument `name' of atomic_program.nucl_z to C string");
  if (f2py_success) {
  /* Processing variable nucl_z */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&nucl_z,name,slen(name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("d",nucl_z);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable nucl_z */
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of nucl_z *******************************/

/*********************************** difnrl ***********************************/
static char doc_f2py_rout_atomic_program_difnrl[] = "\
difnrl(iter,iorb,v,ar,br,n,l,spin,eigv,iflag)\n\nWrapper for ``difnrl``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iorb : input int\n"
"v : input rank-1 array('d') with bounds (*)\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)\n"
"n : input int\n"
"l : input int\n"
"spin : input float\n"
"eigv : input float\n"
"iflag : input int";
/* extern void F_FUNC(difnrl,DIFNRL)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_difnrl(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iorb = 0;
  PyObject *iorb_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double spin = 0;
  PyObject *spin_capi = Py_None;
  double eigv = 0;
  PyObject *eigv_capi = Py_None;
  int iflag = 0;
  PyObject *iflag_capi = Py_None;
    static char *capi_kwlist[] = {"iter","iorb","v","ar","br","n","l","spin","eigv","iflag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|:atomic_program.difnrl",\
        capi_kwlist,&iter_capi,&iorb_capi,&v_capi,&ar_capi,&br_capi,&n_capi,&l_capi,&spin_capi,&eigv_capi,&iflag_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.difnrl() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iorb */
    f2py_success = int_from_pyobj(&iorb,iorb_capi,"atomic_program.difnrl() 2nd argument (iorb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable v */
  ;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `v' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ar' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `br' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.difnrl() 6th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"atomic_program.difnrl() 7th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable spin */
    f2py_success = double_from_pyobj(&spin,spin_capi,"atomic_program.difnrl() 8th argument (spin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eigv */
    f2py_success = double_from_pyobj(&eigv,eigv_capi,"atomic_program.difnrl() 9th argument (eigv) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iflag */
    f2py_success = int_from_pyobj(&iflag,iflag_capi,"atomic_program.difnrl() 10th argument (iflag) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iorb,v,ar,br,&n,&l,&spin,&eigv,&iflag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iflag*/
  /* End of cleaning variable iflag */
  } /*if (f2py_success) of eigv*/
  /* End of cleaning variable eigv */
  } /*if (f2py_success) of spin*/
  /* End of cleaning variable spin */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of iorb*/
  /* End of cleaning variable iorb */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of difnrl *******************************/

/*********************************** difrel ***********************************/
static char doc_f2py_rout_atomic_program_difrel[] = "\
difrel(iter,iorb,v,ar,br,n,l,spin,eigv)\n\nWrapper for ``difrel``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iorb : input int\n"
"v : input rank-1 array('d') with bounds (*)\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)\n"
"n : input int\n"
"l : input int\n"
"spin : input float\n"
"eigv : input float";
/* extern void F_FUNC(difrel,DIFREL)(int*,int*,double*,double*,double*,int*,int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_difrel(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,int*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iorb = 0;
  PyObject *iorb_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double spin = 0;
  PyObject *spin_capi = Py_None;
  double eigv = 0;
  PyObject *eigv_capi = Py_None;
    static char *capi_kwlist[] = {"iter","iorb","v","ar","br","n","l","spin","eigv",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOO|:atomic_program.difrel",\
        capi_kwlist,&iter_capi,&iorb_capi,&v_capi,&ar_capi,&br_capi,&n_capi,&l_capi,&spin_capi,&eigv_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.difrel() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iorb */
    f2py_success = int_from_pyobj(&iorb,iorb_capi,"atomic_program.difrel() 2nd argument (iorb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable v */
  ;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `v' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ar' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `br' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.difrel() 6th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"atomic_program.difrel() 7th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable spin */
    f2py_success = double_from_pyobj(&spin,spin_capi,"atomic_program.difrel() 8th argument (spin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eigv */
    f2py_success = double_from_pyobj(&eigv,eigv_capi,"atomic_program.difrel() 9th argument (eigv) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iorb,v,ar,br,&n,&l,&spin,&eigv);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of eigv*/
  /* End of cleaning variable eigv */
  } /*if (f2py_success) of spin*/
  /* End of cleaning variable spin */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of iorb*/
  /* End of cleaning variable iorb */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of difrel *******************************/

/*********************************** dmixp ***********************************/
static char doc_f2py_rout_atomic_program_dmixp[] = "\
dmixp(a,b,beta,icy,id,nmsh,c,d,vn1,vn12,vn2,vn22)\n\nWrapper for ``dmixp``.\
\n\nParameters\n----------\n"
"a : input rank-1 array('d') with bounds (*)\n"
"b : input rank-1 array('d') with bounds (*)\n"
"beta : input float\n"
"icy : input int\n"
"id : input int\n"
"nmsh : input int\n"
"c : input rank-1 array('d') with bounds (*)\n"
"d : input rank-1 array('d') with bounds (*)\n"
"vn1 : input rank-1 array('d') with bounds (*)\n"
"vn12 : input rank-1 array('d') with bounds (*)\n"
"vn2 : input rank-1 array('d') with bounds (*)\n"
"vn22 : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(dmixp,DMIXP)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_dmixp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[1] = {-1};
  const int a_Rank = 1;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  double *b = NULL;
  npy_intp b_Dims[1] = {-1};
  const int b_Rank = 1;
  PyArrayObject *capi_b_tmp = NULL;
  int capi_b_intent = 0;
  PyObject *b_capi = Py_None;
  double beta = 0;
  PyObject *beta_capi = Py_None;
  int icy = 0;
  PyObject *icy_capi = Py_None;
  int id = 0;
  PyObject *id_capi = Py_None;
  int nmsh = 0;
  PyObject *nmsh_capi = Py_None;
  double *c = NULL;
  npy_intp c_Dims[1] = {-1};
  const int c_Rank = 1;
  PyArrayObject *capi_c_tmp = NULL;
  int capi_c_intent = 0;
  PyObject *c_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double *vn1 = NULL;
  npy_intp vn1_Dims[1] = {-1};
  const int vn1_Rank = 1;
  PyArrayObject *capi_vn1_tmp = NULL;
  int capi_vn1_intent = 0;
  PyObject *vn1_capi = Py_None;
  double *vn12 = NULL;
  npy_intp vn12_Dims[1] = {-1};
  const int vn12_Rank = 1;
  PyArrayObject *capi_vn12_tmp = NULL;
  int capi_vn12_intent = 0;
  PyObject *vn12_capi = Py_None;
  double *vn2 = NULL;
  npy_intp vn2_Dims[1] = {-1};
  const int vn2_Rank = 1;
  PyArrayObject *capi_vn2_tmp = NULL;
  int capi_vn2_intent = 0;
  PyObject *vn2_capi = Py_None;
  double *vn22 = NULL;
  npy_intp vn22_Dims[1] = {-1};
  const int vn22_Rank = 1;
  PyArrayObject *capi_vn22_tmp = NULL;
  int capi_vn22_intent = 0;
  PyObject *vn22_capi = Py_None;
    static char *capi_kwlist[] = {"a","b","beta","icy","id","nmsh","c","d","vn1","vn12","vn2","vn22",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOOO|:atomic_program.dmixp",\
        capi_kwlist,&a_capi,&b_capi,&beta_capi,&icy_capi,&id_capi,&nmsh_capi,&c_capi,&d_capi,&vn1_capi,&vn12_capi,&vn2_capi,&vn22_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `a' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable b */
  ;
  capi_b_intent |= F2PY_INTENT_IN;
  capi_b_tmp = array_from_pyobj(NPY_DOUBLE,b_Dims,b_Rank,capi_b_intent,b_capi);
  if (capi_b_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `b' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    b = (double *)(PyArray_DATA(capi_b_tmp));

  /* Processing variable beta */
    f2py_success = double_from_pyobj(&beta,beta_capi,"atomic_program.dmixp() 3rd argument (beta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable icy */
    f2py_success = int_from_pyobj(&icy,icy_capi,"atomic_program.dmixp() 4th argument (icy) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
    f2py_success = int_from_pyobj(&id,id_capi,"atomic_program.dmixp() 5th argument (id) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nmsh */
    f2py_success = int_from_pyobj(&nmsh,nmsh_capi,"atomic_program.dmixp() 6th argument (nmsh) can't be converted to int");
  if (f2py_success) {
  /* Processing variable c */
  ;
  capi_c_intent |= F2PY_INTENT_IN;
  capi_c_tmp = array_from_pyobj(NPY_DOUBLE,c_Dims,c_Rank,capi_c_intent,c_capi);
  if (capi_c_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `c' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    c = (double *)(PyArray_DATA(capi_c_tmp));

  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `d' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable vn1 */
  ;
  capi_vn1_intent |= F2PY_INTENT_IN;
  capi_vn1_tmp = array_from_pyobj(NPY_DOUBLE,vn1_Dims,vn1_Rank,capi_vn1_intent,vn1_capi);
  if (capi_vn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `vn1' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn1 = (double *)(PyArray_DATA(capi_vn1_tmp));

  /* Processing variable vn12 */
  ;
  capi_vn12_intent |= F2PY_INTENT_IN;
  capi_vn12_tmp = array_from_pyobj(NPY_DOUBLE,vn12_Dims,vn12_Rank,capi_vn12_intent,vn12_capi);
  if (capi_vn12_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 10th argument `vn12' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn12 = (double *)(PyArray_DATA(capi_vn12_tmp));

  /* Processing variable vn2 */
  ;
  capi_vn2_intent |= F2PY_INTENT_IN;
  capi_vn2_tmp = array_from_pyobj(NPY_DOUBLE,vn2_Dims,vn2_Rank,capi_vn2_intent,vn2_capi);
  if (capi_vn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 11st argument `vn2' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn2 = (double *)(PyArray_DATA(capi_vn2_tmp));

  /* Processing variable vn22 */
  ;
  capi_vn22_intent |= F2PY_INTENT_IN;
  capi_vn22_tmp = array_from_pyobj(NPY_DOUBLE,vn22_Dims,vn22_Rank,capi_vn22_intent,vn22_capi);
  if (capi_vn22_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 12nd argument `vn22' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn22 = (double *)(PyArray_DATA(capi_vn22_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,b,&beta,&icy,&id,&nmsh,c,d,vn1,vn12,vn2,vn22);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vn22_tmp!=vn22_capi) {
    Py_XDECREF(capi_vn22_tmp); }
  }  /*if (capi_vn22_tmp == NULL) ... else of vn22*/
  /* End of cleaning variable vn22 */
  if((PyObject *)capi_vn2_tmp!=vn2_capi) {
    Py_XDECREF(capi_vn2_tmp); }
  }  /*if (capi_vn2_tmp == NULL) ... else of vn2*/
  /* End of cleaning variable vn2 */
  if((PyObject *)capi_vn12_tmp!=vn12_capi) {
    Py_XDECREF(capi_vn12_tmp); }
  }  /*if (capi_vn12_tmp == NULL) ... else of vn12*/
  /* End of cleaning variable vn12 */
  if((PyObject *)capi_vn1_tmp!=vn1_capi) {
    Py_XDECREF(capi_vn1_tmp); }
  }  /*if (capi_vn1_tmp == NULL) ... else of vn1*/
  /* End of cleaning variable vn1 */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
  if((PyObject *)capi_c_tmp!=c_capi) {
    Py_XDECREF(capi_c_tmp); }
  }  /*if (capi_c_tmp == NULL) ... else of c*/
  /* End of cleaning variable c */
  } /*if (f2py_success) of nmsh*/
  /* End of cleaning variable nmsh */
  } /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of icy*/
  /* End of cleaning variable icy */
  } /*if (f2py_success) of beta*/
  /* End of cleaning variable beta */
  if((PyObject *)capi_b_tmp!=b_capi) {
    Py_XDECREF(capi_b_tmp); }
  }  /*if (capi_b_tmp == NULL) ... else of b*/
  /* End of cleaning variable b */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of dmixp ********************************/

/*********************************** dsolv1 ***********************************/
static char doc_f2py_rout_atomic_program_dsolv1[] = "\
dsolv1(nfirst,nlast,nn)\n\nWrapper for ``dsolv1``.\
\n\nParameters\n----------\n"
"nfirst : input int\n"
"nlast : input int\n"
"nn : input rank-1 array('i') with bounds (*)";
/* extern void F_FUNC(dsolv1,DSOLV1)(int*,int*,int*); */
static PyObject *f2py_rout_atomic_program_dsolv1(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  int *nn = NULL;
  npy_intp nn_Dims[1] = {-1};
  const int nn_Rank = 1;
  PyArrayObject *capi_nn_tmp = NULL;
  int capi_nn_intent = 0;
  PyObject *nn_capi = Py_None;
    static char *capi_kwlist[] = {"nfirst","nlast","nn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:atomic_program.dsolv1",\
        capi_kwlist,&nfirst_capi,&nlast_capi,&nn_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.dsolv1() 1st argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.dsolv1() 2nd argument (nlast) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nn */
  ;
  capi_nn_intent |= F2PY_INTENT_IN;
  capi_nn_tmp = array_from_pyobj(NPY_INT,nn_Dims,nn_Rank,capi_nn_intent,nn_capi);
  if (capi_nn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `nn' of atomic_program.dsolv1 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nn = (int *)(PyArray_DATA(capi_nn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nfirst,&nlast,nn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_nn_tmp!=nn_capi) {
    Py_XDECREF(capi_nn_tmp); }
  }  /*if (capi_nn_tmp == NULL) ... else of nn*/
  /* End of cleaning variable nn */
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of dsolv1 *******************************/

/*********************************** pseudo ***********************************/
static char doc_f2py_rout_atomic_program_pseudo[] = "\
pseudo(pot_id,headline,ps_generator,[ps_generator_extra_args])\n\nWrapper for ``pseudo``.\
\n\nParameters\n----------\n"
"pot_id : input string(len=40)\n"
"headline : input string(len=79)\n"
"ps_generator : call-back function\n"
"\nOther Parameters\n----------------\n"
"ps_generator_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def ps_generator(i,ar,br): return \n\
  Required arguments:\n"
"    i : input int\n"
"    ar : input rank-1 array('d') with bounds (1500)\n"
"    br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(pseudo,PSEUDO)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_pseudo(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  string pot_id = NULL;
  int slen(pot_id);
  PyObject *pot_id_capi = Py_None;
  string headline = NULL;
  int slen(headline);
  PyObject *headline_capi = Py_None;
    cb_ps_generator_in_pseudo__user__routines_t ps_generator_cb = { Py_None, NULL, 0 };
    cb_ps_generator_in_pseudo__user__routines_t *ps_generator_cb_ptr = &ps_generator_cb;
    PyTupleObject *ps_generator_xa_capi = NULL;
    cb_ps_generator_in_pseudo__user__routines_typedef ps_generator_cptr;
    static char *capi_kwlist[] = {"pot_id","headline","ps_generator","ps_generator_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|O!:atomic_program.pseudo",\
        capi_kwlist,&pot_id_capi,&headline_capi,&ps_generator_cb.capi,&PyTuple_Type,&ps_generator_xa_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable pot_id */
  slen(pot_id) = 40;
  f2py_success = string_from_pyobj(&pot_id,&slen(pot_id),"",pot_id_capi,"string_from_pyobj failed in converting 1st argument `pot_id' of atomic_program.pseudo to C string");
  if (f2py_success) {
  /* Processing variable headline */
  slen(headline) = 79;
  f2py_success = string_from_pyobj(&headline,&slen(headline),"",headline_capi,"string_from_pyobj failed in converting 2nd argument `headline' of atomic_program.pseudo to C string");
  if (f2py_success) {
  /* Processing variable ps_generator */
if(F2PyCapsule_Check(ps_generator_cb.capi)) {
  ps_generator_cptr = F2PyCapsule_AsVoidPtr(ps_generator_cb.capi);
} else {
  ps_generator_cptr = cb_ps_generator_in_pseudo__user__routines;
}

    if (create_cb_arglist(ps_generator_cb.capi,ps_generator_xa_capi,3,0,&ps_generator_cb.nofargs,&ps_generator_cb.args_capi,"failed in processing argument list for call-back ps_generator.")) {

        CFUNCSMESS("Saving callback variables for `ps_generator`.\n");
        ps_generator_cb_ptr = swap_active_cb_ps_generator_in_pseudo__user__routines(ps_generator_cb_ptr);
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(ps_generator_cb.jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(pot_id,headline,ps_generator_cptr,slen(pot_id),slen(headline));
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
        CFUNCSMESS("Restoring callback variables for `ps_generator`.\n");
        ps_generator_cb_ptr = swap_active_cb_ps_generator_in_pseudo__user__routines(ps_generator_cb_ptr);
        Py_DECREF(ps_generator_cb.args_capi);
    }
  /* End of cleaning variable ps_generator */
    STRINGFREE(headline);
  }  /*if (f2py_success) of headline*/
  /* End of cleaning variable headline */
    STRINGFREE(pot_id);
  }  /*if (f2py_success) of pot_id*/
  /* End of cleaning variable pot_id */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of pseudo *******************************/

/************************************* wf *************************************/
static char doc_f2py_rout_atomic_program_wf[] = "\
wf(i,ar,br)\n\nWrapper for ``wf``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(wf,WF)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_wf(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
    static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:atomic_program.wf",\
        capi_kwlist,&i_capi,&ar_capi,&br_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.wf() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.wf to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.wf to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of wf *********************************/

/************************************ hsc ************************************/
static char doc_f2py_rout_atomic_program_hsc[] = "\
hsc(i,ar,br)\n\nWrapper for ``hsc``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(hsc,HSC)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_hsc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
    static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:atomic_program.hsc",\
        capi_kwlist,&i_capi,&ar_capi,&br_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.hsc() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.hsc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.hsc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of hsc *********************************/

/*********************************** excorr ***********************************/
static char doc_f2py_rout_atomic_program_excorr[] = "\
excorr(id,cdd,cdu,cdc,vod,vou,vxc,vc,exc,ec)\n\nWrapper for ``excorr``.\
\n\nParameters\n----------\n"
"id : input string(len=1)\n"
"cdd : input rank-1 array('d') with bounds (1500)\n"
"cdu : input rank-1 array('d') with bounds (1500)\n"
"cdc : input rank-1 array('d') with bounds (1500)\n"
"vod : input rank-1 array('d') with bounds (1500)\n"
"vou : input rank-1 array('d') with bounds (1500)\n"
"vxc : input float\n"
"vc : input float\n"
"exc : input float\n"
"ec : input float";
/* extern void F_FUNC(excorr,EXCORR)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t); */
static PyObject *f2py_rout_atomic_program_excorr(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  double *cdd = NULL;
  npy_intp cdd_Dims[1] = {-1};
  const int cdd_Rank = 1;
  PyArrayObject *capi_cdd_tmp = NULL;
  int capi_cdd_intent = 0;
  PyObject *cdd_capi = Py_None;
  double *cdu = NULL;
  npy_intp cdu_Dims[1] = {-1};
  const int cdu_Rank = 1;
  PyArrayObject *capi_cdu_tmp = NULL;
  int capi_cdu_intent = 0;
  PyObject *cdu_capi = Py_None;
  double *cdc = NULL;
  npy_intp cdc_Dims[1] = {-1};
  const int cdc_Rank = 1;
  PyArrayObject *capi_cdc_tmp = NULL;
  int capi_cdc_intent = 0;
  PyObject *cdc_capi = Py_None;
  double *vod = NULL;
  npy_intp vod_Dims[1] = {-1};
  const int vod_Rank = 1;
  PyArrayObject *capi_vod_tmp = NULL;
  int capi_vod_intent = 0;
  PyObject *vod_capi = Py_None;
  double *vou = NULL;
  npy_intp vou_Dims[1] = {-1};
  const int vou_Rank = 1;
  PyArrayObject *capi_vou_tmp = NULL;
  int capi_vou_intent = 0;
  PyObject *vou_capi = Py_None;
  double vxc = 0;
  PyObject *vxc_capi = Py_None;
  double vc = 0;
  PyObject *vc_capi = Py_None;
  double exc = 0;
  PyObject *exc_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
    static char *capi_kwlist[] = {"id","cdd","cdu","cdc","vod","vou","vxc","vc","exc","ec",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOO|:atomic_program.excorr",\
        capi_kwlist,&id_capi,&cdd_capi,&cdu_capi,&cdc_capi,&vod_capi,&vou_capi,&vxc_capi,&vc_capi,&exc_capi,&ec_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 1st argument `id' of atomic_program.excorr to C string");
  if (f2py_success) {
  /* Processing variable cdd */
  cdd_Dims[0]=1500;
  capi_cdd_intent |= F2PY_INTENT_IN;
  capi_cdd_tmp = array_from_pyobj(NPY_DOUBLE,cdd_Dims,cdd_Rank,capi_cdd_intent,cdd_capi);
  if (capi_cdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `cdd' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdd = (double *)(PyArray_DATA(capi_cdd_tmp));

  /* Processing variable cdu */
  cdu_Dims[0]=1500;
  capi_cdu_intent |= F2PY_INTENT_IN;
  capi_cdu_tmp = array_from_pyobj(NPY_DOUBLE,cdu_Dims,cdu_Rank,capi_cdu_intent,cdu_capi);
  if (capi_cdu_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `cdu' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdu = (double *)(PyArray_DATA(capi_cdu_tmp));

  /* Processing variable cdc */
  cdc_Dims[0]=1500;
  capi_cdc_intent |= F2PY_INTENT_IN;
  capi_cdc_tmp = array_from_pyobj(NPY_DOUBLE,cdc_Dims,cdc_Rank,capi_cdc_intent,cdc_capi);
  if (capi_cdc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `cdc' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdc = (double *)(PyArray_DATA(capi_cdc_tmp));

  /* Processing variable vod */
  vod_Dims[0]=1500;
  capi_vod_intent |= F2PY_INTENT_IN;
  capi_vod_tmp = array_from_pyobj(NPY_DOUBLE,vod_Dims,vod_Rank,capi_vod_intent,vod_capi);
  if (capi_vod_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `vod' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vod = (double *)(PyArray_DATA(capi_vod_tmp));

  /* Processing variable vou */
  vou_Dims[0]=1500;
  capi_vou_intent |= F2PY_INTENT_IN;
  capi_vou_tmp = array_from_pyobj(NPY_DOUBLE,vou_Dims,vou_Rank,capi_vou_intent,vou_capi);
  if (capi_vou_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `vou' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vou = (double *)(PyArray_DATA(capi_vou_tmp));

  /* Processing variable vxc */
    f2py_success = double_from_pyobj(&vxc,vxc_capi,"atomic_program.excorr() 7th argument (vxc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable vc */
    f2py_success = double_from_pyobj(&vc,vc_capi,"atomic_program.excorr() 8th argument (vc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable exc */
    f2py_success = double_from_pyobj(&exc,exc_capi,"atomic_program.excorr() 9th argument (exc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.excorr() 10th argument (ec) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(id,cdd,cdu,cdc,vod,vou,&vxc,&vc,&exc,&ec,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of exc*/
  /* End of cleaning variable exc */
  } /*if (f2py_success) of vc*/
  /* End of cleaning variable vc */
  } /*if (f2py_success) of vxc*/
  /* End of cleaning variable vxc */
  if((PyObject *)capi_vou_tmp!=vou_capi) {
    Py_XDECREF(capi_vou_tmp); }
  }  /*if (capi_vou_tmp == NULL) ... else of vou*/
  /* End of cleaning variable vou */
  if((PyObject *)capi_vod_tmp!=vod_capi) {
    Py_XDECREF(capi_vod_tmp); }
  }  /*if (capi_vod_tmp == NULL) ... else of vod*/
  /* End of cleaning variable vod */
  if((PyObject *)capi_cdc_tmp!=cdc_capi) {
    Py_XDECREF(capi_cdc_tmp); }
  }  /*if (capi_cdc_tmp == NULL) ... else of cdc*/
  /* End of cleaning variable cdc */
  if((PyObject *)capi_cdu_tmp!=cdu_capi) {
    Py_XDECREF(capi_cdu_tmp); }
  }  /*if (capi_cdu_tmp == NULL) ... else of cdu*/
  /* End of cleaning variable cdu */
  if((PyObject *)capi_cdd_tmp!=cdd_capi) {
    Py_XDECREF(capi_cdd_tmp); }
  }  /*if (capi_cdd_tmp == NULL) ... else of cdd*/
  /* End of cleaning variable cdd */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of excorr *******************************/

/************************************ tm2 ************************************/
static char doc_f2py_rout_atomic_program_tm2[] = "\
tm2(i,wfr,br)\n\nWrapper for ``tm2``.\
\n\nParameters\n----------\n"
"i : input int\n"
"wfr : input rank-1 array('d') with bounds (1500)\n"
"br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(tm2,TM2)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_tm2(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *wfr = NULL;
  npy_intp wfr_Dims[1] = {-1};
  const int wfr_Rank = 1;
  PyArrayObject *capi_wfr_tmp = NULL;
  int capi_wfr_intent = 0;
  PyObject *wfr_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
    static char *capi_kwlist[] = {"i","wfr","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:atomic_program.tm2",\
        capi_kwlist,&i_capi,&wfr_capi,&br_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.tm2() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable wfr */
  wfr_Dims[0]=1500;
  capi_wfr_intent |= F2PY_INTENT_IN;
  capi_wfr_tmp = array_from_pyobj(NPY_DOUBLE,wfr_Dims,wfr_Rank,capi_wfr_intent,wfr_capi);
  if (capi_wfr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `wfr' of atomic_program.tm2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    wfr = (double *)(PyArray_DATA(capi_wfr_tmp));

  /* Processing variable br */
  br_Dims[0]=1500;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.tm2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,wfr,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_wfr_tmp!=wfr_capi) {
    Py_XDECREF(capi_wfr_tmp); }
  }  /*if (capi_wfr_tmp == NULL) ... else of wfr*/
  /* End of cleaning variable wfr */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of tm2 *********************************/

/************************************ ker ************************************/
static char doc_f2py_rout_atomic_program_ker[] = "\
ker(i,ar,br)\n\nWrapper for ``ker``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (1500)\n"
"br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(ker,KER)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_ker(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
    static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOO|:atomic_program.ker",\
        capi_kwlist,&i_capi,&ar_capi,&br_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.ker() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ar_Dims[0]=1500;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.ker to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  br_Dims[0]=1500;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.ker to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of ker *********************************/

/*********************************** wrapup ***********************************/
static char doc_f2py_rout_atomic_program_wrapup[] = "\
wrapup(pot_id)\n\nWrapper for ``wrapup``.\
\n\nParameters\n----------\n"
"pot_id : input string(len=40)";
/* extern void F_FUNC(wrapup,WRAPUP)(string,size_t); */
static PyObject *f2py_rout_atomic_program_wrapup(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  string pot_id = NULL;
  int slen(pot_id);
  PyObject *pot_id_capi = Py_None;
    static char *capi_kwlist[] = {"pot_id",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.wrapup",\
        capi_kwlist,&pot_id_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable pot_id */
  slen(pot_id) = 40;
  f2py_success = string_from_pyobj(&pot_id,&slen(pot_id),"",pot_id_capi,"string_from_pyobj failed in converting 1st argument `pot_id' of atomic_program.wrapup to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(pot_id,slen(pot_id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(pot_id);
  }  /*if (f2py_success) of pot_id*/
  /* End of cleaning variable pot_id */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of wrapup *******************************/

/****************************** cutoff_function ******************************/
static char doc_f2py_rout_atomic_program_cutoff_function[] = "\
cutoff_function = cutoff_function(r)\n\nWrapper for ``cutoff_function``.\
\n\nParameters\n----------\n"
"r : input float\n"
"\nReturns\n-------\n"
"cutoff_function : float";
/* extern void F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION)(double*,double*); */
static PyObject *f2py_rout_atomic_program_cutoff_function(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double cutoff_function = 0;
  double r = 0;
  PyObject *r_capi = Py_None;
    static char *capi_kwlist[] = {"r",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.cutoff_function",\
        capi_kwlist,&r_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable r */
    f2py_success = double_from_pyobj(&r,r_capi,"atomic_program.cutoff_function() 1st argument (r) can't be converted to double");
  if (f2py_success) {
  /* Processing variable cutoff_function */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&cutoff_function,&r);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("d",cutoff_function);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable cutoff_function */
  } /*if (f2py_success) of r*/
  /* End of cleaning variable r */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/*************************** end of cutoff_function ***************************/

/*********************************** splift ***********************************/
static char doc_f2py_rout_atomic_program_splift[] = "\
splift(x,y,yp,ypp,w,ierr,isx,a1,b1,an,bn,[n])\n\nWrapper for ``splift``.\
\n\nParameters\n----------\n"
"x : input rank-1 array('d') with bounds (n)\n"
"y : input rank-1 array('d') with bounds (n)\n"
"yp : input rank-1 array('d') with bounds (n)\n"
"ypp : input rank-1 array('d') with bounds (n)\n"
"w : input rank-2 array('d') with bounds (n,3)\n"
"ierr : input int\n"
"isx : input int\n"
"a1 : input float\n"
"b1 : input float\n"
"an : input float\n"
"bn : input float\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(x)";
/* extern void F_FUNC(splift,SPLIFT)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_splift(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *yp = NULL;
  npy_intp yp_Dims[1] = {-1};
  const int yp_Rank = 1;
  PyArrayObject *capi_yp_tmp = NULL;
  int capi_yp_intent = 0;
  PyObject *yp_capi = Py_None;
  double *ypp = NULL;
  npy_intp ypp_Dims[1] = {-1};
  const int ypp_Rank = 1;
  PyArrayObject *capi_ypp_tmp = NULL;
  int capi_ypp_intent = 0;
  PyObject *ypp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *w = NULL;
  npy_intp w_Dims[2] = {-1, -1};
  const int w_Rank = 2;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
  PyObject *w_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  int isx = 0;
  PyObject *isx_capi = Py_None;
  double a1 = 0;
  PyObject *a1_capi = Py_None;
  double b1 = 0;
  PyObject *b1_capi = Py_None;
  double an = 0;
  PyObject *an_capi = Py_None;
  double bn = 0;
  PyObject *bn_capi = Py_None;
    static char *capi_kwlist[] = {"x","y","yp","ypp","w","ierr","isx","a1","b1","an","bn","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOOOOO|O:atomic_program.splift",\
        capi_kwlist,&x_capi,&y_capi,&yp_capi,&ypp_capi,&w_capi,&ierr_capi,&isx_capi,&a1_capi,&b1_capi,&an_capi,&bn_capi,&n_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `x' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.splift() 6th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isx */
    f2py_success = int_from_pyobj(&isx,isx_capi,"atomic_program.splift() 7th argument (isx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable a1 */
    f2py_success = double_from_pyobj(&a1,a1_capi,"atomic_program.splift() 8th argument (a1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable b1 */
    f2py_success = double_from_pyobj(&b1,b1_capi,"atomic_program.splift() 9th argument (b1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable an */
    f2py_success = double_from_pyobj(&an,an_capi,"atomic_program.splift() 10th argument (an) can't be converted to double");
  if (f2py_success) {
  /* Processing variable bn */
    f2py_success = double_from_pyobj(&bn,bn_capi,"atomic_program.splift() 11st argument (bn) can't be converted to double");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(x); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.splift() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=n,"len(x)>=n","1st keyword n","splift:n=%d",n) {
  /* Processing variable w */
  w_Dims[0]=n,w_Dims[1]=3;
  capi_w_intent |= F2PY_INTENT_IN;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,w_capi);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `w' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

  /* Processing variable y */
  y_Dims[0]=n;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `y' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable yp */
  yp_Dims[0]=n;
  capi_yp_intent |= F2PY_INTENT_IN;
  capi_yp_tmp = array_from_pyobj(NPY_DOUBLE,yp_Dims,yp_Rank,capi_yp_intent,yp_capi);
  if (capi_yp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `yp' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yp = (double *)(PyArray_DATA(capi_yp_tmp));

  /* Processing variable ypp */
  ypp_Dims[0]=n;
  capi_ypp_intent |= F2PY_INTENT_IN;
  capi_ypp_tmp = array_from_pyobj(NPY_DOUBLE,ypp_Dims,ypp_Rank,capi_ypp_intent,ypp_capi);
  if (capi_ypp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ypp' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ypp = (double *)(PyArray_DATA(capi_ypp_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(x,y,yp,ypp,&n,w,&ierr,&isx,&a1,&b1,&an,&bn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ypp_tmp!=ypp_capi) {
    Py_XDECREF(capi_ypp_tmp); }
  }  /*if (capi_ypp_tmp == NULL) ... else of ypp*/
  /* End of cleaning variable ypp */
  if((PyObject *)capi_yp_tmp!=yp_capi) {
    Py_XDECREF(capi_yp_tmp); }
  }  /*if (capi_yp_tmp == NULL) ... else of yp*/
  /* End of cleaning variable yp */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  if((PyObject *)capi_w_tmp!=w_capi) {
    Py_XDECREF(capi_w_tmp); }
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  } /*CHECKSCALAR(len(x)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of bn*/
  /* End of cleaning variable bn */
  } /*if (f2py_success) of an*/
  /* End of cleaning variable an */
  } /*if (f2py_success) of b1*/
  /* End of cleaning variable b1 */
  } /*if (f2py_success) of a1*/
  /* End of cleaning variable a1 */
  } /*if (f2py_success) of isx*/
  /* End of cleaning variable isx */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of splift *******************************/

/*********************************** spliq ***********************************/
static char doc_f2py_rout_atomic_program_spliq[] = "\
spliq(x,y,yp,ypp,xlo,xup,ans,ierr,[n,nup])\n\nWrapper for ``spliq``.\
\n\nParameters\n----------\n"
"x : input rank-1 array('d') with bounds (n)\n"
"y : input rank-1 array('d') with bounds (n)\n"
"yp : input rank-1 array('d') with bounds (n)\n"
"ypp : input rank-1 array('d') with bounds (n)\n"
"xlo : input float\n"
"xup : input rank-1 array('d') with bounds (nup)\n"
"ans : input rank-1 array('d') with bounds (nup)\n"
"ierr : input int\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(x)\n"
"nup : input int, optional\n    Default: len(xup)";
/* extern void F_FUNC(spliq,SPLIQ)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_spliq(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *yp = NULL;
  npy_intp yp_Dims[1] = {-1};
  const int yp_Rank = 1;
  PyArrayObject *capi_yp_tmp = NULL;
  int capi_yp_intent = 0;
  PyObject *yp_capi = Py_None;
  double *ypp = NULL;
  npy_intp ypp_Dims[1] = {-1};
  const int ypp_Rank = 1;
  PyArrayObject *capi_ypp_tmp = NULL;
  int capi_ypp_intent = 0;
  PyObject *ypp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double xlo = 0;
  PyObject *xlo_capi = Py_None;
  double *xup = NULL;
  npy_intp xup_Dims[1] = {-1};
  const int xup_Rank = 1;
  PyArrayObject *capi_xup_tmp = NULL;
  int capi_xup_intent = 0;
  PyObject *xup_capi = Py_None;
  int nup = 0;
  PyObject *nup_capi = Py_None;
  double *ans = NULL;
  npy_intp ans_Dims[1] = {-1};
  const int ans_Rank = 1;
  PyArrayObject *capi_ans_tmp = NULL;
  int capi_ans_intent = 0;
  PyObject *ans_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
    static char *capi_kwlist[] = {"x","y","yp","ypp","xlo","xup","ans","ierr","n","nup",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOOO|OO:atomic_program.spliq",\
        capi_kwlist,&x_capi,&y_capi,&yp_capi,&ypp_capi,&xlo_capi,&xup_capi,&ans_capi,&ierr_capi,&n_capi,&nup_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `x' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable xlo */
    f2py_success = double_from_pyobj(&xlo,xlo_capi,"atomic_program.spliq() 5th argument (xlo) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xup */
  ;
  capi_xup_intent |= F2PY_INTENT_IN;
  capi_xup_tmp = array_from_pyobj(NPY_DOUBLE,xup_Dims,xup_Rank,capi_xup_intent,xup_capi);
  if (capi_xup_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `xup' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xup = (double *)(PyArray_DATA(capi_xup_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.spliq() 8th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(x); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.spliq() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=n,"len(x)>=n","1st keyword n","spliq:n=%d",n) {
  /* Processing variable nup */
  if (nup_capi == Py_None) nup = len(xup); else
    f2py_success = int_from_pyobj(&nup,nup_capi,"atomic_program.spliq() 2nd keyword (nup) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xup)>=nup,"len(xup)>=nup","2nd keyword nup","spliq:nup=%d",nup) {
  /* Processing variable ans */
  ans_Dims[0]=nup;
  capi_ans_intent |= F2PY_INTENT_IN;
  capi_ans_tmp = array_from_pyobj(NPY_DOUBLE,ans_Dims,ans_Rank,capi_ans_intent,ans_capi);
  if (capi_ans_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `ans' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ans = (double *)(PyArray_DATA(capi_ans_tmp));

  /* Processing variable y */
  y_Dims[0]=n;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `y' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable yp */
  yp_Dims[0]=n;
  capi_yp_intent |= F2PY_INTENT_IN;
  capi_yp_tmp = array_from_pyobj(NPY_DOUBLE,yp_Dims,yp_Rank,capi_yp_intent,yp_capi);
  if (capi_yp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `yp' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yp = (double *)(PyArray_DATA(capi_yp_tmp));

  /* Processing variable ypp */
  ypp_Dims[0]=n;
  capi_ypp_intent |= F2PY_INTENT_IN;
  capi_ypp_tmp = array_from_pyobj(NPY_DOUBLE,ypp_Dims,ypp_Rank,capi_ypp_intent,ypp_capi);
  if (capi_ypp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ypp' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ypp = (double *)(PyArray_DATA(capi_ypp_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(x,y,yp,ypp,&n,&xlo,xup,&nup,ans,&ierr);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ypp_tmp!=ypp_capi) {
    Py_XDECREF(capi_ypp_tmp); }
  }  /*if (capi_ypp_tmp == NULL) ... else of ypp*/
  /* End of cleaning variable ypp */
  if((PyObject *)capi_yp_tmp!=yp_capi) {
    Py_XDECREF(capi_yp_tmp); }
  }  /*if (capi_yp_tmp == NULL) ... else of yp*/
  /* End of cleaning variable yp */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  if((PyObject *)capi_ans_tmp!=ans_capi) {
    Py_XDECREF(capi_ans_tmp); }
  }  /*if (capi_ans_tmp == NULL) ... else of ans*/
  /* End of cleaning variable ans */
  } /*CHECKSCALAR(len(xup)>=nup)*/
  } /*if (f2py_success) of nup*/
  /* End of cleaning variable nup */
  } /*CHECKSCALAR(len(x)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_xup_tmp!=xup_capi) {
    Py_XDECREF(capi_xup_tmp); }
  }  /*if (capi_xup_tmp == NULL) ... else of xup*/
  /* End of cleaning variable xup */
  } /*if (f2py_success) of xlo*/
  /* End of cleaning variable xlo */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of spliq ********************************/

/*********************************** velect ***********************************/
static char doc_f2py_rout_atomic_program_velect[] = "\
velect(iter,iconv,id,zelec)\n\nWrapper for ``velect``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iconv : input int\n"
"id : input string(len=1)\n"
"zelec : input float";
/* extern void F_FUNC(velect,VELECT)(int*,int*,string,double*,size_t); */
static PyObject *f2py_rout_atomic_program_velect(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,string,double*,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iconv = 0;
  PyObject *iconv_capi = Py_None;
  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  double zelec = 0;
  PyObject *zelec_capi = Py_None;
    static char *capi_kwlist[] = {"iter","iconv","id","zelec",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|:atomic_program.velect",\
        capi_kwlist,&iter_capi,&iconv_capi,&id_capi,&zelec_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.velect() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iconv */
    f2py_success = int_from_pyobj(&iconv,iconv_capi,"atomic_program.velect() 2nd argument (iconv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 3rd argument `id' of atomic_program.velect to C string");
  if (f2py_success) {
  /* Processing variable zelec */
    f2py_success = double_from_pyobj(&zelec,zelec_capi,"atomic_program.velect() 4th argument (zelec) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iconv,id,&zelec,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of zelec*/
  /* End of cleaning variable zelec */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of iconv*/
  /* End of cleaning variable iconv */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of velect *******************************/

/*********************************** vionic ***********************************/
static char doc_f2py_rout_atomic_program_vionic[] = "\
vionic()\n\nWrapper for ``vionic``.\
\n";
/* extern void F_FUNC(vionic,VIONIC)(void); */
static PyObject *f2py_rout_atomic_program_vionic(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

    static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "|:atomic_program.vionic",\
        capi_kwlist))
        return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of vionic *******************************/

/*********************************** wtrans ***********************************/
static char doc_f2py_rout_atomic_program_wtrans[] = "\
wtrans(vd,r,i,ist,[nr])\n\nWrapper for ``wtrans``.\
\n\nParameters\n----------\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"i : input int\n"
"ist : input int\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(wtrans,WTRANS)(double*,double*,int*,int*,int*); */
static PyObject *f2py_rout_atomic_program_wtrans(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int i = 0;
  PyObject *i_capi = Py_None;
  int ist = 0;
  PyObject *ist_capi = Py_None;
    static char *capi_kwlist[] = {"vd","r","i","ist","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|O:atomic_program.wtrans",\
        capi_kwlist,&vd_capi,&r_capi,&i_capi,&ist_capi,&nr_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `vd' of atomic_program.wtrans to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.wtrans() 3rd argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ist */
    f2py_success = int_from_pyobj(&ist,ist_capi,"atomic_program.wtrans() 4th argument (ist) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.wtrans() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","wtrans:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `r' of atomic_program.wtrans to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(vd,r,&nr,&i,&ist);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of ist*/
  /* End of cleaning variable ist */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of wtrans *******************************/

/************************************ v0pp ************************************/
static char doc_f2py_rout_atomic_program_v0pp[] = "\
v0pp = v0pp(gamma)\n\nWrapper for ``v0pp``.\
\n\nParameters\n----------\n"
"gamma : input float\n"
"\nReturns\n-------\n"
"v0pp : float";
/* extern void F_WRAPPEDFUNC(v0pp,V0PP)(double*,double*); */
static PyObject *f2py_rout_atomic_program_v0pp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double v0pp = 0;
  double gamma = 0;
  PyObject *gamma_capi = Py_None;
    static char *capi_kwlist[] = {"gamma",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.v0pp",\
        capi_kwlist,&gamma_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable gamma */
    f2py_success = double_from_pyobj(&gamma,gamma_capi,"atomic_program.v0pp() 1st argument (gamma) can't be converted to double");
  if (f2py_success) {
  /* Processing variable v0pp */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&v0pp,&gamma);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("d",v0pp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable v0pp */
  } /*if (f2py_success) of gamma*/
  /* End of cleaning variable gamma */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of v0pp ********************************/

/********************************** chg_mism **********************************/
static char doc_f2py_rout_atomic_program_chg_mism[] = "\
chg_mism = chg_mism(xdelta)\n\nWrapper for ``chg_mism``.\
\n\nParameters\n----------\n"
"xdelta : input float\n"
"\nReturns\n-------\n"
"chg_mism : float";
/* extern void F_WRAPPEDFUNC_US(chg_mism,CHG_MISM)(double*,double*); */
static PyObject *f2py_rout_atomic_program_chg_mism(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  double chg_mism = 0;
  double xdelta = 0;
  PyObject *xdelta_capi = Py_None;
    static char *capi_kwlist[] = {"xdelta",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.chg_mism",\
        capi_kwlist,&xdelta_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable xdelta */
    f2py_success = double_from_pyobj(&xdelta,xdelta_capi,"atomic_program.chg_mism() 1st argument (xdelta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable chg_mism */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&chg_mism,&xdelta);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("d",chg_mism);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable chg_mism */
  } /*if (f2py_success) of xdelta*/
  /* End of cleaning variable xdelta */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of chg_mism ******************************/

/*********************************** dsolv2 ***********************************/
static char doc_f2py_rout_atomic_program_dsolv2[] = "\
dsolv2(iter,iconv,id,nfirst,nlast,n_of_core_orbs,nn)\n\nWrapper for ``dsolv2``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iconv : input int\n"
"id : input string(len=1)\n"
"nfirst : input int\n"
"nlast : input int\n"
"n_of_core_orbs : input int\n"
"nn : input rank-1 array('i') with bounds (*)";
/* extern void F_FUNC(dsolv2,DSOLV2)(int*,int*,string,int*,int*,int*,int*,size_t); */
static PyObject *f2py_rout_atomic_program_dsolv2(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,string,int*,int*,int*,int*,size_t)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iconv = 0;
  PyObject *iconv_capi = Py_None;
  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  int n_of_core_orbs = 0;
  PyObject *n_of_core_orbs_capi = Py_None;
  int *nn = NULL;
  npy_intp nn_Dims[1] = {-1};
  const int nn_Rank = 1;
  PyArrayObject *capi_nn_tmp = NULL;
  int capi_nn_intent = 0;
  PyObject *nn_capi = Py_None;
    static char *capi_kwlist[] = {"iter","iconv","id","nfirst","nlast","n_of_core_orbs","nn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|:atomic_program.dsolv2",\
        capi_kwlist,&iter_capi,&iconv_capi,&id_capi,&nfirst_capi,&nlast_capi,&n_of_core_orbs_capi,&nn_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.dsolv2() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iconv */
    f2py_success = int_from_pyobj(&iconv,iconv_capi,"atomic_program.dsolv2() 2nd argument (iconv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 3rd argument `id' of atomic_program.dsolv2 to C string");
  if (f2py_success) {
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.dsolv2() 4th argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.dsolv2() 5th argument (nlast) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n_of_core_orbs */
    f2py_success = int_from_pyobj(&n_of_core_orbs,n_of_core_orbs_capi,"atomic_program.dsolv2() 6th argument (n_of_core_orbs) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nn */
  ;
  capi_nn_intent |= F2PY_INTENT_IN;
  capi_nn_tmp = array_from_pyobj(NPY_INT,nn_Dims,nn_Rank,capi_nn_intent,nn_capi);
  if (capi_nn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `nn' of atomic_program.dsolv2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nn = (int *)(PyArray_DATA(capi_nn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iconv,id,&nfirst,&nlast,&n_of_core_orbs,nn,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_nn_tmp!=nn_capi) {
    Py_XDECREF(capi_nn_tmp); }
  }  /*if (capi_nn_tmp == NULL) ... else of nn*/
  /* End of cleaning variable nn */
  } /*if (f2py_success) of n_of_core_orbs*/
  /* End of cleaning variable n_of_core_orbs */
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of iconv*/
  /* End of cleaning variable iconv */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of dsolv2 *******************************/

/*********************************** etotal ***********************************/
static char doc_f2py_rout_atomic_program_etotal[] = "\
etotal(nfirst,nlast)\n\nWrapper for ``etotal``.\
\n\nParameters\n----------\n"
"nfirst : input int\n"
"nlast : input int";
/* extern void F_FUNC(etotal,ETOTAL)(int*,int*); */
static PyObject *f2py_rout_atomic_program_etotal(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
    static char *capi_kwlist[] = {"nfirst","nlast",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|:atomic_program.etotal",\
        capi_kwlist,&nfirst_capi,&nlast_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.etotal() 1st argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.etotal() 2nd argument (nlast) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nfirst,&nlast);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************* end of etotal *******************************/

/************************************ ext ************************************/
static char doc_f2py_rout_atomic_program_ext[] = "\
ext(i)\n\nWrapper for ``ext``.\
\n\nParameters\n----------\n"
"i : input int";
/* extern void F_FUNC(ext,EXT)(int*); */
static PyObject *f2py_rout_atomic_program_ext(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
    static char *capi_kwlist[] = {"i",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.ext",\
        capi_kwlist,&i_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.ext() 1st argument (i) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/********************************* end of ext *********************************/

/*********************************** input ***********************************/
static char doc_f2py_rout_atomic_program_input[] = "\
input(maxit)\n\nWrapper for ``input``.\
\n\nParameters\n----------\n"
"maxit : input int";
/* extern void F_FUNC(input,INPUT)(int*); */
static PyObject *f2py_rout_atomic_program_input(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int maxit = 0;
  PyObject *maxit_capi = Py_None;
    static char *capi_kwlist[] = {"maxit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "O|:atomic_program.input",\
        capi_kwlist,&maxit_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable maxit */
    f2py_success = int_from_pyobj(&maxit,maxit_capi,"atomic_program.input() 1st argument (maxit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&maxit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of maxit*/
  /* End of cleaning variable maxit */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************************** end of input ********************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_radial_def[] = {
  {"a",0,{{-1}},NPY_DOUBLE},
  {"b",0,{{-1}},NPY_DOUBLE},
  {"r",1,{{1500}},NPY_DOUBLE},
  {"rab",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_radial(char *a,char *b,char *r,char *rab) {
  int i_f2py=0;
  f2py_radial_def[i_f2py++].data = a;
  f2py_radial_def[i_f2py++].data = b;
  f2py_radial_def[i_f2py++].data = r;
  f2py_radial_def[i_f2py++].data = rab;
}
extern void F_FUNC(f2pyinitradial,F2PYINITRADIAL)(void(*)(char*,char*,char*,char*));
static void f2py_init_radial(void) {
  F_FUNC(f2pyinitradial,F2PYINITRADIAL)(f2py_setup_radial);
}

static FortranDataDef f2py_rad_int_def[] = {
  {"nr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_rad_int(char *nr) {
  int i_f2py=0;
  f2py_rad_int_def[i_f2py++].data = nr;
}
extern void F_FUNC_US(f2pyinitrad_int,F2PYINITRAD_INT)(void(*)(char*));
static void f2py_init_rad_int(void) {
  F_FUNC_US(f2pyinitrad_int,F2PYINITRAD_INT)(f2py_setup_rad_int);
}

static FortranDataDef f2py_orbital_def[] = {
  {"so",1,{{40}},NPY_DOUBLE},
  {"zo",1,{{40}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_orbital(char *so,char *zo) {
  int i_f2py=0;
  f2py_orbital_def[i_f2py++].data = so;
  f2py_orbital_def[i_f2py++].data = zo;
}
extern void F_FUNC(f2pyinitorbital,F2PYINITORBITAL)(void(*)(char*,char*));
static void f2py_init_orbital(void) {
  F_FUNC(f2pyinitorbital,F2PYINITORBITAL)(f2py_setup_orbital);
}

static FortranDataDef f2py_orb_int_def[] = {
  {"norb",0,{{-1}},NPY_INT},
  {"ncp",0,{{-1}},NPY_INT},
  {"no",1,{{40}},NPY_INT},
  {"lo",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_orb_int(char *norb,char *ncp,char *no,char *lo) {
  int i_f2py=0;
  f2py_orb_int_def[i_f2py++].data = norb;
  f2py_orb_int_def[i_f2py++].data = ncp;
  f2py_orb_int_def[i_f2py++].data = no;
  f2py_orb_int_def[i_f2py++].data = lo;
}
extern void F_FUNC_US(f2pyinitorb_int,F2PYINITORB_INT)(void(*)(char*,char*,char*,char*));
static void f2py_init_orb_int(void) {
  F_FUNC_US(f2pyinitorb_int,F2PYINITORB_INT)(f2py_setup_orb_int);
}

static FortranDataDef f2py_orb_char_def[] = {
  {"il",2,{{5,1}},NPY_STRING},
  {NULL}
};
static void f2py_setup_orb_char(char *il) {
  int i_f2py=0;
  f2py_orb_char_def[i_f2py++].data = il;
}
extern void F_FUNC_US(f2pyinitorb_char,F2PYINITORB_CHAR)(void(*)(char*));
static void f2py_init_orb_char(void) {
  F_FUNC_US(f2pyinitorb_char,F2PYINITORB_CHAR)(f2py_setup_orb_char);
}

static FortranDataDef f2py_orb_log_def[] = {
  {"down",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_orb_log(char *down) {
  int i_f2py=0;
  f2py_orb_log_def[i_f2py++].data = down;
}
extern void F_FUNC_US(f2pyinitorb_log,F2PYINITORB_LOG)(void(*)(char*));
static void f2py_init_orb_log(void) {
  F_FUNC_US(f2pyinitorb_log,F2PYINITORB_LOG)(f2py_setup_orb_log);
}

static FortranDataDef f2py_param_def[] = {
  {"scheme",0,{{-1}},NPY_INT},
  {"job",0,{{-1}},NPY_INT},
  {"ifcore",0,{{-1}},NPY_INT},
  {"ncore",0,{{-1}},NPY_INT},
  {"rsh",0,{{-1}},NPY_DOUBLE},
  {"zel",0,{{-1}},NPY_DOUBLE},
  {"znuc",0,{{-1}},NPY_DOUBLE},
  {"zsh",0,{{-1}},NPY_DOUBLE},
  {"rc",1,{{5}},NPY_DOUBLE},
  {"rc_input",1,{{5}},NPY_DOUBLE},
  {"cfac",0,{{-1}},NPY_DOUBLE},
  {"rcfac",0,{{-1}},NPY_DOUBLE},
  {"logder_radius",0,{{-1}},NPY_DOUBLE},
  {"indu",1,{{5}},NPY_INT},
  {"indd",1,{{5}},NPY_INT},
  {NULL}
};
static void f2py_setup_param(char *scheme,char *job,char *ifcore,char *ncore,char *rsh,char *zel,char *znuc,char *zsh,char *rc,char *rc_input,char *cfac,char *rcfac,char *logder_radius,char *indu,char *indd) {
  int i_f2py=0;
  f2py_param_def[i_f2py++].data = scheme;
  f2py_param_def[i_f2py++].data = job;
  f2py_param_def[i_f2py++].data = ifcore;
  f2py_param_def[i_f2py++].data = ncore;
  f2py_param_def[i_f2py++].data = rsh;
  f2py_param_def[i_f2py++].data = zel;
  f2py_param_def[i_f2py++].data = znuc;
  f2py_param_def[i_f2py++].data = zsh;
  f2py_param_def[i_f2py++].data = rc;
  f2py_param_def[i_f2py++].data = rc_input;
  f2py_param_def[i_f2py++].data = cfac;
  f2py_param_def[i_f2py++].data = rcfac;
  f2py_param_def[i_f2py++].data = logder_radius;
  f2py_param_def[i_f2py++].data = indu;
  f2py_param_def[i_f2py++].data = indd;
}
extern void F_FUNC(f2pyinitparam,F2PYINITPARAM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_param(void) {
  F_FUNC(f2pyinitparam,F2PYINITPARAM)(f2py_setup_param);
}

static FortranDataDef f2py_par_char_def[] = {
  {"nameat",1,{{2}},NPY_STRING},
  {"ispp",1,{{1}},NPY_STRING},
  {"icorr",1,{{2}},NPY_STRING},
  {"irel",1,{{3}},NPY_STRING},
  {"nicore",1,{{4}},NPY_STRING},
  {NULL}
};
static void f2py_setup_par_char(char *nameat,char *ispp,char *icorr,char *irel,char *nicore) {
  int i_f2py=0;
  f2py_par_char_def[i_f2py++].data = nameat;
  f2py_par_char_def[i_f2py++].data = ispp;
  f2py_par_char_def[i_f2py++].data = icorr;
  f2py_par_char_def[i_f2py++].data = irel;
  f2py_par_char_def[i_f2py++].data = nicore;
}
extern void F_FUNC_US(f2pyinitpar_char,F2PYINITPAR_CHAR)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_par_char(void) {
  F_FUNC_US(f2pyinitpar_char,F2PYINITPAR_CHAR)(f2py_setup_par_char);
}

static FortranDataDef f2py_par_log_def[] = {
  {"normal",0,{{-1}},NPY_INT},
  {"polarized",0,{{-1}},NPY_INT},
  {"relativistic",0,{{-1}},NPY_INT},
  {"is_gga",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_par_log(char *normal,char *polarized,char *relativistic,char *is_gga) {
  int i_f2py=0;
  f2py_par_log_def[i_f2py++].data = normal;
  f2py_par_log_def[i_f2py++].data = polarized;
  f2py_par_log_def[i_f2py++].data = relativistic;
  f2py_par_log_def[i_f2py++].data = is_gga;
}
extern void F_FUNC_US(f2pyinitpar_log,F2PYINITPAR_LOG)(void(*)(char*,char*,char*,char*));
static void f2py_init_par_log(void) {
  F_FUNC_US(f2pyinitpar_log,F2PYINITPAR_LOG)(f2py_setup_par_log);
}

static FortranDataDef f2py_charge_def[] = {
  {"cdd",1,{{1500}},NPY_DOUBLE},
  {"cdu",1,{{1500}},NPY_DOUBLE},
  {"cdc",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_charge(char *cdd,char *cdu,char *cdc) {
  int i_f2py=0;
  f2py_charge_def[i_f2py++].data = cdd;
  f2py_charge_def[i_f2py++].data = cdu;
  f2py_charge_def[i_f2py++].data = cdc;
}
extern void F_FUNC(f2pyinitcharge,F2PYINITCHARGE)(void(*)(char*,char*,char*));
static void f2py_init_charge(void) {
  F_FUNC(f2pyinitcharge,F2PYINITCHARGE)(f2py_setup_charge);
}

static FortranDataDef f2py_elecpot_def[] = {
  {"vid",1,{{1500}},NPY_DOUBLE},
  {"viu",1,{{1500}},NPY_DOUBLE},
  {"vod",1,{{1500}},NPY_DOUBLE},
  {"vou",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_elecpot(char *vid,char *viu,char *vod,char *vou) {
  int i_f2py=0;
  f2py_elecpot_def[i_f2py++].data = vid;
  f2py_elecpot_def[i_f2py++].data = viu;
  f2py_elecpot_def[i_f2py++].data = vod;
  f2py_elecpot_def[i_f2py++].data = vou;
}
extern void F_FUNC(f2pyinitelecpot,F2PYINITELECPOT)(void(*)(char*,char*,char*,char*));
static void f2py_init_elecpot(void) {
  F_FUNC(f2pyinitelecpot,F2PYINITELECPOT)(f2py_setup_elecpot);
}

static FortranDataDef f2py_energy_def[] = {
  {"ev",1,{{40}},NPY_DOUBLE},
  {"ep",1,{{40}},NPY_DOUBLE},
  {"ek",1,{{40}},NPY_DOUBLE},
  {"etot",1,{{10}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_energy(char *ev,char *ep,char *ek,char *etot) {
  int i_f2py=0;
  f2py_energy_def[i_f2py++].data = ev;
  f2py_energy_def[i_f2py++].data = ep;
  f2py_energy_def[i_f2py++].data = ek;
  f2py_energy_def[i_f2py++].data = etot;
}
extern void F_FUNC(f2pyinitenergy,F2PYINITENERGY)(void(*)(char*,char*,char*,char*));
static void f2py_init_energy(void) {
  F_FUNC(f2pyinitenergy,F2PYINITENERGY)(f2py_setup_energy);
}

static FortranDataDef f2py_mixer_def[] = {
  {"vn1d",1,{{1500}},NPY_DOUBLE},
  {"vn11d",1,{{1500}},NPY_DOUBLE},
  {"vn2d",1,{{1500}},NPY_DOUBLE},
  {"vn22d",1,{{1500}},NPY_DOUBLE},
  {"vn1u",1,{{1500}},NPY_DOUBLE},
  {"vn11u",1,{{1500}},NPY_DOUBLE},
  {"vn2u",1,{{1500}},NPY_DOUBLE},
  {"vn22u",1,{{1500}},NPY_DOUBLE},
  {"wk1",1,{{1500}},NPY_DOUBLE},
  {"wk2",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_mixer(char *vn1d,char *vn11d,char *vn2d,char *vn22d,char *vn1u,char *vn11u,char *vn2u,char *vn22u,char *wk1,char *wk2) {
  int i_f2py=0;
  f2py_mixer_def[i_f2py++].data = vn1d;
  f2py_mixer_def[i_f2py++].data = vn11d;
  f2py_mixer_def[i_f2py++].data = vn2d;
  f2py_mixer_def[i_f2py++].data = vn22d;
  f2py_mixer_def[i_f2py++].data = vn1u;
  f2py_mixer_def[i_f2py++].data = vn11u;
  f2py_mixer_def[i_f2py++].data = vn2u;
  f2py_mixer_def[i_f2py++].data = vn22u;
  f2py_mixer_def[i_f2py++].data = wk1;
  f2py_mixer_def[i_f2py++].data = wk2;
}
extern void F_FUNC(f2pyinitmixer,F2PYINITMIXER)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_mixer(void) {
  F_FUNC(f2pyinitmixer,F2PYINITMIXER)(f2py_setup_mixer);
}

static FortranDataDef f2py_ion_def[] = {
  {"viod",2,{{4,1500}},NPY_DOUBLE},
  {"viou",2,{{4,1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ion(char *viod,char *viou) {
  int i_f2py=0;
  f2py_ion_def[i_f2py++].data = viod;
  f2py_ion_def[i_f2py++].data = viou;
}
extern void F_FUNC(f2pyinition,F2PYINITION)(void(*)(char*,char*));
static void f2py_init_ion(void) {
  F_FUNC(f2pyinition,F2PYINITION)(f2py_setup_ion);
}

static FortranDataDef f2py__BLNK__def[] = {
  {"rab2",1,{{1500}},NPY_DOUBLE},
  {"fa",1,{{1500}},NPY_DOUBLE},
  {"fb",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup__BLNK_(char *rab2,char *fa,char *fb) {
  int i_f2py=0;
  f2py__BLNK__def[i_f2py++].data = rab2;
  f2py__BLNK__def[i_f2py++].data = fa;
  f2py__BLNK__def[i_f2py++].data = fb;
}
extern void F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(void(*)(char*,char*,char*));
static void f2py_init__BLNK_(void) {
  F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(f2py_setup__BLNK_);
}

static FortranDataDef f2py_tm2_blk_def[] = {
  {"alpha",0,{{-1}},NPY_DOUBLE},
  {"alpha1",0,{{-1}},NPY_DOUBLE},
  {"alpha2",0,{{-1}},NPY_DOUBLE},
  {"alpha3",0,{{-1}},NPY_DOUBLE},
  {"alpha4",0,{{-1}},NPY_DOUBLE},
  {"arc",0,{{-1}},NPY_DOUBLE},
  {"brc",0,{{-1}},NPY_DOUBLE},
  {"cdrc",0,{{-1}},NPY_DOUBLE},
  {"delta",0,{{-1}},NPY_DOUBLE},
  {"eigv",0,{{-1}},NPY_DOUBLE},
  {"rc1",0,{{-1}},NPY_DOUBLE},
  {"rc2",0,{{-1}},NPY_DOUBLE},
  {"rc3",0,{{-1}},NPY_DOUBLE},
  {"rc4",0,{{-1}},NPY_DOUBLE},
  {"rc5",0,{{-1}},NPY_DOUBLE},
  {"rc6",0,{{-1}},NPY_DOUBLE},
  {"rc7",0,{{-1}},NPY_DOUBLE},
  {"rc8",0,{{-1}},NPY_DOUBLE},
  {"vap",0,{{-1}},NPY_DOUBLE},
  {"vapp",0,{{-1}},NPY_DOUBLE},
  {"vrc",0,{{-1}},NPY_DOUBLE},
  {"jrc",0,{{-1}},NPY_INT},
  {"lp",0,{{-1}},NPY_INT},
  {"ar",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_tm2_blk(char *alpha,char *alpha1,char *alpha2,char *alpha3,char *alpha4,char *arc,char *brc,char *cdrc,char *delta,char *eigv,char *rc1,char *rc2,char *rc3,char *rc4,char *rc5,char *rc6,char *rc7,char *rc8,char *vap,char *vapp,char *vrc,char *jrc,char *lp,char *ar) {
  int i_f2py=0;
  f2py_tm2_blk_def[i_f2py++].data = alpha;
  f2py_tm2_blk_def[i_f2py++].data = alpha1;
  f2py_tm2_blk_def[i_f2py++].data = alpha2;
  f2py_tm2_blk_def[i_f2py++].data = alpha3;
  f2py_tm2_blk_def[i_f2py++].data = alpha4;
  f2py_tm2_blk_def[i_f2py++].data = arc;
  f2py_tm2_blk_def[i_f2py++].data = brc;
  f2py_tm2_blk_def[i_f2py++].data = cdrc;
  f2py_tm2_blk_def[i_f2py++].data = delta;
  f2py_tm2_blk_def[i_f2py++].data = eigv;
  f2py_tm2_blk_def[i_f2py++].data = rc1;
  f2py_tm2_blk_def[i_f2py++].data = rc2;
  f2py_tm2_blk_def[i_f2py++].data = rc3;
  f2py_tm2_blk_def[i_f2py++].data = rc4;
  f2py_tm2_blk_def[i_f2py++].data = rc5;
  f2py_tm2_blk_def[i_f2py++].data = rc6;
  f2py_tm2_blk_def[i_f2py++].data = rc7;
  f2py_tm2_blk_def[i_f2py++].data = rc8;
  f2py_tm2_blk_def[i_f2py++].data = vap;
  f2py_tm2_blk_def[i_f2py++].data = vapp;
  f2py_tm2_blk_def[i_f2py++].data = vrc;
  f2py_tm2_blk_def[i_f2py++].data = jrc;
  f2py_tm2_blk_def[i_f2py++].data = lp;
  f2py_tm2_blk_def[i_f2py++].data = ar;
}
extern void F_FUNC_US(f2pyinittm2_blk,F2PYINITTM2_BLK)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_tm2_blk(void) {
  F_FUNC_US(f2pyinittm2_blk,F2PYINITTM2_BLK)(f2py_setup_tm2_blk);
}

static FortranDataDef f2py_rcompat_def[] = {
  {"aa_def",0,{{-1}},NPY_DOUBLE},
  {"bb_def",0,{{-1}},NPY_DOUBLE},
  {"rmax_def",0,{{-1}},NPY_DOUBLE},
  {"ecuts",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_rcompat(char *aa_def,char *bb_def,char *rmax_def,char *ecuts) {
  int i_f2py=0;
  f2py_rcompat_def[i_f2py++].data = aa_def;
  f2py_rcompat_def[i_f2py++].data = bb_def;
  f2py_rcompat_def[i_f2py++].data = rmax_def;
  f2py_rcompat_def[i_f2py++].data = ecuts;
}
extern void F_FUNC(f2pyinitrcompat,F2PYINITRCOMPAT)(void(*)(char*,char*,char*,char*));
static void f2py_init_rcompat(void) {
  F_FUNC(f2pyinitrcompat,F2PYINITRCOMPAT)(f2py_setup_rcompat);
}

static FortranDataDef f2py_lcompat_def[] = {
  {"use_excorr",0,{{-1}},NPY_INT},
  {"use_old_cc",0,{{-1}},NPY_INT},
  {"use_new_cc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_lcompat(char *use_excorr,char *use_old_cc,char *use_new_cc) {
  int i_f2py=0;
  f2py_lcompat_def[i_f2py++].data = use_excorr;
  f2py_lcompat_def[i_f2py++].data = use_old_cc;
  f2py_lcompat_def[i_f2py++].data = use_new_cc;
}
extern void F_FUNC(f2pyinitlcompat,F2PYINITLCOMPAT)(void(*)(char*,char*,char*));
static void f2py_init_lcompat(void) {
  F_FUNC(f2pyinitlcompat,F2PYINITLCOMPAT)(f2py_setup_lcompat);
}

static FortranDataDef f2py_plot_def[] = {
  {"a",1,{{1500}},NPY_DOUBLE},
  {"b",1,{{1500}},NPY_DOUBLE},
  {"c",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_plot(char *a,char *b,char *c) {
  int i_f2py=0;
  f2py_plot_def[i_f2py++].data = a;
  f2py_plot_def[i_f2py++].data = b;
  f2py_plot_def[i_f2py++].data = c;
}
extern void F_FUNC(f2pyinitplot,F2PYINITPLOT)(void(*)(char*,char*,char*));
static void f2py_init_plot(void) {
  F_FUNC(f2pyinitplot,F2PYINITPLOT)(f2py_setup_plot);
}

static FortranDataDef f2py_nonlinear_def[] = {
  {"arc",0,{{-1}},NPY_DOUBLE},
  {"brc",0,{{-1}},NPY_DOUBLE},
  {"eigv",0,{{-1}},NPY_DOUBLE},
  {"cdrc",0,{{-1}},NPY_DOUBLE},
  {"vrc",0,{{-1}},NPY_DOUBLE},
  {"vap",0,{{-1}},NPY_DOUBLE},
  {"vapp",0,{{-1}},NPY_DOUBLE},
  {"rc1",0,{{-1}},NPY_DOUBLE},
  {"rc2",0,{{-1}},NPY_DOUBLE},
  {"rc3",0,{{-1}},NPY_DOUBLE},
  {"lp",0,{{-1}},NPY_INT},
  {"jrc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nonlinear(char *arc,char *brc,char *eigv,char *cdrc,char *vrc,char *vap,char *vapp,char *rc1,char *rc2,char *rc3,char *lp,char *jrc) {
  int i_f2py=0;
  f2py_nonlinear_def[i_f2py++].data = arc;
  f2py_nonlinear_def[i_f2py++].data = brc;
  f2py_nonlinear_def[i_f2py++].data = eigv;
  f2py_nonlinear_def[i_f2py++].data = cdrc;
  f2py_nonlinear_def[i_f2py++].data = vrc;
  f2py_nonlinear_def[i_f2py++].data = vap;
  f2py_nonlinear_def[i_f2py++].data = vapp;
  f2py_nonlinear_def[i_f2py++].data = rc1;
  f2py_nonlinear_def[i_f2py++].data = rc2;
  f2py_nonlinear_def[i_f2py++].data = rc3;
  f2py_nonlinear_def[i_f2py++].data = lp;
  f2py_nonlinear_def[i_f2py++].data = jrc;
}
extern void F_FUNC(f2pyinitnonlinear,F2PYINITNONLINEAR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_nonlinear(void) {
  F_FUNC(f2pyinitnonlinear,F2PYINITNONLINEAR)(f2py_setup_nonlinear);
}

static FortranDataDef f2py_coeffs_def[] = {
  {"alpha",0,{{-1}},NPY_DOUBLE},
  {"alpha1",0,{{-1}},NPY_DOUBLE},
  {"alpha2",0,{{-1}},NPY_DOUBLE},
  {"alpha3",0,{{-1}},NPY_DOUBLE},
  {"alpha4",0,{{-1}},NPY_DOUBLE},
  {"delta",0,{{-1}},NPY_DOUBLE},
  {"gamma",0,{{-1}},NPY_DOUBLE},
  {"ang_moment",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_coeffs(char *alpha,char *alpha1,char *alpha2,char *alpha3,char *alpha4,char *delta,char *gamma,char *ang_moment) {
  int i_f2py=0;
  f2py_coeffs_def[i_f2py++].data = alpha;
  f2py_coeffs_def[i_f2py++].data = alpha1;
  f2py_coeffs_def[i_f2py++].data = alpha2;
  f2py_coeffs_def[i_f2py++].data = alpha3;
  f2py_coeffs_def[i_f2py++].data = alpha4;
  f2py_coeffs_def[i_f2py++].data = delta;
  f2py_coeffs_def[i_f2py++].data = gamma;
  f2py_coeffs_def[i_f2py++].data = ang_moment;
}
extern void F_FUNC(f2pyinitcoeffs,F2PYINITCOEFFS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_coeffs(void) {
  F_FUNC(f2pyinitcoeffs,F2PYINITCOEFFS)(f2py_setup_coeffs);
}

static FortranDataDef f2py_linear_def[] = {
  {"alin",2,{{5,5}},NPY_DOUBLE},
  {"parity",0,{{-1}},NPY_DOUBLE},
  {"indx",1,{{5}},NPY_INT},
  {NULL}
};
static void f2py_setup_linear(char *alin,char *parity,char *indx) {
  int i_f2py=0;
  f2py_linear_def[i_f2py++].data = alin;
  f2py_linear_def[i_f2py++].data = parity;
  f2py_linear_def[i_f2py++].data = indx;
}
extern void F_FUNC(f2pyinitlinear,F2PYINITLINEAR)(void(*)(char*,char*,char*));
static void f2py_init_linear(void) {
  F_FUNC(f2pyinitlinear,F2PYINITLINEAR)(f2py_setup_linear);
}

static FortranDataDef f2py_input_s_def[] = {
  {"aa",0,{{-1}},NPY_DOUBLE},
  {"bb",0,{{-1}},NPY_DOUBLE},
  {"zion",0,{{-1}},NPY_DOUBLE},
  {"nval",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_input_s(char *aa,char *bb,char *zion,char *nval) {
  int i_f2py=0;
  f2py_input_s_def[i_f2py++].data = aa;
  f2py_input_s_def[i_f2py++].data = bb;
  f2py_input_s_def[i_f2py++].data = zion;
  f2py_input_s_def[i_f2py++].data = nval;
}
extern void F_FUNC_US(f2pyinitinput_s,F2PYINITINPUT_S)(void(*)(char*,char*,char*,char*));
static void f2py_init_input_s(void) {
  F_FUNC_US(f2pyinitinput_s,F2PYINITINPUT_S)(f2py_setup_input_s);
}

static FortranDataDef f2py_input_chr_def[] = {
  {"ray",2,{{5,10}},NPY_STRING},
  {"title",2,{{5,10}},NPY_STRING},
  {NULL}
};
static void f2py_setup_input_chr(char *ray,char *title) {
  int i_f2py=0;
  f2py_input_chr_def[i_f2py++].data = ray;
  f2py_input_chr_def[i_f2py++].data = title;
}
extern void F_FUNC_US(f2pyinitinput_chr,F2PYINITINPUT_CHR)(void(*)(char*,char*));
static void f2py_init_input_chr(void) {
  F_FUNC_US(f2pyinitinput_chr,F2PYINITINPUT_CHR)(f2py_setup_input_chr);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"run",-1,{{-1}},0,(char *)F_FUNC(run,RUN),(f2py_init_func)f2py_rout_atomic_program_run,doc_f2py_rout_atomic_program_run},
  {"nucl_z",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(nucl_z,NUCL_Z),(f2py_init_func)f2py_rout_atomic_program_nucl_z,doc_f2py_rout_atomic_program_nucl_z},
  {"difnrl",-1,{{-1}},0,(char *)F_FUNC(difnrl,DIFNRL),(f2py_init_func)f2py_rout_atomic_program_difnrl,doc_f2py_rout_atomic_program_difnrl},
  {"difrel",-1,{{-1}},0,(char *)F_FUNC(difrel,DIFREL),(f2py_init_func)f2py_rout_atomic_program_difrel,doc_f2py_rout_atomic_program_difrel},
  {"dmixp",-1,{{-1}},0,(char *)F_FUNC(dmixp,DMIXP),(f2py_init_func)f2py_rout_atomic_program_dmixp,doc_f2py_rout_atomic_program_dmixp},
  {"dsolv1",-1,{{-1}},0,(char *)F_FUNC(dsolv1,DSOLV1),(f2py_init_func)f2py_rout_atomic_program_dsolv1,doc_f2py_rout_atomic_program_dsolv1},
  {"pseudo",-1,{{-1}},0,(char *)F_FUNC(pseudo,PSEUDO),(f2py_init_func)f2py_rout_atomic_program_pseudo,doc_f2py_rout_atomic_program_pseudo},
  {"wf",-1,{{-1}},0,(char *)F_FUNC(wf,WF),(f2py_init_func)f2py_rout_atomic_program_wf,doc_f2py_rout_atomic_program_wf},
  {"hsc",-1,{{-1}},0,(char *)F_FUNC(hsc,HSC),(f2py_init_func)f2py_rout_atomic_program_hsc,doc_f2py_rout_atomic_program_hsc},
  {"excorr",-1,{{-1}},0,(char *)F_FUNC(excorr,EXCORR),(f2py_init_func)f2py_rout_atomic_program_excorr,doc_f2py_rout_atomic_program_excorr},
  {"tm2",-1,{{-1}},0,(char *)F_FUNC(tm2,TM2),(f2py_init_func)f2py_rout_atomic_program_tm2,doc_f2py_rout_atomic_program_tm2},
  {"ker",-1,{{-1}},0,(char *)F_FUNC(ker,KER),(f2py_init_func)f2py_rout_atomic_program_ker,doc_f2py_rout_atomic_program_ker},
  {"wrapup",-1,{{-1}},0,(char *)F_FUNC(wrapup,WRAPUP),(f2py_init_func)f2py_rout_atomic_program_wrapup,doc_f2py_rout_atomic_program_wrapup},
  {"cutoff_function",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION),(f2py_init_func)f2py_rout_atomic_program_cutoff_function,doc_f2py_rout_atomic_program_cutoff_function},
  {"splift",-1,{{-1}},0,(char *)F_FUNC(splift,SPLIFT),(f2py_init_func)f2py_rout_atomic_program_splift,doc_f2py_rout_atomic_program_splift},
  {"spliq",-1,{{-1}},0,(char *)F_FUNC(spliq,SPLIQ),(f2py_init_func)f2py_rout_atomic_program_spliq,doc_f2py_rout_atomic_program_spliq},
  {"velect",-1,{{-1}},0,(char *)F_FUNC(velect,VELECT),(f2py_init_func)f2py_rout_atomic_program_velect,doc_f2py_rout_atomic_program_velect},
  {"vionic",-1,{{-1}},0,(char *)F_FUNC(vionic,VIONIC),(f2py_init_func)f2py_rout_atomic_program_vionic,doc_f2py_rout_atomic_program_vionic},
  {"wtrans",-1,{{-1}},0,(char *)F_FUNC(wtrans,WTRANS),(f2py_init_func)f2py_rout_atomic_program_wtrans,doc_f2py_rout_atomic_program_wtrans},
  {"v0pp",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(v0pp,V0PP),(f2py_init_func)f2py_rout_atomic_program_v0pp,doc_f2py_rout_atomic_program_v0pp},
  {"chg_mism",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(chg_mism,CHG_MISM),(f2py_init_func)f2py_rout_atomic_program_chg_mism,doc_f2py_rout_atomic_program_chg_mism},
  {"dsolv2",-1,{{-1}},0,(char *)F_FUNC(dsolv2,DSOLV2),(f2py_init_func)f2py_rout_atomic_program_dsolv2,doc_f2py_rout_atomic_program_dsolv2},
  {"etotal",-1,{{-1}},0,(char *)F_FUNC(etotal,ETOTAL),(f2py_init_func)f2py_rout_atomic_program_etotal,doc_f2py_rout_atomic_program_etotal},
  {"ext",-1,{{-1}},0,(char *)F_FUNC(ext,EXT),(f2py_init_func)f2py_rout_atomic_program_ext,doc_f2py_rout_atomic_program_ext},
  {"input",-1,{{-1}},0,(char *)F_FUNC(input,INPUT),(f2py_init_func)f2py_rout_atomic_program_input,doc_f2py_rout_atomic_program_input},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "atomic_program",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_atomic_program(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = atomic_program_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module atomic_program (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.21.0");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'atomic_program' is auto-generated with f2py (version:1.21.0).\nFunctions:\n"
"  run()\n"
"  nucl_z = nucl_z(name)\n"
"  difnrl(iter,iorb,v,ar,br,n,l,spin,eigv,iflag)\n"
"  difrel(iter,iorb,v,ar,br,n,l,spin,eigv)\n"
"  dmixp(a,b,beta,icy,id,nmsh,c,d,vn1,vn12,vn2,vn22)\n"
"  dsolv1(nfirst,nlast,nn)\n"
"  pseudo(pot_id,headline,ps_generator,ps_generator_extra_args=())\n"
"  wf(i,ar,br)\n"
"  hsc(i,ar,br)\n"
"  excorr(id,cdd,cdu,cdc,vod,vou,vxc,vc,exc,ec)\n"
"  tm2(i,wfr,br)\n"
"  ker(i,ar,br)\n"
"  wrapup(pot_id)\n"
"  cutoff_function = cutoff_function(r)\n"
"  splift(x,y,yp,ypp,w,ierr,isx,a1,b1,an,bn,n=len(x))\n"
"  spliq(x,y,yp,ypp,xlo,xup,ans,ierr,n=len(x),nup=len(xup))\n"
"  velect(iter,iconv,id,zelec)\n"
"  vionic()\n"
"  wtrans(vd,r,i,ist,nr=len(vd))\n"
"  v0pp = v0pp(gamma)\n"
"  chg_mism = chg_mism(xdelta)\n"
"  dsolv2(iter,iconv,id,nfirst,nlast,n_of_core_orbs,nn)\n"
"  etotal(nfirst,nlast)\n"
"  ext(i)\n"
"  input(maxit)\n"
"COMMON blocks:\n""  /radial/ a,b,r(1500),rab(1500)\n""  /rad_int/ nr\n""  /orbital/ so(40),zo(40)\n""  /orb_int/ norb,ncp,no(40),lo(40)\n""  /orb_char/ il(5,1)\n""  /orb_log/ down(40)\n""  /param/ scheme,job,ifcore,ncore,rsh,zel,znuc,zsh,rc(5),rc_input(5),cfac,rcfac,logder_radius,indu(5),indd(5)\n""  /par_char/ nameat(2),ispp(1),icorr(2),irel(3),nicore(4)\n""  /par_log/ normal,polarized,relativistic,is_gga\n""  /charge/ cdd(1500),cdu(1500),cdc(1500)\n""  /elecpot/ vid(1500),viu(1500),vod(1500),vou(1500)\n""  /energy/ ev(40),ep(40),ek(40),etot(10)\n""  /mixer/ vn1d(1500),vn11d(1500),vn2d(1500),vn22d(1500),vn1u(1500),vn11u(1500),vn2u(1500),vn22u(1500),wk1(1500),wk2(1500)\n""  /ion/ viod(4,1500),viou(4,1500)\n""  /_BLNK_/ rab2(1500),fa(1500),fb(1500)\n""  /tm2_blk/ alpha,alpha1,alpha2,alpha3,alpha4,arc,brc,cdrc,delta,eigv,rc1,rc2,rc3,rc4,rc5,rc6,rc7,rc8,vap,vapp,vrc,jrc,lp,ar(1500)\n""  /rcompat/ aa_def,bb_def,rmax_def,ecuts\n""  /lcompat/ use_excorr,use_old_cc,use_new_cc\n""  /plot/ a(1500),b(1500),c(1500)\n""  /nonlinear/ arc,brc,eigv,cdrc,vrc,vap,vapp,rc1,rc2,rc3,lp,jrc\n""  /coeffs/ alpha,alpha1,alpha2,alpha3,alpha4,delta,gamma,ang_moment\n""  /linear/ alin(5,5),parity,indx(5)\n""  /input_s/ aa,bb,zion,nval\n""  /input_chr/ ray(5,10),title(5,10)\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.21.0");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  atomic_program_error = PyErr_NewException ("atomic_program.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_atomic_program_error", atomic_program_error);
  Py_DECREF(atomic_program_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }


    {
      extern double F_FUNC_US(nucl_z,NUCL_Z)(void);
      PyObject* o = PyDict_GetItemString(d,"nucl_z");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(nucl_z,NUCL_Z),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("nucl_z");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    












    {
      extern double F_FUNC_US(cutoff_function,CUTOFF_FUNCTION)(void);
      PyObject* o = PyDict_GetItemString(d,"cutoff_function");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(cutoff_function,CUTOFF_FUNCTION),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("cutoff_function");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern double F_FUNC(v0pp,V0PP)(void);
      PyObject* o = PyDict_GetItemString(d,"v0pp");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(v0pp,V0PP),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("v0pp");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC_US(chg_mism,CHG_MISM)(void);
      PyObject* o = PyDict_GetItemString(d,"chg_mism");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(chg_mism,CHG_MISM),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("chg_mism");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    




/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_radial_def,f2py_init_radial);
  F2PyDict_SetItemString(d, "radial", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rad_int_def,f2py_init_rad_int);
  F2PyDict_SetItemString(d, "rad_int", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orbital_def,f2py_init_orbital);
  F2PyDict_SetItemString(d, "orbital", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_int_def,f2py_init_orb_int);
  F2PyDict_SetItemString(d, "orb_int", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_char_def,f2py_init_orb_char);
  F2PyDict_SetItemString(d, "orb_char", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_log_def,f2py_init_orb_log);
  F2PyDict_SetItemString(d, "orb_log", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_param_def,f2py_init_param);
  F2PyDict_SetItemString(d, "param", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_par_char_def,f2py_init_par_char);
  F2PyDict_SetItemString(d, "par_char", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_par_log_def,f2py_init_par_log);
  F2PyDict_SetItemString(d, "par_log", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_charge_def,f2py_init_charge);
  F2PyDict_SetItemString(d, "charge", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_elecpot_def,f2py_init_elecpot);
  F2PyDict_SetItemString(d, "elecpot", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_energy_def,f2py_init_energy);
  F2PyDict_SetItemString(d, "energy", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mixer_def,f2py_init_mixer);
  F2PyDict_SetItemString(d, "mixer", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ion_def,f2py_init_ion);
  F2PyDict_SetItemString(d, "ion", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py__BLNK__def,f2py_init__BLNK_);
  F2PyDict_SetItemString(d, "_BLNK_", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_tm2_blk_def,f2py_init_tm2_blk);
  F2PyDict_SetItemString(d, "tm2_blk", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rcompat_def,f2py_init_rcompat);
  F2PyDict_SetItemString(d, "rcompat", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lcompat_def,f2py_init_lcompat);
  F2PyDict_SetItemString(d, "lcompat", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_plot_def,f2py_init_plot);
  F2PyDict_SetItemString(d, "plot", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nonlinear_def,f2py_init_nonlinear);
  F2PyDict_SetItemString(d, "nonlinear", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_coeffs_def,f2py_init_coeffs);
  F2PyDict_SetItemString(d, "coeffs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_linear_def,f2py_init_linear);
  F2PyDict_SetItemString(d, "linear", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_input_s_def,f2py_init_input_s);
  F2PyDict_SetItemString(d, "input_s", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_input_chr_def,f2py_init_input_chr);
  F2PyDict_SetItemString(d, "input_chr", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"atomic_program");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
