from typing import Any, NamedTuple

from osmium import MergeInputReader as MergeInputReader
from osmium import version as version

LOG: Any

class OsmosisState(NamedTuple):
    sequence: Any
    timestamp: Any

class DownloadResult(NamedTuple):
    id: Any
    reader: Any
    newest: Any

class ReplicationServer:
    baseurl: Any
    diff_type: Any
    session: Any
    def __init__(self, url, diff_type: str = ...) -> None: ...
    def make_request(self, url): ...
    def open_url(self, url): ...
    def collect_diffs(self, start_id, max_size: int = ...): ...
    def apply_diffs(self, handler, start_id, max_size: int = ..., idx: str = ..., simplify: bool = ...): ...
    def apply_diffs_to_file(
        self, infile, outfile, start_id, max_size: int = ..., set_replication_header: bool = ..., extra_headers: Any | None = ..., outformat: Any | None = ...
    ): ...
    def timestamp_to_sequence(self, timestamp, balanced_search: bool = ...): ...
    def get_state_info(self, seq: Any | None = ..., retries: int = ...): ...
    def get_diff_block(self, seq): ...
    def get_state_url(self, seq): ...
    def get_diff_url(self, seq): ...
