import datetime
from typing import ClassVar, Iterator, Optional, Tuple, overload

ALL: osm_entity_bits
AREA: osm_entity_bits
CHANGESET: osm_entity_bits
NODE: osm_entity_bits
NOTHING: osm_entity_bits
OBJECT: osm_entity_bits
RELATION: osm_entity_bits
WAY: osm_entity_bits

class Area(OSMObject):
    def __init__(self, *args, **kwargs) -> None: ...
    def from_way(self) -> bool: ...
    def inner_rings(self, outer_ring: OuterRing) -> InnerRingIterator: ...
    def is_multipolygon(self) -> bool: ...
    def num_rings(self) -> Tuple[int, int]: ...
    def orig_id(self) -> int: ...
    def outer_rings(self) -> Iterator: ...

class Box:
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: Location, arg1: Location) -> None: ...
    def contains(self, location: Location) -> bool: ...
    @overload
    def extend(self, location: Location) -> Box: ...
    @overload
    def extend(self, box: Box) -> Box: ...
    def size(self) -> float: ...
    def valid(self) -> bool: ...
    @property
    def bottom_left(self) -> Location: ...
    @property
    def top_right(self) -> Location: ...

class Changeset:
    def __init__(self, *args, **kwargs) -> None: ...
    def user_is_anonymous(self) -> bool: ...
    @property
    def bounds(self) -> Box: ...
    @property
    def closed_at(self) -> datetime.datetime: ...
    @property
    def created_at(self) -> datetime.datetime: ...
    @property
    def id(self) -> int: ...
    @property
    def num_changes(self) -> int: ...
    @property
    def open(self) -> bool: ...
    @property
    def tags(self) -> TagList: ...
    @property
    def uid(self) -> int: ...
    @property
    def user(self) -> str: ...

class InnerRing(NodeRefList):
    def __init__(self, *args, **kwargs) -> None: ...

class InnerRingIterator:
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterator: ...

class Location:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    def lat_without_check(self) -> float: ...
    def lon_without_check(self) -> float: ...
    def valid(self) -> bool: ...
    @property
    def lat(self) -> float: ...
    @property
    def lon(self) -> float: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class Node(OSMObject):
    replace: ClassVar[function] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def location(self) -> Location: ...

class NodeRef:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lat(self) -> float: ...
    @property
    def location(self) -> Location: ...
    @property
    def lon(self) -> float: ...
    @property
    def ref(self) -> int: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class NodeRefList:
    def __init__(self, *args, **kwargs) -> None: ...
    def ends_have_same_id(self) -> bool: ...
    def ends_have_same_location(self) -> bool: ...
    def is_closed(self) -> bool: ...
    def __getitem__(self, arg0: int) -> NodeRef: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...

class OSMObject:
    def __init__(self, *args, **kwargs) -> None: ...
    def positive_id(self) -> int: ...
    def user_is_anonymous(self) -> bool: ...
    @property
    def changeset(self) -> int: ...
    @property
    def deleted(self) -> bool: ...
    @property
    def id(self) -> int: ...
    @property
    def tags(self) -> TagList: ...
    @property
    def timestamp(self) -> datetime.datetime: ...
    @property
    def uid(self) -> int: ...
    @property
    def user(self) -> str: ...
    @property
    def version(self) -> int: ...
    @property
    def visible(self) -> bool: ...

class OuterRing(NodeRefList):
    def __init__(self, *args, **kwargs) -> None: ...

class Relation(OSMObject):
    replace: ClassVar[function] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def members(self) -> RelationMemberList: ...

class RelationMember:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def ref(self) -> int: ...
    @property
    def role(self) -> str: ...
    @property
    def type(self) -> str: ...

class RelationMemberList:
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...

class Tag:
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> TagIterator: ...
    @property
    def k(self) -> str: ...
    @property
    def v(self) -> str: ...

class TagIterator:
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> TagIterator: ...
    def __len__(self) -> int: ...
    def __next__(self) -> str: ...

class TagList:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def get(self, key: str, default: Optional[str]) -> str: ...
    @overload
    def get(self, arg0: str) -> str: ...
    def __contains__(self, arg0: str) -> bool: ...
    def __getitem__(self, arg0: str) -> str: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...

class Way(OSMObject):
    replace: ClassVar[function] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def ends_have_same_id(self) -> bool: ...
    def ends_have_same_location(self) -> bool: ...
    def is_closed(self) -> bool: ...
    @property
    def nodes(self) -> WayNodeList: ...

class WayNodeList(NodeRefList):
    def __init__(self, *args, **kwargs) -> None: ...

class osm_entity_bits:
    ALL: ClassVar[osm_entity_bits] = ...
    AREA: ClassVar[osm_entity_bits] = ...
    CHANGESET: ClassVar[osm_entity_bits] = ...
    NODE: ClassVar[osm_entity_bits] = ...
    NOTHING: ClassVar[osm_entity_bits] = ...
    OBJECT: ClassVar[osm_entity_bits] = ...
    RELATION: ClassVar[osm_entity_bits] = ...
    WAY: ClassVar[osm_entity_bits] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...
