from typing import ClassVar, overload

import osmium.osm._osm

ALL: use_nodes
BACKWARD: direction
FORWARD: direction
UNIQUE: use_nodes

class Coordinates:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: osmium.osm._osm.Location) -> None: ...
    def valid(self) -> bool: ...
    @property
    def x(self) -> float: ...
    @property
    def y(self) -> float: ...

class GeoJSONFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm._osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm._osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm._osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm._osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm._osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm._osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

class WKBFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm._osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm._osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm._osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm._osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm._osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm._osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

class WKTFactory:
    def __init__(self) -> None: ...
    @overload
    def create_linestring(self, list: osmium.osm._osm.WayNodeList, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    @overload
    def create_linestring(self, way: osmium.osm._osm.Way, use_nodes: use_nodes = ..., direction: direction = ...) -> str: ...
    def create_multipolygon(self, area: osmium.osm._osm.Area) -> str: ...
    @overload
    def create_point(self, location: osmium.osm._osm.Location) -> str: ...
    @overload
    def create_point(self, node: osmium.osm._osm.Node) -> str: ...
    @overload
    def create_point(self, ref: osmium.osm._osm.NodeRef) -> str: ...
    @property
    def epsg(self) -> int: ...
    @property
    def proj_string(self) -> str: ...

class direction:
    BACKWARD: ClassVar[direction] = ...
    FORWARD: ClassVar[direction] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: bool) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> bool: ...
    def __int__(self) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: bool) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> bool: ...

class use_nodes:
    ALL: ClassVar[use_nodes] = ...
    UNIQUE: ClassVar[use_nodes] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: bool) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> bool: ...
    def __int__(self) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: bool) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> bool: ...

def haversine_distance(list: osmium.osm._osm.WayNodeList) -> float: ...
def lonlat_to_mercator(coordinate: Coordinates) -> Coordinates: ...
def mercator_to_lonlat(coordinate: Coordinates) -> Coordinates: ...
