
# Watson Health Cognitive Services Python SDK Version 1.1.4

The IBM Watson Health Cognitive Services (WHCS) Python SDK allows developers to programmatically interact with the following WHCS services:

| Service Name | Imported Class Name |
|--------------|-------------|
| [Annotator for Clinical data](https://cloud.ibm.com/apidocs/wh-acd) | AnnotatorForClinicalDataV1 |
| [Insights for Medical Literature](https://cloud.ibm.com/apidocs/wh-iml) | InsightsForMedicalLiteratureServiceV1 |

NOTE:  You must be signed in to IBM Cloud to see the docs.

## Prerequisites

An [IBM Cloud](https://cloud.ibm.com/registration?target=%2Fdeveloper%2Fwatson&) account.

An IAM API key to allow the SDK to access your provisioned service instance.

Python 3.5 or above

## Installation

To install, use `pip`

```bash
pip install --upgrade ibm-whcs-sdk
```

## Using the SDK
For general SDK usage information, please see [this link](https://github.com/IBM/ibm-cloud-sdk-common/blob/master/README.md)

## Questions

If you are having difficulties using this SDK or have a question about the IBM Cloud services,
please ask a question at [Stack Overflow](http://stackoverflow.com/questions/ask?tags=ibm-cloud).

## Issues
If you encounter an issue with the project, you are welcome to submit a
[bug report](https://github.com/IBM/whcs-python-sdk/issues).
Before that, please search for similar issues. It's possible that someone has already reported the problem.

## Open source @ IBM
Find more open source projects on the [IBM Github Page](http://ibm.github.io/)

## Contributing
See [CONTRIBUTING](CONTRIBUTING.md).

## License

The IBM Watson Health Cognitive Services Python SDK is released under the Apache 2.0 license.
The license's full text can be found in [LICENSE](LICENSE.md).