# mypy-boto3-comprehendmedical

[![PyPI - mypy-boto3-comprehendmedical](https://img.shields.io/pypi/v/mypy-boto3-comprehendmedical.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehendmedical)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-comprehendmedical.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehendmedical)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ComprehendMedical 1.14.21](https://boto3.amazonaws.com/v1/documentation/api/1.14.21/reference/services/comprehendmedical.html#ComprehendMedical) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ComprehendMedical` service.

```bash
python -m pip install boto3-stubs[comprehendmedical]
```

## How to use

### Client annotations

`ComprehendMedicalClient` provides annotations for `boto3.client("comprehendmedical")`.

```python
import boto3

from mypy_boto3_comprehendmedical import ComprehendMedicalClient
from mypy_boto3_comprehendmedical.type_defs import AttributeTypeDef, ...

client: ComprehendMedicalClient = boto3.client("comprehendmedical")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ComprehendMedicalClient = session.client("comprehendmedical")
```








### Typed dictionations

`mypy_boto3_comprehendmedical.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AttributeTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_comprehendmedical` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("comprehendmedical")

session_client = boto3.Session().client("comprehendmedical")
```
