# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRecoveryGroupResult',
    'AwaitableGetRecoveryGroupResult',
    'get_recovery_group',
    'get_recovery_group_output',
]

@pulumi.output_type
class GetRecoveryGroupResult:
    def __init__(__self__, cells=None, recovery_group_arn=None, tags=None):
        if cells and not isinstance(cells, list):
            raise TypeError("Expected argument 'cells' to be a list")
        pulumi.set(__self__, "cells", cells)
        if recovery_group_arn and not isinstance(recovery_group_arn, str):
            raise TypeError("Expected argument 'recovery_group_arn' to be a str")
        pulumi.set(__self__, "recovery_group_arn", recovery_group_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cells(self) -> Optional[Sequence[str]]:
        """
        A list of the cell Amazon Resource Names (ARNs) in the recovery group.
        """
        return pulumi.get(self, "cells")

    @property
    @pulumi.getter(name="recoveryGroupArn")
    def recovery_group_arn(self) -> Optional[str]:
        """
        A collection of tags associated with a resource.
        """
        return pulumi.get(self, "recovery_group_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.RecoveryGroupTag']]:
        """
        A collection of tags associated with a resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRecoveryGroupResult(GetRecoveryGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecoveryGroupResult(
            cells=self.cells,
            recovery_group_arn=self.recovery_group_arn,
            tags=self.tags)


def get_recovery_group(recovery_group_name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecoveryGroupResult:
    """
    AWS Route53 Recovery Readiness Recovery Group Schema and API specifications.


    :param str recovery_group_name: The name of the recovery group to create.
    """
    __args__ = dict()
    __args__['recoveryGroupName'] = recovery_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53recoveryreadiness:getRecoveryGroup', __args__, opts=opts, typ=GetRecoveryGroupResult).value

    return AwaitableGetRecoveryGroupResult(
        cells=__ret__.cells,
        recovery_group_arn=__ret__.recovery_group_arn,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_recovery_group)
def get_recovery_group_output(recovery_group_name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRecoveryGroupResult]:
    """
    AWS Route53 Recovery Readiness Recovery Group Schema and API specifications.


    :param str recovery_group_name: The name of the recovery group to create.
    """
    ...
