# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicaKeyResult',
    'AwaitableGetReplicaKeyResult',
    'get_replica_key',
    'get_replica_key_output',
]

@pulumi.output_type
class GetReplicaKeyResult:
    def __init__(__self__, arn=None, description=None, enabled=None, key_id=None, key_policy=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_policy and not isinstance(key_policy, dict):
            raise TypeError("Expected argument 'key_policy' to be a dict")
        pulumi.set(__self__, "key_policy", key_policy)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the AWS KMS key. Use a description that helps you to distinguish this AWS KMS key from others in the account, such as its intended use.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Specifies whether the AWS KMS key is enabled. Disabled AWS KMS keys cannot be used in cryptographic operations.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyPolicy")
    def key_policy(self) -> Optional[Any]:
        """
        The key policy that authorizes use of the AWS KMS key. The key policy must observe the following rules.
        """
        return pulumi.get(self, "key_policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ReplicaKeyTag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetReplicaKeyResult(GetReplicaKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicaKeyResult(
            arn=self.arn,
            description=self.description,
            enabled=self.enabled,
            key_id=self.key_id,
            key_policy=self.key_policy,
            tags=self.tags)


def get_replica_key(key_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicaKeyResult:
    """
    The AWS::KMS::ReplicaKey resource specifies a multi-region replica AWS KMS key in AWS Key Management Service (AWS KMS).
    """
    __args__ = dict()
    __args__['keyId'] = key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:kms:getReplicaKey', __args__, opts=opts, typ=GetReplicaKeyResult).value

    return AwaitableGetReplicaKeyResult(
        arn=__ret__.arn,
        description=__ret__.description,
        enabled=__ret__.enabled,
        key_id=__ret__.key_id,
        key_policy=__ret__.key_policy,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_replica_key)
def get_replica_key_output(key_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicaKeyResult]:
    """
    The AWS::KMS::ReplicaKey resource specifies a multi-region replica AWS KMS key in AWS Key Management Service (AWS KMS).
    """
    ...
