# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        device: List[BatchAddDeviceGroupRelationsRequestDevice] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.device = device

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchAddDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(
        self,
        valid_device_count: int = None,
        success_added_device_count: int = None,
        request_id: str = None,
        exceed_ten_group_device_count: int = None,
        error_message: str = None,
        already_related_group_device_count: int = None,
        code: str = None,
        success: bool = None,
    ):
        self.valid_device_count = valid_device_count
        self.success_added_device_count = success_added_device_count
        self.request_id = request_id
        self.exceed_ten_group_device_count = exceed_ten_group_device_count
        self.error_message = error_message
        self.already_related_group_device_count = already_related_group_device_count
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchAddDeviceGroupRelationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        sign: str = None,
        timestamp: str = None,
        sign_method: str = None,
        client_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.sign = sign
        self.timestamp = timestamp
        self.sign_method = sign_method
        self.client_id = client_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        gw_product_key: str = None,
        ext: Dict[str, Any] = None,
        gw_device_name: str = None,
        topo_add_item: List[BatchAddThingTopoRequestTopoAddItem] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.gw_product_key = gw_product_key
        self.ext = ext
        self.gw_device_name = gw_device_name
        self.topo_add_item = topo_add_item

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.ext is not None:
            result['Ext'] = self.ext
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('Ext') is not None:
            self.ext = m.get('Ext')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoShrinkRequestTopoAddItem(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        sign: str = None,
        timestamp: str = None,
        sign_method: str = None,
        client_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.sign = sign
        self.timestamp = timestamp
        self.sign_method = sign_method
        self.client_id = client_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoShrinkRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        gw_product_key: str = None,
        ext_shrink: str = None,
        gw_device_name: str = None,
        topo_add_item: List[BatchAddThingTopoShrinkRequestTopoAddItem] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.gw_product_key = gw_product_key
        self.ext_shrink = ext_shrink
        self.gw_device_name = gw_device_name
        self.topo_add_item = topo_add_item

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.ext_shrink is not None:
            result['Ext'] = self.ext_shrink
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('Ext') is not None:
            self.ext_shrink = m.get('Ext')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoShrinkRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchAddThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchBindDeviceToEdgeInstanceWithDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDeviceToEdgeInstanceWithDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(
        self,
        device_nickname: str = None,
        device_name: str = None,
    ):
        self.device_nickname = device_nickname
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: List[str] = None,
        device_name_list: List[BatchCheckDeviceNamesRequestDeviceNameList] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.device_name_list = device_name_list

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(
        self,
        invalid_device_name: List[str] = None,
    ):
        self.invalid_device_name = invalid_device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList(TeaModel):
    def __init__(
        self,
        invalid_device_nickname: List[str] = None,
    ):
        self.invalid_device_nickname = invalid_device_nickname

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        invalid_device_name_list: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList = None,
        invalid_device_nickname_list: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList = None,
    ):
        self.apply_id = apply_id
        self.invalid_device_name_list = invalid_device_name_list
        self.invalid_device_nickname_list = invalid_device_nickname_list

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: BatchCheckDeviceNamesResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchCheckDeviceNamesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchCheckDeviceNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchClearEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchClearEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        device: List[BatchDeleteDeviceGroupRelationsRequestDevice] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.device = device

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchDeleteDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(
        self,
        valid_device_count: int = None,
        request_id: str = None,
        success_device_count: int = None,
        error_message: str = None,
        already_related_group_device_count: int = None,
        code: str = None,
        success: bool = None,
    ):
        self.valid_device_count = valid_device_count
        self.request_id = request_id
        self.success_device_count = success_device_count
        self.error_message = error_message
        self.already_related_group_device_count = already_related_group_device_count
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchDeleteDeviceGroupRelationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchDeleteEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        bind_status: int = None,
        iot_id: str = None,
    ):
        self.bind_status = bind_status
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceBindStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: List[BatchGetDeviceBindStatusResponseBodyData] = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetDeviceBindStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceBindStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: List[str] = None,
        iot_id: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        last_online_time: str = None,
        device_name: str = None,
        device_id: str = None,
        as_address: str = None,
        iot_id: str = None,
    ):
        self.status = status
        self.last_online_time = last_online_time
        self.device_name = device_name
        self.device_id = device_id
        self.as_address = as_address
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusList(TeaModel):
    def __init__(
        self,
        device_status: List[BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus] = None,
    ):
        self.device_status = device_status

    def validate(self):
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_status_list: BatchGetDeviceStateResponseBodyDeviceStatusList = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.device_status_list = device_status_list
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseBodyDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetDeviceStateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_ids = driver_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseBodyDriverList(TeaModel):
    def __init__(
        self,
        gmt_create_timestamp: int = None,
        type: int = None,
        cpu_arch: str = None,
        driver_id: str = None,
        is_built_in: bool = None,
        gmt_modified_timestamp: int = None,
        runtime: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
    ):
        self.gmt_create_timestamp = gmt_create_timestamp
        self.type = type
        self.cpu_arch = cpu_arch
        self.driver_id = driver_id
        self.is_built_in = is_built_in
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.runtime = runtime
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.type is not None:
            result['Type'] = self.type
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        return self


class BatchGetEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        driver_list: List[BatchGetEdgeDriverResponseBodyDriverList] = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.driver_list = driver_list
        self.code = code
        self.success = success

    def validate(self):
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseBodyDriverList()
                self.driver_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_ids = channel_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig(TeaModel):
    def __init__(
        self,
        key: str = None,
        config_id: str = None,
        format: str = None,
        content: str = None,
    ):
        self.key = key
        self.config_id = config_id
        self.format = format
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList(TeaModel):
    def __init__(
        self,
        config: List[BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannel(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        channel_id: str = None,
        config_list: BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList = None,
    ):
        self.channel_name = channel_name
        self.channel_id = channel_id
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseBodyData(TeaModel):
    def __init__(
        self,
        channel: List[BatchGetEdgeInstanceChannelResponseBodyDataChannel] = None,
    ):
        self.channel = channel

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: BatchGetEdgeInstanceChannelResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList(TeaModel):
    def __init__(
        self,
        channel_name: str = None,
        channel_id: str = None,
        iot_id: str = None,
    ):
        self.channel_name = channel_name
        self.channel_id = channel_id
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
        device_channel_list: List[BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList] = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success
        self.device_channel_list = device_channel_list

    def validate(self):
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig(TeaModel):
    def __init__(
        self,
        content: str = None,
        format: str = None,
    ):
        self.content = content
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList(TeaModel):
    def __init__(
        self,
        config: BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig = None,
        iot_id: str = None,
    ):
        self.config = config
        self.iot_id = iot_id

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        device_config_list: List[BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList] = None,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.device_config_list = device_config_list
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        iot_id: str = None,
    ):
        self.driver_id = driver_id
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        device_driver_list: List[BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList] = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.device_driver_list = device_driver_list
        self.code = code
        self.success = success

    def validate(self):
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDeviceDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_ids = driver_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList(TeaModel):
    def __init__(
        self,
        key: str = None,
        config_id: str = None,
        format: str = None,
        content: str = None,
    ):
        self.key = key
        self.config_id = config_id
        self.format = format
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        config_list: List[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList] = None,
    ):
        self.driver_id = driver_id
        self.config_list = config_list

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        driver_config_list: List[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList] = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.driver_config_list = driver_config_list
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchGetEdgeInstanceDriverConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        qos: int = None,
        topic_short_name: str = None,
        message_content: str = None,
        device_name: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.qos = qos
        self.topic_short_name = topic_short_name
        self.message_content = message_content
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchPubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchPubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchPubResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchPubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        product_key: str = None,
        iot_instance_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        device_name: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.product_key = product_key
        self.iot_instance_id = iot_instance_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchQueryDeviceDetailResponseBodyDataData(TeaModel):
    def __init__(
        self,
        status: str = None,
        utc_active: str = None,
        product_name: str = None,
        device_name: str = None,
        firmware_version: str = None,
        utc_create: str = None,
        product_key: str = None,
        node_type: int = None,
        region: str = None,
        device_secret: str = None,
        gmt_active: str = None,
        gmt_create: str = None,
        nickname: str = None,
        iot_id: str = None,
    ):
        self.status = status
        self.utc_active = utc_active
        self.product_name = product_name
        self.device_name = device_name
        self.firmware_version = firmware_version
        self.utc_create = utc_create
        self.product_key = product_key
        self.node_type = node_type
        self.region = region
        self.device_secret = device_secret
        self.gmt_active = gmt_active
        self.gmt_create = gmt_create
        self.nickname = nickname
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchQueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[BatchQueryDeviceDetailResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: BatchQueryDeviceDetailResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchQueryDeviceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchQueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        count: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class BatchRegisterDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
    ):
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: BatchRegisterDeviceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchRegisterDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        apply_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBodyData(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
    ):
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: BatchRegisterDeviceWithApplyIdResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchRegisterDeviceWithApplyIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_id = channel_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchSetEdgeInstanceDeviceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(
        self,
        content: str = None,
        iot_id: str = None,
    ):
        self.content = content
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        device_configs: List[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.device_configs = device_configs

    def validate(self):
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchSetEdgeInstanceDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        iot_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.iot_ids = iot_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUnbindDeviceFromEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindDeviceFromEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        iot_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        device_nickname_info: List[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.device_nickname_info = device_nickname_info

    def validate(self):
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BatchUpdateDeviceNicknameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUpdateDeviceNicknameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        application_id: str = None,
        application_version: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.application_id = application_id
        self.application_version = application_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindApplicationToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindApplicationToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        order_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindDriverToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindDriverToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindGatewayToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindGatewayToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        role_arn: str = None,
        role_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.role_arn = role_arn
        self.role_name = role_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindRoleToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindRoleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        rule_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindSceneRuleToEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSceneRuleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTAStrategyByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTAStrategyByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        job_id: str = None,
        device_name: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.job_id = job_id
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class CancelOTATaskByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTATaskByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        job_id: str = None,
        cancel_scheduled_task: bool = None,
        cancel_queued_task: bool = None,
        cancel_in_progress_task: bool = None,
        cancel_notified_task: bool = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id
        self.cancel_scheduled_task = cancel_scheduled_task
        self.cancel_queued_task = cancel_queued_task
        self.cancel_in_progress_task = cancel_in_progress_task
        self.cancel_notified_task = cancel_notified_task

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        return self


class CancelOTATaskByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOTATaskByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ClearEdgeInstanceDriverConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloseEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloseEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        source_product_key: str = None,
        target_product_key: str = None,
        source_model_version: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.source_product_key = source_product_key
        self.target_product_key = target_product_key
        self.source_model_version = source_model_version
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CopyThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CopyThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
        group_id: str = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConsumerGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConsumerGroupSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(
        self,
        type: str = None,
        required: bool = None,
        example: str = None,
        name: str = None,
        desc: str = None,
    ):
        self.type = type
        self.required = required
        self.example = example
        self.name = name
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(
        self,
        type: str = None,
        required: bool = None,
        example: str = None,
        name: str = None,
        desc: str = None,
    ):
        self.type = type
        self.required = required
        self.example = example
        self.name = name
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        display_name: str = None,
        origin_sql: str = None,
        desc: str = None,
        template_sql: str = None,
        api_path: str = None,
        iot_instance_id: str = None,
        request_param: List[CreateDataAPIServiceRequestRequestParam] = None,
        response_param: List[CreateDataAPIServiceRequestResponseParam] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.display_name = display_name
        self.origin_sql = origin_sql
        self.desc = desc
        self.template_sql = template_sql
        self.api_path = api_path
        self.iot_instance_id = iot_instance_id
        self.request_param = request_param
        self.response_param = response_param

    def validate(self):
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        return self


class CreateDataAPIServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        api_srn: str = None,
        create_time: int = None,
        last_update_time: int = None,
    ):
        self.api_srn = api_srn
        self.create_time = create_time
        self.last_update_time = last_update_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateDataAPIServiceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataAPIServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        super_group_id: str = None,
        group_desc: str = None,
        group_name: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.super_group_id = super_group_id
        self.group_desc = group_desc
        self.group_name = group_name
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateDeviceGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        utc_create: str = None,
        group_desc: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.utc_create = utc_create
        self.group_desc = group_desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class CreateDeviceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateDeviceGroupResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_name: str = None,
        driver_protocol: str = None,
        runtime: str = None,
        cpu_arch: str = None,
        is_built_in: bool = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_name = driver_name
        self.driver_protocol = driver_protocol
        self.runtime = runtime
        self.cpu_arch = cpu_arch
        self.is_built_in = is_built_in

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        driver_id: str = None,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.driver_id = driver_id
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
        edge_version: str = None,
        description: str = None,
        source_config: str = None,
        driver_config: str = None,
        container_config: str = None,
        config_check_rule: str = None,
        argument: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version
        self.edge_version = edge_version
        self.description = description
        self.source_config = source_config
        self.driver_config = driver_config
        self.container_config = container_config
        self.config_check_rule = config_check_rule
        self.argument = argument

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        name: str = None,
        tags: str = None,
        spec: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.name = name
        self.tags = tags
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.instance_id = instance_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(
        self,
        key: str = None,
        content: str = None,
        format: str = None,
    ):
        self.key = key
        self.content = content
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        driver_id: str = None,
        channel_name: str = None,
        configs: List[CreateEdgeInstanceChannelRequestConfigs] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.driver_id = driver_id
        self.channel_name = channel_name
        self.configs = configs

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceChannelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        deployment_id: str = None,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.deployment_id = deployment_id
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        resource_id: str = None,
        file_name: str = None,
        iot_instance_id: str = None,
        type: str = None,
        instance_id: str = None,
        resource_version: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.resource_id = resource_id
        self.file_name = file_name
        self.iot_instance_id = iot_instance_id
        self.type = type
        self.instance_id = instance_id
        self.resource_version = resource_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseBodyData(TeaModel):
    def __init__(
        self,
        oss_address: str = None,
        oss_pre_signed_address: str = None,
    ):
        self.oss_address = oss_address
        self.oss_pre_signed_address = oss_pre_signed_address

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        return self


class CreateEdgeOssPreSignedAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateEdgeOssPreSignedAddressResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEdgeOssPreSignedAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        description: str = None,
        job_document: str = None,
        type: str = None,
        job_file: Dict[str, Any] = None,
        job_name: str = None,
        timeout_config: Dict[str, Any] = None,
        rollout_config: Dict[str, Any] = None,
        target_config: Dict[str, Any] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.job_document = job_document
        self.type = type
        self.job_file = job_file
        self.job_name = job_name
        self.timeout_config = timeout_config
        self.rollout_config = rollout_config
        self.target_config = target_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        description: str = None,
        job_document: str = None,
        type: str = None,
        job_file_shrink: str = None,
        job_name: str = None,
        timeout_config_shrink: str = None,
        rollout_config_shrink: str = None,
        target_config_shrink: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.description = description
        self.job_document = job_document
        self.type = type
        self.job_file_shrink = job_file_shrink
        self.job_name = job_name
        self.timeout_config_shrink = timeout_config_shrink
        self.rollout_config_shrink = rollout_config_shrink
        self.target_config_shrink = target_config_shrink

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
        job_id: str = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(
        self,
        dev_eui: str = None,
        pin_code: str = None,
    ):
        self.dev_eui = dev_eui
        self.pin_code = pin_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_info: List[CreateLoRaNodesTaskRequestDeviceInfo] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponseBody(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.task_id = task_id
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLoRaNodesTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLoRaNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        overwrite_mode: int = None,
        dynamic_mode: int = None,
        src_version: List[str] = None,
        tag: List[CreateOTADynamicUpgradeJobRequestTag] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.overwrite_mode = overwrite_mode
        self.dynamic_mode = dynamic_mode
        self.src_version = src_version
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTADynamicUpgradeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateOTADynamicUpgradeJobResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTADynamicUpgradeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_name: str = None,
        dest_version: str = None,
        firmware_url: str = None,
        firmware_sign: str = None,
        sign_method: str = None,
        firmware_size: int = None,
        product_key: str = None,
        firmware_desc: str = None,
        type: int = None,
        src_version: str = None,
        module_name: str = None,
        need_to_verify: bool = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_name = firmware_name
        self.dest_version = dest_version
        self.firmware_url = firmware_url
        self.firmware_sign = firmware_sign
        self.sign_method = sign_method
        self.firmware_size = firmware_size
        self.product_key = product_key
        self.firmware_desc = firmware_desc
        self.type = type
        self.src_version = src_version
        self.module_name = module_name
        self.need_to_verify = need_to_verify

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        return self


class CreateOTAFirmwareResponseBodyData(TeaModel):
    def __init__(
        self,
        utc_create: str = None,
        firmware_id: str = None,
    ):
        self.utc_create = utc_create
        self.firmware_id = firmware_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class CreateOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateOTAFirmwareResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        alias_name: str = None,
        iot_instance_id: str = None,
        module_name: str = None,
        desc: str = None,
        product_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.alias_name = alias_name
        self.iot_instance_id = iot_instance_id
        self.module_name = module_name
        self.desc = desc
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAModuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        product_key: str = None,
        target_selection: str = None,
        schedule_time: int = None,
        retry_interval: int = None,
        retry_count: int = None,
        timeout_in_minutes: int = None,
        maximum_per_minute: int = None,
        gray_percent: str = None,
        schedule_finish_time: int = None,
        overwrite_mode: int = None,
        dn_list_file_url: str = None,
        src_version: List[str] = None,
        target_device_name: List[str] = None,
        tag: List[CreateOTAStaticUpgradeJobRequestTag] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.product_key = product_key
        self.target_selection = target_selection
        self.schedule_time = schedule_time
        self.retry_interval = retry_interval
        self.retry_count = retry_count
        self.timeout_in_minutes = timeout_in_minutes
        self.maximum_per_minute = maximum_per_minute
        self.gray_percent = gray_percent
        self.schedule_finish_time = schedule_finish_time
        self.overwrite_mode = overwrite_mode
        self.dn_list_file_url = dn_list_file_url
        self.src_version = src_version
        self.target_device_name = target_device_name
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTAStaticUpgradeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateOTAStaticUpgradeJobResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAStaticUpgradeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        timeout_in_minutes: int = None,
        product_key: str = None,
        target_device_name: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.timeout_in_minutes = timeout_in_minutes
        self.product_key = product_key
        self.target_device_name = target_device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class CreateOTAVerifyJobResponseBodyData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateOTAVerifyJobResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOTAVerifyJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAVerifyJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_name: str = None,
        node_type: int = None,
        data_format: int = None,
        description: str = None,
        aliyun_commodity_code: str = None,
        id_2: bool = None,
        category_id: int = None,
        protocol_type: str = None,
        net_type: str = None,
        join_permission_id: str = None,
        resource_group_id: str = None,
        auth_type: str = None,
        category_key: str = None,
        publish_auto: bool = None,
        validate_type: int = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_name = product_name
        self.node_type = node_type
        self.data_format = data_format
        self.description = description
        self.aliyun_commodity_code = aliyun_commodity_code
        self.id_2 = id_2
        self.category_id = category_id
        self.protocol_type = protocol_type
        self.net_type = net_type
        self.join_permission_id = join_permission_id
        self.resource_group_id = resource_group_id
        self.auth_type = auth_type
        self.category_key = category_key
        self.publish_auto = publish_auto
        self.validate_type = validate_type
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateProductResponseBodyData(TeaModel):
    def __init__(
        self,
        auth_type: str = None,
        product_key: str = None,
        product_name: str = None,
        node_type: int = None,
        description: str = None,
        id_2: bool = None,
        product_secret: str = None,
        protocol_type: str = None,
        data_format: int = None,
        aliyun_commodity_code: str = None,
    ):
        self.auth_type = auth_type
        self.product_key = product_key
        self.product_name = product_name
        self.node_type = node_type
        self.description = description
        self.id_2 = id_2
        self.product_secret = product_secret
        self.protocol_type = protocol_type
        self.data_format = data_format
        self.aliyun_commodity_code = aliyun_commodity_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        return self


class CreateProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: CreateProductResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        product_key: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.product_key = product_key
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        product_tag: List[CreateProductTagsRequestProductTag] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBodyInvalidProductTagsProductTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class CreateProductTagsResponseBodyInvalidProductTags(TeaModel):
    def __init__(
        self,
        product_tag: List[CreateProductTagsResponseBodyInvalidProductTagsProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseBodyInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        invalid_product_tags: CreateProductTagsResponseBodyInvalidProductTags = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.invalid_product_tags = invalid_product_tags
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseBodyInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        topic_short_name: str = None,
        operation: str = None,
        desc: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.topic_short_name = topic_short_name
        self.operation = operation
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateProductTopicResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        topic_id: int = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.topic_id = topic_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProductTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        select: str = None,
        short_topic: str = None,
        where: str = None,
        product_key: str = None,
        name: str = None,
        rule_desc: str = None,
        data_type: str = None,
        topic_type: int = None,
        resource_group_id: str = None,
        topic: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.select = select
        self.short_topic = short_topic
        self.where = where
        self.product_key = product_key
        self.name = name
        self.rule_desc = rule_desc
        self.data_type = data_type
        self.topic_type = topic_type
        self.resource_group_id = resource_group_id
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_id: int = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.rule_id = rule_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: int = None,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class CreateRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        action_id: int = None,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.action_id = action_id
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_name: str = None,
        rule_content: str = None,
        rule_description: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_name = rule_name
        self.rule_content = rule_content
        self.rule_description = rule_description

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.rule_id = rule_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_data_flag: bool = None,
        device_life_cycle_flag: bool = None,
        device_status_change_flag: bool = None,
        device_topo_life_cycle_flag: bool = None,
        found_device_list_flag: bool = None,
        mns_configuration: str = None,
        type: str = None,
        ota_event_flag: bool = None,
        thing_history_flag: bool = None,
        device_tag_flag: bool = None,
        ota_version_flag: bool = None,
        ota_job_flag: bool = None,
        consumer_group_ids: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_data_flag = device_data_flag
        self.device_life_cycle_flag = device_life_cycle_flag
        self.device_status_change_flag = device_status_change_flag
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag
        self.found_device_list_flag = found_device_list_flag
        self.mns_configuration = mns_configuration
        self.type = type
        self.ota_event_flag = ota_event_flag
        self.thing_history_flag = thing_history_flag
        self.device_tag_flag = device_tag_flag
        self.ota_version_flag = ota_version_flag
        self.ota_job_flag = ota_job_flag
        self.consumer_group_ids = consumer_group_ids

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        return self


class CreateSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        thing_model_json: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.thing_model_json = thing_model_json
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        script_content: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        script_type: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.script_content = script_content
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.script_type = script_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateThingScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        src_topic: str = None,
        dst_topic: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.src_topic = src_topic
        self.dst_topic = dst_topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        return self


class CreateTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(
        self,
        topic: List[Dict[str, Any]] = None,
    ):
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        failure_topics: CreateTopicRouteTableResponseBodyFailureTopics = None,
        error_message: str = None,
        code: str = None,
        is_all_succeed: bool = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.failure_topics = failure_topics
        self.error_message = error_message
        self.code = code
        self.is_all_succeed = is_all_succeed
        self.success = success

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTopicRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientIdsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_id: str = None,
        iot_instance_id: str = None,
        auth_config: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_id = iot_id
        self.iot_instance_id = iot_instance_id
        self.auth_config = auth_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class DeleteClientIdsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteClientIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteClientIdsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClientIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConsumerGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        consumer_group_id: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.consumer_group_id = consumer_group_id
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConsumerGroupSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        file_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteDeviceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        prop_key: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.prop_key = prop_key
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDevicePropResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDevicePropResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeDriverResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        job_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        module_name: str = None,
        auth_config: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.module_name = module_name
        self.auth_config = auth_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class DeleteOTAModuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteOTAModuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        product_tag_key: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.product_tag_key = product_tag_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        return self


class DeleteProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        topic_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProductTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        action_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.action_id = action_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class DeleteRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        type: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSubscribeRelationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        function_block_id: str = None,
        is_clear_all_function: bool = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
        property_identifier: List[str] = None,
        service_identifier: List[str] = None,
        event_identifier: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.function_block_id = function_block_id
        self.is_clear_all_function = is_clear_all_function
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key
        self.property_identifier = property_identifier
        self.service_identifier = service_identifier
        self.event_identifier = event_identifier

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.is_clear_all_function is not None:
            result['IsClearAllFunction'] = self.is_clear_all_function
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IsClearAllFunction') is not None:
            self.is_clear_all_function = m.get('IsClearAllFunction')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        return self


class DeleteThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        src_topic: str = None,
        dst_topic: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.src_topic = src_topic
        self.dst_topic = dst_topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        return self


class DeleteTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(
        self,
        topic: List[Dict[str, Any]] = None,
    ):
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        failure_topics: DeleteTopicRouteTableResponseBodyFailureTopics = None,
        error_message: str = None,
        code: str = None,
        is_all_succeed: bool = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.failure_topics = failure_topics
        self.error_message = error_message
        self.code = code
        self.is_all_succeed = is_all_succeed
        self.success = success

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTopicRouteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableThingRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DisableThingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableThingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableThingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableThingRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class EnableThingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableThingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableThingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        signature: str = None,
        host: str = None,
        file_url: str = None,
        policy: str = None,
        object_storage: str = None,
        utc_create: str = None,
        access_key_id: str = None,
    ):
        self.key = key
        self.signature = signature
        self.host = host
        self.file_url = file_url
        self.policy = policy
        self.object_storage = object_storage
        self.utc_create = utc_create
        self.access_key_id = access_key_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        return self


class GenerateDeviceNameListURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GenerateDeviceNameListURLResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDeviceNameListURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDeviceNameListURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        file_suffix: str = None,
        biz_code: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix
        self.biz_code = biz_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class GenerateFileUploadURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        oss_access_key_id: str = None,
        signature: str = None,
        host: str = None,
        policy: str = None,
        object_storage: str = None,
    ):
        self.key = key
        self.oss_access_key_id = oss_access_key_id
        self.signature = signature
        self.host = host
        self.policy = policy
        self.object_storage = object_storage

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GenerateFileUploadURLResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateFileUploadURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateFileUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        file_suffix: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.file_suffix = file_suffix

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseBodyData(TeaModel):
    def __init__(
        self,
        key: str = None,
        ossaccess_key_id: str = None,
        signature: str = None,
        host: str = None,
        policy: str = None,
        object_storage: str = None,
        firmware_url: str = None,
        utc_create: str = None,
    ):
        self.key = key
        self.ossaccess_key_id = ossaccess_key_id
        self.signature = signature
        self.host = host
        self.policy = policy
        self.object_storage = object_storage
        self.firmware_url = firmware_url
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateOTAUploadURLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GenerateOTAUploadURLResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateOTAUploadURLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateOTAUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        api_srn: str = None,
        iot_instance_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.api_srn = api_srn
        self.iot_instance_id = iot_instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(
        self,
        type: str = None,
        required: bool = None,
        example: str = None,
        name: str = None,
        desc: str = None,
    ):
        self.type = type
        self.required = required
        self.example = example
        self.name = name
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(
        self,
        request_params: List[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams] = None,
    ):
        self.request_params = request_params

    def validate(self):
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(
        self,
        type: str = None,
        required: bool = None,
        example: str = None,
        name: str = None,
        desc: str = None,
    ):
        self.type = type
        self.required = required
        self.example = example
        self.name = name
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(
        self,
        response_params: List[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams] = None,
    ):
        self.response_params = response_params

    def validate(self):
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO(TeaModel):
    def __init__(
        self,
        request_params: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams = None,
        origin_sql: str = None,
        response_params: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams = None,
        template_sql: str = None,
    ):
        self.request_params = request_params
        self.origin_sql = origin_sql
        self.response_params = response_params
        self.template_sql = template_sql

    def validate(self):
        if self.request_params:
            self.request_params.validate()
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        result = dict()
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        return self


class GetDataAPIServiceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        status: int = None,
        api_srn: str = None,
        sql_template_dto: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO = None,
        description: str = None,
        create_time: int = None,
        last_update_time: int = None,
        request_method: str = None,
        date_format: str = None,
        request_protocol: str = None,
        api_path: str = None,
    ):
        self.display_name = display_name
        self.status = status
        self.api_srn = api_srn
        self.sql_template_dto = sql_template_dto
        self.description = description
        self.create_time = create_time
        self.last_update_time = last_update_time
        self.request_method = request_method
        self.date_format = date_format
        self.request_protocol = request_protocol
        self.api_path = api_path

    def validate(self):
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        return self


class GetDataAPIServiceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetDataAPIServiceDetailResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataAPIServiceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataAPIServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceShadowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        shadow_message: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.shadow_message = shadow_message
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceShadowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceShadowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetDeviceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDeviceStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetDeviceStatusResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        driver_id: str = None,
        driver_version: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.driver_id = driver_id
        self.driver_version = driver_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        gmt_create_timestamp: int = None,
        config_check_rule: str = None,
        edge_version: str = None,
        driver_id: str = None,
        gmt_modified_timestamp: int = None,
        version_state: str = None,
        container_config: str = None,
        description: str = None,
        driver_config: str = None,
        argument: str = None,
        driver_version: str = None,
        source_config: str = None,
    ):
        self.gmt_create_timestamp = gmt_create_timestamp
        self.config_check_rule = config_check_rule
        self.edge_version = edge_version
        self.driver_id = driver_id
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.version_state = version_state
        self.container_config = container_config
        self.description = description
        self.driver_config = driver_config
        self.argument = argument
        self.driver_version = driver_version
        self.source_config = source_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        return self


class GetEdgeDriverVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetEdgeDriverVersionResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeDriverVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        type: str = None,
        gmt_create_timestamp: int = None,
        role_arn: str = None,
        role_attach_time: str = None,
        spec: int = None,
        gmt_modified_timestamp: int = None,
        tags: str = None,
        role_name: str = None,
        instance_id: str = None,
        gmt_modified: str = None,
        role_attach_timestamp: int = None,
        latest_deployment_type: str = None,
        latest_deployment_status: int = None,
        biz_enable: bool = None,
        gmt_create: str = None,
        name: str = None,
    ):
        self.type = type
        self.gmt_create_timestamp = gmt_create_timestamp
        self.role_arn = role_arn
        self.role_attach_time = role_attach_time
        self.spec = spec
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.tags = tags
        self.role_name = role_name
        self.instance_id = instance_id
        self.gmt_modified = gmt_modified
        self.role_attach_timestamp = role_attach_timestamp
        self.latest_deployment_type = latest_deployment_type
        self.latest_deployment_status = latest_deployment_status
        self.biz_enable = biz_enable
        self.gmt_create = gmt_create
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetEdgeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetEdgeInstanceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        instance_id: str = None,
        deployment_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.instance_id = instance_id
        self.deployment_id = deployment_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList(TeaModel):
    def __init__(
        self,
        gmt_create_timestamp: int = None,
        status: int = None,
        stage: int = None,
        gmt_modified_timestamp: int = None,
        log: str = None,
        gmt_modified: str = None,
        operate_type: int = None,
        resource_type: str = None,
        snapshot_id: str = None,
        gmt_completed: str = None,
        gmt_create: str = None,
        gmt_completed_timestamp: int = None,
        resource_id: str = None,
        resource_name: str = None,
    ):
        self.gmt_create_timestamp = gmt_create_timestamp
        self.status = status
        self.stage = stage
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.log = log
        self.gmt_modified = gmt_modified
        self.operate_type = operate_type
        self.resource_type = resource_type
        self.snapshot_id = snapshot_id
        self.gmt_completed = gmt_completed
        self.gmt_create = gmt_create
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.resource_id = resource_id
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.status is not None:
            result['Status'] = self.status
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskList(TeaModel):
    def __init__(
        self,
        gmt_create_timestamp: int = None,
        status: int = None,
        resource_snapshot_list: List[GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList] = None,
        stage: int = None,
        gateway_id: str = None,
        gmt_modified_timestamp: int = None,
        gmt_completed: str = None,
        gmt_create: str = None,
        gmt_completed_timestamp: int = None,
        gmt_modified: str = None,
        task_id: str = None,
    ):
        self.gmt_create_timestamp = gmt_create_timestamp
        self.status = status
        self.resource_snapshot_list = resource_snapshot_list
        self.stage = stage
        self.gateway_id = gateway_id
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.gmt_completed = gmt_completed
        self.gmt_create = gmt_create
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.gmt_modified = gmt_modified
        self.task_id = task_id

    def validate(self):
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.status is not None:
            result['Status'] = self.status
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetEdgeInstanceDeploymentResponseBodyData(TeaModel):
    def __init__(
        self,
        gmt_create_timestamp: int = None,
        type: str = None,
        status: int = None,
        deployment_id: str = None,
        description: str = None,
        gmt_modified_timestamp: int = None,
        task_list: List[GetEdgeInstanceDeploymentResponseBodyDataTaskList] = None,
        gmt_completed: str = None,
        gmt_create: str = None,
        gmt_completed_timestamp: int = None,
        gmt_modified: str = None,
    ):
        self.gmt_create_timestamp = gmt_create_timestamp
        self.type = type
        self.status = status
        self.deployment_id = deployment_id
        self.description = description
        self.gmt_modified_timestamp = gmt_modified_timestamp
        self.task_list = task_list
        self.gmt_completed = gmt_completed
        self.gmt_create = gmt_create
        self.gmt_completed_timestamp = gmt_completed_timestamp
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class GetEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetEdgeInstanceDeploymentResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetEdgeInstanceDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetGatewayBySubDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        utc_active: str = None,
        product_name: str = None,
        device_name: str = None,
        utc_create: str = None,
        firmware_version: str = None,
        gmt_online: str = None,
        region: str = None,
        iot_id: str = None,
        utc_online: str = None,
        product_key: str = None,
        ip_address: str = None,
        node_type: str = None,
        device_secret: str = None,
        gmt_create: str = None,
        gmt_active: str = None,
    ):
        self.status = status
        self.utc_active = utc_active
        self.product_name = product_name
        self.device_name = device_name
        self.utc_create = utc_create
        self.firmware_version = firmware_version
        self.gmt_online = gmt_online
        self.region = region
        self.iot_id = iot_id
        self.utc_online = utc_online
        self.product_key = product_key
        self.ip_address = ip_address
        self.node_type = node_type
        self.device_secret = device_secret
        self.gmt_create = gmt_create
        self.gmt_active = gmt_active

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.region is not None:
            result['region'] = self.region
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        return self


class GetGatewayBySubDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetGatewayBySubDeviceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetGatewayBySubDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetGatewayBySubDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        success_dev_euis: GetLoraNodesTaskResponseBodySuccessDevEuis = None,
        task_id: str = None,
        request_id: str = None,
        error_message: str = None,
        success_count: int = None,
        task_state: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.total_count = total_count
        self.success_dev_euis = success_dev_euis
        self.task_id = task_id
        self.request_id = request_id
        self.error_message = error_message
        self.success_count = success_count
        self.task_state = task_state
        self.code = code
        self.success = success

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetLoraNodesTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLoraNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        task_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(
        self,
        success_dev_eui: List[str] = None,
    ):
        self.success_dev_eui = success_dev_eui

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        success_dev_euis: GetNodesAddingTaskResponseBodySuccessDevEuis = None,
        task_id: str = None,
        request_id: str = None,
        error_message: str = None,
        success_count: int = None,
        task_state: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.total_count = total_count
        self.success_dev_euis = success_dev_euis
        self.task_id = task_id
        self.request_id = request_id
        self.error_message = error_message
        self.success_count = success_count
        self.task_state = task_state
        self.code = code
        self.success = success

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodesAddingTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodesAddingTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseBodyRuleInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        modified: str = None,
        data_type: str = None,
        select: str = None,
        utc_created: str = None,
        create_user_id: int = None,
        topic_type: int = None,
        where: str = None,
        product_key: str = None,
        utc_modified: str = None,
        topic: str = None,
        short_topic: str = None,
        rule_desc: str = None,
        name: str = None,
        created: str = None,
        id: int = None,
    ):
        self.status = status
        self.modified = modified
        self.data_type = data_type
        self.select = select
        self.utc_created = utc_created
        self.create_user_id = create_user_id
        self.topic_type = topic_type
        self.where = where
        self.product_key = product_key
        self.utc_modified = utc_modified
        self.topic = topic
        self.short_topic = short_topic
        self.rule_desc = rule_desc
        self.name = name
        self.created = created
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.select is not None:
            result['Select'] = self.select
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.name is not None:
            result['Name'] = self.name
        if self.created is not None:
            result['Created'] = self.created
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        rule_info: GetRuleResponseBodyRuleInfo = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.rule_info = rule_info
        self.code = code
        self.success = success

    def validate(self):
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseBodyRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        action_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.action_id = action_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class GetRuleActionResponseBodyRuleActionInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
        id: int = None,
        rule_id: int = None,
    ):
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag
        self.id = id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        rule_action_info: GetRuleActionResponseBodyRuleActionInfo = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.rule_action_info = rule_action_info
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseBodyRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRuleActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        rule_status: int = None,
        rule_content: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        rule_description: str = None,
        rule_name: str = None,
    ):
        self.rule_status = rule_status
        self.rule_content = rule_content
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.rule_description = rule_description
        self.rule_name = rule_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class GetSceneRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetSceneRuleResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSceneRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        simple: bool = None,
        function_block_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.simple = simple
        self.function_block_id = function_block_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class GetThingModelTslResponseBodyData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetThingModelTslResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingModelTslResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        resource_group_id: str = None,
        simple: bool = None,
        model_version: str = None,
        function_block_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.resource_group_id = resource_group_id
        self.simple = simple
        self.model_version = model_version
        self.function_block_id = function_block_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class GetThingModelTslPublishedResponseBodyData(TeaModel):
    def __init__(
        self,
        tsl_str: str = None,
        tsl_uri: str = None,
    ):
        self.tsl_str = tsl_str
        self.tsl_uri = tsl_uri

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetThingModelTslPublishedResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingModelTslPublishedResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslPublishedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseBodyData(TeaModel):
    def __init__(
        self,
        script_type: str = None,
        script_url: str = None,
    ):
        self.script_type = script_type
        self.script_url = script_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetThingScriptResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingScriptResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        category_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.category_key = category_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        thing_model_json: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.thing_model_json = thing_model_json
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTopoRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        page_no: int = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.page_no = page_no
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataListDeviceInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataList(TeaModel):
    def __init__(
        self,
        device_info: List[GetThingTopoResponseBodyDataListDeviceInfo] = None,
    ):
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['deviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['deviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_info = []
        if m.get('deviceInfo') is not None:
            for k in m.get('deviceInfo'):
                temp_model = GetThingTopoResponseBodyDataListDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class GetThingTopoResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        list: GetThingTopoResponseBodyDataList = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
    ):
        self.current_page = current_page
        self.list = list
        self.page_size = page_size
        self.page_count = page_count
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('List') is not None:
            temp_model = GetThingTopoResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetThingTopoResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        tsl_str: str = None,
        tsl_url: str = None,
        function_block_id: str = None,
        function_block_name: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.tsl_str = tsl_str
        self.tsl_url = tsl_url
        self.function_block_id = function_block_id
        self.function_block_name = function_block_name
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class ImportThingModelTslResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportThingModelTslResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(
        self,
        param_name: str = None,
        param_type: str = None,
        param_value: str = None,
        list_param_type: str = None,
        list_param_value: List[str] = None,
    ):
        self.param_name = param_name
        self.param_type = param_type
        self.param_value = param_value
        self.list_param_type = list_param_type
        self.list_param_value = list_param_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        api_srn: str = None,
        iot_instance_id: str = None,
        param: List[InvokeDataAPIServiceRequestParam] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.api_srn = api_srn
        self.iot_instance_id = iot_instance_id
        self.param = param

    def validate(self):
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        return self


class InvokeDataAPIServiceResponseBodyDataResultList(TeaModel):
    def __init__(
        self,
        result_list: List[Dict[str, Any]] = None,
    ):
        self.result_list = result_list

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseBodyDataFieldNameList(TeaModel):
    def __init__(
        self,
        field_name_list: List[str] = None,
    ):
        self.field_name_list = field_name_list

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        result_list: InvokeDataAPIServiceResponseBodyDataResultList = None,
        api_srn: str = None,
        field_name_list: InvokeDataAPIServiceResponseBodyDataFieldNameList = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.result_list = result_list
        self.api_srn = api_srn
        self.field_name_list = field_name_list
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        if self.result_list:
            self.result_list.validate()
        if self.field_name_list:
            self.field_name_list.validate()

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class InvokeDataAPIServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: InvokeDataAPIServiceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeDataAPIServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingServiceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        identifier: str = None,
        args: str = None,
        iot_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.identifier = identifier
        self.args = args
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class InvokeThingServiceResponseBodyData(TeaModel):
    def __init__(
        self,
        message_id: str = None,
        result: str = None,
    ):
        self.message_id = message_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class InvokeThingServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: InvokeThingServiceResponseBodyData = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.data = data
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = InvokeThingServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeThingServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeThingServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        identifier: str = None,
        args: str = None,
        device_name: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.identifier = identifier
        self.args = args
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class InvokeThingsServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_message: str = None,
        code: str = None,
        success: bool = None,
    ):
        self.request_id = request_id
        self.error_message = error_message
        self.code = code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InvokeThingsServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        status: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.status = status
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: str = None,
        description: str = None,
        type: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.description = description
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListJobResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page: int = None,
        data: ListJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page = page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        page_size: int = None,
        current_page: int = None,
        dest_version: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.page_size = page_size
        self.current_page = current_page
        self.dest_version = dest_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(
        self,
        firmware_name: str = None,
        firmware_id: str = None,
        src_version: str = None,
        dest_version: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        status: int = None,
        firmware_desc: str = None,
        firmware_sign: str = None,
        firmware_size: int = None,
        firmware_url: str = None,
        product_key: str = None,
        sign_method: str = None,
        product_name: str = None,
        type: int = None,
        module_name: str = None,
    ):
        self.firmware_name = firmware_name
        self.firmware_id = firmware_id
        self.src_version = src_version
        self.dest_version = dest_version
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.status = status
        self.firmware_desc = firmware_desc
        self.firmware_sign = firmware_sign
        self.firmware_size = firmware_size
        self.firmware_url = firmware_url
        self.product_key = product_key
        self.sign_method = sign_method
        self.product_name = product_name
        self.type = type
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfo(TeaModel):
    def __init__(
        self,
        simple_firmware_info: List[ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo] = None,
    ):
        self.simple_firmware_info = simple_firmware_info

    def validate(self):
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        firmware_info: ListOTAFirmwareResponseBodyFirmwareInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.firmware_info = firmware_info

    def validate(self):
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseBodyFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAJobByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        firmware_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.firmware_id = firmware_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(
        self,
        ota_tag_dto: List[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO] = None,
    ):
        self.ota_tag_dto = ota_tag_dto

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        utc_start_time: str = None,
        utc_end_time: str = None,
        job_status: str = None,
        job_type: str = None,
        target_selection: str = None,
        selection_type: str = None,
        tags: ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags = None,
    ):
        self.job_id = job_id
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.utc_start_time = utc_start_time
        self.utc_end_time = utc_end_time
        self.job_status = job_status
        self.job_type = job_type
        self.target_selection = target_selection
        self.selection_type = selection_type
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otajob_info: List[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo] = None,
    ):
        self.simple_otajob_info = simple_otajob_info

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAJobByFirmwareResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAJobByFirmwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        auth_config: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.auth_config = auth_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class ListOTAModuleByProductResponseBodyData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        module_name: str = None,
        alias_name: str = None,
        desc: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        self.product_key = product_key
        self.module_name = module_name
        self.alias_name = alias_name
        self.desc = desc
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListOTAModuleByProductResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAModuleByProductResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleByProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        module_version: str = None,
        module_name: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.module_version = module_version
        self.module_name = module_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otamodule_info: List[ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo] = None,
    ):
        self.simple_otamodule_info = simple_otamodule_info

    def validate(self):
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTAModuleVersionsByDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTAModuleVersionsByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        task_status: str = None,
        job_id: str = None,
        current_page: int = None,
        device_names: List[str] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.task_status = task_status
        self.job_id = job_id
        self.current_page = current_page
        self.device_names = device_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        utc_modified: str = None,
        product_key: str = None,
        firmware_id: str = None,
        task_status: str = None,
        job_id: str = None,
        product_name: str = None,
        device_name: str = None,
        src_version: str = None,
        dest_version: str = None,
        task_desc: str = None,
        progress: str = None,
        iot_id: str = None,
        utc_create: str = None,
    ):
        self.task_id = task_id
        self.utc_modified = utc_modified
        self.product_key = product_key
        self.firmware_id = firmware_id
        self.task_status = task_status
        self.job_id = job_id
        self.product_name = product_name
        self.device_name = device_name
        self.src_version = src_version
        self.dest_version = dest_version
        self.task_desc = task_desc
        self.progress = progress
        self.iot_id = iot_id
        self.utc_create = utc_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class ListOTATaskByJobResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_otatask_info: List[ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo] = None,
    ):
        self.simple_otatask_info = simple_otatask_info

    def validate(self):
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        current_page: int = None,
        data: ListOTATaskByJobResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.current_page = current_page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOTATaskByJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        product_tag: List[ListProductByTagsRequestProductTag] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBodyProductInfosProductInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        create_time: int = None,
        description: str = None,
        node_type: int = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.create_time = create_time
        self.description = description
        self.node_type = node_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseBodyProductInfos(TeaModel):
    def __init__(
        self,
        product_info: List[ListProductByTagsResponseBodyProductInfosProductInfo] = None,
    ):
        self.product_info = product_info

    def validate(self):
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseBodyProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        product_infos: ListProductByTagsResponseBodyProductInfos = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.product_infos = product_infos

    def validate(self):
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseBodyProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListProductByTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class ListProductTagsResponseBodyDataProductTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseBodyData(TeaModel):
    def __init__(
        self,
        product_tag: List[ListProductTagsResponseBodyDataProductTag] = None,
    ):
        self.product_tag = product_tag

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseBodyDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: ListProductTagsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListProductTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        current_page: int = None,
        page_size: int = None,
        search_name: str = None,
        resource_group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.current_page = current_page
        self.page_size = page_size
        self.search_name = search_name
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_name is not None:
            result['SearchName'] = self.search_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchName') is not None:
            self.search_name = m.get('SearchName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListRuleResponseBodyDataRuleInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        select: str = None,
        topic: str = None,
        short_topic: str = None,
        where: str = None,
        status: str = None,
        create_user_id: int = None,
        product_key: str = None,
        name: str = None,
        data_type: str = None,
        rule_desc: str = None,
        created: str = None,
        utc_created: str = None,
        modified: str = None,
        utc_modified: str = None,
    ):
        self.id = id
        self.select = select
        self.topic = topic
        self.short_topic = short_topic
        self.where = where
        self.status = status
        self.create_user_id = create_user_id
        self.product_key = product_key
        self.name = name
        self.data_type = data_type
        self.rule_desc = rule_desc
        self.created = created
        self.utc_created = utc_created
        self.modified = modified
        self.utc_modified = utc_modified

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        rule_info: List[ListRuleResponseBodyDataRuleInfo] = None,
    ):
        self.rule_info = rule_info

    def validate(self):
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = ListRuleResponseBodyDataRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        return self


class ListRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        total: int = None,
        page_size: int = None,
        data: ListRuleResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.total = total
        self.page_size = page_size
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Data') is not None:
            temp_model = ListRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleActionsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListRuleActionsResponseBodyRuleActionListRuleActionInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        rule_id: int = None,
        type: str = None,
        configuration: str = None,
        error_action_flag: bool = None,
    ):
        self.id = id
        self.rule_id = rule_id
        self.type = type
        self.configuration = configuration
        self.error_action_flag = error_action_flag

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class ListRuleActionsResponseBodyRuleActionList(TeaModel):
    def __init__(
        self,
        rule_action_info: List[ListRuleActionsResponseBodyRuleActionListRuleActionInfo] = None,
    ):
        self.rule_action_info = rule_action_info

    def validate(self):
        if self.rule_action_info:
            for k in self.rule_action_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RuleActionInfo'] = []
        if self.rule_action_info is not None:
            for k in self.rule_action_info:
                result['RuleActionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rule_action_info = []
        if m.get('RuleActionInfo') is not None:
            for k in m.get('RuleActionInfo'):
                temp_model = ListRuleActionsResponseBodyRuleActionListRuleActionInfo()
                self.rule_action_info.append(temp_model.from_map(k))
        return self


class ListRuleActionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        rule_action_list: ListRuleActionsResponseBodyRuleActionList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.rule_action_list = rule_action_list

    def validate(self):
        if self.rule_action_list:
            self.rule_action_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_list is not None:
            result['RuleActionList'] = self.rule_action_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionList') is not None:
            temp_model = ListRuleActionsResponseBodyRuleActionList()
            self.rule_action_list = temp_model.from_map(m['RuleActionList'])
        return self


class ListRuleActionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListRuleActionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        limit: int = None,
        job_id: str = None,
        next_token: str = None,
        device: str = None,
        status: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.limit = limit
        self.job_id = job_id
        self.next_token = next_token
        self.device = device
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: str = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        next_token: str = None,
        data: ListTaskResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.next_token = next_token
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: str = None,
        page_no: str = None,
        job_id: str = None,
        device: str = None,
        status: str = None,
        device_name: str = None,
        job_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.page_no = page_no
        self.job_id = job_id
        self.device = device
        self.status = status
        self.device_name = device_name
        self.job_name = job_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseBodyDataData(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        job_name: str = None,
        task_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        progress: int = None,
        utc_queue_time: str = None,
        utc_modified: str = None,
        status_detail: str = None,
        status: str = None,
        product_name: str = None,
    ):
        self.job_id = job_id
        self.job_name = job_name
        self.task_id = task_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.progress = progress
        self.utc_queue_time = utc_queue_time
        self.utc_modified = utc_modified
        self.status_detail = status_detail
        self.status = status
        self.product_name = product_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[ListTaskByPageResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        page: int = None,
        data: ListTaskByPageResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.page = page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTaskByPageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskByPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseBodyDataModelVersions(TeaModel):
    def __init__(
        self,
        model_version: str = None,
        description: str = None,
        gmt_create: int = None,
    ):
        self.model_version = model_version
        self.description = description
        self.gmt_create = gmt_create

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        model_versions: List[ListThingModelVersionResponseBodyDataModelVersions] = None,
    ):
        self.model_versions = model_versions

    def validate(self):
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseBodyDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: ListThingModelVersionResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListThingModelVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingModelVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListThingTemplatesResponseBodyData(TeaModel):
    def __init__(
        self,
        category_key: str = None,
        category_name: str = None,
    ):
        self.category_key = category_key
        self.category_name = category_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: List[ListThingTemplatesResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListThingTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class NotifyAddThingTopoRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        device_list_str: str = None,
        gw_iot_id: str = None,
        gw_product_key: str = None,
        gw_device_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.device_list_str = device_list_str
        self.gw_iot_id = gw_iot_id
        self.gw_product_key = gw_product_key
        self.gw_device_name = gw_device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_list_str is not None:
            result['DeviceListStr'] = self.device_list_str
        if self.gw_iot_id is not None:
            result['GwIotId'] = self.gw_iot_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceListStr') is not None:
            self.device_list_str = m.get('DeviceListStr')
        if m.get('GwIotId') is not None:
            self.gw_iot_id = m.get('GwIotId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class NotifyAddThingTopoResponseBodyData(TeaModel):
    def __init__(
        self,
        message_id: str = None,
    ):
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class NotifyAddThingTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: NotifyAddThingTopoResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = NotifyAddThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class NotifyAddThingTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: NotifyAddThingTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = NotifyAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubRequestUserProp(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class PubRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        qos: int = None,
        topic_full_name: str = None,
        message_content: str = None,
        response_topic: str = None,
        correlation_data: str = None,
        user_prop: List[PubRequestUserProp] = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.qos = qos
        self.topic_full_name = topic_full_name
        self.message_content = message_content
        self.response_topic = response_topic
        self.correlation_data = correlation_data
        self.user_prop = user_prop

    def validate(self):
        if self.user_prop:
            for k in self.user_prop:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.response_topic is not None:
            result['ResponseTopic'] = self.response_topic
        if self.correlation_data is not None:
            result['CorrelationData'] = self.correlation_data
        result['UserProp'] = []
        if self.user_prop is not None:
            for k in self.user_prop:
                result['UserProp'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ResponseTopic') is not None:
            self.response_topic = m.get('ResponseTopic')
        if m.get('CorrelationData') is not None:
            self.correlation_data = m.get('CorrelationData')
        self.user_prop = []
        if m.get('UserProp') is not None:
            for k in m.get('UserProp'):
                temp_model = PubRequestUserProp()
                self.user_prop.append(temp_model.from_map(k))
        return self


class PubResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        message_id: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PubResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubBroadcastRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        topic_full_name: str = None,
        message_content: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.topic_full_name = topic_full_name
        self.message_content = message_content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class PubBroadcastResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        message_id: int = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.message_id = message_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubBroadcastResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PubBroadcastResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubBroadcastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        resource_group_id: str = None,
        product_key: str = None,
        model_version: str = None,
        description: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.resource_group_id = resource_group_id
        self.product_key = product_key
        self.model_version = model_version
        self.description = description
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class PublishThingModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: PublishThingModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PublishThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAppDeviceListRequestTagList(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryAppDeviceListRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key_list: List[str] = None,
        category_key_list: List[str] = None,
        app_key: str = None,
        tag_list: List[QueryAppDeviceListRequestTagList] = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key_list = product_key_list
        self.category_key_list = category_key_list
        self.app_key = app_key
        self.tag_list = tag_list
        self.current_page = current_page

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key_list is not None:
            result['ProductKeyList'] = self.product_key_list
        if self.category_key_list is not None:
            result['CategoryKeyList'] = self.category_key_list
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKeyList') is not None:
            self.product_key_list = m.get('ProductKeyList')
        if m.get('CategoryKeyList') is not None:
            self.category_key_list = m.get('CategoryKeyList')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = QueryAppDeviceListRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryAppDeviceListResponseBodyDataData(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        node_type: int = None,
        status: str = None,
        active_time: str = None,
        last_online_time: str = None,
        create_time: str = None,
        child_device_count: int = None,
        utc_active_time: str = None,
        utc_last_online_time: str = None,
        utc_create_time: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.node_type = node_type
        self.status = status
        self.active_time = active_time
        self.last_online_time = last_online_time
        self.create_time = create_time
        self.child_device_count = child_device_count
        self.utc_active_time = utc_active_time
        self.utc_last_online_time = utc_last_online_time
        self.utc_create_time = utc_create_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.child_device_count is not None:
            result['ChildDeviceCount'] = self.child_device_count
        if self.utc_active_time is not None:
            result['UtcActiveTime'] = self.utc_active_time
        if self.utc_last_online_time is not None:
            result['UtcLastOnlineTime'] = self.utc_last_online_time
        if self.utc_create_time is not None:
            result['UtcCreateTime'] = self.utc_create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChildDeviceCount') is not None:
            self.child_device_count = m.get('ChildDeviceCount')
        if m.get('UtcActiveTime') is not None:
            self.utc_active_time = m.get('UtcActiveTime')
        if m.get('UtcLastOnlineTime') is not None:
            self.utc_last_online_time = m.get('UtcLastOnlineTime')
        if m.get('UtcCreateTime') is not None:
            self.utc_create_time = m.get('UtcCreateTime')
        return self


class QueryAppDeviceListResponseBodyData(TeaModel):
    def __init__(
        self,
        data: List[QueryAppDeviceListResponseBodyDataData] = None,
    ):
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryAppDeviceListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryAppDeviceListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryAppDeviceListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryAppDeviceListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryAppDeviceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryAppDeviceListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAppDeviceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBatchRegisterDeviceStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        apply_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataValidList(TeaModel):
    def __init__(
        self,
        name: List[str] = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList(TeaModel):
    def __init__(
        self,
        name: List[str] = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        valid_list: QueryBatchRegisterDeviceStatusResponseBodyDataValidList = None,
        invalid_list: QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList = None,
    ):
        self.status = status
        self.valid_list = valid_list
        self.invalid_list = invalid_list

    def validate(self):
        if self.valid_list:
            self.valid_list.validate()
        if self.invalid_list:
            self.invalid_list.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.valid_list is not None:
            result['ValidList'] = self.valid_list.to_map()
        if self.invalid_list is not None:
            result['InvalidList'] = self.invalid_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ValidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataValidList()
            self.valid_list = temp_model.from_map(m['ValidList'])
        if m.get('InvalidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList()
            self.invalid_list = temp_model.from_map(m['InvalidList'])
        return self


class QueryBatchRegisterDeviceStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryBatchRegisterDeviceStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryBatchRegisterDeviceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryBatchRegisterDeviceStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        apply_id: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        cert_url: str = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.cert_url = cert_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryCertUrlByApplyIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCertUrlByApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryClientIdsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_id: str = None,
        iot_instance_id: str = None,
        auth_config: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_id = iot_id
        self.iot_instance_id = iot_instance_id
        self.auth_config = auth_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class QueryClientIdsResponseBodyDataDynamicRegClientIds(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        create_time: int = None,
    ):
        self.client_id = client_id
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryClientIdsResponseBodyData(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        dynamic_reg_client_ids: List[QueryClientIdsResponseBodyDataDynamicRegClientIds] = None,
    ):
        self.iot_id = iot_id
        self.dynamic_reg_client_ids = dynamic_reg_client_ids

    def validate(self):
        if self.dynamic_reg_client_ids:
            for k in self.dynamic_reg_client_ids:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        result['DynamicRegClientIds'] = []
        if self.dynamic_reg_client_ids is not None:
            for k in self.dynamic_reg_client_ids:
                result['DynamicRegClientIds'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        self.dynamic_reg_client_ids = []
        if m.get('DynamicRegClientIds') is not None:
            for k in m.get('DynamicRegClientIds'):
                temp_model = QueryClientIdsResponseBodyDataDynamicRegClientIds()
                self.dynamic_reg_client_ids.append(temp_model.from_map(k))
        return self


class QueryClientIdsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryClientIdsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryClientIdsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryClientIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryClientIdsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryClientIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseBodyData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryConsumerGroupByGroupIdResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupByGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        current_page: int = None,
        fuzzy: bool = None,
        group_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.current_page = current_page
        self.fuzzy = fuzzy
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseBodyDataConsumerGroupDTO(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        create_time: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseBodyData(TeaModel):
    def __init__(
        self,
        consumer_group_dto: List[QueryConsumerGroupListResponseBodyDataConsumerGroupDTO] = None,
    ):
        self.consumer_group_dto = consumer_group_dto

    def validate(self):
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseBodyDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        current_page: int = None,
        code: str = None,
        data: QueryConsumerGroupListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.current_page = current_page
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_ip_port: str = None,
        online_time: int = None,
    ):
        self.client_id = client_id
        self.client_ip_port = client_ip_port
        self.online_time = online_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusList(TeaModel):
    def __init__(
        self,
        consumer_group_client_connection_info: List[QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo] = None,
    ):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info

    def validate(self):
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        accumulation_count: int = None,
        consumer_speed: int = None,
        last_consumer_time: str = None,
        code: str = None,
        client_connection_status_list: QueryConsumerGroupStatusResponseBodyClientConnectionStatusList = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.accumulation_count = accumulation_count
        self.consumer_speed = consumer_speed
        self.last_consumer_time = last_consumer_time
        self.code = code
        self.client_connection_status_list = client_connection_status_list

    def validate(self):
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryConsumerGroupStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        rule_id: str = None,
        start_time: int = None,
        end_time: int = None,
        trace_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.rule_id = rule_id
        self.start_time = start_time
        self.end_time = end_time
        self.trace_id = trace_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseBodyDataLogList(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        pk_dn: str = None,
    ):
        self.code = code
        self.message = message
        self.pk_dn = pk_dn

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseBodyData(TeaModel):
    def __init__(
        self,
        total: int = None,
        page_size: int = None,
        current_page: int = None,
        log_list: List[QueryDetailSceneRuleLogResponseBodyDataLogList] = None,
    ):
        self.total = total
        self.page_size = page_size
        self.current_page = current_page
        self.log_list = log_list

    def validate(self):
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseBodyDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        error_message: str = None,
        code: str = None,
        data: QueryDetailSceneRuleLogResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.error_message = error_message
        self.code = code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDetailSceneRuleLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceResponseBodyDataDeviceInfo(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_secret: str = None,
        product_key: str = None,
        device_status: str = None,
        device_name: str = None,
        device_type: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        iot_id: str = None,
        nickname: str = None,
    ):
        self.device_id = device_id
        self.device_secret = device_secret
        self.product_key = product_key
        self.device_status = device_status
        self.device_name = device_name
        self.device_type = device_type
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.iot_id = iot_id
        self.nickname = nickname

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceResponseBodyData(TeaModel):
    def __init__(
        self,
        device_info: List[QueryDeviceResponseBodyDataDeviceInfo] = None,
    ):
        self.device_info = device_info

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = QueryDeviceResponseBodyDataDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total: int = None,
        page_size: int = None,
        page_count: int = None,
        page: int = None,
        data: QueryDeviceResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total = total
        self.page_size = page_size
        self.page_count = page_count
        self.page = page
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = QueryDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        sql: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseBodyDataGroups(TeaModel):
    def __init__(
        self,
        group_id: str = None,
    ):
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseBodyDataTags(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        tag_value: str = None,
    ):
        self.tag_name = tag_name
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseBodyDataOTAModules(TeaModel):
    def __init__(
        self,
        module_name: str = None,
        firmware_version: str = None,
    ):
        self.module_name = module_name
        self.firmware_version = firmware_version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseBodyData(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        nickname: str = None,
        status: str = None,
        active_time: str = None,
        iot_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        groups: List[QueryDeviceBySQLResponseBodyDataGroups] = None,
        tags: List[QueryDeviceBySQLResponseBodyDataTags] = None,
        otamodules: List[QueryDeviceBySQLResponseBodyDataOTAModules] = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.nickname = nickname
        self.status = status
        self.active_time = active_time
        self.iot_id = iot_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.groups = groups
        self.tags = tags
        self.otamodules = otamodules

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseBodyDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseBodyDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        total_count: int = None,
        data: List[QueryDeviceBySQLResponseBodyData] = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.total_count = total_count
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceBySQLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceBySQLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        status: int = None,
        current_page: int = None,
        page_size: int = None,
        biz_tenant_id: str = None,
        resource_group_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.status = status
        self.current_page = current_page
        self.page_size = page_size
        self.biz_tenant_id = biz_tenant_id
        self.resource_group_id = resource_group_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.biz_tenant_id is not None:
            result['BizTenantId'] = self.biz_tenant_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BizTenantId') is not None:
            self.biz_tenant_id = m.get('BizTenantId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_key: str = None,
        device_name: str = None,
        status: str = None,
        iot_id: str = None,
        nickname: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        utc_create: str = None,
        utc_modified: str = None,
        device_secret: str = None,
    ):
        self.product_key = product_key
        self.device_name = device_name
        self.status = status
        self.iot_id = iot_id
        self.nickname = nickname
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.utc_create = utc_create
        self.utc_modified = utc_modified
        self.device_secret = device_secret

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceByStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceByStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByTagsRequestTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceByTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        tag: List[QueryDeviceByTagsRequestTag] = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.tag = tag
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceByTagsResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceByTagsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceByTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceCertRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceCertResponseBodyDeviceCertInfo(TeaModel):
    def __init__(
        self,
        status: int = None,
        certificate: str = None,
        private_key: str = None,
        cert_sn: str = None,
    ):
        self.status = status
        self.certificate = certificate
        self.private_key = private_key
        self.cert_sn = cert_sn

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.cert_sn is not None:
            result['CertSN'] = self.cert_sn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('CertSN') is not None:
            self.cert_sn = m.get('CertSN')
        return self


class QueryDeviceCertResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        device_cert_info: QueryDeviceCertResponseBodyDeviceCertInfo = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.device_cert_info = device_cert_info

    def validate(self):
        if self.device_cert_info:
            self.device_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_cert_info is not None:
            result['DeviceCertInfo'] = self.device_cert_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceCertInfo') is not None:
            temp_model = QueryDeviceCertResponseBodyDeviceCertInfo()
            self.device_cert_info = temp_model.from_map(m['DeviceCertInfo'])
        return self


class QueryDeviceCertResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceCertResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDesiredPropertyRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        identifier: List[str] = None,
        iot_id: str = None,
        function_block_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.identifier = identifier
        self.iot_id = iot_id
        self.function_block_id = function_block_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo(TeaModel):
    def __init__(
        self,
        unit: str = None,
        identifier: str = None,
        data_type: str = None,
        time: str = None,
        value: str = None,
        name: str = None,
        version: int = None,
    ):
        self.unit = unit
        self.identifier = identifier
        self.data_type = data_type
        self.time = time
        self.value = value
        self.name = name
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataList(TeaModel):
    def __init__(
        self,
        desired_property_info: List[QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo] = None,
    ):
        self.desired_property_info = desired_property_info

    def validate(self):
        if self.desired_property_info:
            for k in self.desired_property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DesiredPropertyInfo'] = []
        if self.desired_property_info is not None:
            for k in self.desired_property_info:
                result['DesiredPropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.desired_property_info = []
        if m.get('DesiredPropertyInfo') is not None:
            for k in m.get('DesiredPropertyInfo'):
                temp_model = QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo()
                self.desired_property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceDesiredPropertyResponseBodyData(TeaModel):
    def __init__(
        self,
        list: QueryDeviceDesiredPropertyResponseBodyDataList = None,
    ):
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceDesiredPropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceDesiredPropertyResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDesiredPropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceDesiredPropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDetailRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        iot_id: str = None,
        product_key: str = None,
        product_name: str = None,
        device_name: str = None,
        device_secret: str = None,
        firmware_version: str = None,
        gmt_create: str = None,
        utc_create: str = None,
        gmt_active: str = None,
        utc_active: str = None,
        gmt_online: str = None,
        utc_online: str = None,
        status: str = None,
        ip_address: str = None,
        node_type: int = None,
        region: str = None,
        owner: bool = None,
        nickname: str = None,
    ):
        self.iot_id = iot_id
        self.product_key = product_key
        self.product_name = product_name
        self.device_name = device_name
        self.device_secret = device_secret
        self.firmware_version = firmware_version
        self.gmt_create = gmt_create
        self.utc_create = utc_create
        self.gmt_active = gmt_active
        self.utc_active = utc_active
        self.gmt_online = gmt_online
        self.utc_online = utc_online
        self.status = status
        self.ip_address = ip_address
        self.node_type = node_type
        self.region = region
        self.owner = owner
        self.nickname = nickname

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.status is not None:
            result['Status'] = self.status
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceDetailResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceEventDataRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        start_time: int = None,
        identifier: str = None,
        event_type: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.start_time = start_time
        self.identifier = identifier
        self.event_type = event_type
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceEventDataResponseBodyDataListEventInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        identifier: str = None,
        name: str = None,
        event_type: str = None,
        output_data: str = None,
    ):
        self.time = time
        self.identifier = identifier
        self.name = name
        self.event_type = event_type
        self.output_data = output_data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceEventDataResponseBodyDataList(TeaModel):
    def __init__(
        self,
        event_info: List[QueryDeviceEventDataResponseBodyDataListEventInfo] = None,
    ):
        self.event_info = event_info

    def validate(self):
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceEventDataResponseBodyDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceEventDataResponseBodyData(TeaModel):
    def __init__(
        self,
        next_time: int = None,
        next_valid: bool = None,
        list: QueryDeviceEventDataResponseBodyDataList = None,
    ):
        self.next_time = next_time
        self.next_valid = next_valid
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_time is not None:
            result['NextTime'] = self.next_time
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextTime') is not None:
            self.next_time = m.get('NextTime')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceEventDataResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceEventDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceEventDataResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceEventDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceEventDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceEventDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceEventDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceFileRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        file_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class QueryDeviceFileResponseBodyData(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        name: str = None,
        size: str = None,
        utc_created_on: str = None,
        download_url: str = None,
    ):
        self.file_id = file_id
        self.name = name
        self.size = size
        self.utc_created_on = utc_created_on
        self.download_url = download_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        return self


class QueryDeviceFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceFileResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceFileListRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceFileListResponseBodyDataFileSummary(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        name: str = None,
        size: str = None,
        utc_created_on: str = None,
    ):
        self.file_id = file_id
        self.name = name
        self.size = size
        self.utc_created_on = utc_created_on

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        return self


class QueryDeviceFileListResponseBodyData(TeaModel):
    def __init__(
        self,
        file_summary: List[QueryDeviceFileListResponseBodyDataFileSummary] = None,
    ):
        self.file_summary = file_summary

    def validate(self):
        if self.file_summary:
            for k in self.file_summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FileSummary'] = []
        if self.file_summary is not None:
            for k in self.file_summary:
                result['FileSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_summary = []
        if m.get('FileSummary') is not None:
            for k in m.get('FileSummary'):
                temp_model = QueryDeviceFileListResponseBodyDataFileSummary()
                self.file_summary.append(temp_model.from_map(k))
        return self


class QueryDeviceFileListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        current_page: int = None,
        page_count: int = None,
        page_size: int = None,
        total: int = None,
        data: QueryDeviceFileListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.current_page = current_page
        self.page_count = page_count
        self.page_size = page_size
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceFileListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceFileListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupByDeviceRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        product_key: str = None,
        device_name: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.product_key = product_key
        self.device_name = device_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        utc_create: str = None,
        group_desc: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.utc_create = utc_create
        self.group_desc = group_desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class QueryDeviceGroupByDeviceResponseBodyGroupInfos(TeaModel):
    def __init__(
        self,
        group_info: List[QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo] = None,
    ):
        self.group_info = group_info

    def validate(self):
        if self.group_info:
            for k in self.group_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupInfo'] = []
        if self.group_info is not None:
            for k in self.group_info:
                result['GroupInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.group_info = []
        if m.get('GroupInfo') is not None:
            for k in m.get('GroupInfo'):
                temp_model = QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo()
                self.group_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        group_infos: QueryDeviceGroupByDeviceResponseBodyGroupInfos = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.group_infos = group_infos

    def validate(self):
        if self.group_infos:
            self.group_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_infos is not None:
            result['GroupInfos'] = self.group_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupInfos') is not None:
            temp_model = QueryDeviceGroupByDeviceResponseBodyGroupInfos()
            self.group_infos = temp_model.from_map(m['GroupInfos'])
        return self


class QueryDeviceGroupByDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceGroupByDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupByTagsRequestTag(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupByTagsRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        tag: List[QueryDeviceGroupByTagsRequestTag] = None,
        current_page: int = None,
        page_size: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.tag = tag
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceGroupByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceGroupByTagsResponseBodyDataDeviceGroup(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryDeviceGroupByTagsResponseBodyData(TeaModel):
    def __init__(
        self,
        device_group: List[QueryDeviceGroupByTagsResponseBodyDataDeviceGroup] = None,
    ):
        self.device_group = device_group

    def validate(self):
        if self.device_group:
            for k in self.device_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceGroup'] = []
        if self.device_group is not None:
            for k in self.device_group:
                result['DeviceGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_group = []
        if m.get('DeviceGroup') is not None:
            for k in m.get('DeviceGroup'):
                temp_model = QueryDeviceGroupByTagsResponseBodyDataDeviceGroup()
                self.device_group.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceGroupByTagsResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupByTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupByTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceGroupByTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupInfoRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
        real_tenant_id: str = None,
        real_tripartite_key: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.real_tenant_id = real_tenant_id
        self.real_tripartite_key = real_tripartite_key

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceGroupInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        utc_create: str = None,
        group_name: str = None,
        group_desc: str = None,
        device_count: int = None,
        device_active: int = None,
        device_online: int = None,
    ):
        self.group_id = group_id
        self.utc_create = utc_create
        self.group_name = group_name
        self.group_desc = group_desc
        self.device_count = device_count
        self.device_active = device_active
        self.device_online = device_online

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.device_active is not None:
            result['DeviceActive'] = self.device_active
        if self.device_online is not None:
            result['DeviceOnline'] = self.device_online
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('DeviceActive') is not None:
            self.device_active = m.get('DeviceActive')
        if m.get('DeviceOnline') is not None:
            self.device_online = m.get('DeviceOnline')
        return self


class QueryDeviceGroupInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceGroupInfoResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceGroupInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupListRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        super_group_id: str = None,
        group_name: str = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.super_group_id = super_group_id
        self.group_name = group_name
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceGroupListResponseBodyDataGroupInfo(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        utc_create: str = None,
        group_name: str = None,
        group_desc: str = None,
    ):
        self.group_id = group_id
        self.utc_create = utc_create
        self.group_name = group_name
        self.group_desc = group_desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class QueryDeviceGroupListResponseBodyData(TeaModel):
    def __init__(
        self,
        group_info: List[QueryDeviceGroupListResponseBodyDataGroupInfo] = None,
    ):
        self.group_info = group_info

    def validate(self):
        if self.group_info:
            for k in self.group_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupInfo'] = []
        if self.group_info is not None:
            for k in self.group_info:
                result['GroupInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.group_info = []
        if m.get('GroupInfo') is not None:
            for k in m.get('GroupInfo'):
                temp_model = QueryDeviceGroupListResponseBodyDataGroupInfo()
                self.group_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        current_page: int = None,
        page_count: int = None,
        page_size: int = None,
        total: int = None,
        data: QueryDeviceGroupListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.current_page = current_page
        self.page_count = page_count
        self.page_size = page_size
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceGroupListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupTagListRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceGroupTagListResponseBodyDataGroupTagInfo(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupTagListResponseBodyData(TeaModel):
    def __init__(
        self,
        group_tag_info: List[QueryDeviceGroupTagListResponseBodyDataGroupTagInfo] = None,
    ):
        self.group_tag_info = group_tag_info

    def validate(self):
        if self.group_tag_info:
            for k in self.group_tag_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupTagInfo'] = []
        if self.group_tag_info is not None:
            for k in self.group_tag_info:
                result['GroupTagInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.group_tag_info = []
        if m.get('GroupTagInfo') is not None:
            for k in m.get('GroupTagInfo'):
                temp_model = QueryDeviceGroupTagListResponseBodyDataGroupTagInfo()
                self.group_tag_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupTagListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceGroupTagListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupTagListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupTagListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceGroupTagListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupTagListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceListByDeviceGroupRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        group_id: str = None,
        page_size: int = None,
        current_page: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.group_id = group_id
        self.page_size = page_size
        self.current_page = current_page

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceListByDeviceGroupResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(
        self,
        product_name: str = None,
        product_key: str = None,
        device_name: str = None,
        iot_id: str = None,
    ):
        self.product_name = product_name
        self.product_key = product_key
        self.device_name = device_name
        self.iot_id = iot_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceListByDeviceGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        simple_device_info: List[QueryDeviceListByDeviceGroupResponseBodyDataSimpleDeviceInfo] = None,
    ):
        self.simple_device_info = simple_device_info

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceListByDeviceGroupResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceListByDeviceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        page: int = None,
        page_size: int = None,
        page_count: int = None,
        total: int = None,
        data: QueryDeviceListByDeviceGroupResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.page = page
        self.page_size = page_size
        self.page_count = page_count
        self.total = total
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceListByDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceListByDeviceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceListByDeviceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceListByDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceOriginalEventDataRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalEventDataResponseBodyDataListEventInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        identifier: str = None,
        name: str = None,
        event_type: str = None,
        output_data: str = None,
    ):
        self.time = time
        self.identifier = identifier
        self.name = name
        self.event_type = event_type
        self.output_data = output_data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalEventDataResponseBodyDataList(TeaModel):
    def __init__(
        self,
        event_info: List[QueryDeviceOriginalEventDataResponseBodyDataListEventInfo] = None,
    ):
        self.event_info = event_info

    def validate(self):
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceOriginalEventDataResponseBodyDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalEventDataResponseBodyData(TeaModel):
    def __init__(
        self,
        next_page_token: str = None,
        next_valid: bool = None,
        list: QueryDeviceOriginalEventDataResponseBodyDataList = None,
    ):
        self.next_page_token = next_page_token
        self.next_valid = next_valid
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalEventDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalEventDataResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalEventDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceOriginalEventDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceOriginalPropertyDataRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalPropertyDataResponseBodyDataListPropertyInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        value: str = None,
    ):
        self.time = time
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryDeviceOriginalPropertyDataResponseBodyDataList(TeaModel):
    def __init__(
        self,
        property_info: List[QueryDeviceOriginalPropertyDataResponseBodyDataListPropertyInfo] = None,
    ):
        self.property_info = property_info

    def validate(self):
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = QueryDeviceOriginalPropertyDataResponseBodyDataListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyDataResponseBodyData(TeaModel):
    def __init__(
        self,
        next_valid: bool = None,
        next_page_token: str = None,
        list: QueryDeviceOriginalPropertyDataResponseBodyDataList = None,
    ):
        self.next_valid = next_valid
        self.next_page_token = next_page_token
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['nextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('nextPageToken') is not None:
            self.next_page_token = m.get('nextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalPropertyDataResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalPropertyDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceOriginalPropertyDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceOriginalPropertyStatusRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        iot_id: str = None,
        asc: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.iot_id = iot_id
        self.asc = asc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.asc is not None:
            result['Asc'] = self.asc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        return self


class QueryDeviceOriginalPropertyStatusResponseBodyDataListPropertyStatusDataInfo(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        value: str = None,
        time: int = None,
    ):
        self.identifier = identifier
        self.value = value
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.value is not None:
            result['Value'] = self.value
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class QueryDeviceOriginalPropertyStatusResponseBodyDataList(TeaModel):
    def __init__(
        self,
        property_status_data_info: List[QueryDeviceOriginalPropertyStatusResponseBodyDataListPropertyStatusDataInfo] = None,
    ):
        self.property_status_data_info = property_status_data_info

    def validate(self):
        if self.property_status_data_info:
            for k in self.property_status_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyStatusDataInfo'] = []
        if self.property_status_data_info is not None:
            for k in self.property_status_data_info:
                result['PropertyStatusDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_status_data_info = []
        if m.get('PropertyStatusDataInfo') is not None:
            for k in m.get('PropertyStatusDataInfo'):
                temp_model = QueryDeviceOriginalPropertyStatusResponseBodyDataListPropertyStatusDataInfo()
                self.property_status_data_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        next_valid: bool = None,
        next_page_token: str = None,
        list: QueryDeviceOriginalPropertyStatusResponseBodyDataList = None,
    ):
        self.next_valid = next_valid
        self.next_page_token = next_page_token
        self.list = list

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_message: str = None,
        data: QueryDeviceOriginalPropertyStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.success = success
        self.code = code
        self.error_message = error_message
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalPropertyStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryDeviceOriginalPropertyStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceOriginalServiceDataRequest(TeaModel):
    def __init__(
        self,
        api_product: str = None,
        api_revision: str = None,
        iot_instance_id: str = None,
        page_size: int = None,
        product_key: str = None,
        device_name: str = None,
        next_page_token: str = None,
        start_time: int = None,
        identifier: str = None,
        asc: int = None,
        iot_id: str = None,
        end_time: int = None,
    ):
        self.api_product = api_product
        self.api_revision = api_revision
        self.iot_instance_id = iot_instance_id
        self.page_size = page_size
        self.product_key = product_key
        self.device_name = device_name
        self.next_page_token = next_page_token
        self.start_time = start_time
        self.identifier = identifier
        self.asc = asc
        self.iot_id = iot_id
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalServiceDataResponseBodyDataListServiceInfo(TeaModel):
    def __init__(
        self,
        time: str = None,
        identifier: str = None,
        name: str = None,
        input_data: str = None,
        output_data: str = None,
    ):
        self.time = time
        self.identifier = identifier
        self.name = name
        self.input_data = input_data
        self.output_data = output_data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.input_data is not None:
            result['InputData'] = self.input_data
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InputData') is not None:
            self.input_data = m.get('InputData')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalServiceDataResponseBodyDataList(TeaModel):
    def __init__(
        self,
        service_info: List[QueryDeviceOriginalServiceDataResponseBodyDataListServiceInfo] = None,
    ):
        self.service_info = service_info

    def validate(self):
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()

    def