"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_budgets_1 = require("aws-cdk-lib/aws-budgets");
const constructs_1 = require("constructs");
const notificationType_1 = require("./notificationType");
const timeUnit_1 = require("./timeUnit");
class BudgetNotifier extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.validateProperties(props);
        const costFilters = this.createCostFilters(props);
        const subscribers = this.createSubscribers(props);
        new aws_budgets_1.CfnBudget(this, 'MonthlyBudget_' + id, {
            budget: {
                budgetType: 'COST',
                timeUnit: props.timeUnit ? props.timeUnit : timeUnit_1.TimeUnit.MONTHLY,
                budgetLimit: {
                    amount: props.limit,
                    unit: props.unit,
                },
                costFilters: costFilters,
            },
            notificationsWithSubscribers: [
                {
                    notification: {
                        comparisonOperator: 'GREATER_THAN',
                        threshold: props.threshold,
                        thresholdType: 'PERCENTAGE',
                        notificationType: props.notificationType
                            ? props.notificationType
                            : notificationType_1.NotificationType.ACTUAL,
                    },
                    subscribers: subscribers,
                },
            ],
        });
    }
    validateProperties(props) {
        if (props.recipients && props.recipients.length > 10) {
            throw new Error('The maximum number of 10 e-mail recipients is exceeded.');
        }
        if (props.threshold <= 0) {
            throw new Error('Thresholds less than or equal to 0 are not allowed.');
        }
    }
    createSubscribers(props) {
        const subscribers = new Array();
        if (props.recipients) {
            for (const recipient of props.recipients) {
                subscribers.push({
                    address: recipient,
                    subscriptionType: 'EMAIL',
                });
            }
        }
        if (props.topicArn) {
            subscribers.push({
                address: props.topicArn,
                subscriptionType: 'SNS',
            });
        }
        return subscribers;
    }
    createCostFilters(props) {
        const tags = [];
        if (props.application) {
            tags.push('user:Application$' + props.application);
        }
        if (props.costCenter) {
            tags.push('user:Cost Center$' + props.costCenter);
        }
        if (props.service) {
            tags.push('user:Service$' + props.service);
        }
        const costFilters = {};
        if (tags && tags.length > 0) {
            costFilters.TagKeyValue = tags;
        }
        const availabilityZones = [];
        if (props.availabilityZones) {
            for (const az of props.availabilityZones) {
                availabilityZones.push(az);
            }
            costFilters.AZ = availabilityZones;
        }
        return costFilters;
    }
}
exports.BudgetNotifier = BudgetNotifier;
_a = JSII_RTTI_SYMBOL_1;
BudgetNotifier[_a] = { fqn: "aws_budget_notifier.BudgetNotifier", version: "0.3.41" };
//# sourceMappingURL=data:application/json;base64,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