from sneks.config.definition import Config, Game, Graphics, Colors


config = Config(
    runs=10,
    turn_limit=2000,
    registrar_prefix="./submissions",
    game=Game(
        rows=60,
        columns=90,
        dynamic_food=False,
        food=40,
    ),
    graphics=Graphics(
        display=True,
        headless=False,
        cell_size=8,
        padding=1,
        delay=40,
        record=False,
        record_prefix="./output",
        colors=Colors(
            background=(25, 28, 26),
            border=(113, 121, 113),
            invalid=(186, 26, 26),
            food=(251, 253, 248),
            snake=[
                (222, 97, 116),
                (221, 65, 82),
                (223, 83, 51),
                (215, 117, 85),
                (231, 131, 31),
                (192, 123, 49),
                (194, 141, 80),
                (203, 149, 43),
                (223, 187, 36),
                (212, 189, 95),
                (150, 135, 41),
                (134, 124, 51),
                (186, 182, 59),
                (190, 190, 111),
                (174, 202, 41),
                (21, 149, 43),
                (54, 198, 76),
                (15, 145, 62),
                (124, 197, 56),
                (141, 197, 105),
                (63, 146, 47),
                (83, 188, 69),
                (128, 194, 121),
                (79, 201, 101),
                (60, 139, 73),
                (72, 208, 129),
                (78, 187, 130),
                (67, 194, 158),
                (54, 222, 230),
                (102, 161, 229),
                (92, 138, 228),
                (87, 127, 240),
                (121, 130, 206),
                (131, 106, 238),
                (159, 121, 219),
                (194, 134, 210),
                (192, 100, 217),
                (217, 69, 194),
                (212, 91, 184),
                (215, 122, 182),
                (222, 85, 144),
            ],
        ),
    ),
)
