"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const YAML = require("yaml");
const json_patch_1 = require("./json-patch");
/**
 * Represents a Yaml File.
 */
class YamlFile {
    constructor(filePath, options = {}) {
        this.filePath = filePath;
        this.obj = options.obj ?? {};
        this.patchOperations = [];
        // default value for commentAtTop
        this.commentAtTop = `AUTOMATICALLY GENERATED FILE, DO NOT EDIT MANUALLY.
Generated by AWS CDK and [cdk-pipelines-github](https://github.com/cdklabs/cdk-pipelines-github)`;
    }
    /**
     * Update the output object.
     */
    update(obj) {
        this.obj = obj;
    }
    /**
     * Applies an RFC 6902 JSON-patch to the synthesized object file.
     * See https://datatracker.ietf.org/doc/html/rfc6902 for more information.
     *
     * For example, with the following yaml file
     * ```yaml
     * name: deploy
     * on:
     *   push:
     *     branches:
     *       - main
     *   workflow_dispatch: {}
     * ...
     * ```
     *
     * modified in the following way:
     *
     * ```ts
     * declare const pipeline: GitHubWorkflow;
     * pipeline.workflowFile.patch(JsonPatch.add("/on/workflow_call", "{}"));
     * pipeline.workflowFile.patch(JsonPatch.remove("/on/workflow_dispatch"));
     * ```
     *
     * would result in the following yaml file:
     *
     * ```yaml
     * name: deploy
     * on:
     *   push:
     *     branches:
     *       - main
     *   workflow_call: {}
     * ...
     * ```
     *
     * @param patches - The patch operations to apply
     */
    patch(...patches) {
        this.patchOperations.push(...patches);
    }
    /**
     * Returns the patched yaml file.
     */
    toYaml() {
        const obj = JSON.parse(JSON.stringify(this.obj));
        const patched = json_patch_1.JsonPatch.apply(obj, ...this.patchOperations);
        const yamlDoc = new YAML.Document(patched);
        yamlDoc.commentBefore = this.commentAtTop ?? null;
        return yamlDoc.toString({
            commentString: (comment) => comment.split('\n').map((x) => x == '' ? '' : `# ${x}`).join('\n'),
            indent: 2,
        });
    }
    /**
     * Write the patched yaml file to the specified location.
     */
    writeFile() {
        (0, fs_1.writeFileSync)(this.filePath, this.toYaml());
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "cdk-pipelines-github.YamlFile", version: "0.4.116" };
//# sourceMappingURL=data:application/json;base64,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