"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerCredential = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a credential used to authenticate to a docker registry.
 * Uses the official Docker Login GitHub Action to authenticate.
 *
 * @see https://github.com/marketplace/actions/docker-login
 */
class DockerCredential {
    /**
     * Reference credential secrets to authenticate to DockerHub. This method assumes
     * that your credentials will be stored as long-lived GitHub Secrets under the
     * usernameKey and personalAccessTokenKey.
     *
     * The default for usernameKey is `DOCKERHUB_USERNAME`. The default for personalAccessTokenKey
     * is `DOCKERHUB_TOKEN`. If you do not set these values, your credentials should be
     * found in your GitHub Secrets under these default keys.
     */
    static dockerHub(creds = {}) {
        const username = creds.usernameKey ?? 'DOCKERHUB_USERNAME';
        const password = creds.personalAccessTokenKey ?? 'DOCKERHUB_TOKEN';
        return new DockerCredential('docker', undefined, `\${{ secrets.${username} }}`, `\${{ secrets.${password} }}`);
    }
    /**
     * Create a credential for ECR. This method will reuse your AWS credentials to log in to AWS.
     * Your AWS credentials are already used to deploy your CDK stacks. It can be supplied via
     * GitHub Secrets or using an IAM role that trusts the GitHub OIDC identity provider.
     *
     * NOTE - All ECR repositories in the same account and region share a domain name
     * (e.g., 0123456789012.dkr.ecr.eu-west-1.amazonaws.com), and can only have one associated
     * set of credentials (and DockerCredential). Attempting to associate one set of credentials
     * with one ECR repo and another with another ECR repo in the same account and region will
     * result in failures when using these credentials in the pipeline.
     */
    static ecr(registry) {
        return new DockerCredential('ecr', registry);
    }
    /**
     * Create a credential for the GitHub Container Registry (GHCR).
     *
     * For more information on authenticating to GHCR,
     * @see https://docs.github.com/en/packages/managing-github-packages-using-github-actions-workflows/publishing-and-installing-a-package-with-github-actions
     */
    static ghcr() {
        return new DockerCredential('ghcr', 'ghcr.io', '\${{ github.actor }}', '\${{ secrets.GITHUB_TOKEN }}');
    }
    /**
     * Create a credential for a custom registry. This method assumes that you will have long-lived
     * GitHub Secrets stored under the usernameKey and passwordKey that will authenticate to the
     * registry you provide.
     *
     * @see https://github.com/marketplace/actions/docker-login
     */
    static customRegistry(registry, creds) {
        return new DockerCredential('custom', registry, `\${{ secrets.${creds.usernameKey} }}`, `\${{ secrets.${creds.passwordKey} }}`);
    }
    constructor(name, registry, username, password) {
        this.name = name;
        this.registry = registry;
        this.username = username;
        this.password = password;
    }
}
exports.DockerCredential = DockerCredential;
_a = JSII_RTTI_SYMBOL_1;
DockerCredential[_a] = { fqn: "cdk-pipelines-github.DockerCredential", version: "0.4.116" };
//# sourceMappingURL=data:application/json;base64,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