# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddMigratableInstancesRequest(TeaModel):
    def __init__(self, business_migration_type=None, instance_id=None, network_migration_type=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, vpc_id=None):
        self.business_migration_type = business_migration_type  # type: int
        self.instance_id = instance_id  # type: list[str]
        self.network_migration_type = network_migration_type  # type: int
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMigratableInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_migration_type is not None:
            result['BusinessMigrationType'] = self.business_migration_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_migration_type is not None:
            result['NetworkMigrationType'] = self.network_migration_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessMigrationType') is not None:
            self.business_migration_type = m.get('BusinessMigrationType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkMigrationType') is not None:
            self.network_migration_type = m.get('NetworkMigrationType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddMigratableInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMigratableInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMigratableInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMigratableInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMigratableInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMigratableInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequestNetworkAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = m.get('SlbUdpTimeout')
        if m.get('UdpTimeout') is not None:
            self.udp_timeout = m.get('UdpTimeout')
        return self


class AllocateDedicatedHostsRequestSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequestSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(self, network_attributes=None, scheduler_options=None, action_on_maintenance=None,
                 auto_placement=None, auto_release_time=None, auto_renew=None, auto_renew_period=None, business_info=None,
                 charge_type=None, client_token=None, cpu_over_commit_ratio=None, dedicated_host_cluster_id=None,
                 dedicated_host_name=None, dedicated_host_type=None, description=None, from_app=None, min_quantity=None,
                 owner_account=None, owner_id=None, period=None, period_unit=None, quantity=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, tag=None, zone_id=None):
        self.network_attributes = network_attributes  # type: AllocateDedicatedHostsRequestNetworkAttributes
        self.scheduler_options = scheduler_options  # type: AllocateDedicatedHostsRequestSchedulerOptions
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.auto_placement = auto_placement  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.auto_renew = auto_renew  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.business_info = business_info  # type: str
        self.charge_type = charge_type  # type: str
        self.client_token = client_token  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.description = description  # type: str
        self.from_app = from_app  # type: str
        self.min_quantity = min_quantity  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.quantity = quantity  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[AllocateDedicatedHostsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.network_attributes:
            self.network_attributes.validate()
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.description is not None:
            result['Description'] = self.description
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.min_quantity is not None:
            result['MinQuantity'] = self.min_quantity
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('SchedulerOptions') is not None:
            temp_model = AllocateDedicatedHostsRequestSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = m.get('ActionOnMaintenance')
        if m.get('AutoPlacement') is not None:
            self.auto_placement = m.get('AutoPlacement')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = m.get('CpuOverCommitRatio')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('MinQuantity') is not None:
            self.min_quantity = m.get('MinQuantity')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class AllocateDedicatedHostsResponseBodyDedicatedHostIdSets(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponseBodyDedicatedHostIdSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class AllocateDedicatedHostsResponseBody(TeaModel):
    def __init__(self, dedicated_host_id_sets=None, order_id=None, request_id=None):
        self.dedicated_host_id_sets = dedicated_host_id_sets  # type: AllocateDedicatedHostsResponseBodyDedicatedHostIdSets
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseBodyDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(m['DedicatedHostIdSets'])
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocateDedicatedHostsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelMigrationInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, network_migration_type=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.network_migration_type = network_migration_type  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMigrationInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_migration_type is not None:
            result['NetworkMigrationType'] = self.network_migration_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkMigrationType') is not None:
            self.network_migration_type = m.get('NetworkMigrationType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelMigrationInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMigrationInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelMigrationInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelMigrationInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelMigrationInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelMigrationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelMigrationPlanRequest(TeaModel):
    def __init__(self, migration_plan_id=None, only_cancel_plan=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.migration_plan_id = migration_plan_id  # type: str
        self.only_cancel_plan = only_cancel_plan  # type: bool
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMigrationPlanRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.only_cancel_plan is not None:
            result['OnlyCancelPlan'] = self.only_cancel_plan
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('OnlyCancelPlan') is not None:
            self.only_cancel_plan = m.get('OnlyCancelPlan')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelMigrationPlanResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMigrationPlanResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelMigrationPlanResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelMigrationPlanResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelMigrationPlanResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelMigrationPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigureSecurityGroupPermissionsRequestAuthorizePermission(TeaModel):
    def __init__(self, description=None, dest_cidr_ip=None, dest_group_id=None, dest_prefix_list_id=None,
                 direction=None, gress_flow=None, group_owner_account=None, group_owner_id=None, ip_protocol=None,
                 ipv_6dest_cidr_ip=None, ipv_6source_cidr_ip=None, nic_type=None, policy=None, port_range=None, priority=None,
                 source_cidr_ip=None, source_group_id=None, source_port_range=None, source_prefix_list_id=None):
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_prefix_list_id = dest_prefix_list_id  # type: str
        self.direction = direction  # type: str
        self.gress_flow = gress_flow  # type: str
        self.group_owner_account = group_owner_account  # type: str
        self.group_owner_id = group_owner_id  # type: long
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_port_range = source_port_range  # type: str
        self.source_prefix_list_id = source_prefix_list_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigureSecurityGroupPermissionsRequestAuthorizePermission, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_prefix_list_id is not None:
            result['DestPrefixListId'] = self.dest_prefix_list_id
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.gress_flow is not None:
            result['GressFlow'] = self.gress_flow
        if self.group_owner_account is not None:
            result['GroupOwnerAccount'] = self.group_owner_account
        if self.group_owner_id is not None:
            result['GroupOwnerId'] = self.group_owner_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.source_prefix_list_id is not None:
            result['SourcePrefixListId'] = self.source_prefix_list_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestPrefixListId') is not None:
            self.dest_prefix_list_id = m.get('DestPrefixListId')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('GressFlow') is not None:
            self.gress_flow = m.get('GressFlow')
        if m.get('GroupOwnerAccount') is not None:
            self.group_owner_account = m.get('GroupOwnerAccount')
        if m.get('GroupOwnerId') is not None:
            self.group_owner_id = m.get('GroupOwnerId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('SourcePrefixListId') is not None:
            self.source_prefix_list_id = m.get('SourcePrefixListId')
        return self


class ConfigureSecurityGroupPermissionsRequestRevokePermission(TeaModel):
    def __init__(self, description=None, dest_cidr_ip=None, dest_group_id=None, dest_prefix_list_id=None,
                 direction=None, gress_flow=None, group_owner_account=None, group_owner_id=None, ip_protocol=None,
                 ipv_6dest_cidr_ip=None, ipv_6source_cidr_ip=None, nic_type=None, policy=None, port_range=None, priority=None,
                 source_cidr_ip=None, source_group_id=None, source_port_range=None, source_prefix_list_id=None):
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_prefix_list_id = dest_prefix_list_id  # type: str
        self.direction = direction  # type: str
        self.gress_flow = gress_flow  # type: str
        self.group_owner_account = group_owner_account  # type: str
        self.group_owner_id = group_owner_id  # type: long
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_port_range = source_port_range  # type: str
        self.source_prefix_list_id = source_prefix_list_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigureSecurityGroupPermissionsRequestRevokePermission, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_prefix_list_id is not None:
            result['DestPrefixListId'] = self.dest_prefix_list_id
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.gress_flow is not None:
            result['GressFlow'] = self.gress_flow
        if self.group_owner_account is not None:
            result['GroupOwnerAccount'] = self.group_owner_account
        if self.group_owner_id is not None:
            result['GroupOwnerId'] = self.group_owner_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.source_prefix_list_id is not None:
            result['SourcePrefixListId'] = self.source_prefix_list_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestPrefixListId') is not None:
            self.dest_prefix_list_id = m.get('DestPrefixListId')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('GressFlow') is not None:
            self.gress_flow = m.get('GressFlow')
        if m.get('GroupOwnerAccount') is not None:
            self.group_owner_account = m.get('GroupOwnerAccount')
        if m.get('GroupOwnerId') is not None:
            self.group_owner_id = m.get('GroupOwnerId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('SourcePrefixListId') is not None:
            self.source_prefix_list_id = m.get('SourcePrefixListId')
        return self


class ConfigureSecurityGroupPermissionsRequest(TeaModel):
    def __init__(self, authorize_permission=None, client_token=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, revoke_permission=None,
                 security_group_id=None):
        self.authorize_permission = authorize_permission  # type: list[ConfigureSecurityGroupPermissionsRequestAuthorizePermission]
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.revoke_permission = revoke_permission  # type: list[ConfigureSecurityGroupPermissionsRequestRevokePermission]
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        if self.authorize_permission:
            for k in self.authorize_permission:
                if k:
                    k.validate()
        if self.revoke_permission:
            for k in self.revoke_permission:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ConfigureSecurityGroupPermissionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AuthorizePermission'] = []
        if self.authorize_permission is not None:
            for k in self.authorize_permission:
                result['AuthorizePermission'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['RevokePermission'] = []
        if self.revoke_permission is not None:
            for k in self.revoke_permission:
                result['RevokePermission'].append(k.to_map() if k else None)
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.authorize_permission = []
        if m.get('AuthorizePermission') is not None:
            for k in m.get('AuthorizePermission'):
                temp_model = ConfigureSecurityGroupPermissionsRequestAuthorizePermission()
                self.authorize_permission.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.revoke_permission = []
        if m.get('RevokePermission') is not None:
            for k in m.get('RevokePermission'):
                temp_model = ConfigureSecurityGroupPermissionsRequestRevokePermission()
                self.revoke_permission.append(temp_model.from_map(k))
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class ConfigureSecurityGroupPermissionsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigureSecurityGroupPermissionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfigureSecurityGroupPermissionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfigureSecurityGroupPermissionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfigureSecurityGroupPermissionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfigureSecurityGroupPermissionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmReservationDemandRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmReservationDemandRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ConfirmReservationDemandRequest(TeaModel):
    def __init__(self, demand_id=None, region_id=None, resource_group_id=None, tag=None):
        self.demand_id = demand_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tag = tag  # type: list[ConfirmReservationDemandRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ConfirmReservationDemandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ConfirmReservationDemandRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ConfirmReservationDemandResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmReservationDemandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfirmReservationDemandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfirmReservationDemandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfirmReservationDemandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmReservationDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCapacityReservationRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCapacityReservationRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCapacityReservationRequest(TeaModel):
    def __init__(self, capacity_reservation_name=None, description=None, end_date_type=None, instance_count=None,
                 instance_match_criteria=None, instance_platform=None, instance_type=None, network_type=None, owner_account=None,
                 owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 tag=None, time_slot=None, zone_id=None):
        self.capacity_reservation_name = capacity_reservation_name  # type: str
        self.description = description  # type: str
        self.end_date_type = end_date_type  # type: str
        self.instance_count = instance_count  # type: str
        self.instance_match_criteria = instance_match_criteria  # type: str
        self.instance_platform = instance_platform  # type: str
        self.instance_type = instance_type  # type: str
        self.network_type = network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateCapacityReservationRequestTag]
        self.time_slot = time_slot  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCapacityReservationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservation_name is not None:
            result['CapacityReservationName'] = self.capacity_reservation_name
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date_type is not None:
            result['EndDateType'] = self.end_date_type
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_match_criteria is not None:
            result['InstanceMatchCriteria'] = self.instance_match_criteria
        if self.instance_platform is not None:
            result['InstancePlatform'] = self.instance_platform
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.time_slot is not None:
            result['TimeSlot'] = self.time_slot
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservationName') is not None:
            self.capacity_reservation_name = m.get('CapacityReservationName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDateType') is not None:
            self.end_date_type = m.get('EndDateType')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceMatchCriteria') is not None:
            self.instance_match_criteria = m.get('InstanceMatchCriteria')
        if m.get('InstancePlatform') is not None:
            self.instance_platform = m.get('InstancePlatform')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCapacityReservationRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimeSlot') is not None:
            self.time_slot = m.get('TimeSlot')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateCapacityReservationResponseBody(TeaModel):
    def __init__(self, capacity_reservation_id=None, request_id=None):
        self.capacity_reservation_id = capacity_reservation_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCapacityReservationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservation_id is not None:
            result['CapacityReservationId'] = self.capacity_reservation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservationId') is not None:
            self.capacity_reservation_id = m.get('CapacityReservationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCapacityReservationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCapacityReservationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCapacityReservationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCapacityReservationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedBlockStorageClusterRequest(TeaModel):
    def __init__(self, capacity=None, category=None, client_token=None, dedicated_block_storage_cluster_name=None,
                 description=None, from_app=None, owner_account=None, owner_id=None, period=None, period_unit=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, type=None, zone_id=None):
        self.capacity = capacity  # type: int
        self.category = category  # type: str
        self.client_token = client_token  # type: str
        self.dedicated_block_storage_cluster_name = dedicated_block_storage_cluster_name  # type: str
        self.description = description  # type: str
        self.from_app = from_app  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.type = type  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dedicated_block_storage_cluster_name is not None:
            result['DedicatedBlockStorageClusterName'] = self.dedicated_block_storage_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DedicatedBlockStorageClusterName') is not None:
            self.dedicated_block_storage_cluster_name = m.get('DedicatedBlockStorageClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDedicatedBlockStorageClusterResponseBody(TeaModel):
    def __init__(self, dedicated_block_storage_cluster_id=None, dedicated_block_storage_cluster_order_id=None,
                 request_id=None):
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id  # type: str
        self.dedicated_block_storage_cluster_order_id = dedicated_block_storage_cluster_order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.dedicated_block_storage_cluster_order_id is not None:
            result['DedicatedBlockStorageClusterOrderId'] = self.dedicated_block_storage_cluster_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('DedicatedBlockStorageClusterOrderId') is not None:
            self.dedicated_block_storage_cluster_order_id = m.get('DedicatedBlockStorageClusterOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedBlockStorageClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDedicatedBlockStorageClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDedicatedBlockStorageClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostClusterRequestSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedHostClusterRequestSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class CreateDedicatedHostClusterRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedHostClusterRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDedicatedHostClusterRequest(TeaModel):
    def __init__(self, scheduler_options=None, dedicated_host_cluster_name=None, description=None, dry_run=None,
                 owner_account=None, owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None, zone_id=None):
        self.scheduler_options = scheduler_options  # type: CreateDedicatedHostClusterRequestSchedulerOptions
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateDedicatedHostClusterRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDedicatedHostClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerOptions') is not None:
            temp_model = CreateDedicatedHostClusterRequestSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDedicatedHostClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDedicatedHostClusterResponseBody(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, request_id=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedHostClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedHostClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDedicatedHostClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDedicatedHostClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDefaultAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDefaultAutoSnapshotPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateDefaultAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, auto_snapshot_policy_name=None, repeat_weekdays=None,
                 request_id=None, retention_days=None, time_points=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.request_id = request_id  # type: str
        self.retention_days = retention_days  # type: int
        self.time_points = time_points  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDefaultAutoSnapshotPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.auto_snapshot_policy_name is not None:
            result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.repeat_weekdays is not None:
            result['RepeatWeekdays'] = self.repeat_weekdays
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.time_points is not None:
            result['TimePoints'] = self.time_points
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('AutoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('AutoSnapshotPolicyName')
        if m.get('RepeatWeekdays') is not None:
            self.repeat_weekdays = m.get('RepeatWeekdays')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('TimePoints') is not None:
            self.time_points = m.get('TimePoints')
        return self


class CreateDefaultAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDefaultAutoSnapshotPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDefaultAutoSnapshotPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDefaultAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnoseRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnoseRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDiagnoseRequest(TeaModel):
    def __init__(self, amount=None, diagnose_action=None, diagnose_error_code=None, diagnose_product=None,
                 diagnose_request_id=None, diagnose_request_params=None, diagnose_response=None, disk_category=None, expire_time=None,
                 instance_charge_type=None, instance_type_name=None, iz_no=None, mark=None, network_type=None, owner_account=None,
                 owner_id=None, period=None, period_unit=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None, type=None):
        self.amount = amount  # type: int
        self.diagnose_action = diagnose_action  # type: str
        self.diagnose_error_code = diagnose_error_code  # type: str
        self.diagnose_product = diagnose_product  # type: str
        self.diagnose_request_id = diagnose_request_id  # type: str
        self.diagnose_request_params = diagnose_request_params  # type: str
        self.diagnose_response = diagnose_response  # type: str
        self.disk_category = disk_category  # type: str
        self.expire_time = expire_time  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type_name = instance_type_name  # type: str
        self.iz_no = iz_no  # type: str
        self.mark = mark  # type: str
        self.network_type = network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateDiagnoseRequestTag]
        self.type = type  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDiagnoseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.diagnose_action is not None:
            result['DiagnoseAction'] = self.diagnose_action
        if self.diagnose_error_code is not None:
            result['DiagnoseErrorCode'] = self.diagnose_error_code
        if self.diagnose_product is not None:
            result['DiagnoseProduct'] = self.diagnose_product
        if self.diagnose_request_id is not None:
            result['DiagnoseRequestId'] = self.diagnose_request_id
        if self.diagnose_request_params is not None:
            result['DiagnoseRequestParams'] = self.diagnose_request_params
        if self.diagnose_response is not None:
            result['DiagnoseResponse'] = self.diagnose_response
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type_name is not None:
            result['InstanceTypeName'] = self.instance_type_name
        if self.iz_no is not None:
            result['IzNo'] = self.iz_no
        if self.mark is not None:
            result['Mark'] = self.mark
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('DiagnoseAction') is not None:
            self.diagnose_action = m.get('DiagnoseAction')
        if m.get('DiagnoseErrorCode') is not None:
            self.diagnose_error_code = m.get('DiagnoseErrorCode')
        if m.get('DiagnoseProduct') is not None:
            self.diagnose_product = m.get('DiagnoseProduct')
        if m.get('DiagnoseRequestId') is not None:
            self.diagnose_request_id = m.get('DiagnoseRequestId')
        if m.get('DiagnoseRequestParams') is not None:
            self.diagnose_request_params = m.get('DiagnoseRequestParams')
        if m.get('DiagnoseResponse') is not None:
            self.diagnose_response = m.get('DiagnoseResponse')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceTypeName') is not None:
            self.instance_type_name = m.get('InstanceTypeName')
        if m.get('IzNo') is not None:
            self.iz_no = m.get('IzNo')
        if m.get('Mark') is not None:
            self.mark = m.get('Mark')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDiagnoseRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDiagnoseResponseBody(TeaModel):
    def __init__(self, diagnose_id=None, request_id=None, status=None):
        self.diagnose_id = diagnose_id  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnoseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.diagnose_id is not None:
            result['DiagnoseId'] = self.diagnose_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiagnoseId') is not None:
            self.diagnose_id = m.get('DiagnoseId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDiagnoseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnoseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnoseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnoseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosisOperateRecordsRequest(TeaModel):
    def __init__(self, error_code=None, instance_type=None, new_instance_type=None, new_zone_id=None,
                 operate_record_type=None, owner_id=None, pay_type=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, zone_id=None):
        self.error_code = error_code  # type: str
        self.instance_type = instance_type  # type: str
        self.new_instance_type = new_instance_type  # type: str
        self.new_zone_id = new_zone_id  # type: str
        self.operate_record_type = operate_record_type  # type: str
        self.owner_id = owner_id  # type: long
        self.pay_type = pay_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosisOperateRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.new_instance_type is not None:
            result['NewInstanceType'] = self.new_instance_type
        if self.new_zone_id is not None:
            result['NewZoneId'] = self.new_zone_id
        if self.operate_record_type is not None:
            result['OperateRecordType'] = self.operate_record_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NewInstanceType') is not None:
            self.new_instance_type = m.get('NewInstanceType')
        if m.get('NewZoneId') is not None:
            self.new_zone_id = m.get('NewZoneId')
        if m.get('OperateRecordType') is not None:
            self.operate_record_type = m.get('OperateRecordType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDiagnosisOperateRecordsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosisOperateRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnosisOperateRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnosisOperateRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnosisOperateRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosisOperateRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticReportRequest(TeaModel):
    def __init__(self, client_token=None, command_name=None, command_type=None, diagnostic_category=None,
                 end_time=None, owner_account=None, owner_id=None, plugin_version=None, region_id=None, resource_id=None,
                 resource_owner_account=None, resource_owner_id=None, resource_type=None, source_system=None, start_time=None):
        self.client_token = client_token  # type: str
        self.command_name = command_name  # type: list[str]
        self.command_type = command_type  # type: str
        self.diagnostic_category = diagnostic_category  # type: str
        self.end_time = end_time  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.plugin_version = plugin_version  # type: str
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str
        self.source_system = source_system  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.command_name is not None:
            result['CommandName'] = self.command_name
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.diagnostic_category is not None:
            result['DiagnosticCategory'] = self.diagnostic_category
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.plugin_version is not None:
            result['PluginVersion'] = self.plugin_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.source_system is not None:
            result['SourceSystem'] = self.source_system
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CommandName') is not None:
            self.command_name = m.get('CommandName')
        if m.get('CommandType') is not None:
            self.command_type = m.get('CommandType')
        if m.get('DiagnosticCategory') is not None:
            self.diagnostic_category = m.get('DiagnosticCategory')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PluginVersion') is not None:
            self.plugin_version = m.get('PluginVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SourceSystem') is not None:
            self.source_system = m.get('SourceSystem')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateDiagnosticReportResponseBodyCommandInvokeResultsInvokeResult(TeaModel):
    def __init__(self, command_name=None, data_file_dir=None, invoke_result=None):
        self.command_name = command_name  # type: str
        self.data_file_dir = data_file_dir  # type: str
        self.invoke_result = invoke_result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportResponseBodyCommandInvokeResultsInvokeResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_name is not None:
            result['CommandName'] = self.command_name
        if self.data_file_dir is not None:
            result['DataFileDir'] = self.data_file_dir
        if self.invoke_result is not None:
            result['InvokeResult'] = self.invoke_result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandName') is not None:
            self.command_name = m.get('CommandName')
        if m.get('DataFileDir') is not None:
            self.data_file_dir = m.get('DataFileDir')
        if m.get('InvokeResult') is not None:
            self.invoke_result = m.get('InvokeResult')
        return self


class CreateDiagnosticReportResponseBodyCommandInvokeResults(TeaModel):
    def __init__(self, invoke_result=None):
        self.invoke_result = invoke_result  # type: list[CreateDiagnosticReportResponseBodyCommandInvokeResultsInvokeResult]

    def validate(self):
        if self.invoke_result:
            for k in self.invoke_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDiagnosticReportResponseBodyCommandInvokeResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InvokeResult'] = []
        if self.invoke_result is not None:
            for k in self.invoke_result:
                result['InvokeResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.invoke_result = []
        if m.get('InvokeResult') is not None:
            for k in m.get('InvokeResult'):
                temp_model = CreateDiagnosticReportResponseBodyCommandInvokeResultsInvokeResult()
                self.invoke_result.append(temp_model.from_map(k))
        return self


class CreateDiagnosticReportResponseBody(TeaModel):
    def __init__(self, command_invoke_results=None, create_time=None, report_id=None, request_id=None, status=None):
        self.command_invoke_results = command_invoke_results  # type: CreateDiagnosticReportResponseBodyCommandInvokeResults
        self.create_time = create_time  # type: str
        self.report_id = report_id  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.command_invoke_results:
            self.command_invoke_results.validate()

    def to_map(self):
        _map = super(CreateDiagnosticReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_invoke_results is not None:
            result['CommandInvokeResults'] = self.command_invoke_results.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandInvokeResults') is not None:
            temp_model = CreateDiagnosticReportResponseBodyCommandInvokeResults()
            self.command_invoke_results = temp_model.from_map(m['CommandInvokeResults'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateDiagnosticReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnosticReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnosticReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDisksRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDisksRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDisksRequest(TeaModel):
    def __init__(self, amount=None, auto_snapshot_policy_id=None, bursting_enabled=None, category=None,
                 client_token=None, description=None, disk_name=None, encrypt_algorithm=None, encrypted=None, kmskey_id=None,
                 multi_attach=None, owner_account=None, owner_id=None, performance_level=None, provisioned_iops=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None, size=None,
                 snapshot_id=None, storage_cluster_id=None, storage_set_id=None, storage_set_partition_number=None, tag=None,
                 zone_id=None):
        self.amount = amount  # type: int
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.bursting_enabled = bursting_enabled  # type: bool
        self.category = category  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: bool
        self.kmskey_id = kmskey_id  # type: str
        self.multi_attach = multi_attach  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.storage_cluster_id = storage_cluster_id  # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.tag = tag  # type: list[CreateDisksRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDisksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.multi_attach is not None:
            result['MultiAttach'] = self.multi_attach
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('MultiAttach') is not None:
            self.multi_attach = m.get('MultiAttach')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDisksRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDisksResponseBodyDiskId(TeaModel):
    def __init__(self, disk_ids=None):
        self.disk_ids = disk_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDisksResponseBodyDiskId, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_ids is not None:
            result['DiskIds'] = self.disk_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskIds') is not None:
            self.disk_ids = m.get('DiskIds')
        return self


class CreateDisksResponseBody(TeaModel):
    def __init__(self, disk_id=None, request_id=None):
        self.disk_id = disk_id  # type: CreateDisksResponseBodyDiskId
        self.request_id = request_id  # type: str

    def validate(self):
        if self.disk_id:
            self.disk_id.validate()

    def to_map(self):
        _map = super(CreateDisksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskId') is not None:
            temp_model = CreateDisksResponseBodyDiskId()
            self.disk_id = temp_model.from_map(m['DiskId'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDisksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDisksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDisksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDisksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, name=None):
        self.match_criteria = match_criteria  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateElasticityAssuranceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateElasticityAssuranceRequest(TeaModel):
    def __init__(self, private_pool_options=None, assurance_times=None, client_token=None, description=None,
                 instance_amount=None, instance_cpu_core_count=None, instance_type=None, owner_account=None, owner_id=None,
                 period=None, period_unit=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, start_time=None, tag=None, zone_id=None):
        self.private_pool_options = private_pool_options  # type: CreateElasticityAssuranceRequestPrivatePoolOptions
        self.assurance_times = assurance_times  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.instance_type = instance_type  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str
        self.tag = tag  # type: list[CreateElasticityAssuranceRequestTag]
        self.zone_id = zone_id  # type: list[str]

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.assurance_times is not None:
            result['AssuranceTimes'] = self.assurance_times
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('AssuranceTimes') is not None:
            self.assurance_times = m.get('AssuranceTimes')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = m.get('InstanceCpuCoreCount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateElasticityAssuranceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateElasticityAssuranceResponseBody(TeaModel):
    def __init__(self, order_id=None, private_pool_options_id=None, request_id=None):
        self.order_id = order_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateElasticityAssuranceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateElasticityAssuranceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateElasticityAssuranceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateElasticityAssuranceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEniQosGroupRequest(TeaModel):
    def __init__(self, instance_id=None, owner_id=None, qos_group_name=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, rx=None, rx_pps=None, tx=None, tx_pps=None):
        self.instance_id = instance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.qos_group_name = qos_group_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.rx = rx  # type: int
        self.rx_pps = rx_pps  # type: int
        self.tx = tx  # type: int
        self.tx_pps = tx_pps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEniQosGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_group_name is not None:
            result['QosGroupName'] = self.qos_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rx is not None:
            result['Rx'] = self.rx
        if self.rx_pps is not None:
            result['RxPps'] = self.rx_pps
        if self.tx is not None:
            result['Tx'] = self.tx
        if self.tx_pps is not None:
            result['TxPps'] = self.tx_pps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosGroupName') is not None:
            self.qos_group_name = m.get('QosGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Rx') is not None:
            self.rx = m.get('Rx')
        if m.get('RxPps') is not None:
            self.rx_pps = m.get('RxPps')
        if m.get('Tx') is not None:
            self.tx = m.get('Tx')
        if m.get('TxPps') is not None:
            self.tx_pps = m.get('TxPps')
        return self


class CreateEniQosGroupResponseBody(TeaModel):
    def __init__(self, qos_group_name=None, request_id=None):
        self.qos_group_name = qos_group_name  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEniQosGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_group_name is not None:
            result['QosGroupName'] = self.qos_group_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QosGroupName') is not None:
            self.qos_group_name = m.get('QosGroupName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEniQosGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEniQosGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEniQosGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEniQosGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFunctionFeedbackRequest(TeaModel):
    def __init__(self, category=None, feedback=None, function_name=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, suggestion=None):
        self.category = category  # type: str
        self.feedback = feedback  # type: str
        self.function_name = function_name  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFunctionFeedbackRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class CreateFunctionFeedbackResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFunctionFeedbackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFunctionFeedbackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateFunctionFeedbackResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFunctionFeedbackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFunctionFeedbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageCacheRequest(TeaModel):
    def __init__(self, client_token=None, image_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, zone_id=None):
        self.client_token = client_token  # type: str
        self.image_id = image_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageCacheRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateImageCacheResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageCacheResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageCacheResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateImageCacheResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateImageCacheResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageCacheResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIssueCategoryReportRelationRequestRelationModelList(TeaModel):
    def __init__(self, customer_input_content=None, issue_category_id=None, issue_category_name=None,
                 mapping_tools=None, report_id=None):
        self.customer_input_content = customer_input_content  # type: str
        self.issue_category_id = issue_category_id  # type: long
        self.issue_category_name = issue_category_name  # type: str
        self.mapping_tools = mapping_tools  # type: str
        self.report_id = report_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateIssueCategoryReportRelationRequestRelationModelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_input_content is not None:
            result['CustomerInputContent'] = self.customer_input_content
        if self.issue_category_id is not None:
            result['IssueCategoryId'] = self.issue_category_id
        if self.issue_category_name is not None:
            result['IssueCategoryName'] = self.issue_category_name
        if self.mapping_tools is not None:
            result['MappingTools'] = self.mapping_tools
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomerInputContent') is not None:
            self.customer_input_content = m.get('CustomerInputContent')
        if m.get('IssueCategoryId') is not None:
            self.issue_category_id = m.get('IssueCategoryId')
        if m.get('IssueCategoryName') is not None:
            self.issue_category_name = m.get('IssueCategoryName')
        if m.get('MappingTools') is not None:
            self.mapping_tools = m.get('MappingTools')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class CreateIssueCategoryReportRelationRequest(TeaModel):
    def __init__(self, region_id=None, relation_model_list=None):
        self.region_id = region_id  # type: str
        self.relation_model_list = relation_model_list  # type: list[CreateIssueCategoryReportRelationRequestRelationModelList]

    def validate(self):
        if self.relation_model_list:
            for k in self.relation_model_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateIssueCategoryReportRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['RelationModelList'] = []
        if self.relation_model_list is not None:
            for k in self.relation_model_list:
                result['RelationModelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.relation_model_list = []
        if m.get('RelationModelList') is not None:
            for k in m.get('RelationModelList'):
                temp_model = CreateIssueCategoryReportRelationRequestRelationModelList()
                self.relation_model_list.append(temp_model.from_map(k))
        return self


class CreateIssueCategoryReportRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, status=None):
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateIssueCategoryReportRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateIssueCategoryReportRelationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateIssueCategoryReportRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateIssueCategoryReportRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIssueCategoryReportRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMigrationPlanRequestCustomMigrationTimes(TeaModel):
    def __init__(self, instance_id=None, migration_time=None):
        self.instance_id = instance_id  # type: str
        self.migration_time = migration_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrationPlanRequestCustomMigrationTimes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.migration_time is not None:
            result['MigrationTime'] = self.migration_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MigrationTime') is not None:
            self.migration_time = m.get('MigrationTime')
        return self


class CreateMigrationPlanRequest(TeaModel):
    def __init__(self, custom_migration_times=None, dry_run=None, enable_auto_create_vswitch=None,
                 ensure_network_connectivity=None, global_migration_time=None, instance_ids=None, name=None, owner_id=None, region_id=None,
                 remain_private_ip=None, remain_public_mac_as_priority=None, resource_owner_account=None, resource_owner_id=None,
                 target_security_group_ids=None, target_vswitch_id=None, target_vpc_id=None, target_zone_id=None, type=None):
        self.custom_migration_times = custom_migration_times  # type: list[CreateMigrationPlanRequestCustomMigrationTimes]
        self.dry_run = dry_run  # type: bool
        self.enable_auto_create_vswitch = enable_auto_create_vswitch  # type: bool
        self.ensure_network_connectivity = ensure_network_connectivity  # type: bool
        self.global_migration_time = global_migration_time  # type: str
        self.instance_ids = instance_ids  # type: list[str]
        self.name = name  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.remain_private_ip = remain_private_ip  # type: bool
        self.remain_public_mac_as_priority = remain_public_mac_as_priority  # type: bool
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.target_security_group_ids = target_security_group_ids  # type: list[str]
        self.target_vswitch_id = target_vswitch_id  # type: str
        self.target_vpc_id = target_vpc_id  # type: str
        self.target_zone_id = target_zone_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.custom_migration_times:
            for k in self.custom_migration_times:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomMigrationTimes'] = []
        if self.custom_migration_times is not None:
            for k in self.custom_migration_times:
                result['CustomMigrationTimes'].append(k.to_map() if k else None)
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.enable_auto_create_vswitch is not None:
            result['EnableAutoCreateVSwitch'] = self.enable_auto_create_vswitch
        if self.ensure_network_connectivity is not None:
            result['EnsureNetworkConnectivity'] = self.ensure_network_connectivity
        if self.global_migration_time is not None:
            result['GlobalMigrationTime'] = self.global_migration_time
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remain_private_ip is not None:
            result['RemainPrivateIp'] = self.remain_private_ip
        if self.remain_public_mac_as_priority is not None:
            result['RemainPublicMacAsPriority'] = self.remain_public_mac_as_priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.target_security_group_ids is not None:
            result['TargetSecurityGroupIds'] = self.target_security_group_ids
        if self.target_vswitch_id is not None:
            result['TargetVSwitchId'] = self.target_vswitch_id
        if self.target_vpc_id is not None:
            result['TargetVpcId'] = self.target_vpc_id
        if self.target_zone_id is not None:
            result['TargetZoneId'] = self.target_zone_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_migration_times = []
        if m.get('CustomMigrationTimes') is not None:
            for k in m.get('CustomMigrationTimes'):
                temp_model = CreateMigrationPlanRequestCustomMigrationTimes()
                self.custom_migration_times.append(temp_model.from_map(k))
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('EnableAutoCreateVSwitch') is not None:
            self.enable_auto_create_vswitch = m.get('EnableAutoCreateVSwitch')
        if m.get('EnsureNetworkConnectivity') is not None:
            self.ensure_network_connectivity = m.get('EnsureNetworkConnectivity')
        if m.get('GlobalMigrationTime') is not None:
            self.global_migration_time = m.get('GlobalMigrationTime')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemainPrivateIp') is not None:
            self.remain_private_ip = m.get('RemainPrivateIp')
        if m.get('RemainPublicMacAsPriority') is not None:
            self.remain_public_mac_as_priority = m.get('RemainPublicMacAsPriority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TargetSecurityGroupIds') is not None:
            self.target_security_group_ids = m.get('TargetSecurityGroupIds')
        if m.get('TargetVSwitchId') is not None:
            self.target_vswitch_id = m.get('TargetVSwitchId')
        if m.get('TargetVpcId') is not None:
            self.target_vpc_id = m.get('TargetVpcId')
        if m.get('TargetZoneId') is not None:
            self.target_zone_id = m.get('TargetZoneId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModelsFailModel(TeaModel):
    def __init__(self, error_code=None, error_message=None):
        self.error_code = error_code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModelsFailModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModels(TeaModel):
    def __init__(self, fail_model=None):
        self.fail_model = fail_model  # type: list[CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModelsFailModel]

    def validate(self):
        if self.fail_model:
            for k in self.fail_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailModel'] = []
        if self.fail_model is not None:
            for k in self.fail_model:
                result['FailModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fail_model = []
        if m.get('FailModel') is not None:
            for k in m.get('FailModel'):
                temp_model = CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModelsFailModel()
                self.fail_model.append(temp_model.from_map(k))
        return self


class CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModel(TeaModel):
    def __init__(self, fail_models=None, instance_id=None):
        self.fail_models = fail_models  # type: CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModels
        self.instance_id = instance_id  # type: str

    def validate(self):
        if self.fail_models:
            self.fail_models.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_models is not None:
            result['FailModels'] = self.fail_models.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailModels') is not None:
            temp_model = CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModelFailModels()
            self.fail_models = temp_model.from_map(m['FailModels'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateMigrationPlanResponseBodyInstancesFailModels(TeaModel):
    def __init__(self, instances_fail_model=None):
        self.instances_fail_model = instances_fail_model  # type: list[CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModel]

    def validate(self):
        if self.instances_fail_model:
            for k in self.instances_fail_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyInstancesFailModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstancesFailModel'] = []
        if self.instances_fail_model is not None:
            for k in self.instances_fail_model:
                result['InstancesFailModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instances_fail_model = []
        if m.get('InstancesFailModel') is not None:
            for k in m.get('InstancesFailModel'):
                temp_model = CreateMigrationPlanResponseBodyInstancesFailModelsInstancesFailModel()
                self.instances_fail_model.append(temp_model.from_map(k))
        return self


class CreateMigrationPlanResponseBodyPlanFailModelsPlanFailModel(TeaModel):
    def __init__(self, error_code=None, error_message=None):
        self.error_code = error_code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyPlanFailModelsPlanFailModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateMigrationPlanResponseBodyPlanFailModels(TeaModel):
    def __init__(self, plan_fail_model=None):
        self.plan_fail_model = plan_fail_model  # type: list[CreateMigrationPlanResponseBodyPlanFailModelsPlanFailModel]

    def validate(self):
        if self.plan_fail_model:
            for k in self.plan_fail_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodyPlanFailModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PlanFailModel'] = []
        if self.plan_fail_model is not None:
            for k in self.plan_fail_model:
                result['PlanFailModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.plan_fail_model = []
        if m.get('PlanFailModel') is not None:
            for k in m.get('PlanFailModel'):
                temp_model = CreateMigrationPlanResponseBodyPlanFailModelsPlanFailModel()
                self.plan_fail_model.append(temp_model.from_map(k))
        return self


class CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModelsFailModel(TeaModel):
    def __init__(self, error_code=None, error_message=None):
        self.error_code = error_code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModelsFailModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModels(TeaModel):
    def __init__(self, fail_model=None):
        self.fail_model = fail_model  # type: list[CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModelsFailModel]

    def validate(self):
        if self.fail_model:
            for k in self.fail_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailModel'] = []
        if self.fail_model is not None:
            for k in self.fail_model:
                result['FailModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fail_model = []
        if m.get('FailModel') is not None:
            for k in m.get('FailModel'):
                temp_model = CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModelsFailModel()
                self.fail_model.append(temp_model.from_map(k))
        return self


class CreateMigrationPlanResponseBodySgFailModelsSgFailModel(TeaModel):
    def __init__(self, fail_models=None, group_no=None):
        self.fail_models = fail_models  # type: CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModels
        self.group_no = group_no  # type: str

    def validate(self):
        if self.fail_models:
            self.fail_models.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodySgFailModelsSgFailModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_models is not None:
            result['FailModels'] = self.fail_models.to_map()
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailModels') is not None:
            temp_model = CreateMigrationPlanResponseBodySgFailModelsSgFailModelFailModels()
            self.fail_models = temp_model.from_map(m['FailModels'])
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        return self


class CreateMigrationPlanResponseBodySgFailModels(TeaModel):
    def __init__(self, sg_fail_model=None):
        self.sg_fail_model = sg_fail_model  # type: list[CreateMigrationPlanResponseBodySgFailModelsSgFailModel]

    def validate(self):
        if self.sg_fail_model:
            for k in self.sg_fail_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBodySgFailModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SgFailModel'] = []
        if self.sg_fail_model is not None:
            for k in self.sg_fail_model:
                result['SgFailModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sg_fail_model = []
        if m.get('SgFailModel') is not None:
            for k in m.get('SgFailModel'):
                temp_model = CreateMigrationPlanResponseBodySgFailModelsSgFailModel()
                self.sg_fail_model.append(temp_model.from_map(k))
        return self


class CreateMigrationPlanResponseBody(TeaModel):
    def __init__(self, instances_fail_models=None, migration_plan_id=None, plan_fail_models=None, request_id=None,
                 sg_fail_models=None):
        self.instances_fail_models = instances_fail_models  # type: CreateMigrationPlanResponseBodyInstancesFailModels
        self.migration_plan_id = migration_plan_id  # type: str
        self.plan_fail_models = plan_fail_models  # type: CreateMigrationPlanResponseBodyPlanFailModels
        self.request_id = request_id  # type: str
        self.sg_fail_models = sg_fail_models  # type: CreateMigrationPlanResponseBodySgFailModels

    def validate(self):
        if self.instances_fail_models:
            self.instances_fail_models.validate()
        if self.plan_fail_models:
            self.plan_fail_models.validate()
        if self.sg_fail_models:
            self.sg_fail_models.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instances_fail_models is not None:
            result['InstancesFailModels'] = self.instances_fail_models.to_map()
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.plan_fail_models is not None:
            result['PlanFailModels'] = self.plan_fail_models.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sg_fail_models is not None:
            result['SgFailModels'] = self.sg_fail_models.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstancesFailModels') is not None:
            temp_model = CreateMigrationPlanResponseBodyInstancesFailModels()
            self.instances_fail_models = temp_model.from_map(m['InstancesFailModels'])
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('PlanFailModels') is not None:
            temp_model = CreateMigrationPlanResponseBodyPlanFailModels()
            self.plan_fail_models = temp_model.from_map(m['PlanFailModels'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SgFailModels') is not None:
            temp_model = CreateMigrationPlanResponseBodySgFailModels()
            self.sg_fail_models = temp_model.from_map(m['SgFailModels'])
        return self


class CreateMigrationPlanResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMigrationPlanResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMigrationPlanResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMigrationPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInsightsPathRequest(TeaModel):
    def __init__(self, client_token=None, destination=None, destination_port=None, destination_type=None,
                 dry_run=None, need_diagnose_guest=None, network_insights_path_name=None, protocol=None, region_id=None,
                 resource_owner_id=None, source=None, source_type=None):
        self.client_token = client_token  # type: str
        self.destination = destination  # type: str
        self.destination_port = destination_port  # type: str
        self.destination_type = destination_type  # type: str
        self.dry_run = dry_run  # type: bool
        self.need_diagnose_guest = need_diagnose_guest  # type: bool
        self.network_insights_path_name = network_insights_path_name  # type: str
        self.protocol = protocol  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source = source  # type: str
        self.source_type = source_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInsightsPathRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_port is not None:
            result['DestinationPort'] = self.destination_port
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.need_diagnose_guest is not None:
            result['NeedDiagnoseGuest'] = self.need_diagnose_guest
        if self.network_insights_path_name is not None:
            result['NetworkInsightsPathName'] = self.network_insights_path_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source is not None:
            result['Source'] = self.source
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationPort') is not None:
            self.destination_port = m.get('DestinationPort')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NeedDiagnoseGuest') is not None:
            self.need_diagnose_guest = m.get('NeedDiagnoseGuest')
        if m.get('NetworkInsightsPathName') is not None:
            self.network_insights_path_name = m.get('NetworkInsightsPathName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class CreateNetworkInsightsPathResponseBody(TeaModel):
    def __init__(self, network_insights_path_id=None, request_id=None):
        self.network_insights_path_id = network_insights_path_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInsightsPathResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkInsightsPathResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateNetworkInsightsPathResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateNetworkInsightsPathResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkInsightsPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrderRequest(TeaModel):
    def __init__(self, affinity=None, async_pattern=None, business_info=None, charge_type=None, client_token=None,
                 commodity=None, dedicated_host_cluster_id=None, dedicated_host_id=None, from_app=None, order_type=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 tenancy=None):
        self.affinity = affinity  # type: str
        self.async_pattern = async_pattern  # type: bool
        self.business_info = business_info  # type: str
        self.charge_type = charge_type  # type: str
        self.client_token = client_token  # type: str
        self.commodity = commodity  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.from_app = from_app  # type: str
        self.order_type = order_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tenancy = tenancy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.async_pattern is not None:
            result['AsyncPattern'] = self.async_pattern
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.commodity is not None:
            result['Commodity'] = self.commodity
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        if m.get('AsyncPattern') is not None:
            self.async_pattern = m.get('AsyncPattern')
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Commodity') is not None:
            self.commodity = m.get('Commodity')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        return self


class CreateOrderResponseBodyOrderParams(TeaModel):
    def __init__(self, order_param=None):
        self.order_param = order_param  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderResponseBodyOrderParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_param is not None:
            result['OrderParam'] = self.order_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderParam') is not None:
            self.order_param = m.get('OrderParam')
        return self


class CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetInstanceIdSet(TeaModel):
    def __init__(self, instance_ids=None):
        self.instance_ids = instance_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetInstanceIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetRelatedOrderIds(TeaModel):
    def __init__(self, related_order_id=None):
        self.related_order_id = related_order_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetRelatedOrderIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.related_order_id is not None:
            result['RelatedOrderId'] = self.related_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RelatedOrderId') is not None:
            self.related_order_id = m.get('RelatedOrderId')
        return self


class CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSet(TeaModel):
    def __init__(self, instance_id_set=None, related_order_ids=None):
        self.instance_id_set = instance_id_set  # type: CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetInstanceIdSet
        self.related_order_ids = related_order_ids  # type: CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetRelatedOrderIds

    def validate(self):
        if self.instance_id_set:
            self.instance_id_set.validate()
        if self.related_order_ids:
            self.related_order_ids.validate()

    def to_map(self):
        _map = super(CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id_set is not None:
            result['InstanceIdSet'] = self.instance_id_set.to_map()
        if self.related_order_ids is not None:
            result['RelatedOrderIds'] = self.related_order_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIdSet') is not None:
            temp_model = CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetInstanceIdSet()
            self.instance_id_set = temp_model.from_map(m['InstanceIdSet'])
        if m.get('RelatedOrderIds') is not None:
            temp_model = CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSetRelatedOrderIds()
            self.related_order_ids = temp_model.from_map(m['RelatedOrderIds'])
        return self


class CreateOrderResponseBodyRelatedOrderItemSets(TeaModel):
    def __init__(self, related_order_item_set=None):
        self.related_order_item_set = related_order_item_set  # type: list[CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSet]

    def validate(self):
        if self.related_order_item_set:
            for k in self.related_order_item_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOrderResponseBodyRelatedOrderItemSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RelatedOrderItemSet'] = []
        if self.related_order_item_set is not None:
            for k in self.related_order_item_set:
                result['RelatedOrderItemSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.related_order_item_set = []
        if m.get('RelatedOrderItemSet') is not None:
            for k in m.get('RelatedOrderItemSet'):
                temp_model = CreateOrderResponseBodyRelatedOrderItemSetsRelatedOrderItemSet()
                self.related_order_item_set.append(temp_model.from_map(k))
        return self


class CreateOrderResponseBody(TeaModel):
    def __init__(self, order_id=None, order_params=None, related_order_item_sets=None, request_id=None,
                 task_id=None, trade_price=None):
        self.order_id = order_id  # type: str
        self.order_params = order_params  # type: CreateOrderResponseBodyOrderParams
        self.related_order_item_sets = related_order_item_sets  # type: CreateOrderResponseBodyRelatedOrderItemSets
        self.request_id = request_id  # type: str
        self.task_id = task_id  # type: str
        self.trade_price = trade_price  # type: float

    def validate(self):
        if self.order_params:
            self.order_params.validate()
        if self.related_order_item_sets:
            self.related_order_item_sets.validate()

    def to_map(self):
        _map = super(CreateOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_params is not None:
            result['OrderParams'] = self.order_params.to_map()
        if self.related_order_item_sets is not None:
            result['RelatedOrderItemSets'] = self.related_order_item_sets.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderParams') is not None:
            temp_model = CreateOrderResponseBodyOrderParams()
            self.order_params = temp_model.from_map(m['OrderParams'])
        if m.get('RelatedOrderItemSets') is not None:
            temp_model = CreateOrderResponseBodyRelatedOrderItemSets()
            self.related_order_item_sets = temp_model.from_map(m['RelatedOrderItemSets'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class CreateOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateReservationDemandRequestPrivatePoolOptions(TeaModel):
    def __init__(self, instance_amount=None, instance_type=None, match_criteria=None, zone_id=None):
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.match_criteria = match_criteria  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateReservationDemandRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateReservationDemandRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateReservationDemandRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateReservationDemandRequest(TeaModel):
    def __init__(self, client_token=None, confirm_type=None, coupon_auto=None, coupon_type=None, description=None,
                 end_time=None, instance_amount=None, instance_charge_type=None, instance_cpu_core_count=None,
                 instance_type_family=None, instance_types=None, match_criteria=None, name=None, period=None, period_unit=None,
                 phone_number=None, platform=None, private_pool_options=None, product_type=None, region_id=None,
                 reserved_instance_description=None, reserved_instance_name=None, reserved_instance_offering_type=None,
                 reserved_instance_scope=None, resource_group_id=None, resource_owner_id=None, resource_supply_type=None,
                 saving_plan_description=None, saving_plan_hour_fee=None, saving_plan_id=None,
                 saving_plan_instance_type_family_group=None, saving_plan_name=None, saving_plan_pay_mode=None, saving_plan_saving_type=None,
                 start_time=None, tag=None, zone_ids=None):
        self.client_token = client_token  # type: str
        self.confirm_type = confirm_type  # type: str
        self.coupon_auto = coupon_auto  # type: bool
        self.coupon_type = coupon_type  # type: str
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.instance_type_family = instance_type_family  # type: str
        self.instance_types = instance_types  # type: str
        self.match_criteria = match_criteria  # type: str
        self.name = name  # type: str
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.phone_number = phone_number  # type: str
        self.platform = platform  # type: str
        self.private_pool_options = private_pool_options  # type: list[CreateReservationDemandRequestPrivatePoolOptions]
        self.product_type = product_type  # type: str
        self.region_id = region_id  # type: str
        self.reserved_instance_description = reserved_instance_description  # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.reserved_instance_offering_type = reserved_instance_offering_type  # type: str
        self.reserved_instance_scope = reserved_instance_scope  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_supply_type = resource_supply_type  # type: str
        self.saving_plan_description = saving_plan_description  # type: str
        self.saving_plan_hour_fee = saving_plan_hour_fee  # type: float
        self.saving_plan_id = saving_plan_id  # type: str
        self.saving_plan_instance_type_family_group = saving_plan_instance_type_family_group  # type: str
        self.saving_plan_name = saving_plan_name  # type: str
        self.saving_plan_pay_mode = saving_plan_pay_mode  # type: str
        self.saving_plan_saving_type = saving_plan_saving_type  # type: str
        self.start_time = start_time  # type: str
        self.tag = tag  # type: list[CreateReservationDemandRequestTag]
        self.zone_ids = zone_ids  # type: str

    def validate(self):
        if self.private_pool_options:
            for k in self.private_pool_options:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateReservationDemandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.confirm_type is not None:
            result['ConfirmType'] = self.confirm_type
        if self.coupon_auto is not None:
            result['CouponAuto'] = self.coupon_auto
        if self.coupon_type is not None:
            result['CouponType'] = self.coupon_type
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.name is not None:
            result['Name'] = self.name
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.platform is not None:
            result['Platform'] = self.platform
        result['PrivatePoolOptions'] = []
        if self.private_pool_options is not None:
            for k in self.private_pool_options:
                result['PrivatePoolOptions'].append(k.to_map() if k else None)
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_description is not None:
            result['ReservedInstanceDescription'] = self.reserved_instance_description
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.reserved_instance_offering_type is not None:
            result['ReservedInstanceOfferingType'] = self.reserved_instance_offering_type
        if self.reserved_instance_scope is not None:
            result['ReservedInstanceScope'] = self.reserved_instance_scope
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_supply_type is not None:
            result['ResourceSupplyType'] = self.resource_supply_type
        if self.saving_plan_description is not None:
            result['SavingPlanDescription'] = self.saving_plan_description
        if self.saving_plan_hour_fee is not None:
            result['SavingPlanHourFee'] = self.saving_plan_hour_fee
        if self.saving_plan_id is not None:
            result['SavingPlanId'] = self.saving_plan_id
        if self.saving_plan_instance_type_family_group is not None:
            result['SavingPlanInstanceTypeFamilyGroup'] = self.saving_plan_instance_type_family_group
        if self.saving_plan_name is not None:
            result['SavingPlanName'] = self.saving_plan_name
        if self.saving_plan_pay_mode is not None:
            result['SavingPlanPayMode'] = self.saving_plan_pay_mode
        if self.saving_plan_saving_type is not None:
            result['SavingPlanSavingType'] = self.saving_plan_saving_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_ids is not None:
            result['ZoneIds'] = self.zone_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfirmType') is not None:
            self.confirm_type = m.get('ConfirmType')
        if m.get('CouponAuto') is not None:
            self.coupon_auto = m.get('CouponAuto')
        if m.get('CouponType') is not None:
            self.coupon_type = m.get('CouponType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = m.get('InstanceCpuCoreCount')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        self.private_pool_options = []
        if m.get('PrivatePoolOptions') is not None:
            for k in m.get('PrivatePoolOptions'):
                temp_model = CreateReservationDemandRequestPrivatePoolOptions()
                self.private_pool_options.append(temp_model.from_map(k))
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceDescription') is not None:
            self.reserved_instance_description = m.get('ReservedInstanceDescription')
        if m.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = m.get('ReservedInstanceName')
        if m.get('ReservedInstanceOfferingType') is not None:
            self.reserved_instance_offering_type = m.get('ReservedInstanceOfferingType')
        if m.get('ReservedInstanceScope') is not None:
            self.reserved_instance_scope = m.get('ReservedInstanceScope')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceSupplyType') is not None:
            self.resource_supply_type = m.get('ResourceSupplyType')
        if m.get('SavingPlanDescription') is not None:
            self.saving_plan_description = m.get('SavingPlanDescription')
        if m.get('SavingPlanHourFee') is not None:
            self.saving_plan_hour_fee = m.get('SavingPlanHourFee')
        if m.get('SavingPlanId') is not None:
            self.saving_plan_id = m.get('SavingPlanId')
        if m.get('SavingPlanInstanceTypeFamilyGroup') is not None:
            self.saving_plan_instance_type_family_group = m.get('SavingPlanInstanceTypeFamilyGroup')
        if m.get('SavingPlanName') is not None:
            self.saving_plan_name = m.get('SavingPlanName')
        if m.get('SavingPlanPayMode') is not None:
            self.saving_plan_pay_mode = m.get('SavingPlanPayMode')
        if m.get('SavingPlanSavingType') is not None:
            self.saving_plan_saving_type = m.get('SavingPlanSavingType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateReservationDemandRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneIds') is not None:
            self.zone_ids = m.get('ZoneIds')
        return self


class CreateReservationDemandResponseBody(TeaModel):
    def __init__(self, demand_id=None, request_id=None):
        self.demand_id = demand_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateReservationDemandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateReservationDemandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateReservationDemandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateReservationDemandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateReservationDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, description=None, max_partition_number=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, storage_set_name=None,
                 zone_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.max_partition_number = max_partition_number  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.storage_set_name = storage_set_name  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStorageSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.max_partition_number is not None:
            result['MaxPartitionNumber'] = self.max_partition_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaxPartitionNumber') is not None:
            self.max_partition_number = m.get('MaxPartitionNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StorageSetName') is not None:
            self.storage_set_name = m.get('StorageSetName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateStorageSetResponseBody(TeaModel):
    def __init__(self, request_id=None, storage_set_id=None):
        self.request_id = request_id  # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStorageSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateStorageSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateStorageSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserQuotaApplicationRequest(TeaModel):
    def __init__(self, charge_type=None, client_token=None, description=None, instance_type=None,
                 owner_account=None, owner_id=None, quota_type=None, quota_value=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, zone_id=None):
        self.charge_type = charge_type  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.quota_type = quota_type  # type: str
        self.quota_value = quota_value  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserQuotaApplicationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.quota_type is not None:
            result['QuotaType'] = self.quota_type
        if self.quota_value is not None:
            result['QuotaValue'] = self.quota_value
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QuotaType') is not None:
            self.quota_type = m.get('QuotaType')
        if m.get('QuotaValue') is not None:
            self.quota_value = m.get('QuotaValue')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateUserQuotaApplicationResponseBody(TeaModel):
    def __init__(self, application_id=None, request_id=None):
        self.application_id = application_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUserQuotaApplicationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUserQuotaApplicationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUserQuotaApplicationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUserQuotaApplicationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserQuotaApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVolumesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVolumesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateVolumesRequest(TeaModel):
    def __init__(self, amount=None, client_token=None, description=None, kmskey_id=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, size=None,
                 snapshot_id=None, storage_set_id=None, storage_set_partition_number=None, tag=None, volume_category=None,
                 volume_encrypted=None, volume_name=None, zone_id=None):
        self.amount = amount  # type: int
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.kmskey_id = kmskey_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.tag = tag  # type: list[CreateVolumesRequestTag]
        self.volume_category = volume_category  # type: str
        self.volume_encrypted = volume_encrypted  # type: bool
        self.volume_name = volume_name  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateVolumesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.volume_category is not None:
            result['VolumeCategory'] = self.volume_category
        if self.volume_encrypted is not None:
            result['VolumeEncrypted'] = self.volume_encrypted
        if self.volume_name is not None:
            result['VolumeName'] = self.volume_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateVolumesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VolumeCategory') is not None:
            self.volume_category = m.get('VolumeCategory')
        if m.get('VolumeEncrypted') is not None:
            self.volume_encrypted = m.get('VolumeEncrypted')
        if m.get('VolumeName') is not None:
            self.volume_name = m.get('VolumeName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateVolumesResponseBodyVolumeIds(TeaModel):
    def __init__(self, volume_id=None):
        self.volume_id = volume_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVolumesResponseBodyVolumeIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.volume_id is not None:
            result['VolumeId'] = self.volume_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VolumeId') is not None:
            self.volume_id = m.get('VolumeId')
        return self


class CreateVolumesResponseBody(TeaModel):
    def __init__(self, request_id=None, volume_ids=None):
        self.request_id = request_id  # type: str
        self.volume_ids = volume_ids  # type: CreateVolumesResponseBodyVolumeIds

    def validate(self):
        if self.volume_ids:
            self.volume_ids.validate()

    def to_map(self):
        _map = super(CreateVolumesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.volume_ids is not None:
            result['VolumeIds'] = self.volume_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VolumeIds') is not None:
            temp_model = CreateVolumesResponseBodyVolumeIds()
            self.volume_ids = temp_model.from_map(m['VolumeIds'])
        return self


class CreateVolumesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVolumesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVolumesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVolumesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWaitingOrderRequestCpuOptions(TeaModel):
    def __init__(self, core=None, numa=None, threads_per_core=None):
        self.core = core  # type: int
        self.numa = numa  # type: str
        self.threads_per_core = threads_per_core  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestCpuOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.core is not None:
            result['Core'] = self.core
        if self.numa is not None:
            result['Numa'] = self.numa
        if self.threads_per_core is not None:
            result['ThreadsPerCore'] = self.threads_per_core
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Core') is not None:
            self.core = m.get('Core')
        if m.get('Numa') is not None:
            self.numa = m.get('Numa')
        if m.get('ThreadsPerCore') is not None:
            self.threads_per_core = m.get('ThreadsPerCore')
        return self


class CreateWaitingOrderRequestHibernationOptions(TeaModel):
    def __init__(self, configured=None):
        self.configured = configured  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestHibernationOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configured is not None:
            result['Configured'] = self.configured
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configured') is not None:
            self.configured = m.get('Configured')
        return self


class CreateWaitingOrderRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None, match_criteria=None):
        self.id = id  # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateWaitingOrderRequestSchedulerOptions(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        return self


class CreateWaitingOrderRequestSecurityOptions(TeaModel):
    def __init__(self, confidential_computing_mode=None, trusted_system_mode=None):
        self.confidential_computing_mode = confidential_computing_mode  # type: str
        self.trusted_system_mode = trusted_system_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestSecurityOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confidential_computing_mode is not None:
            result['ConfidentialComputingMode'] = self.confidential_computing_mode
        if self.trusted_system_mode is not None:
            result['TrustedSystemMode'] = self.trusted_system_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfidentialComputingMode') is not None:
            self.confidential_computing_mode = m.get('ConfidentialComputingMode')
        if m.get('TrustedSystemMode') is not None:
            self.trusted_system_mode = m.get('TrustedSystemMode')
        return self


class CreateWaitingOrderRequestSystemDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, category=None, description=None, disk_name=None,
                 performance_level=None, size=None, storage_cluster_id=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.category = category  # type: str
        self.description = description  # type: str
        self.disk_name = disk_name  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: str
        self.storage_cluster_id = storage_cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        return self


class CreateWaitingOrderRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, role_type=None, rolearn=None):
        self.assume_role_for = assume_role_for  # type: long
        self.role_type = role_type  # type: str
        self.rolearn = rolearn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestArn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        return self


class CreateWaitingOrderRequestDataDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, category=None, delete_with_instance=None, description=None,
                 device=None, disk_name=None, encrypt_algorithm=None, encrypted=None, kmskey_id=None,
                 performance_level=None, size=None, snapshot_id=None, storage_cluster_id=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: str
        self.kmskey_id = kmskey_id  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.storage_cluster_id = storage_cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        return self


class CreateWaitingOrderRequestNetworkInterface(TeaModel):
    def __init__(self, description=None, network_interface_name=None, primary_ip_address=None, queue_number=None,
                 security_group_id=None, security_group_ids=None, v_switch_id=None):
        self.description = description  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.queue_number = queue_number  # type: int
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestNetworkInterface, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('QueueNumber') is not None:
            self.queue_number = m.get('QueueNumber')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateWaitingOrderRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateWaitingOrderRequest(TeaModel):
    def __init__(self, cpu_options=None, hibernation_options=None, private_pool_options=None,
                 scheduler_options=None, security_options=None, system_disk=None, affinity=None, arn=None, auto_release_time=None,
                 auto_renew=None, auto_renew_period=None, client_token=None, credit_specification=None, data_disk=None,
                 dedicated_host_id=None, deletion_protection=None, deployment_set_group_no=None, deployment_set_id=None,
                 description=None, dry_run=None, expired_time=None, host_name=None, host_names=None, hpc_cluster_id=None,
                 http_endpoint=None, http_put_response_hop_limit=None, http_tokens=None, image_family=None, image_id=None,
                 instance_charge_type=None, instance_name=None, instance_type=None, internet_charge_type=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, io_optimized=None, ipv_6address=None,
                 ipv_6address_count=None, isp=None, key_pair_name=None, launch_template_id=None, launch_template_name=None,
                 launch_template_version=None, max_amount=None, min_amount=None, network_interface=None,
                 network_interface_queue_number=None, owner_account=None, owner_id=None, password=None, password_inherit=None, period=None,
                 period_unit=None, private_ip_address=None, ram_role_name=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, security_enhancement_strategy=None, security_group_id=None,
                 security_group_ids=None, spot_duration=None, spot_interruption_behavior=None, spot_price_limit=None,
                 spot_strategy=None, storage_set_id=None, storage_set_partition_number=None, tag=None, tenancy=None,
                 unique_suffix=None, user_data=None, v_switch_id=None, zone_id=None):
        self.cpu_options = cpu_options  # type: CreateWaitingOrderRequestCpuOptions
        self.hibernation_options = hibernation_options  # type: CreateWaitingOrderRequestHibernationOptions
        self.private_pool_options = private_pool_options  # type: CreateWaitingOrderRequestPrivatePoolOptions
        self.scheduler_options = scheduler_options  # type: CreateWaitingOrderRequestSchedulerOptions
        self.security_options = security_options  # type: CreateWaitingOrderRequestSecurityOptions
        self.system_disk = system_disk  # type: CreateWaitingOrderRequestSystemDisk
        self.affinity = affinity  # type: str
        self.arn = arn  # type: list[CreateWaitingOrderRequestArn]
        self.auto_release_time = auto_release_time  # type: str
        self.auto_renew = auto_renew  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.client_token = client_token  # type: str
        self.credit_specification = credit_specification  # type: str
        self.data_disk = data_disk  # type: list[CreateWaitingOrderRequestDataDisk]
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.deletion_protection = deletion_protection  # type: bool
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.deployment_set_id = deployment_set_id  # type: str
        self.description = description  # type: str
        self.dry_run = dry_run  # type: bool
        self.expired_time = expired_time  # type: str
        self.host_name = host_name  # type: str
        self.host_names = host_names  # type: list[str]
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.http_endpoint = http_endpoint  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int
        self.http_tokens = http_tokens  # type: str
        self.image_family = image_family  # type: str
        self.image_id = image_id  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_name = instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.io_optimized = io_optimized  # type: str
        self.ipv_6address = ipv_6address  # type: list[str]
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.isp = isp  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.launch_template_version = launch_template_version  # type: long
        self.max_amount = max_amount  # type: int
        self.min_amount = min_amount  # type: int
        self.network_interface = network_interface  # type: list[CreateWaitingOrderRequestNetworkInterface]
        self.network_interface_queue_number = network_interface_queue_number  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.password = password  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.spot_duration = spot_duration  # type: int
        self.spot_interruption_behavior = spot_interruption_behavior  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_strategy = spot_strategy  # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.tag = tag  # type: list[CreateWaitingOrderRequestTag]
        self.tenancy = tenancy  # type: str
        self.unique_suffix = unique_suffix  # type: bool
        self.user_data = user_data  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.cpu_options:
            self.cpu_options.validate()
        if self.hibernation_options:
            self.hibernation_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.security_options:
            self.security_options.validate()
        if self.system_disk:
            self.system_disk.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateWaitingOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_options is not None:
            result['CpuOptions'] = self.cpu_options.to_map()
        if self.hibernation_options is not None:
            result['HibernationOptions'] = self.hibernation_options.to_map()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.security_options is not None:
            result['SecurityOptions'] = self.security_options.to_map()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.deployment_set_group_no is not None:
            result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_names is not None:
            result['HostNames'] = self.host_names
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_put_response_hop_limit is not None:
            result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.max_amount is not None:
            result['MaxAmount'] = self.max_amount
        if self.min_amount is not None:
            result['MinAmount'] = self.min_amount
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.network_interface_queue_number is not None:
            result['NetworkInterfaceQueueNumber'] = self.network_interface_queue_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.unique_suffix is not None:
            result['UniqueSuffix'] = self.unique_suffix
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuOptions') is not None:
            temp_model = CreateWaitingOrderRequestCpuOptions()
            self.cpu_options = temp_model.from_map(m['CpuOptions'])
        if m.get('HibernationOptions') is not None:
            temp_model = CreateWaitingOrderRequestHibernationOptions()
            self.hibernation_options = temp_model.from_map(m['HibernationOptions'])
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateWaitingOrderRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('SchedulerOptions') is not None:
            temp_model = CreateWaitingOrderRequestSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('SecurityOptions') is not None:
            temp_model = CreateWaitingOrderRequestSecurityOptions()
            self.security_options = temp_model.from_map(m['SecurityOptions'])
        if m.get('SystemDisk') is not None:
            temp_model = CreateWaitingOrderRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateWaitingOrderRequestArn()
                self.arn.append(temp_model.from_map(k))
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateWaitingOrderRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DeploymentSetGroupNo') is not None:
            self.deployment_set_group_no = m.get('DeploymentSetGroupNo')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostNames') is not None:
            self.host_names = m.get('HostNames')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpPutResponseHopLimit') is not None:
            self.http_put_response_hop_limit = m.get('HttpPutResponseHopLimit')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        if m.get('MaxAmount') is not None:
            self.max_amount = m.get('MaxAmount')
        if m.get('MinAmount') is not None:
            self.min_amount = m.get('MinAmount')
        self.network_interface = []
        if m.get('NetworkInterface') is not None:
            for k in m.get('NetworkInterface'):
                temp_model = CreateWaitingOrderRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if m.get('NetworkInterfaceQueueNumber') is not None:
            self.network_interface_queue_number = m.get('NetworkInterfaceQueueNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateWaitingOrderRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('UniqueSuffix') is not None:
            self.unique_suffix = m.get('UniqueSuffix')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateWaitingOrderResponseBody(TeaModel):
    def __init__(self, dry_run_result=None, request_id=None, wait_time_cycle=None, wait_time_value=None,
                 waiting_order_id=None):
        self.dry_run_result = dry_run_result  # type: str
        self.request_id = request_id  # type: str
        self.wait_time_cycle = wait_time_cycle  # type: str
        self.wait_time_value = wait_time_value  # type: int
        self.waiting_order_id = waiting_order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateWaitingOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run_result is not None:
            result['DryRunResult'] = self.dry_run_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.wait_time_cycle is not None:
            result['WaitTimeCycle'] = self.wait_time_cycle
        if self.wait_time_value is not None:
            result['WaitTimeValue'] = self.wait_time_value
        if self.waiting_order_id is not None:
            result['WaitingOrderId'] = self.waiting_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRunResult') is not None:
            self.dry_run_result = m.get('DryRunResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WaitTimeCycle') is not None:
            self.wait_time_cycle = m.get('WaitTimeCycle')
        if m.get('WaitTimeValue') is not None:
            self.wait_time_value = m.get('WaitTimeValue')
        if m.get('WaitingOrderId') is not None:
            self.waiting_order_id = m.get('WaitingOrderId')
        return self


class CreateWaitingOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateWaitingOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateWaitingOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWaitingOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedHostClusterRequest(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDedicatedHostClusterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedHostClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDedicatedHostClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEniQosGroupRequest(TeaModel):
    def __init__(self, owner_id=None, qos_group_name=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        self.qos_group_name = qos_group_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEniQosGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_group_name is not None:
            result['QosGroupName'] = self.qos_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosGroupName') is not None:
            self.qos_group_name = m.get('QosGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteEniQosGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEniQosGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEniQosGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEniQosGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEniQosGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEniQosGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageCacheRequest(TeaModel):
    def __init__(self, client_token=None, image_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, zone_id=None):
        self.client_token = client_token  # type: str
        self.image_id = image_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageCacheRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DeleteImageCacheResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageCacheResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageCacheResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteImageCacheResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteImageCacheResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageCacheResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMigratableInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMigratableInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteMigratableInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMigratableInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMigratableInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMigratableInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMigratableInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMigratableInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInsightsAnalysisRequest(TeaModel):
    def __init__(self, dry_run=None, network_insights_analysis_id=None, region_id=None, resource_owner_id=None):
        self.dry_run = dry_run  # type: bool
        self.network_insights_analysis_id = network_insights_analysis_id  # type: list[str]
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInsightsAnalysisRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.network_insights_analysis_id is not None:
            result['NetworkInsightsAnalysisId'] = self.network_insights_analysis_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NetworkInsightsAnalysisId') is not None:
            self.network_insights_analysis_id = m.get('NetworkInsightsAnalysisId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteNetworkInsightsAnalysisResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInsightsAnalysisResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInsightsAnalysisResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNetworkInsightsAnalysisResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNetworkInsightsAnalysisResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInsightsAnalysisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInsightsPathRequest(TeaModel):
    def __init__(self, dry_run=None, network_insights_path_id=None, region_id=None, resource_owner_id=None):
        self.dry_run = dry_run  # type: bool
        self.network_insights_path_id = network_insights_path_id  # type: list[str]
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInsightsPathRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteNetworkInsightsPathResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInsightsPathResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInsightsPathResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNetworkInsightsPathResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNetworkInsightsPathResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInsightsPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteReservationDemandRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteReservationDemandRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteReservationDemandRequest(TeaModel):
    def __init__(self, demand_id=None, region_id=None, resource_group_id=None, resource_owner_id=None, tag=None):
        self.demand_id = demand_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DeleteReservationDemandRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteReservationDemandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DeleteReservationDemandRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DeleteReservationDemandResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteReservationDemandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteReservationDemandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteReservationDemandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteReservationDemandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteReservationDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, storage_set_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStorageSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        return self


class DeleteStorageSetResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStorageSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStorageSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStorageSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserQuotaApplicationRequest(TeaModel):
    def __init__(self, application_id=None, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.application_id = application_id  # type: str
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserQuotaApplicationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteUserQuotaApplicationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUserQuotaApplicationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserQuotaApplicationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteUserQuotaApplicationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUserQuotaApplicationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserQuotaApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaitingOrdersRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, region_id=None, resource_group_id=None,
                 waiting_order_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: long
        self.waiting_order_id = waiting_order_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWaitingOrdersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.waiting_order_id is not None:
            result['WaitingOrderId'] = self.waiting_order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('WaitingOrderId') is not None:
            self.waiting_order_id = m.get('WaitingOrderId')
        return self


class DeleteWaitingOrdersResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteWaitingOrdersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWaitingOrdersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteWaitingOrdersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteWaitingOrdersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWaitingOrdersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountAttributesRequest(TeaModel):
    def __init__(self, attribute_name=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, zone_id=None):
        self.attribute_name = attribute_name  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountAttributesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(self, count=None, disk_category=None, expired_time=None, instance_charge_type=None,
                 instance_type=None, value=None, zone_id=None):
        self.count = count  # type: int
        self.disk_category = disk_category  # type: str
        self.expired_time = expired_time  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.value = value  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.value is not None:
            result['Value'] = self.value
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(self, value_item=None):
        self.value_item = value_item  # type: list[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem]

    def validate(self):
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.value_item = []
        if m.get('ValueItem') is not None:
            for k in m.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                self.value_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(self, attribute_name=None, attribute_values=None):
        self.attribute_name = attribute_name  # type: str
        self.attribute_values = attribute_values  # type: DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues

    def validate(self):
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(m['AttributeValues'])
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItems(TeaModel):
    def __init__(self, account_attribute_item=None):
        self.account_attribute_item = account_attribute_item  # type: list[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem]

    def validate(self):
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.account_attribute_item = []
        if m.get('AccountAttributeItem') is not None:
            for k in m.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem()
                self.account_attribute_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBody(TeaModel):
    def __init__(self, account_attribute_items=None, request_id=None):
        self.account_attribute_items = account_attribute_items  # type: DescribeAccountAttributesResponseBodyAccountAttributeItems
        self.request_id = request_id  # type: str

    def validate(self):
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(m['AccountAttributeItems'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccountAttributesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountLimitsRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountLimitsRequestFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAccountLimitsRequest(TeaModel):
    def __init__(self, filter=None, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.filter = filter  # type: list[DescribeAccountLimitsRequestFilter]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountLimitsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeAccountLimitsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimitLimitValueSet(TeaModel):
    def __init__(self, limit_value=None):
        self.limit_value = limit_value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimitLimitValueSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit_value is not None:
            result['LimitValue'] = self.limit_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LimitValue') is not None:
            self.limit_value = m.get('LimitValue')
        return self


class DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimit(TeaModel):
    def __init__(self, limit_name=None, limit_value_set=None):
        self.limit_name = limit_name  # type: str
        self.limit_value_set = limit_value_set  # type: DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimitLimitValueSet

    def validate(self):
        if self.limit_value_set:
            self.limit_value_set.validate()

    def to_map(self):
        _map = super(DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimit, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit_name is not None:
            result['LimitName'] = self.limit_name
        if self.limit_value_set is not None:
            result['LimitValueSet'] = self.limit_value_set.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LimitName') is not None:
            self.limit_name = m.get('LimitName')
        if m.get('LimitValueSet') is not None:
            temp_model = DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimitLimitValueSet()
            self.limit_value_set = temp_model.from_map(m['LimitValueSet'])
        return self


class DescribeAccountLimitsResponseBodyAccountLimitTypeSet(TeaModel):
    def __init__(self, account_limit=None):
        self.account_limit = account_limit  # type: list[DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimit]

    def validate(self):
        if self.account_limit:
            for k in self.account_limit:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountLimitsResponseBodyAccountLimitTypeSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountLimit'] = []
        if self.account_limit is not None:
            for k in self.account_limit:
                result['AccountLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.account_limit = []
        if m.get('AccountLimit') is not None:
            for k in m.get('AccountLimit'):
                temp_model = DescribeAccountLimitsResponseBodyAccountLimitTypeSetAccountLimit()
                self.account_limit.append(temp_model.from_map(k))
        return self


class DescribeAccountLimitsResponseBody(TeaModel):
    def __init__(self, account_limit_type_set=None, request_id=None):
        self.account_limit_type_set = account_limit_type_set  # type: DescribeAccountLimitsResponseBodyAccountLimitTypeSet
        self.request_id = request_id  # type: str

    def validate(self):
        if self.account_limit_type_set:
            self.account_limit_type_set.validate()

    def to_map(self):
        _map = super(DescribeAccountLimitsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_limit_type_set is not None:
            result['AccountLimitTypeSet'] = self.account_limit_type_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountLimitTypeSet') is not None:
            temp_model = DescribeAccountLimitsResponseBodyAccountLimitTypeSet()
            self.account_limit_type_set = temp_model.from_map(m['AccountLimitTypeSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccountLimitsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccountLimitsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccountLimitsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountLimitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountQuotaAttributesRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountQuotaAttributesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAccountQuotaAttributesResponseBodyQuotaAttributes(TeaModel):
    def __init__(self, ecs_elastic_quota_enable=None):
        self.ecs_elastic_quota_enable = ecs_elastic_quota_enable  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountQuotaAttributesResponseBodyQuotaAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_elastic_quota_enable is not None:
            result['EcsElasticQuotaEnable'] = self.ecs_elastic_quota_enable
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EcsElasticQuotaEnable') is not None:
            self.ecs_elastic_quota_enable = m.get('EcsElasticQuotaEnable')
        return self


class DescribeAccountQuotaAttributesResponseBody(TeaModel):
    def __init__(self, quota_attributes=None, request_id=None):
        self.quota_attributes = quota_attributes  # type: DescribeAccountQuotaAttributesResponseBodyQuotaAttributes
        self.request_id = request_id  # type: str

    def validate(self):
        if self.quota_attributes:
            self.quota_attributes.validate()

    def to_map(self):
        _map = super(DescribeAccountQuotaAttributesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_attributes is not None:
            result['QuotaAttributes'] = self.quota_attributes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaAttributes') is not None:
            temp_model = DescribeAccountQuotaAttributesResponseBodyQuotaAttributes()
            self.quota_attributes = temp_model.from_map(m['QuotaAttributes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccountQuotaAttributesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccountQuotaAttributesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccountQuotaAttributesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountQuotaAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupCapacitiesRequest(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupCapacitiesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacitiesCapacity(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, pay_as_you_go_capacity=None, spot_capacity=None,
                 total_capacity=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.pay_as_you_go_capacity = pay_as_you_go_capacity  # type: str
        self.spot_capacity = spot_capacity  # type: str
        self.total_capacity = total_capacity  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacitiesCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.pay_as_you_go_capacity is not None:
            result['PayAsYouGoCapacity'] = self.pay_as_you_go_capacity
        if self.spot_capacity is not None:
            result['SpotCapacity'] = self.spot_capacity
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('PayAsYouGoCapacity') is not None:
            self.pay_as_you_go_capacity = m.get('PayAsYouGoCapacity')
        if m.get('SpotCapacity') is not None:
            self.spot_capacity = m.get('SpotCapacity')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        return self


class DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacities(TeaModel):
    def __init__(self, capacity=None):
        self.capacity = capacity  # type: list[DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacitiesCapacity]

    def validate(self):
        if self.capacity:
            for k in self.capacity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Capacity'] = []
        if self.capacity is not None:
            for k in self.capacity:
                result['Capacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.capacity = []
        if m.get('Capacity') is not None:
            for k in m.get('Capacity'):
                temp_model = DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacitiesCapacity()
                self.capacity.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupCapacitiesResponseBody(TeaModel):
    def __init__(self, capacities=None, code=None, message=None, request_id=None, success=None):
        self.capacities = capacities  # type: DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacities
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.capacities:
            self.capacities.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupCapacitiesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacities is not None:
            result['Capacities'] = self.capacities.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Capacities') is not None:
            temp_model = DescribeAutoProvisioningGroupCapacitiesResponseBodyCapacities()
            self.capacities = temp_model.from_map(m['Capacities'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAutoProvisioningGroupCapacitiesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoProvisioningGroupCapacitiesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupCapacitiesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupCapacitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwidthPriceRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, price_unit=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, verbose=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.price_unit = price_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.verbose = verbose  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthPriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.price_unit is not None:
            result['PriceUnit'] = self.price_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.verbose is not None:
            result['Verbose'] = self.verbose
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PriceUnit') is not None:
            self.price_unit = m.get('PriceUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Verbose') is not None:
            self.verbose = m.get('Verbose')
        return self


class DescribeBandwidthPriceResponseBodyPriceInfoOrderRuleIdSet(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBodyPriceInfoOrderRuleIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeBandwidthPriceResponseBodyPriceInfoOrder(TeaModel):
    def __init__(self, currency=None, discount_price=None, original_price=None, rule_id_set=None, trade_price=None):
        self.currency = currency  # type: str
        self.discount_price = discount_price  # type: float
        self.original_price = original_price  # type: float
        self.rule_id_set = rule_id_set  # type: DescribeBandwidthPriceResponseBodyPriceInfoOrderRuleIdSet
        self.trade_price = trade_price  # type: float

    def validate(self):
        if self.rule_id_set:
            self.rule_id_set.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBodyPriceInfoOrder, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.rule_id_set is not None:
            result['RuleIdSet'] = self.rule_id_set.to_map()
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('RuleIdSet') is not None:
            temp_model = DescribeBandwidthPriceResponseBodyPriceInfoOrderRuleIdSet()
            self.rule_id_set = temp_model.from_map(m['RuleIdSet'])
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribeBandwidthPriceResponseBodyPriceInfoRulesRule(TeaModel):
    def __init__(self, name=None, rule_id=None, title=None):
        self.name = name  # type: str
        self.rule_id = rule_id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBodyPriceInfoRulesRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeBandwidthPriceResponseBodyPriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule  # type: list[DescribeBandwidthPriceResponseBodyPriceInfoRulesRule]

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBodyPriceInfoRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribeBandwidthPriceResponseBodyPriceInfoRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribeBandwidthPriceResponseBodyPriceInfo(TeaModel):
    def __init__(self, order=None, rules=None):
        self.order = order  # type: DescribeBandwidthPriceResponseBodyPriceInfoOrder
        self.rules = rules  # type: DescribeBandwidthPriceResponseBodyPriceInfoRules

    def validate(self):
        if self.order:
            self.order.validate()
        if self.rules:
            self.rules.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBodyPriceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribeBandwidthPriceResponseBodyPriceInfoOrder()
            self.order = temp_model.from_map(m['Order'])
        if m.get('Rules') is not None:
            temp_model = DescribeBandwidthPriceResponseBodyPriceInfoRules()
            self.rules = temp_model.from_map(m['Rules'])
        return self


class DescribeBandwidthPriceResponseBody(TeaModel):
    def __init__(self, price_info=None, request_id=None):
        self.price_info = price_info  # type: DescribeBandwidthPriceResponseBodyPriceInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribeBandwidthPriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBandwidthPriceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBandwidthPriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBandwidthPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCapacityReservationsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCapacityReservationsRequest(TeaModel):
    def __init__(self, capacity_reservation_ids=None, capacity_reservation_name=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, status=None, tag=None, zone_id=None):
        self.capacity_reservation_ids = capacity_reservation_ids  # type: str
        self.capacity_reservation_name = capacity_reservation_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeCapacityReservationsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservation_ids is not None:
            result['CapacityReservationIds'] = self.capacity_reservation_ids
        if self.capacity_reservation_name is not None:
            result['CapacityReservationName'] = self.capacity_reservation_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservationIds') is not None:
            self.capacity_reservation_ids = m.get('CapacityReservationIds')
        if m.get('CapacityReservationName') is not None:
            self.capacity_reservation_name = m.get('CapacityReservationName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCapacityReservationsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationsCapacityReservation(TeaModel):
    def __init__(self, available_instance_count=None, capacity_reservation_id=None,
                 capacity_reservation_name=None, description=None, end_date_type=None, instance_match_criteria=None, instance_platform=None,
                 instance_type=None, network_type=None, region_id=None, status=None, time_slot=None, total_instance_count=None,
                 zone_id=None):
        self.available_instance_count = available_instance_count  # type: int
        self.capacity_reservation_id = capacity_reservation_id  # type: str
        self.capacity_reservation_name = capacity_reservation_name  # type: str
        self.description = description  # type: str
        self.end_date_type = end_date_type  # type: str
        self.instance_match_criteria = instance_match_criteria  # type: str
        self.instance_platform = instance_platform  # type: str
        self.instance_type = instance_type  # type: str
        self.network_type = network_type  # type: str
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.time_slot = time_slot  # type: str
        self.total_instance_count = total_instance_count  # type: int
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationsCapacityReservation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_instance_count is not None:
            result['AvailableInstanceCount'] = self.available_instance_count
        if self.capacity_reservation_id is not None:
            result['CapacityReservationId'] = self.capacity_reservation_id
        if self.capacity_reservation_name is not None:
            result['CapacityReservationName'] = self.capacity_reservation_name
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date_type is not None:
            result['EndDateType'] = self.end_date_type
        if self.instance_match_criteria is not None:
            result['InstanceMatchCriteria'] = self.instance_match_criteria
        if self.instance_platform is not None:
            result['InstancePlatform'] = self.instance_platform
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time_slot is not None:
            result['TimeSlot'] = self.time_slot
        if self.total_instance_count is not None:
            result['TotalInstanceCount'] = self.total_instance_count
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableInstanceCount') is not None:
            self.available_instance_count = m.get('AvailableInstanceCount')
        if m.get('CapacityReservationId') is not None:
            self.capacity_reservation_id = m.get('CapacityReservationId')
        if m.get('CapacityReservationName') is not None:
            self.capacity_reservation_name = m.get('CapacityReservationName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDateType') is not None:
            self.end_date_type = m.get('EndDateType')
        if m.get('InstanceMatchCriteria') is not None:
            self.instance_match_criteria = m.get('InstanceMatchCriteria')
        if m.get('InstancePlatform') is not None:
            self.instance_platform = m.get('InstancePlatform')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimeSlot') is not None:
            self.time_slot = m.get('TimeSlot')
        if m.get('TotalInstanceCount') is not None:
            self.total_instance_count = m.get('TotalInstanceCount')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservations(TeaModel):
    def __init__(self, capacity_reservation=None):
        self.capacity_reservation = capacity_reservation  # type: list[DescribeCapacityReservationsResponseBodyCapacityReservationsCapacityReservation]

    def validate(self):
        if self.capacity_reservation:
            for k in self.capacity_reservation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CapacityReservation'] = []
        if self.capacity_reservation is not None:
            for k in self.capacity_reservation:
                result['CapacityReservation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.capacity_reservation = []
        if m.get('CapacityReservation') is not None:
            for k in m.get('CapacityReservation'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationsCapacityReservation()
                self.capacity_reservation.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBody(TeaModel):
    def __init__(self, capacity_reservations=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.capacity_reservations = capacity_reservations  # type: DescribeCapacityReservationsResponseBodyCapacityReservations
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.capacity_reservations:
            self.capacity_reservations.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservations is not None:
            result['CapacityReservations'] = self.capacity_reservations.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservations') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservations()
            self.capacity_reservations = temp_model.from_map(m['CapacityReservations'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCapacityReservationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCapacityReservationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCapacityReservationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomerIssueCategoryRequest(TeaModel):
    def __init__(self, layer=None, region_id=None):
        self.layer = layer  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomerIssueCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomerIssueCategoryResponseBodyIssueCategoryModelList(TeaModel):
    def __init__(self, issue_category_id=None, issue_category_name=None, issue_category_parent_id=None, layer=None,
                 mapping_tools=None, metric_set_id=None, resource_type=None):
        self.issue_category_id = issue_category_id  # type: long
        self.issue_category_name = issue_category_name  # type: str
        self.issue_category_parent_id = issue_category_parent_id  # type: long
        self.layer = layer  # type: long
        self.mapping_tools = mapping_tools  # type: str
        self.metric_set_id = metric_set_id  # type: str
        self.resource_type = resource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomerIssueCategoryResponseBodyIssueCategoryModelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.issue_category_id is not None:
            result['IssueCategoryId'] = self.issue_category_id
        if self.issue_category_name is not None:
            result['IssueCategoryName'] = self.issue_category_name
        if self.issue_category_parent_id is not None:
            result['IssueCategoryParentId'] = self.issue_category_parent_id
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.mapping_tools is not None:
            result['MappingTools'] = self.mapping_tools
        if self.metric_set_id is not None:
            result['MetricSetId'] = self.metric_set_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IssueCategoryId') is not None:
            self.issue_category_id = m.get('IssueCategoryId')
        if m.get('IssueCategoryName') is not None:
            self.issue_category_name = m.get('IssueCategoryName')
        if m.get('IssueCategoryParentId') is not None:
            self.issue_category_parent_id = m.get('IssueCategoryParentId')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('MappingTools') is not None:
            self.mapping_tools = m.get('MappingTools')
        if m.get('MetricSetId') is not None:
            self.metric_set_id = m.get('MetricSetId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribeCustomerIssueCategoryResponseBody(TeaModel):
    def __init__(self, issue_category_model_list=None, request_id=None):
        self.issue_category_model_list = issue_category_model_list  # type: list[DescribeCustomerIssueCategoryResponseBodyIssueCategoryModelList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.issue_category_model_list:
            for k in self.issue_category_model_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomerIssueCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IssueCategoryModelList'] = []
        if self.issue_category_model_list is not None:
            for k in self.issue_category_model_list:
                result['IssueCategoryModelList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.issue_category_model_list = []
        if m.get('IssueCategoryModelList') is not None:
            for k in m.get('IssueCategoryModelList'):
                temp_model = DescribeCustomerIssueCategoryResponseBodyIssueCategoryModelList()
                self.issue_category_model_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomerIssueCategoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomerIssueCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomerIssueCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomerIssueCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(self, instance_ids=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, resource_type=None):
        self.instance_ids = instance_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributesInstanceRenewAttribute(TeaModel):
    def __init__(self, auto_renew_enabled=None, duration=None, instance_id=None, period_unit=None,
                 renewal_status=None):
        self.auto_renew_enabled = auto_renew_enabled  # type: bool
        self.duration = duration  # type: int
        self.instance_id = instance_id  # type: str
        self.period_unit = period_unit  # type: str
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributesInstanceRenewAttribute, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew_enabled is not None:
            result['AutoRenewEnabled'] = self.auto_renew_enabled
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRenewEnabled') is not None:
            self.auto_renew_enabled = m.get('AutoRenewEnabled')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributes(TeaModel):
    def __init__(self, instance_renew_attribute=None):
        self.instance_renew_attribute = instance_renew_attribute  # type: list[DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributesInstanceRenewAttribute]

    def validate(self):
        if self.instance_renew_attribute:
            for k in self.instance_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceRenewAttribute'] = []
        if self.instance_renew_attribute is not None:
            for k in self.instance_renew_attribute:
                result['InstanceRenewAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_renew_attribute = []
        if m.get('InstanceRenewAttribute') is not None:
            for k in m.get('InstanceRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributesInstanceRenewAttribute()
                self.instance_renew_attribute.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostAutoRenewResponseBody(TeaModel):
    def __init__(self, instance_renew_attributes=None, request_id=None):
        self.instance_renew_attributes = instance_renew_attributes  # type: DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributes
        self.request_id = request_id  # type: str

    def validate(self):
        if self.instance_renew_attributes:
            self.instance_renew_attributes.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_renew_attributes is not None:
            result['InstanceRenewAttributes'] = self.instance_renew_attributes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBodyInstanceRenewAttributes()
            self.instance_renew_attributes = temp_model.from_map(m['InstanceRenewAttributes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedHostAutoRenewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostClustersRequestSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersRequestSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class DescribeDedicatedHostClustersRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDedicatedHostClustersRequest(TeaModel):
    def __init__(self, scheduler_options=None, dedicated_host_cluster_ids=None, dedicated_host_cluster_name=None,
                 lock_reason=None, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, status=None, tag=None, zone_id=None):
        self.scheduler_options = scheduler_options  # type: DescribeDedicatedHostClustersRequestSchedulerOptions
        self.dedicated_host_cluster_ids = dedicated_host_cluster_ids  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.lock_reason = lock_reason  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeDedicatedHostClustersRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.dedicated_host_cluster_ids is not None:
            result['DedicatedHostClusterIds'] = self.dedicated_host_cluster_ids
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerOptions') is not None:
            temp_model = DescribeDedicatedHostClustersRequestSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('DedicatedHostClusterIds') is not None:
            self.dedicated_host_cluster_ids = m.get('DedicatedHostClusterIds')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType(TeaModel):
    def __init__(self, available_instance_capacity=None, instance_type=None):
        self.available_instance_capacity = available_instance_capacity  # type: int
        self.instance_type = instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_instance_capacity is not None:
            result['AvailableInstanceCapacity'] = self.available_instance_capacity
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableInstanceCapacity') is not None:
            self.available_instance_capacity = m.get('AvailableInstanceCapacity')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes(TeaModel):
    def __init__(self, available_instance_type=None):
        self.available_instance_type = available_instance_type  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType]

    def validate(self):
        if self.available_instance_type:
            for k in self.available_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableInstanceType'] = []
        if self.available_instance_type is not None:
            for k in self.available_instance_type:
                result['AvailableInstanceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.available_instance_type = []
        if m.get('AvailableInstanceType') is not None:
            for k in m.get('AvailableInstanceType'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType()
                self.available_instance_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity(TeaModel):
    def __init__(self, available_disk=None, data_disk_category=None, total_disk=None):
        self.available_disk = available_disk  # type: int
        self.data_disk_category = data_disk_category  # type: str
        self.total_disk = total_disk  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_disk is not None:
            result['AvailableDisk'] = self.available_disk
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.total_disk is not None:
            result['TotalDisk'] = self.total_disk
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableDisk') is not None:
            self.available_disk = m.get('AvailableDisk')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('TotalDisk') is not None:
            self.total_disk = m.get('TotalDisk')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities(TeaModel):
    def __init__(self, local_storage_capacity=None):
        self.local_storage_capacity = local_storage_capacity  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity]

    def validate(self):
        if self.local_storage_capacity:
            for k in self.local_storage_capacity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LocalStorageCapacity'] = []
        if self.local_storage_capacity is not None:
            for k in self.local_storage_capacity:
                result['LocalStorageCapacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.local_storage_capacity = []
        if m.get('LocalStorageCapacity') is not None:
            for k in m.get('LocalStorageCapacity'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity()
                self.local_storage_capacity.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity(TeaModel):
    def __init__(self, available_instance_types=None, available_memory=None, available_vcpus=None,
                 local_storage_capacities=None, total_memory=None, total_vcpus=None):
        self.available_instance_types = available_instance_types  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes
        self.available_memory = available_memory  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.local_storage_capacities = local_storage_capacities  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities
        self.total_memory = total_memory  # type: int
        self.total_vcpus = total_vcpus  # type: int

    def validate(self):
        if self.available_instance_types:
            self.available_instance_types.validate()
        if self.local_storage_capacities:
            self.local_storage_capacities.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_instance_types is not None:
            result['AvailableInstanceTypes'] = self.available_instance_types.to_map()
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.local_storage_capacities is not None:
            result['LocalStorageCapacities'] = self.local_storage_capacities.to_map()
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableInstanceTypes') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes()
            self.available_instance_types = temp_model.from_map(m['AvailableInstanceTypes'])
        if m.get('AvailableMemory') is not None:
            self.available_memory = m.get('AvailableMemory')
        if m.get('AvailableVcpus') is not None:
            self.available_vcpus = m.get('AvailableVcpus')
        if m.get('LocalStorageCapacities') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities()
            self.local_storage_capacities = temp_model.from_map(m['LocalStorageCapacities'])
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster(TeaModel):
    def __init__(self, scheduler_options=None, dedicated_host_cluster_capacity=None,
                 dedicated_host_cluster_id=None, dedicated_host_cluster_name=None, dedicated_host_ids=None, description=None, region_id=None,
                 resource_group_id=None, tags=None, zone_id=None):
        self.scheduler_options = scheduler_options  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterSchedulerOptions
        self.dedicated_host_cluster_capacity = dedicated_host_cluster_capacity  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.dedicated_host_ids = dedicated_host_ids  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds
        self.description = description  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags
        self.zone_id = zone_id  # type: str

    def validate(self):
        self.validate_required(self.scheduler_options, 'scheduler_options')
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.dedicated_host_cluster_capacity:
            self.dedicated_host_cluster_capacity.validate()
        if self.dedicated_host_ids:
            self.dedicated_host_ids.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.dedicated_host_cluster_capacity is not None:
            result['DedicatedHostClusterCapacity'] = self.dedicated_host_cluster_capacity.to_map()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerOptions') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('DedicatedHostClusterCapacity') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity()
            self.dedicated_host_cluster_capacity = temp_model.from_map(m['DedicatedHostClusterCapacity'])
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('DedicatedHostIds') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds()
            self.dedicated_host_ids = temp_model.from_map(m['DedicatedHostIds'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Tags') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters(TeaModel):
    def __init__(self, dedicated_host_cluster=None):
        self.dedicated_host_cluster = dedicated_host_cluster  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster]

    def validate(self):
        if self.dedicated_host_cluster:
            for k in self.dedicated_host_cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostCluster'] = []
        if self.dedicated_host_cluster is not None:
            for k in self.dedicated_host_cluster:
                result['DedicatedHostCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dedicated_host_cluster = []
        if m.get('DedicatedHostCluster') is not None:
            for k in m.get('DedicatedHostCluster'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster()
                self.dedicated_host_cluster.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBody(TeaModel):
    def __init__(self, dedicated_host_clusters=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.dedicated_host_clusters = dedicated_host_clusters  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.dedicated_host_clusters:
            self.dedicated_host_clusters.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_clusters is not None:
            result['DedicatedHostClusters'] = self.dedicated_host_clusters.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusters') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClusters()
            self.dedicated_host_clusters = temp_model.from_map(m['DedicatedHostClusters'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDedicatedHostClustersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedHostClustersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostTypesRequest(TeaModel):
    def __init__(self, dedicated_host_type=None, generation=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, support_instance_type_family=None):
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.generation = generation  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.support_instance_type_family = support_instance_type_family  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.generation is not None:
            result['Generation'] = self.generation
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.support_instance_type_family is not None:
            result['SupportInstanceTypeFamily'] = self.support_instance_type_family
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('Generation') is not None:
            self.generation = m.get('Generation')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SupportInstanceTypeFamily') is not None:
            self.support_instance_type_family = m.get('SupportInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypeFamilies(TeaModel):
    def __init__(self, support_instance_type_family=None):
        self.support_instance_type_family = support_instance_type_family  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypeFamilies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_instance_type_family is not None:
            result['SupportInstanceTypeFamily'] = self.support_instance_type_family
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportInstanceTypeFamily') is not None:
            self.support_instance_type_family = m.get('SupportInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypesList(TeaModel):
    def __init__(self, support_instance_types_list=None):
        self.support_instance_types_list = support_instance_types_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypesList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_instance_types_list is not None:
            result['SupportInstanceTypesList'] = self.support_instance_types_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportInstanceTypesList') is not None:
            self.support_instance_types_list = m.get('SupportInstanceTypesList')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType(TeaModel):
    def __init__(self, cpu_over_commit_ratio_range=None, dedicated_host_type=None, gpuspec=None, generation=None,
                 local_storage_amount=None, local_storage_capacity=None, local_storage_category=None, memory_size=None,
                 physical_gpus=None, support_cpu_over_commit_ratio=None, support_instance_type_families=None,
                 support_instance_types_list=None, total_physical_cores=None, total_sockets=None, total_vcpus=None, total_vgpus=None):
        self.cpu_over_commit_ratio_range = cpu_over_commit_ratio_range  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.gpuspec = gpuspec  # type: str
        self.generation = generation  # type: str
        self.local_storage_amount = local_storage_amount  # type: int
        self.local_storage_capacity = local_storage_capacity  # type: long
        self.local_storage_category = local_storage_category  # type: str
        self.memory_size = memory_size  # type: float
        self.physical_gpus = physical_gpus  # type: int
        self.support_cpu_over_commit_ratio = support_cpu_over_commit_ratio  # type: bool
        self.support_instance_type_families = support_instance_type_families  # type: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypeFamilies
        self.support_instance_types_list = support_instance_types_list  # type: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypesList
        self.total_physical_cores = total_physical_cores  # type: int
        self.total_sockets = total_sockets  # type: int
        self.total_vcpus = total_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int

    def validate(self):
        if self.support_instance_type_families:
            self.support_instance_type_families.validate()
        if self.support_instance_types_list:
            self.support_instance_types_list.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_over_commit_ratio_range is not None:
            result['CpuOverCommitRatioRange'] = self.cpu_over_commit_ratio_range
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.generation is not None:
            result['Generation'] = self.generation
        if self.local_storage_amount is not None:
            result['LocalStorageAmount'] = self.local_storage_amount
        if self.local_storage_capacity is not None:
            result['LocalStorageCapacity'] = self.local_storage_capacity
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.support_cpu_over_commit_ratio is not None:
            result['SupportCpuOverCommitRatio'] = self.support_cpu_over_commit_ratio
        if self.support_instance_type_families is not None:
            result['SupportInstanceTypeFamilies'] = self.support_instance_type_families.to_map()
        if self.support_instance_types_list is not None:
            result['SupportInstanceTypesList'] = self.support_instance_types_list.to_map()
        if self.total_physical_cores is not None:
            result['TotalPhysicalCores'] = self.total_physical_cores
        if self.total_sockets is not None:
            result['TotalSockets'] = self.total_sockets
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuOverCommitRatioRange') is not None:
            self.cpu_over_commit_ratio_range = m.get('CpuOverCommitRatioRange')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('GPUSpec') is not None:
            self.gpuspec = m.get('GPUSpec')
        if m.get('Generation') is not None:
            self.generation = m.get('Generation')
        if m.get('LocalStorageAmount') is not None:
            self.local_storage_amount = m.get('LocalStorageAmount')
        if m.get('LocalStorageCapacity') is not None:
            self.local_storage_capacity = m.get('LocalStorageCapacity')
        if m.get('LocalStorageCategory') is not None:
            self.local_storage_category = m.get('LocalStorageCategory')
        if m.get('MemorySize') is not None:
            self.memory_size = m.get('MemorySize')
        if m.get('PhysicalGpus') is not None:
            self.physical_gpus = m.get('PhysicalGpus')
        if m.get('SupportCpuOverCommitRatio') is not None:
            self.support_cpu_over_commit_ratio = m.get('SupportCpuOverCommitRatio')
        if m.get('SupportInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypeFamilies()
            self.support_instance_type_families = temp_model.from_map(m['SupportInstanceTypeFamilies'])
        if m.get('SupportInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostTypeSupportInstanceTypesList()
            self.support_instance_types_list = temp_model.from_map(m['SupportInstanceTypesList'])
        if m.get('TotalPhysicalCores') is not None:
            self.total_physical_cores = m.get('TotalPhysicalCores')
        if m.get('TotalSockets') is not None:
            self.total_sockets = m.get('TotalSockets')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        if m.get('TotalVgpus') is not None:
            self.total_vgpus = m.get('TotalVgpus')
        return self


class DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes(TeaModel):
    def __init__(self, dedicated_host_type=None):
        self.dedicated_host_type = dedicated_host_type  # type: list[DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType]

    def validate(self):
        if self.dedicated_host_type:
            for k in self.dedicated_host_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostType'] = []
        if self.dedicated_host_type is not None:
            for k in self.dedicated_host_type:
                result['DedicatedHostType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dedicated_host_type = []
        if m.get('DedicatedHostType') is not None:
            for k in m.get('DedicatedHostType'):
                temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypesDedicatedHostType()
                self.dedicated_host_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostTypesResponseBody(TeaModel):
    def __init__(self, dedicated_host_types=None, request_id=None):
        self.dedicated_host_types = dedicated_host_types  # type: DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dedicated_host_types:
            self.dedicated_host_types.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_types is not None:
            result['DedicatedHostTypes'] = self.dedicated_host_types.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostTypes') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBodyDedicatedHostTypes()
            self.dedicated_host_types = temp_model.from_map(m['DedicatedHostTypes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDedicatedHostTypesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedHostTypesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostTypesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostsRequestSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsRequestSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class DescribeDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(self, scheduler_options=None, dedicated_host_cluster_id=None, dedicated_host_ids=None,
                 dedicated_host_name=None, dedicated_host_type=None, lock_reason=None, owner_account=None, owner_id=None,
                 page_number=None, page_size=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, status=None, tag=None, zone_id=None):
        self.scheduler_options = scheduler_options  # type: DescribeDedicatedHostsRequestSchedulerOptions
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.lock_reason = lock_reason  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeDedicatedHostsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerOptions') is not None:
            temp_model = DescribeDedicatedHostsRequestSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = m.get('DedicatedHostIds')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSchedulerOptions(TeaModel):
    def __init__(self, managed_private_space_id=None):
        self.managed_private_space_id = managed_private_space_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSchedulerOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity(TeaModel):
    def __init__(self, available_local_storage=None, available_memory=None, available_vcpus=None,
                 available_vgpus=None, local_storage_category=None, total_local_storage=None, total_memory=None, total_vcpus=None,
                 total_vgpus=None):
        self.available_local_storage = available_local_storage  # type: int
        self.available_memory = available_memory  # type: float
        self.available_vcpus = available_vcpus  # type: int
        self.available_vgpus = available_vgpus  # type: int
        self.local_storage_category = local_storage_category  # type: str
        self.total_local_storage = total_local_storage  # type: int
        self.total_memory = total_memory  # type: float
        self.total_vcpus = total_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_local_storage is not None:
            result['AvailableLocalStorage'] = self.available_local_storage
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.available_vgpus is not None:
            result['AvailableVgpus'] = self.available_vgpus
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        if self.total_local_storage is not None:
            result['TotalLocalStorage'] = self.total_local_storage
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableLocalStorage') is not None:
            self.available_local_storage = m.get('AvailableLocalStorage')
        if m.get('AvailableMemory') is not None:
            self.available_memory = m.get('AvailableMemory')
        if m.get('AvailableVcpus') is not None:
            self.available_vcpus = m.get('AvailableVcpus')
        if m.get('AvailableVgpus') is not None:
            self.available_vgpus = m.get('AvailableVgpus')
        if m.get('LocalStorageCategory') is not None:
            self.local_storage_category = m.get('LocalStorageCategory')
        if m.get('TotalLocalStorage') is not None:
            self.total_local_storage = m.get('TotalLocalStorage')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        if m.get('TotalVgpus') is not None:
            self.total_vgpus = m.get('TotalVgpus')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo(TeaModel):
    def __init__(self, serial_number=None):
        self.serial_number = serial_number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, instance_type=None):
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance  # type: list[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance]

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = m.get('SlbUdpTimeout')
        if m.get('UdpTimeout') is not None:
            self.udp_timeout = m.get('UdpTimeout')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: list[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock]

    def validate(self):
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.operation_lock = []
        if m.get('OperationLock') is not None:
            for k in m.get('OperationLock'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypeFamilies(TeaModel):
    def __init__(self, support_instance_type_family=None):
        self.support_instance_type_family = support_instance_type_family  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypeFamilies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_instance_type_family is not None:
            result['SupportInstanceTypeFamily'] = self.support_instance_type_family
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportInstanceTypeFamily') is not None:
            self.support_instance_type_family = m.get('SupportInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypesList(TeaModel):
    def __init__(self, support_instance_types_list=None):
        self.support_instance_types_list = support_instance_types_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypesList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_instance_types_list is not None:
            result['SupportInstanceTypesList'] = self.support_instance_types_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportInstanceTypesList') is not None:
            self.support_instance_types_list = m.get('SupportInstanceTypesList')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_custom_instance_type_family=None):
        self.supported_custom_instance_type_family = supported_custom_instance_type_family  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_custom_instance_type_family is not None:
            result['SupportedCustomInstanceTypeFamily'] = self.supported_custom_instance_type_family
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportedCustomInstanceTypeFamily') is not None:
            self.supported_custom_instance_type_family = m.get('SupportedCustomInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost(TeaModel):
    def __init__(self, scheduler_options=None, action_on_maintenance=None, auto_placement=None,
                 auto_release_time=None, capacity=None, charge_type=None, cpu_over_commit_ratio=None, creation_time=None,
                 dedicated_host_cluster_id=None, dedicated_host_id=None, dedicated_host_name=None, dedicated_host_type=None,
                 description=None, expired_time=None, gpuspec=None, host_detail_info=None, instances=None, machine_id=None,
                 network_attributes=None, operation_locks=None, physical_gpus=None, region_id=None, resource_group_id=None,
                 sale_cycle=None, status=None, support_instance_type_families=None, support_instance_types_list=None,
                 supported_custom_instance_type_families=None, tags=None, total_physical_cores=None, total_sockets=None, zone_id=None):
        self.scheduler_options = scheduler_options  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSchedulerOptions
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.auto_placement = auto_placement  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.capacity = capacity  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity
        self.charge_type = charge_type  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.creation_time = creation_time  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.description = description  # type: str
        self.expired_time = expired_time  # type: str
        self.gpuspec = gpuspec  # type: str
        self.host_detail_info = host_detail_info  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo
        self.instances = instances  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances
        self.machine_id = machine_id  # type: str
        self.network_attributes = network_attributes  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes
        self.operation_locks = operation_locks  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks
        self.physical_gpus = physical_gpus  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.sale_cycle = sale_cycle  # type: str
        self.status = status  # type: str
        self.support_instance_type_families = support_instance_type_families  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypeFamilies
        self.support_instance_types_list = support_instance_types_list  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypesList
        self.supported_custom_instance_type_families = supported_custom_instance_type_families  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies
        self.tags = tags  # type: DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags
        self.total_physical_cores = total_physical_cores  # type: int
        self.total_sockets = total_sockets  # type: int
        self.zone_id = zone_id  # type: str

    def validate(self):
        self.validate_required(self.scheduler_options, 'scheduler_options')
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.capacity:
            self.capacity.validate()
        if self.host_detail_info:
            self.host_detail_info.validate()
        if self.instances:
            self.instances.validate()
        if self.network_attributes:
            self.network_attributes.validate()
        if self.operation_locks:
            self.operation_locks.validate()
        if self.support_instance_type_families:
            self.support_instance_type_families.validate()
        if self.support_instance_types_list:
            self.support_instance_types_list.validate()
        if self.supported_custom_instance_type_families:
            self.supported_custom_instance_type_families.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.capacity is not None:
            result['Capacity'] = self.capacity.to_map()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.host_detail_info is not None:
            result['HostDetailInfo'] = self.host_detail_info.to_map()
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.machine_id is not None:
            result['MachineId'] = self.machine_id
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sale_cycle is not None:
            result['SaleCycle'] = self.sale_cycle
        if self.status is not None:
            result['Status'] = self.status
        if self.support_instance_type_families is not None:
            result['SupportInstanceTypeFamilies'] = self.support_instance_type_families.to_map()
        if self.support_instance_types_list is not None:
            result['SupportInstanceTypesList'] = self.support_instance_types_list.to_map()
        if self.supported_custom_instance_type_families is not None:
            result['SupportedCustomInstanceTypeFamilies'] = self.supported_custom_instance_type_families.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.total_physical_cores is not None:
            result['TotalPhysicalCores'] = self.total_physical_cores
        if self.total_sockets is not None:
            result['TotalSockets'] = self.total_sockets
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SchedulerOptions') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = m.get('ActionOnMaintenance')
        if m.get('AutoPlacement') is not None:
            self.auto_placement = m.get('AutoPlacement')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('Capacity') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostCapacity()
            self.capacity = temp_model.from_map(m['Capacity'])
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = m.get('CpuOverCommitRatio')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('GPUSpec') is not None:
            self.gpuspec = m.get('GPUSpec')
        if m.get('HostDetailInfo') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostHostDetailInfo()
            self.host_detail_info = temp_model.from_map(m['HostDetailInfo'])
        if m.get('Instances') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('MachineId') is not None:
            self.machine_id = m.get('MachineId')
        if m.get('NetworkAttributes') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('OperationLocks') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('PhysicalGpus') is not None:
            self.physical_gpus = m.get('PhysicalGpus')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SaleCycle') is not None:
            self.sale_cycle = m.get('SaleCycle')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypeFamilies()
            self.support_instance_type_families = temp_model.from_map(m['SupportInstanceTypeFamilies'])
        if m.get('SupportInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportInstanceTypesList()
            self.support_instance_types_list = temp_model.from_map(m['SupportInstanceTypesList'])
        if m.get('SupportedCustomInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies()
            self.supported_custom_instance_type_families = temp_model.from_map(m['SupportedCustomInstanceTypeFamilies'])
        if m.get('Tags') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHostTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TotalPhysicalCores') is not None:
            self.total_physical_cores = m.get('TotalPhysicalCores')
        if m.get('TotalSockets') is not None:
            self.total_sockets = m.get('TotalSockets')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedHostsResponseBodyDedicatedHosts(TeaModel):
    def __init__(self, dedicated_host=None):
        self.dedicated_host = dedicated_host  # type: list[DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost]

    def validate(self):
        if self.dedicated_host:
            for k in self.dedicated_host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBodyDedicatedHosts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHost'] = []
        if self.dedicated_host is not None:
            for k in self.dedicated_host:
                result['DedicatedHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dedicated_host = []
        if m.get('DedicatedHost') is not None:
            for k in m.get('DedicatedHost'):
                temp_model = DescribeDedicatedHostsResponseBodyDedicatedHostsDedicatedHost()
                self.dedicated_host.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseBody(TeaModel):
    def __init__(self, dedicated_hosts=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.dedicated_hosts = dedicated_hosts  # type: DescribeDedicatedHostsResponseBodyDedicatedHosts
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseBodyDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(m['DedicatedHosts'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedHostsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnoseRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnoseRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDiagnoseRequest(TeaModel):
    def __init__(self, diagnose_action=None, diagnose_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None, status=None, tag=None,
                 type=None):
        self.diagnose_action = diagnose_action  # type: str
        self.diagnose_id = diagnose_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: int
        self.tag = tag  # type: list[DescribeDiagnoseRequestTag]
        self.type = type  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnoseRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.diagnose_action is not None:
            result['DiagnoseAction'] = self.diagnose_action
        if self.diagnose_id is not None:
            result['DiagnoseId'] = self.diagnose_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiagnoseAction') is not None:
            self.diagnose_action = m.get('DiagnoseAction')
        if m.get('DiagnoseId') is not None:
            self.diagnose_id = m.get('DiagnoseId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDiagnoseRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDiagnoseResponseBodyDiagnoseInstancesDiagnoseInstance(TeaModel):
    def __init__(self, amount=None, creation_time=None, diagnose_action=None, diagnose_id=None,
                 diagnose_request_id=None, disk_category=None, error_code=None, expire_time=None, instance_charge_type=None,
                 instance_type_name=None, iz_no=None, mark=None, modification_time=None, network_type=None, period=None,
                 period_unit=None, product=None, region_id=None, solutions=None, star=None, status=None):
        self.amount = amount  # type: int
        self.creation_time = creation_time  # type: str
        self.diagnose_action = diagnose_action  # type: str
        self.diagnose_id = diagnose_id  # type: str
        self.diagnose_request_id = diagnose_request_id  # type: str
        self.disk_category = disk_category  # type: str
        self.error_code = error_code  # type: str
        self.expire_time = expire_time  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type_name = instance_type_name  # type: str
        self.iz_no = iz_no  # type: str
        self.mark = mark  # type: str
        self.modification_time = modification_time  # type: str
        self.network_type = network_type  # type: str
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.solutions = solutions  # type: str
        self.star = star  # type: int
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnoseResponseBodyDiagnoseInstancesDiagnoseInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.diagnose_action is not None:
            result['DiagnoseAction'] = self.diagnose_action
        if self.diagnose_id is not None:
            result['DiagnoseId'] = self.diagnose_id
        if self.diagnose_request_id is not None:
            result['DiagnoseRequestId'] = self.diagnose_request_id
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type_name is not None:
            result['InstanceTypeName'] = self.instance_type_name
        if self.iz_no is not None:
            result['IzNo'] = self.iz_no
        if self.mark is not None:
            result['Mark'] = self.mark
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.solutions is not None:
            result['Solutions'] = self.solutions
        if self.star is not None:
            result['Star'] = self.star
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DiagnoseAction') is not None:
            self.diagnose_action = m.get('DiagnoseAction')
        if m.get('DiagnoseId') is not None:
            self.diagnose_id = m.get('DiagnoseId')
        if m.get('DiagnoseRequestId') is not None:
            self.diagnose_request_id = m.get('DiagnoseRequestId')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceTypeName') is not None:
            self.instance_type_name = m.get('InstanceTypeName')
        if m.get('IzNo') is not None:
            self.iz_no = m.get('IzNo')
        if m.get('Mark') is not None:
            self.mark = m.get('Mark')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Solutions') is not None:
            self.solutions = m.get('Solutions')
        if m.get('Star') is not None:
            self.star = m.get('Star')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDiagnoseResponseBodyDiagnoseInstances(TeaModel):
    def __init__(self, diagnose_instance=None):
        self.diagnose_instance = diagnose_instance  # type: list[DescribeDiagnoseResponseBodyDiagnoseInstancesDiagnoseInstance]

    def validate(self):
        if self.diagnose_instance:
            for k in self.diagnose_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnoseResponseBodyDiagnoseInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiagnoseInstance'] = []
        if self.diagnose_instance is not None:
            for k in self.diagnose_instance:
                result['DiagnoseInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.diagnose_instance = []
        if m.get('DiagnoseInstance') is not None:
            for k in m.get('DiagnoseInstance'):
                temp_model = DescribeDiagnoseResponseBodyDiagnoseInstancesDiagnoseInstance()
                self.diagnose_instance.append(temp_model.from_map(k))
        return self


class DescribeDiagnoseResponseBody(TeaModel):
    def __init__(self, diagnose_instances=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.diagnose_instances = diagnose_instances  # type: DescribeDiagnoseResponseBodyDiagnoseInstances
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.diagnose_instances:
            self.diagnose_instances.validate()

    def to_map(self):
        _map = super(DescribeDiagnoseResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.diagnose_instances is not None:
            result['DiagnoseInstances'] = self.diagnose_instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiagnoseInstances') is not None:
            temp_model = DescribeDiagnoseResponseBodyDiagnoseInstances()
            self.diagnose_instances = temp_model.from_map(m['DiagnoseInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDiagnoseResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDiagnoseResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDiagnoseResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnoseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosisOperateRecordsRequest(TeaModel):
    def __init__(self, error_code=None, instance_type=None, operate_record_type=None, owner_id=None,
                 page_number=None, page_size=None, pay_type=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, zone_id=None):
        self.error_code = error_code  # type: str
        self.instance_type = instance_type  # type: str
        self.operate_record_type = operate_record_type  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.pay_type = pay_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosisOperateRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.operate_record_type is not None:
            result['OperateRecordType'] = self.operate_record_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OperateRecordType') is not None:
            self.operate_record_type = m.get('OperateRecordType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDiagnosisOperateRecordsResponseBodyDiagnosisOperateRecordModels(TeaModel):
    def __init__(self, instance_type=None, new_instance_type=None, new_zone_id=None, operate_date=None,
                 operate_record_type=None, zone_id=None):
        self.instance_type = instance_type  # type: str
        self.new_instance_type = new_instance_type  # type: str
        self.new_zone_id = new_zone_id  # type: str
        self.operate_date = operate_date  # type: str
        self.operate_record_type = operate_record_type  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosisOperateRecordsResponseBodyDiagnosisOperateRecordModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.new_instance_type is not None:
            result['NewInstanceType'] = self.new_instance_type
        if self.new_zone_id is not None:
            result['NewZoneId'] = self.new_zone_id
        if self.operate_date is not None:
            result['OperateDate'] = self.operate_date
        if self.operate_record_type is not None:
            result['OperateRecordType'] = self.operate_record_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NewInstanceType') is not None:
            self.new_instance_type = m.get('NewInstanceType')
        if m.get('NewZoneId') is not None:
            self.new_zone_id = m.get('NewZoneId')
        if m.get('OperateDate') is not None:
            self.operate_date = m.get('OperateDate')
        if m.get('OperateRecordType') is not None:
            self.operate_record_type = m.get('OperateRecordType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDiagnosisOperateRecordsResponseBody(TeaModel):
    def __init__(self, diagnosis_operate_record_models=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.diagnosis_operate_record_models = diagnosis_operate_record_models  # type: list[DescribeDiagnosisOperateRecordsResponseBodyDiagnosisOperateRecordModels]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.diagnosis_operate_record_models:
            for k in self.diagnosis_operate_record_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosisOperateRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiagnosisOperateRecordModels'] = []
        if self.diagnosis_operate_record_models is not None:
            for k in self.diagnosis_operate_record_models:
                result['DiagnosisOperateRecordModels'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.diagnosis_operate_record_models = []
        if m.get('DiagnosisOperateRecordModels') is not None:
            for k in m.get('DiagnosisOperateRecordModels'):
                temp_model = DescribeDiagnosisOperateRecordsResponseBodyDiagnosisOperateRecordModels()
                self.diagnosis_operate_record_models.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDiagnosisOperateRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDiagnosisOperateRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDiagnosisOperateRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosisOperateRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosticReportsRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_id=None, region_id=None, report_id=None,
                 resource_id=None, resource_owner_account=None, resource_owner_id=None, resource_type=None, severity=None,
                 source_system=None, status=None):
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.report_id = report_id  # type: list[str]
        self.resource_id = resource_id  # type: list[str]
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str
        self.severity = severity  # type: str
        self.source_system = source_system  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosticReportsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.source_system is not None:
            result['SourceSystem'] = self.source_system
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('SourceSystem') is not None:
            self.source_system = m.get('SourceSystem')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParametersParameter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParametersParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParameters(TeaModel):
    def __init__(self, parameter=None):
        self.parameter = parameter  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParametersParameter]

    def validate(self):
        if self.parameter:
            for k in self.parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Parameter'] = []
        if self.parameter is not None:
            for k in self.parameter:
                result['Parameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.parameter = []
        if m.get('Parameter') is not None:
            for k in m.get('Parameter'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParametersParameter()
                self.parameter.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedAction(TeaModel):
    def __init__(self, action_code=None, parameters=None, url=None):
        self.action_code = action_code  # type: str
        self.parameters = parameters  # type: DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParameters
        self.url = url  # type: str

    def validate(self):
        if self.parameters:
            self.parameters.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedAction, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code is not None:
            result['ActionCode'] = self.action_code
        if self.parameters is not None:
            result['Parameters'] = self.parameters.to_map()
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionCode') is not None:
            self.action_code = m.get('ActionCode')
        if m.get('Parameters') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedActionParameters()
            self.parameters = temp_model.from_map(m['Parameters'])
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActions(TeaModel):
    def __init__(self, recommended_action=None):
        self.recommended_action = recommended_action  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedAction]

    def validate(self):
        if self.recommended_action:
            for k in self.recommended_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecommendedAction'] = []
        if self.recommended_action is not None:
            for k in self.recommended_action:
                result['RecommendedAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.recommended_action = []
        if m.get('RecommendedAction') is not None:
            for k in m.get('RecommendedAction'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActionsRecommendedAction()
                self.recommended_action.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssue(TeaModel):
    def __init__(self, issue_category=None, issue_code=None, message=None, occurrence_time=None,
                 recommended_actions=None, severity=None):
        self.issue_category = issue_category  # type: str
        self.issue_code = issue_code  # type: str
        self.message = message  # type: str
        self.occurrence_time = occurrence_time  # type: str
        self.recommended_actions = recommended_actions  # type: DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActions
        self.severity = severity  # type: str

    def validate(self):
        if self.recommended_actions:
            self.recommended_actions.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.issue_category is not None:
            result['IssueCategory'] = self.issue_category
        if self.issue_code is not None:
            result['IssueCode'] = self.issue_code
        if self.message is not None:
            result['Message'] = self.message
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.recommended_actions is not None:
            result['RecommendedActions'] = self.recommended_actions.to_map()
        if self.severity is not None:
            result['Severity'] = self.severity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IssueCategory') is not None:
            self.issue_category = m.get('IssueCategory')
        if m.get('IssueCode') is not None:
            self.issue_code = m.get('IssueCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('RecommendedActions') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssueRecommendedActions()
            self.recommended_actions = temp_model.from_map(m['RecommendedActions'])
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportIssues(TeaModel):
    def __init__(self, issue=None):
        self.issue = issue  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssue]

    def validate(self):
        if self.issue:
            for k in self.issue:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportIssues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Issue'] = []
        if self.issue is not None:
            for k in self.issue:
                result['Issue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.issue = []
        if m.get('Issue') is not None:
            for k in m.get('Issue'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssuesIssue()
                self.issue.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatasItemData(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatasItemData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatas(TeaModel):
    def __init__(self, item_data=None):
        self.item_data = item_data  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatasItemData]

    def validate(self):
        if self.item_data:
            for k in self.item_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatas, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ItemData'] = []
        if self.item_data is not None:
            for k in self.item_data:
                result['ItemData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item_data = []
        if m.get('ItemData') is not None:
            for k in m.get('ItemData'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatasItemData()
                self.item_data.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportItemsItem(TeaModel):
    def __init__(self, item_category=None, item_code=None, item_datas=None, occurrence_time=None, severity=None,
                 status=None):
        self.item_category = item_category  # type: str
        self.item_code = item_code  # type: str
        self.item_datas = item_datas  # type: DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatas
        self.occurrence_time = occurrence_time  # type: str
        self.severity = severity  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.item_datas:
            self.item_datas.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_category is not None:
            result['ItemCategory'] = self.item_category
        if self.item_code is not None:
            result['ItemCode'] = self.item_code
        if self.item_datas is not None:
            result['ItemDatas'] = self.item_datas.to_map()
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemCategory') is not None:
            self.item_category = m.get('ItemCategory')
        if m.get('ItemCode') is not None:
            self.item_code = m.get('ItemCode')
        if m.get('ItemDatas') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportItemsItemItemDatas()
            self.item_datas = temp_model.from_map(m['ItemDatas'])
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportRecentEventsRecentEvent(TeaModel):
    def __init__(self, event_id=None, event_name=None, publish_time=None):
        self.event_id = event_id  # type: str
        self.event_name = event_name  # type: str
        self.publish_time = publish_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportRecentEventsRecentEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventID'] = self.event_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventID') is not None:
            self.event_id = m.get('EventID')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        return self


class DescribeDiagnosticReportsResponseBodyReportsReportRecentEvents(TeaModel):
    def __init__(self, recent_event=None):
        self.recent_event = recent_event  # type: list[DescribeDiagnosticReportsResponseBodyReportsReportRecentEventsRecentEvent]

    def validate(self):
        if self.recent_event:
            for k in self.recent_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReportRecentEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecentEvent'] = []
        if self.recent_event is not None:
            for k in self.recent_event:
                result['RecentEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.recent_event = []
        if m.get('RecentEvent') is not None:
            for k in m.get('RecentEvent'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReportRecentEventsRecentEvent()
                self.recent_event.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBodyReportsReport(TeaModel):
    def __init__(self, creation_time=None, diagnostic_category=None, end_time=None, finished_time=None,
                 invoke_system=None, issue_category_id=None, issues=None, items=None, offline_diag_report_status=None,
                 pe_password=None, recent_events=None, report_id=None, resource_id=None, resource_type=None, severity=None,
                 start_time=None, status=None):
        self.creation_time = creation_time  # type: str
        self.diagnostic_category = diagnostic_category  # type: str
        self.end_time = end_time  # type: str
        self.finished_time = finished_time  # type: str
        self.invoke_system = invoke_system  # type: str
        self.issue_category_id = issue_category_id  # type: str
        self.issues = issues  # type: DescribeDiagnosticReportsResponseBodyReportsReportIssues
        self.items = items  # type: DescribeDiagnosticReportsResponseBodyReportsReportItems
        self.offline_diag_report_status = offline_diag_report_status  # type: str
        self.pe_password = pe_password  # type: str
        self.recent_events = recent_events  # type: DescribeDiagnosticReportsResponseBodyReportsReportRecentEvents
        self.report_id = report_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_type = resource_type  # type: str
        self.severity = severity  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.issues:
            self.issues.validate()
        if self.items:
            self.items.validate()
        if self.recent_events:
            self.recent_events.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReportsReport, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.diagnostic_category is not None:
            result['DiagnosticCategory'] = self.diagnostic_category
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.finished_time is not None:
            result['FinishedTime'] = self.finished_time
        if self.invoke_system is not None:
            result['InvokeSystem'] = self.invoke_system
        if self.issue_category_id is not None:
            result['IssueCategoryId'] = self.issue_category_id
        if self.issues is not None:
            result['Issues'] = self.issues.to_map()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.offline_diag_report_status is not None:
            result['OfflineDiagReportStatus'] = self.offline_diag_report_status
        if self.pe_password is not None:
            result['PePassword'] = self.pe_password
        if self.recent_events is not None:
            result['RecentEvents'] = self.recent_events.to_map()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.severity is not None:
            result['Severity'] = self.severity
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DiagnosticCategory') is not None:
            self.diagnostic_category = m.get('DiagnosticCategory')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FinishedTime') is not None:
            self.finished_time = m.get('FinishedTime')
        if m.get('InvokeSystem') is not None:
            self.invoke_system = m.get('InvokeSystem')
        if m.get('IssueCategoryId') is not None:
            self.issue_category_id = m.get('IssueCategoryId')
        if m.get('Issues') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportIssues()
            self.issues = temp_model.from_map(m['Issues'])
        if m.get('Items') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('OfflineDiagReportStatus') is not None:
            self.offline_diag_report_status = m.get('OfflineDiagReportStatus')
        if m.get('PePassword') is not None:
            self.pe_password = m.get('PePassword')
        if m.get('RecentEvents') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReportsReportRecentEvents()
            self.recent_events = temp_model.from_map(m['RecentEvents'])
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Severity') is not None:
            self.severity = m.get('Severity')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDiagnosticReportsResponseBodyReports(TeaModel):
    def __init__(self, report=None):
        self.report = report  # type: list[DescribeDiagnosticReportsResponseBodyReportsReport]

    def validate(self):
        if self.report:
            for k in self.report:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBodyReports, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Report'] = []
        if self.report is not None:
            for k in self.report:
                result['Report'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.report = []
        if m.get('Report') is not None:
            for k in m.get('Report'):
                temp_model = DescribeDiagnosticReportsResponseBodyReportsReport()
                self.report.append(temp_model.from_map(k))
        return self


class DescribeDiagnosticReportsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, reports=None, request_id=None):
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.reports = reports  # type: DescribeDiagnosticReportsResponseBodyReports
        self.request_id = request_id  # type: str

    def validate(self):
        if self.reports:
            self.reports.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.reports is not None:
            result['Reports'] = self.reports.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Reports') is not None:
            temp_model = DescribeDiagnosticReportsResponseBodyReports()
            self.reports = temp_model.from_map(m['Reports'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDiagnosticReportsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDiagnosticReportsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDiagnosticReportsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosticReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiskReplicaPairsRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiskReplicaPairsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDiskReplicaPairsResponseBodyDiskReplicaPairsDiskReplicaPair(TeaModel):
    def __init__(self, async_cycle=None, bandwidth=None, description=None, destination_disk_id=None,
                 destination_region=None, health_status=None, pair_name=None, replica_pair_id=None, rpo_time=None, source_disk_id=None,
                 source_region=None, status=None, total_copied_size=None):
        self.async_cycle = async_cycle  # type: int
        self.bandwidth = bandwidth  # type: int
        self.description = description  # type: str
        self.destination_disk_id = destination_disk_id  # type: str
        self.destination_region = destination_region  # type: str
        self.health_status = health_status  # type: str
        self.pair_name = pair_name  # type: str
        self.replica_pair_id = replica_pair_id  # type: str
        self.rpo_time = rpo_time  # type: str
        self.source_disk_id = source_disk_id  # type: str
        self.source_region = source_region  # type: str
        self.status = status  # type: str
        self.total_copied_size = total_copied_size  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDiskReplicaPairsResponseBodyDiskReplicaPairsDiskReplicaPair, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_cycle is not None:
            result['AsyncCycle'] = self.async_cycle
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_disk_id is not None:
            result['DestinationDiskId'] = self.destination_disk_id
        if self.destination_region is not None:
            result['DestinationRegion'] = self.destination_region
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.pair_name is not None:
            result['PairName'] = self.pair_name
        if self.replica_pair_id is not None:
            result['ReplicaPairId'] = self.replica_pair_id
        if self.rpo_time is not None:
            result['RpoTime'] = self.rpo_time
        if self.source_disk_id is not None:
            result['SourceDiskId'] = self.source_disk_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.status is not None:
            result['Status'] = self.status
        if self.total_copied_size is not None:
            result['TotalCopiedSize'] = self.total_copied_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsyncCycle') is not None:
            self.async_cycle = m.get('AsyncCycle')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationDiskId') is not None:
            self.destination_disk_id = m.get('DestinationDiskId')
        if m.get('DestinationRegion') is not None:
            self.destination_region = m.get('DestinationRegion')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('PairName') is not None:
            self.pair_name = m.get('PairName')
        if m.get('ReplicaPairId') is not None:
            self.replica_pair_id = m.get('ReplicaPairId')
        if m.get('RpoTime') is not None:
            self.rpo_time = m.get('RpoTime')
        if m.get('SourceDiskId') is not None:
            self.source_disk_id = m.get('SourceDiskId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCopiedSize') is not None:
            self.total_copied_size = m.get('TotalCopiedSize')
        return self


class DescribeDiskReplicaPairsResponseBodyDiskReplicaPairs(TeaModel):
    def __init__(self, disk_replica_pair=None):
        self.disk_replica_pair = disk_replica_pair  # type: list[DescribeDiskReplicaPairsResponseBodyDiskReplicaPairsDiskReplicaPair]

    def validate(self):
        if self.disk_replica_pair:
            for k in self.disk_replica_pair:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDiskReplicaPairsResponseBodyDiskReplicaPairs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskReplicaPair'] = []
        if self.disk_replica_pair is not None:
            for k in self.disk_replica_pair:
                result['DiskReplicaPair'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.disk_replica_pair = []
        if m.get('DiskReplicaPair') is not None:
            for k in m.get('DiskReplicaPair'):
                temp_model = DescribeDiskReplicaPairsResponseBodyDiskReplicaPairsDiskReplicaPair()
                self.disk_replica_pair.append(temp_model.from_map(k))
        return self


class DescribeDiskReplicaPairsResponseBody(TeaModel):
    def __init__(self, disk_replica_pairs=None, next_token=None, request_id=None):
        self.disk_replica_pairs = disk_replica_pairs  # type: DescribeDiskReplicaPairsResponseBodyDiskReplicaPairs
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.disk_replica_pairs:
            self.disk_replica_pairs.validate()

    def to_map(self):
        _map = super(DescribeDiskReplicaPairsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_replica_pairs is not None:
            result['DiskReplicaPairs'] = self.disk_replica_pairs.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskReplicaPairs') is not None:
            temp_model = DescribeDiskReplicaPairsResponseBodyDiskReplicaPairs()
            self.disk_replica_pairs = temp_model.from_map(m['DiskReplicaPairs'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDiskReplicaPairsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDiskReplicaPairsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDiskReplicaPairsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiskReplicaPairsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEcsScenarioFacadeRequestScenarioListScenarioResources(TeaModel):
    def __init__(self, type=None, values=None):
        self.type = type  # type: str
        self.values = values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeRequestScenarioListScenarioResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeEcsScenarioFacadeRequestScenarioList(TeaModel):
    def __init__(self, scenario=None, scenario_resources=None):
        self.scenario = scenario  # type: str
        self.scenario_resources = scenario_resources  # type: list[DescribeEcsScenarioFacadeRequestScenarioListScenarioResources]

    def validate(self):
        if self.scenario_resources:
            for k in self.scenario_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeRequestScenarioList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        result['ScenarioResources'] = []
        if self.scenario_resources is not None:
            for k in self.scenario_resources:
                result['ScenarioResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        self.scenario_resources = []
        if m.get('ScenarioResources') is not None:
            for k in m.get('ScenarioResources'):
                temp_model = DescribeEcsScenarioFacadeRequestScenarioListScenarioResources()
                self.scenario_resources.append(temp_model.from_map(k))
        return self


class DescribeEcsScenarioFacadeRequest(TeaModel):
    def __init__(self, ext_map=None, ext_param=None, owner_id=None, region_id=None, resource_owner_id=None,
                 scenario_list=None):
        self.ext_map = ext_map  # type: dict[str, str]
        self.ext_param = ext_param  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.scenario_list = scenario_list  # type: list[DescribeEcsScenarioFacadeRequestScenarioList]

    def validate(self):
        if self.scenario_list:
            for k in self.scenario_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ext_map is not None:
            result['ExtMap'] = self.ext_map
        if self.ext_param is not None:
            result['ExtParam'] = self.ext_param
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['ScenarioList'] = []
        if self.scenario_list is not None:
            for k in self.scenario_list:
                result['ScenarioList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExtMap') is not None:
            self.ext_map = m.get('ExtMap')
        if m.get('ExtParam') is not None:
            self.ext_param = m.get('ExtParam')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.scenario_list = []
        if m.get('ScenarioList') is not None:
            for k in m.get('ScenarioList'):
                temp_model = DescribeEcsScenarioFacadeRequestScenarioList()
                self.scenario_list.append(temp_model.from_map(k))
        return self


class DescribeEcsScenarioFacadeResponseBodyScenariosContentsEcsScenarioContentData(TeaModel):
    def __init__(self, type=None, values=None):
        self.type = type  # type: str
        self.values = values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeResponseBodyScenariosContentsEcsScenarioContentData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeEcsScenarioFacadeResponseBodyScenariosContents(TeaModel):
    def __init__(self, action=None, attributes=None, color_level=None, description=None,
                 ecs_scenario_content_data=None, icon=None, support_cancel=None, tips=None, title=None, track=None):
        self.action = action  # type: dict[str, str]
        self.attributes = attributes  # type: dict[str, str]
        self.color_level = color_level  # type: str
        self.description = description  # type: str
        self.ecs_scenario_content_data = ecs_scenario_content_data  # type: list[DescribeEcsScenarioFacadeResponseBodyScenariosContentsEcsScenarioContentData]
        self.icon = icon  # type: str
        self.support_cancel = support_cancel  # type: str
        self.tips = tips  # type: str
        self.title = title  # type: str
        self.track = track  # type: dict[str, str]

    def validate(self):
        if self.ecs_scenario_content_data:
            for k in self.ecs_scenario_content_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeResponseBodyScenariosContents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.attributes is not None:
            result['Attributes'] = self.attributes
        if self.color_level is not None:
            result['ColorLevel'] = self.color_level
        if self.description is not None:
            result['Description'] = self.description
        result['EcsScenarioContentData'] = []
        if self.ecs_scenario_content_data is not None:
            for k in self.ecs_scenario_content_data:
                result['EcsScenarioContentData'].append(k.to_map() if k else None)
        if self.icon is not None:
            result['Icon'] = self.icon
        if self.support_cancel is not None:
            result['SupportCancel'] = self.support_cancel
        if self.tips is not None:
            result['Tips'] = self.tips
        if self.title is not None:
            result['Title'] = self.title
        if self.track is not None:
            result['Track'] = self.track
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Attributes') is not None:
            self.attributes = m.get('Attributes')
        if m.get('ColorLevel') is not None:
            self.color_level = m.get('ColorLevel')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.ecs_scenario_content_data = []
        if m.get('EcsScenarioContentData') is not None:
            for k in m.get('EcsScenarioContentData'):
                temp_model = DescribeEcsScenarioFacadeResponseBodyScenariosContentsEcsScenarioContentData()
                self.ecs_scenario_content_data.append(temp_model.from_map(k))
        if m.get('Icon') is not None:
            self.icon = m.get('Icon')
        if m.get('SupportCancel') is not None:
            self.support_cancel = m.get('SupportCancel')
        if m.get('Tips') is not None:
            self.tips = m.get('Tips')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Track') is not None:
            self.track = m.get('Track')
        return self


class DescribeEcsScenarioFacadeResponseBodyScenarios(TeaModel):
    def __init__(self, contents=None, scenario=None):
        self.contents = contents  # type: list[DescribeEcsScenarioFacadeResponseBodyScenariosContents]
        self.scenario = scenario  # type: str

    def validate(self):
        if self.contents:
            for k in self.contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeResponseBodyScenarios, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contents'] = []
        if self.contents is not None:
            for k in self.contents:
                result['Contents'].append(k.to_map() if k else None)
        if self.scenario is not None:
            result['Scenario'] = self.scenario
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contents = []
        if m.get('Contents') is not None:
            for k in m.get('Contents'):
                temp_model = DescribeEcsScenarioFacadeResponseBodyScenariosContents()
                self.contents.append(temp_model.from_map(k))
        if m.get('Scenario') is not None:
            self.scenario = m.get('Scenario')
        return self


class DescribeEcsScenarioFacadeResponseBody(TeaModel):
    def __init__(self, request_id=None, scenarios=None):
        self.request_id = request_id  # type: str
        self.scenarios = scenarios  # type: list[DescribeEcsScenarioFacadeResponseBodyScenarios]

    def validate(self):
        if self.scenarios:
            for k in self.scenarios:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Scenarios'] = []
        if self.scenarios is not None:
            for k in self.scenarios:
                result['Scenarios'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scenarios = []
        if m.get('Scenarios') is not None:
            for k in m.get('Scenarios'):
                temp_model = DescribeEcsScenarioFacadeResponseBodyScenarios()
                self.scenarios.append(temp_model.from_map(k))
        return self


class DescribeEcsScenarioFacadeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEcsScenarioFacadeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEcsScenarioFacadeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEcsScenarioFacadeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEniQosGroupInfoRequest(TeaModel):
    def __init__(self, owner_id=None, qos_group_name=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        self.qos_group_name = qos_group_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_group_name is not None:
            result['QosGroupName'] = self.qos_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosGroupName') is not None:
            self.qos_group_name = m.get('QosGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeEniQosGroupInfoResponseBodyQosGroupInfoNetworkInterfaceIds(TeaModel):
    def __init__(self, network_interface_id=None):
        self.network_interface_id = network_interface_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoResponseBodyQosGroupInfoNetworkInterfaceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        return self


class DescribeEniQosGroupInfoResponseBodyQosGroupInfoQosGroup(TeaModel):
    def __init__(self, gmt_create=None, gmt_modify=None, qos_group_name=None, rx=None, rx_pps=None, tx=None,
                 tx_pps=None, type=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_modify = gmt_modify  # type: str
        self.qos_group_name = qos_group_name  # type: str
        self.rx = rx  # type: str
        self.rx_pps = rx_pps  # type: str
        self.tx = tx  # type: str
        self.tx_pps = tx_pps  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoResponseBodyQosGroupInfoQosGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.qos_group_name is not None:
            result['QosGroupName'] = self.qos_group_name
        if self.rx is not None:
            result['Rx'] = self.rx
        if self.rx_pps is not None:
            result['RxPps'] = self.rx_pps
        if self.tx is not None:
            result['Tx'] = self.tx
        if self.tx_pps is not None:
            result['TxPps'] = self.tx_pps
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('QosGroupName') is not None:
            self.qos_group_name = m.get('QosGroupName')
        if m.get('Rx') is not None:
            self.rx = m.get('Rx')
        if m.get('RxPps') is not None:
            self.rx_pps = m.get('RxPps')
        if m.get('Tx') is not None:
            self.tx = m.get('Tx')
        if m.get('TxPps') is not None:
            self.tx_pps = m.get('TxPps')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEniQosGroupInfoResponseBodyQosGroupInfo(TeaModel):
    def __init__(self, instance_id=None, network_interface_ids=None, qos_group=None):
        self.instance_id = instance_id  # type: str
        self.network_interface_ids = network_interface_ids  # type: DescribeEniQosGroupInfoResponseBodyQosGroupInfoNetworkInterfaceIds
        self.qos_group = qos_group  # type: DescribeEniQosGroupInfoResponseBodyQosGroupInfoQosGroup

    def validate(self):
        if self.network_interface_ids:
            self.network_interface_ids.validate()
        if self.qos_group:
            self.qos_group.validate()

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoResponseBodyQosGroupInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids.to_map()
        if self.qos_group is not None:
            result['QosGroup'] = self.qos_group.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkInterfaceIds') is not None:
            temp_model = DescribeEniQosGroupInfoResponseBodyQosGroupInfoNetworkInterfaceIds()
            self.network_interface_ids = temp_model.from_map(m['NetworkInterfaceIds'])
        if m.get('QosGroup') is not None:
            temp_model = DescribeEniQosGroupInfoResponseBodyQosGroupInfoQosGroup()
            self.qos_group = temp_model.from_map(m['QosGroup'])
        return self


class DescribeEniQosGroupInfoResponseBody(TeaModel):
    def __init__(self, qos_group_info=None, request_id=None):
        self.qos_group_info = qos_group_info  # type: DescribeEniQosGroupInfoResponseBodyQosGroupInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.qos_group_info:
            self.qos_group_info.validate()

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_group_info is not None:
            result['QosGroupInfo'] = self.qos_group_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QosGroupInfo') is not None:
            temp_model = DescribeEniQosGroupInfoResponseBodyQosGroupInfo()
            self.qos_group_info = temp_model.from_map(m['QosGroupInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEniQosGroupInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEniQosGroupInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEniQosGroupInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEniQosGroupInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFunctionFeedbackRequest(TeaModel):
    def __init__(self, category=None, feedback=None, function_name=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.category = category  # type: str
        self.feedback = feedback  # type: str
        self.function_name = function_name  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFunctionFeedbackRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeFunctionFeedbackResponseBodyDataFeedback(TeaModel):
    def __init__(self, category=None, creation_time=None, feedback=None, finished_time=None, function_name=None,
                 suggestion=None):
        self.category = category  # type: str
        self.creation_time = creation_time  # type: str
        self.feedback = feedback  # type: str
        self.finished_time = finished_time  # type: str
        self.function_name = function_name  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFunctionFeedbackResponseBodyDataFeedback, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.finished_time is not None:
            result['FinishedTime'] = self.finished_time
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('FinishedTime') is not None:
            self.finished_time = m.get('FinishedTime')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class DescribeFunctionFeedbackResponseBodyData(TeaModel):
    def __init__(self, feedback=None):
        self.feedback = feedback  # type: list[DescribeFunctionFeedbackResponseBodyDataFeedback]

    def validate(self):
        if self.feedback:
            for k in self.feedback:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFunctionFeedbackResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['feedback'] = []
        if self.feedback is not None:
            for k in self.feedback:
                result['feedback'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.feedback = []
        if m.get('feedback') is not None:
            for k in m.get('feedback'):
                temp_model = DescribeFunctionFeedbackResponseBodyDataFeedback()
                self.feedback.append(temp_model.from_map(k))
        return self


class DescribeFunctionFeedbackResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: DescribeFunctionFeedbackResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeFunctionFeedbackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeFunctionFeedbackResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFunctionFeedbackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeFunctionFeedbackResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFunctionFeedbackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFunctionFeedbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHavsInstanceTypesRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHavsInstanceTypesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponseHavsInstanceTypes(TeaModel):
    def __init__(self, havs_instance_types=None):
        self.havs_instance_types = havs_instance_types  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponseHavsInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.havs_instance_types is not None:
            result['HavsInstanceTypes'] = self.havs_instance_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HavsInstanceTypes') is not None:
            self.havs_instance_types = m.get('HavsInstanceTypes')
        return self


class DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponse(TeaModel):
    def __init__(self, havs_instance_types=None):
        self.havs_instance_types = havs_instance_types  # type: DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponseHavsInstanceTypes

    def validate(self):
        if self.havs_instance_types:
            self.havs_instance_types.validate()

    def to_map(self):
        _map = super(DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.havs_instance_types is not None:
            result['HavsInstanceTypes'] = self.havs_instance_types.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HavsInstanceTypes') is not None:
            temp_model = DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponseHavsInstanceTypes()
            self.havs_instance_types = temp_model.from_map(m['HavsInstanceTypes'])
        return self


class DescribeHavsInstanceTypesResponseBody(TeaModel):
    def __init__(self, describe_havs_instance_types_response=None, request_id=None):
        self.describe_havs_instance_types_response = describe_havs_instance_types_response  # type: DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponse
        self.request_id = request_id  # type: str

    def validate(self):
        if self.describe_havs_instance_types_response:
            self.describe_havs_instance_types_response.validate()

    def to_map(self):
        _map = super(DescribeHavsInstanceTypesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.describe_havs_instance_types_response is not None:
            result['DescribeHavsInstanceTypesResponse'] = self.describe_havs_instance_types_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DescribeHavsInstanceTypesResponse') is not None:
            temp_model = DescribeHavsInstanceTypesResponseBodyDescribeHavsInstanceTypesResponse()
            self.describe_havs_instance_types_response = temp_model.from_map(m['DescribeHavsInstanceTypesResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHavsInstanceTypesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHavsInstanceTypesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHavsInstanceTypesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHavsInstanceTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageAgreementRequest(TeaModel):
    def __init__(self, agreement_type=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        self.agreement_type = agreement_type  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageAgreementRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agreement_type is not None:
            result['AgreementType'] = self.agreement_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgreementType') is not None:
            self.agreement_type = m.get('AgreementType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeImageAgreementResponseBody(TeaModel):
    def __init__(self, request_id=None, status=None):
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageAgreementResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageAgreementResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageAgreementResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageAgreementResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageAgreementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageCachesRequest(TeaModel):
    def __init__(self, client_token=None, image_id=None, max_results=None, next_token=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, zone_id=None):
        self.client_token = client_token  # type: str
        self.image_id = image_id  # type: str
        self.max_results = max_results  # type: long
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageCachesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeImageCachesResponseBodyImageCachesImageCache(TeaModel):
    def __init__(self, creation_time=None, image_id=None, progress=None, status=None):
        self.creation_time = creation_time  # type: str
        self.image_id = image_id  # type: str
        self.progress = progress  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageCachesResponseBodyImageCachesImageCache, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageCachesResponseBodyImageCaches(TeaModel):
    def __init__(self, image_cache=None):
        self.image_cache = image_cache  # type: list[DescribeImageCachesResponseBodyImageCachesImageCache]

    def validate(self):
        if self.image_cache:
            for k in self.image_cache:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeImageCachesResponseBodyImageCaches, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageCache'] = []
        if self.image_cache is not None:
            for k in self.image_cache:
                result['ImageCache'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_cache = []
        if m.get('ImageCache') is not None:
            for k in m.get('ImageCache'):
                temp_model = DescribeImageCachesResponseBodyImageCachesImageCache()
                self.image_cache.append(temp_model.from_map(k))
        return self


class DescribeImageCachesResponseBody(TeaModel):
    def __init__(self, image_caches=None, next_token=None, request_id=None, total_count=None):
        self.image_caches = image_caches  # type: DescribeImageCachesResponseBodyImageCaches
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.image_caches:
            self.image_caches.validate()

    def to_map(self):
        _map = super(DescribeImageCachesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_caches is not None:
            result['ImageCaches'] = self.image_caches.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageCaches') is not None:
            temp_model = DescribeImageCachesResponseBodyImageCaches()
            self.image_caches = temp_model.from_map(m['ImageCaches'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageCachesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageCachesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageCachesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageCachesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageFamiliesRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, status=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageFamiliesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageFamiliesResponseBodyImageFamilies(TeaModel):
    def __init__(self, image_family=None):
        self.image_family = image_family  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageFamiliesResponseBodyImageFamilies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        return self


class DescribeImageFamiliesResponseBody(TeaModel):
    def __init__(self, image_families=None, page_number=None, page_size=None, region_id=None, request_id=None,
                 total_count=None):
        self.image_families = image_families  # type: DescribeImageFamiliesResponseBodyImageFamilies
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.image_families:
            self.image_families.validate()

    def to_map(self):
        _map = super(DescribeImageFamiliesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_families is not None:
            result['ImageFamilies'] = self.image_families.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageFamilies') is not None:
            temp_model = DescribeImageFamiliesResponseBodyImageFamilies()
            self.image_families = temp_model.from_map(m['ImageFamilies'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageFamiliesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageFamiliesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageFamiliesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageFamiliesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAutoRebootTimeRequest(TeaModel):
    def __init__(self, auto_reboot_time_from=None, auto_reboot_time_to=None, instance_ids=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.auto_reboot_time_from = auto_reboot_time_from  # type: str
        self.auto_reboot_time_to = auto_reboot_time_to  # type: str
        self.instance_ids = instance_ids  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAutoRebootTimeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_reboot_time_from is not None:
            result['AutoRebootTimeFrom'] = self.auto_reboot_time_from
        if self.auto_reboot_time_to is not None:
            result['AutoRebootTimeTo'] = self.auto_reboot_time_to
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRebootTimeFrom') is not None:
            self.auto_reboot_time_from = m.get('AutoRebootTimeFrom')
        if m.get('AutoRebootTimeTo') is not None:
            self.auto_reboot_time_to = m.get('AutoRebootTimeTo')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfosAutoRebootInfo(TeaModel):
    def __init__(self, instance_id=None, limit_reboot_time=None, order_type=None, reboot_time=None):
        self.instance_id = instance_id  # type: str
        self.limit_reboot_time = limit_reboot_time  # type: str
        self.order_type = order_type  # type: str
        self.reboot_time = reboot_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfosAutoRebootInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.limit_reboot_time is not None:
            result['LimitRebootTime'] = self.limit_reboot_time
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.reboot_time is not None:
            result['RebootTime'] = self.reboot_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LimitRebootTime') is not None:
            self.limit_reboot_time = m.get('LimitRebootTime')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RebootTime') is not None:
            self.reboot_time = m.get('RebootTime')
        return self


class DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfos(TeaModel):
    def __init__(self, auto_reboot_info=None):
        self.auto_reboot_info = auto_reboot_info  # type: list[DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfosAutoRebootInfo]

    def validate(self):
        if self.auto_reboot_info:
            for k in self.auto_reboot_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoRebootInfo'] = []
        if self.auto_reboot_info is not None:
            for k in self.auto_reboot_info:
                result['AutoRebootInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.auto_reboot_info = []
        if m.get('AutoRebootInfo') is not None:
            for k in m.get('AutoRebootInfo'):
                temp_model = DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfosAutoRebootInfo()
                self.auto_reboot_info.append(temp_model.from_map(k))
        return self


class DescribeInstanceAutoRebootTimeResponseBody(TeaModel):
    def __init__(self, auto_reboot_infos=None, request_id=None):
        self.auto_reboot_infos = auto_reboot_infos  # type: DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.auto_reboot_infos:
            self.auto_reboot_infos.validate()

    def to_map(self):
        _map = super(DescribeInstanceAutoRebootTimeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_reboot_infos is not None:
            result['AutoRebootInfos'] = self.auto_reboot_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRebootInfos') is not None:
            temp_model = DescribeInstanceAutoRebootTimeResponseBodyAutoRebootInfos()
            self.auto_reboot_infos = temp_model.from_map(m['AutoRebootInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceAutoRebootTimeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceAutoRebootTimeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceAutoRebootTimeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAutoRebootTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceHealthStatusRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceHealthStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeInstanceHealthStatusResponseBodyHealthStatusModelHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceHealthStatusResponseBodyHealthStatusModelHealthStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeInstanceHealthStatusResponseBodyHealthStatusModel(TeaModel):
    def __init__(self, health_status=None, instance_id=None):
        self.health_status = health_status  # type: DescribeInstanceHealthStatusResponseBodyHealthStatusModelHealthStatus
        self.instance_id = instance_id  # type: str

    def validate(self):
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        _map = super(DescribeInstanceHealthStatusResponseBodyHealthStatusModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HealthStatus') is not None:
            temp_model = DescribeInstanceHealthStatusResponseBodyHealthStatusModelHealthStatus()
            self.health_status = temp_model.from_map(m['HealthStatus'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceHealthStatusResponseBody(TeaModel):
    def __init__(self, health_status_model=None, request_id=None):
        self.health_status_model = health_status_model  # type: list[DescribeInstanceHealthStatusResponseBodyHealthStatusModel]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.health_status_model:
            for k in self.health_status_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceHealthStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HealthStatusModel'] = []
        if self.health_status_model is not None:
            for k in self.health_status_model:
                result['HealthStatusModel'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.health_status_model = []
        if m.get('HealthStatusModel') is not None:
            for k in m.get('HealthStatusModel'):
                temp_model = DescribeInstanceHealthStatusResponseBodyHealthStatusModel()
                self.health_status_model.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceHealthStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceHealthStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceHealthStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceHealthStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, instance_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues(TeaModel):
    def __init__(self, supported_value=None):
        self.supported_value = supported_value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_value is not None:
            result['SupportedValue'] = self.supported_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportedValue') is not None:
            self.supported_value = m.get('SupportedValue')
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenance(TeaModel):
    def __init__(self, default_value=None, supported_values=None, value=None):
        self.default_value = default_value  # type: str
        self.supported_values = supported_values  # type: DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues
        self.value = value  # type: str

    def validate(self):
        if self.supported_values:
            self.supported_values.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.supported_values is not None:
            result['SupportedValues'] = self.supported_values.to_map()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('SupportedValues') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues()
            self.supported_values = temp_model.from_map(m['SupportedValues'])
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        self.end_time = end_time  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindows(TeaModel):
    def __init__(self, maintenance_window=None):
        self.maintenance_window = maintenance_window  # type: list[DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow]

    def validate(self):
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindows, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.maintenance_window = []
        if m.get('MaintenanceWindow') is not None:
            for k in m.get('MaintenanceWindow'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow()
                self.maintenance_window.append(temp_model.from_map(k))
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttribute(TeaModel):
    def __init__(self, action_on_maintenance=None, instance_id=None, live_migration=None, maintenance_windows=None):
        self.action_on_maintenance = action_on_maintenance  # type: DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenance
        self.instance_id = instance_id  # type: str
        self.live_migration = live_migration  # type: bool
        self.maintenance_windows = maintenance_windows  # type: DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindows

    def validate(self):
        if self.action_on_maintenance:
            self.action_on_maintenance.validate()
        if self.maintenance_windows:
            self.maintenance_windows.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttribute, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.live_migration is not None:
            result['LiveMigration'] = self.live_migration
        if self.maintenance_windows is not None:
            result['MaintenanceWindows'] = self.maintenance_windows.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionOnMaintenance') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeActionOnMaintenance()
            self.action_on_maintenance = temp_model.from_map(m['ActionOnMaintenance'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LiveMigration') is not None:
            self.live_migration = m.get('LiveMigration')
        if m.get('MaintenanceWindows') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttributeMaintenanceWindows()
            self.maintenance_windows = temp_model.from_map(m['MaintenanceWindows'])
        return self


class DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributes(TeaModel):
    def __init__(self, maintenance_attribute=None):
        self.maintenance_attribute = maintenance_attribute  # type: list[DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttribute]

    def validate(self):
        if self.maintenance_attribute:
            for k in self.maintenance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MaintenanceAttribute'] = []
        if self.maintenance_attribute is not None:
            for k in self.maintenance_attribute:
                result['MaintenanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.maintenance_attribute = []
        if m.get('MaintenanceAttribute') is not None:
            for k in m.get('MaintenanceAttribute'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributesMaintenanceAttribute()
                self.maintenance_attribute.append(temp_model.from_map(k))
        return self


class DescribeInstanceMaintenanceAttributesResponseBody(TeaModel):
    def __init__(self, maintenance_attributes=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.maintenance_attributes = maintenance_attributes  # type: DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributes
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.maintenance_attributes:
            self.maintenance_attributes.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maintenance_attributes is not None:
            result['MaintenanceAttributes'] = self.maintenance_attributes.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaintenanceAttributes') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseBodyMaintenanceAttributes()
            self.maintenance_attributes = temp_model.from_map(m['MaintenanceAttributes'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceMaintenanceAttributesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceMaintenanceAttributesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceModificationPriceRequestSystemDisk(TeaModel):
    def __init__(self, category=None):
        self.category = category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceRequestSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class DescribeInstanceModificationPriceRequestDataDisk(TeaModel):
    def __init__(self, category=None, performance_level=None, size=None):
        self.category = category  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceRequestDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeInstanceModificationPriceRequest(TeaModel):
    def __init__(self, system_disk=None, data_disk=None, instance_id=None, instance_type=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.system_disk = system_disk  # type: DescribeInstanceModificationPriceRequestSystemDisk
        self.data_disk = data_disk  # type: list[DescribeInstanceModificationPriceRequestDataDisk]
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = DescribeInstanceModificationPriceRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = DescribeInstanceModificationPriceRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeInstanceModificationPriceResponseBodyPriceInfoPrice(TeaModel):
    def __init__(self, currency=None, discount_price=None, original_price=None, trade_price=None):
        self.currency = currency  # type: str
        self.discount_price = discount_price  # type: float
        self.original_price = original_price  # type: float
        self.trade_price = trade_price  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponseBodyPriceInfoPrice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribeInstanceModificationPriceResponseBodyPriceInfoRulesRule(TeaModel):
    def __init__(self, description=None, rule_id=None):
        self.description = description  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponseBodyPriceInfoRulesRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeInstanceModificationPriceResponseBodyPriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule  # type: list[DescribeInstanceModificationPriceResponseBodyPriceInfoRulesRule]

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponseBodyPriceInfoRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribeInstanceModificationPriceResponseBodyPriceInfoRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribeInstanceModificationPriceResponseBodyPriceInfo(TeaModel):
    def __init__(self, price=None, rules=None):
        self.price = price  # type: DescribeInstanceModificationPriceResponseBodyPriceInfoPrice
        self.rules = rules  # type: DescribeInstanceModificationPriceResponseBodyPriceInfoRules

    def validate(self):
        if self.price:
            self.price.validate()
        if self.rules:
            self.rules.validate()

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponseBodyPriceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price is not None:
            result['Price'] = self.price.to_map()
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Price') is not None:
            temp_model = DescribeInstanceModificationPriceResponseBodyPriceInfoPrice()
            self.price = temp_model.from_map(m['Price'])
        if m.get('Rules') is not None:
            temp_model = DescribeInstanceModificationPriceResponseBodyPriceInfoRules()
            self.rules = temp_model.from_map(m['Rules'])
        return self


class DescribeInstanceModificationPriceResponseBody(TeaModel):
    def __init__(self, price_info=None, request_id=None):
        self.price_info = price_info  # type: DescribeInstanceModificationPriceResponseBodyPriceInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribeInstanceModificationPriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceModificationPriceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceModificationPriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceModificationPriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceModificationPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceNeedRebootRequest(TeaModel):
    def __init__(self, instance_ids=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.instance_ids = instance_ids  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceNeedRebootRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeInstanceNeedRebootResponseBodyInstanceInfo(TeaModel):
    def __init__(self, instance_info=None):
        self.instance_info = instance_info  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceNeedRebootResponseBodyInstanceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_info is not None:
            result['InstanceInfo'] = self.instance_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceInfo') is not None:
            self.instance_info = m.get('InstanceInfo')
        return self


class DescribeInstanceNeedRebootResponseBody(TeaModel):
    def __init__(self, instance_info=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.instance_info = instance_info  # type: DescribeInstanceNeedRebootResponseBodyInstanceInfo
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.instance_info:
            self.instance_info.validate()

    def to_map(self):
        _map = super(DescribeInstanceNeedRebootResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_info is not None:
            result['InstanceInfo'] = self.instance_info.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceInfo') is not None:
            temp_model = DescribeInstanceNeedRebootResponseBodyInstanceInfo()
            self.instance_info = temp_model.from_map(m['InstanceInfo'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceNeedRebootResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceNeedRebootResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceNeedRebootResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceNeedRebootResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstancePerformanceRestrictHistoryRequest(TeaModel):
    def __init__(self, instance_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistoryIntervals(TeaModel):
    def __init__(self, interval=None):
        self.interval = interval  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistoryIntervals, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistory(TeaModel):
    def __init__(self, instance_id=None, intervals=None):
        self.instance_id = instance_id  # type: str
        self.intervals = intervals  # type: DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistoryIntervals

    def validate(self):
        if self.intervals:
            self.intervals.validate()

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.intervals is not None:
            result['Intervals'] = self.intervals.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Intervals') is not None:
            temp_model = DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistoryIntervals()
            self.intervals = temp_model.from_map(m['Intervals'])
        return self


class DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistories(TeaModel):
    def __init__(self, performance_restrict_history=None):
        self.performance_restrict_history = performance_restrict_history  # type: list[DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistory]

    def validate(self):
        if self.performance_restrict_history:
            for k in self.performance_restrict_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PerformanceRestrictHistory'] = []
        if self.performance_restrict_history is not None:
            for k in self.performance_restrict_history:
                result['PerformanceRestrictHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.performance_restrict_history = []
        if m.get('PerformanceRestrictHistory') is not None:
            for k in m.get('PerformanceRestrictHistory'):
                temp_model = DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistoriesPerformanceRestrictHistory()
                self.performance_restrict_history.append(temp_model.from_map(k))
        return self


class DescribeInstancePerformanceRestrictHistoryResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, performance_restrict_histories=None, request_id=None,
                 total_count=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.performance_restrict_histories = performance_restrict_histories  # type: DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistories
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.performance_restrict_histories:
            self.performance_restrict_histories.validate()

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.performance_restrict_histories is not None:
            result['PerformanceRestrictHistories'] = self.performance_restrict_histories.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PerformanceRestrictHistories') is not None:
            temp_model = DescribeInstancePerformanceRestrictHistoryResponseBodyPerformanceRestrictHistories()
            self.performance_restrict_histories = temp_model.from_map(m['PerformanceRestrictHistories'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstancePerformanceRestrictHistoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstancePerformanceRestrictHistoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstancePerformanceRestrictHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstancePerformanceRestrictHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceTypeResourceRequest(TeaModel):
    def __init__(self, cores=None, instance_type_families=None, instance_type_match_mode=None, instance_types=None,
                 memories=None, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, search_types=None, zone_ids=None):
        self.cores = cores  # type: int
        self.instance_type_families = instance_type_families  # type: list[str]
        self.instance_type_match_mode = instance_type_match_mode  # type: str
        self.instance_types = instance_types  # type: list[str]
        self.memories = memories  # type: list[float]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.search_types = search_types  # type: list[str]
        self.zone_ids = zone_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        if self.instance_type_match_mode is not None:
            result['InstanceTypeMatchMode'] = self.instance_type_match_mode
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.memories is not None:
            result['Memories'] = self.memories
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.search_types is not None:
            result['SearchTypes'] = self.search_types
        if self.zone_ids is not None:
            result['ZoneIds'] = self.zone_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = m.get('InstanceTypeFamilies')
        if m.get('InstanceTypeMatchMode') is not None:
            self.instance_type_match_mode = m.get('InstanceTypeMatchMode')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('Memories') is not None:
            self.memories = m.get('Memories')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SearchTypes') is not None:
            self.search_types = m.get('SearchTypes')
        if m.get('ZoneIds') is not None:
            self.zone_ids = m.get('ZoneIds')
        return self


class DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResourceStockHealth(TeaModel):
    def __init__(self, adequacy_score=None, health_score=None, hot_score=None, supply_score=None):
        self.adequacy_score = adequacy_score  # type: int
        self.health_score = health_score  # type: int
        self.hot_score = hot_score  # type: int
        self.supply_score = supply_score  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResourceStockHealth, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adequacy_score is not None:
            result['AdequacyScore'] = self.adequacy_score
        if self.health_score is not None:
            result['HealthScore'] = self.health_score
        if self.hot_score is not None:
            result['HotScore'] = self.hot_score
        if self.supply_score is not None:
            result['SupplyScore'] = self.supply_score
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdequacyScore') is not None:
            self.adequacy_score = m.get('AdequacyScore')
        if m.get('HealthScore') is not None:
            self.health_score = m.get('HealthScore')
        if m.get('HotScore') is not None:
            self.hot_score = m.get('HotScore')
        if m.get('SupplyScore') is not None:
            self.supply_score = m.get('SupplyScore')
        return self


class DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResource(TeaModel):
    def __init__(self, instance_type=None, instance_type_family=None, region_id=None, search_type=None,
                 stock_health=None, total_quota=None, zone_id=None):
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.region_id = region_id  # type: str
        self.search_type = search_type  # type: str
        self.stock_health = stock_health  # type: DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResourceStockHealth
        self.total_quota = total_quota  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.stock_health:
            self.stock_health.validate()

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_type is not None:
            result['SearchType'] = self.search_type
        if self.stock_health is not None:
            result['StockHealth'] = self.stock_health.to_map()
        if self.total_quota is not None:
            result['TotalQuota'] = self.total_quota
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchType') is not None:
            self.search_type = m.get('SearchType')
        if m.get('StockHealth') is not None:
            temp_model = DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResourceStockHealth()
            self.stock_health = temp_model.from_map(m['StockHealth'])
        if m.get('TotalQuota') is not None:
            self.total_quota = m.get('TotalQuota')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeInstanceTypeResourceResponseBodyInstanceTypeResources(TeaModel):
    def __init__(self, instance_type_resource=None):
        self.instance_type_resource = instance_type_resource  # type: list[DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResource]

    def validate(self):
        if self.instance_type_resource:
            for k in self.instance_type_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceResponseBodyInstanceTypeResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceTypeResource'] = []
        if self.instance_type_resource is not None:
            for k in self.instance_type_resource:
                result['InstanceTypeResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_type_resource = []
        if m.get('InstanceTypeResource') is not None:
            for k in m.get('InstanceTypeResource'):
                temp_model = DescribeInstanceTypeResourceResponseBodyInstanceTypeResourcesInstanceTypeResource()
                self.instance_type_resource.append(temp_model.from_map(k))
        return self


class DescribeInstanceTypeResourceResponseBody(TeaModel):
    def __init__(self, instance_type_resources=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.instance_type_resources = instance_type_resources  # type: DescribeInstanceTypeResourceResponseBodyInstanceTypeResources
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.instance_type_resources:
            self.instance_type_resources.validate()

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type_resources is not None:
            result['InstanceTypeResources'] = self.instance_type_resources.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceTypeResources') is not None:
            temp_model = DescribeInstanceTypeResourceResponseBodyInstanceTypeResources()
            self.instance_type_resources = temp_model.from_map(m['InstanceTypeResources'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceTypeResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeInstanceTypeResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceTypeResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceTypeResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeKMSKeyAttributeRequest(TeaModel):
    def __init__(self, kmskey_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, app_key=None, channel=None, operator=None, proxy_id=None, token=None):
        self.kmskey_id = kmskey_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.app_key = app_key  # type: str
        self.channel = channel  # type: str
        self.operator = operator  # type: str
        self.proxy_id = proxy_id  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeKMSKeyAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.app_key is not None:
            result['appKey'] = self.app_key
        if self.channel is not None:
            result['channel'] = self.channel
        if self.operator is not None:
            result['operator'] = self.operator
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('appKey') is not None:
            self.app_key = m.get('appKey')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class DescribeKMSKeyAttributeResponseBody(TeaModel):
    def __init__(self, alias=None, creator=None, ecs_tagged=None, kmskey_id=None, request_id=None, status=None):
        self.alias = alias  # type: str
        self.creator = creator  # type: str
        self.ecs_tagged = ecs_tagged  # type: bool
        self.kmskey_id = kmskey_id  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeKMSKeyAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.ecs_tagged is not None:
            result['EcsTagged'] = self.ecs_tagged
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('EcsTagged') is not None:
            self.ecs_tagged = m.get('EcsTagged')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeKMSKeyAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeKMSKeyAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeKMSKeyAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeKMSKeyAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeKMSKeysRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, app_key=None, channel=None, operator=None, proxy_id=None, token=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.app_key = app_key  # type: str
        self.channel = channel  # type: str
        self.operator = operator  # type: str
        self.proxy_id = proxy_id  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeKMSKeysRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.app_key is not None:
            result['appKey'] = self.app_key
        if self.channel is not None:
            result['channel'] = self.channel
        if self.operator is not None:
            result['operator'] = self.operator
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('appKey') is not None:
            self.app_key = m.get('appKey')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class DescribeKMSKeysResponseBodyKMSKeyIds(TeaModel):
    def __init__(self, kms_key_id=None):
        self.kms_key_id = kms_key_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeKMSKeysResponseBodyKMSKeyIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kms_key_id is not None:
            result['kmsKeyId'] = self.kms_key_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('kmsKeyId') is not None:
            self.kms_key_id = m.get('kmsKeyId')
        return self


class DescribeKMSKeysResponseBody(TeaModel):
    def __init__(self, kmskey_ids=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.kmskey_ids = kmskey_ids  # type: DescribeKMSKeysResponseBodyKMSKeyIds
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.kmskey_ids:
            self.kmskey_ids.validate()

    def to_map(self):
        _map = super(DescribeKMSKeysResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kmskey_ids is not None:
            result['KMSKeyIds'] = self.kmskey_ids.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KMSKeyIds') is not None:
            temp_model = DescribeKMSKeysResponseBodyKMSKeyIds()
            self.kmskey_ids = temp_model.from_map(m['KMSKeyIds'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeKMSKeysResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeKMSKeysResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeKMSKeysResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeKMSKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLinkedKMSKeysRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, app_key=None, channel=None, operator=None, proxy_id=None, token=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.app_key = app_key  # type: str
        self.channel = channel  # type: str
        self.operator = operator  # type: str
        self.proxy_id = proxy_id  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLinkedKMSKeysRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.app_key is not None:
            result['appKey'] = self.app_key
        if self.channel is not None:
            result['channel'] = self.channel
        if self.operator is not None:
            result['operator'] = self.operator
        if self.proxy_id is not None:
            result['proxyId'] = self.proxy_id
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('appKey') is not None:
            self.app_key = m.get('appKey')
        if m.get('channel') is not None:
            self.channel = m.get('channel')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('proxyId') is not None:
            self.proxy_id = m.get('proxyId')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class DescribeLinkedKMSKeysResponseBodyKMSKeysKMSKey(TeaModel):
    def __init__(self, alias=None, kmskey_id=None):
        self.alias = alias  # type: str
        self.kmskey_id = kmskey_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLinkedKMSKeysResponseBodyKMSKeysKMSKey, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        return self


class DescribeLinkedKMSKeysResponseBodyKMSKeys(TeaModel):
    def __init__(self, kmskey=None):
        self.kmskey = kmskey  # type: list[DescribeLinkedKMSKeysResponseBodyKMSKeysKMSKey]

    def validate(self):
        if self.kmskey:
            for k in self.kmskey:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLinkedKMSKeysResponseBodyKMSKeys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KMSKey'] = []
        if self.kmskey is not None:
            for k in self.kmskey:
                result['KMSKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.kmskey = []
        if m.get('KMSKey') is not None:
            for k in m.get('KMSKey'):
                temp_model = DescribeLinkedKMSKeysResponseBodyKMSKeysKMSKey()
                self.kmskey.append(temp_model.from_map(k))
        return self


class DescribeLinkedKMSKeysResponseBody(TeaModel):
    def __init__(self, kmskeys=None, request_id=None):
        self.kmskeys = kmskeys  # type: DescribeLinkedKMSKeysResponseBodyKMSKeys
        self.request_id = request_id  # type: str

    def validate(self):
        if self.kmskeys:
            self.kmskeys.validate()

    def to_map(self):
        _map = super(DescribeLinkedKMSKeysResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kmskeys is not None:
            result['KMSKeys'] = self.kmskeys.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KMSKeys') is not None:
            temp_model = DescribeLinkedKMSKeysResponseBodyKMSKeys()
            self.kmskeys = temp_model.from_map(m['KMSKeys'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLinkedKMSKeysResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLinkedKMSKeysResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLinkedKMSKeysResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLinkedKMSKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLocalDiskRepairActivitiesRequest(TeaModel):
    def __init__(self, disk_id=None, include_history=None, instance_id=None, owner_account=None, owner_id=None,
                 page_number=None, page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.disk_id = disk_id  # type: list[str]
        self.include_history = include_history  # type: bool
        self.instance_id = instance_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.include_history is not None:
            result['IncludeHistory'] = self.include_history
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('IncludeHistory') is not None:
            self.include_history = m.get('IncludeHistory')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEventEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEventEventType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEvent(TeaModel):
    def __init__(self, event_end_time=None, event_id=None, event_time=None, event_type=None):
        self.event_end_time = event_end_time  # type: str
        self.event_id = event_id  # type: str
        self.event_time = event_time  # type: str
        self.event_type = event_type  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEventEventType

    def validate(self):
        if self.event_type:
            self.event_type.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_end_time is not None:
            result['EventEndTime'] = self.event_end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventEndTime') is not None:
            self.event_end_time = m.get('EventEndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventTime') is not None:
            self.event_time = m.get('EventTime')
        if m.get('EventType') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEventEventType()
            self.event_type = temp_model.from_map(m['EventType'])
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventCycleStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code  # type: int
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventExtendedAttribute(TeaModel):
    def __init__(self, device=None, disk_id=None, online_repair_policy=None):
        self.device = device  # type: str
        self.disk_id = disk_id  # type: str
        self.online_repair_policy = online_repair_policy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventExtendedAttribute, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.online_repair_policy is not None:
            result['OnlineRepairPolicy'] = self.online_repair_policy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('OnlineRepairPolicy') is not None:
            self.online_repair_policy = m.get('OnlineRepairPolicy')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEvent(TeaModel):
    def __init__(self, event_cycle_status=None, event_finish_time=None, event_id=None, event_publish_time=None,
                 event_type=None, extended_attribute=None, instance_id=None, reason=None):
        self.event_cycle_status = event_cycle_status  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventCycleStatus
        self.event_finish_time = event_finish_time  # type: str
        self.event_id = event_id  # type: str
        self.event_publish_time = event_publish_time  # type: str
        self.event_type = event_type  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventType
        self.extended_attribute = extended_attribute  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventExtendedAttribute
        self.instance_id = instance_id  # type: str
        self.reason = reason  # type: str

    def validate(self):
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        if self.event_type:
            self.event_type.validate()
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        if self.event_finish_time is not None:
            result['EventFinishTime'] = self.event_finish_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventCycleStatus') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(m['EventCycleStatus'])
        if m.get('EventFinishTime') is not None:
            self.event_finish_time = m.get('EventFinishTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventPublishTime') is not None:
            self.event_publish_time = m.get('EventPublishTime')
        if m.get('EventType') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventEventType()
            self.event_type = temp_model.from_map(m['EventType'])
        if m.get('ExtendedAttribute') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEventExtendedAttribute()
            self.extended_attribute = temp_model.from_map(m['ExtendedAttribute'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEvents(TeaModel):
    def __init__(self, instance_event=None):
        self.instance_event = instance_event  # type: list[DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEvent]

    def validate(self):
        if self.instance_event:
            for k in self.instance_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceEvent'] = []
        if self.instance_event is not None:
            for k in self.instance_event:
                result['InstanceEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_event = []
        if m.get('InstanceEvent') is not None:
            for k in m.get('InstanceEvent'):
                temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEventsInstanceEvent()
                self.instance_event.append(temp_model.from_map(k))
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivity(TeaModel):
    def __init__(self, disk_event=None, disk_id=None, instance_events=None, instance_id=None, progress=None):
        self.disk_event = disk_event  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEvent
        self.disk_id = disk_id  # type: str
        self.instance_events = instance_events  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEvents
        self.instance_id = instance_id  # type: str
        self.progress = progress  # type: str

    def validate(self):
        if self.disk_event:
            self.disk_event.validate()
        if self.instance_events:
            self.instance_events.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_event is not None:
            result['DiskEvent'] = self.disk_event.to_map()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.instance_events is not None:
            result['InstanceEvents'] = self.instance_events.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.progress is not None:
            result['Progress'] = self.progress
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskEvent') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityDiskEvent()
            self.disk_event = temp_model.from_map(m['DiskEvent'])
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('InstanceEvents') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivityInstanceEvents()
            self.instance_events = temp_model.from_map(m['InstanceEvents'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        return self


class DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivities(TeaModel):
    def __init__(self, local_disk_repair_activity=None):
        self.local_disk_repair_activity = local_disk_repair_activity  # type: list[DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivity]

    def validate(self):
        if self.local_disk_repair_activity:
            for k in self.local_disk_repair_activity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LocalDiskRepairActivity'] = []
        if self.local_disk_repair_activity is not None:
            for k in self.local_disk_repair_activity:
                result['LocalDiskRepairActivity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.local_disk_repair_activity = []
        if m.get('LocalDiskRepairActivity') is not None:
            for k in m.get('LocalDiskRepairActivity'):
                temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivitiesLocalDiskRepairActivity()
                self.local_disk_repair_activity.append(temp_model.from_map(k))
        return self


class DescribeLocalDiskRepairActivitiesResponseBody(TeaModel):
    def __init__(self, local_disk_repair_activities=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.local_disk_repair_activities = local_disk_repair_activities  # type: DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivities
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.local_disk_repair_activities:
            self.local_disk_repair_activities.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_disk_repair_activities is not None:
            result['LocalDiskRepairActivities'] = self.local_disk_repair_activities.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocalDiskRepairActivities') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBodyLocalDiskRepairActivities()
            self.local_disk_repair_activities = temp_model.from_map(m['LocalDiskRepairActivities'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLocalDiskRepairActivitiesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLocalDiskRepairActivitiesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLocalDiskRepairActivitiesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLocalDiskRepairActivitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrationInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationInstancesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMigrationInstancesRequest(TeaModel):
    def __init__(self, business_migration_type=None, hostname=None, instance_id=None, migration_plan_id=None,
                 migration_status=None, network_migration_type=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, tag=None, zone_id=None):
        self.business_migration_type = business_migration_type  # type: str
        self.hostname = hostname  # type: str
        self.instance_id = instance_id  # type: list[str]
        self.migration_plan_id = migration_plan_id  # type: str
        self.migration_status = migration_status  # type: str
        self.network_migration_type = network_migration_type  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeMigrationInstancesRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_migration_type is not None:
            result['BusinessMigrationType'] = self.business_migration_type
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.migration_status is not None:
            result['MigrationStatus'] = self.migration_status
        if self.network_migration_type is not None:
            result['NetworkMigrationType'] = self.network_migration_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessMigrationType') is not None:
            self.business_migration_type = m.get('BusinessMigrationType')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('MigrationStatus') is not None:
            self.migration_status = m.get('MigrationStatus')
        if m.get('NetworkMigrationType') is not None:
            self.network_migration_type = m.get('NetworkMigrationType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMigrationInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSets(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSetsAfterTransition(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSetsAfterTransition, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstance(TeaModel):
    def __init__(self, business_migration_type=None, business_status=None, change_public_ip=None, finish_time=None,
                 has_local_disk=None, instance_charge_type=None, instance_id=None, instance_type=None, internet_ip=None,
                 internet_ip_after_transition=None, intranet_ip=None, intranet_ip_after_transition=None, load_progress=None,
                 mac_address_after_transition=None, merge_progress=None, migration_plan_id=None, migration_status=None, name=None,
                 network_connectivity_status=None, network_migration_type=None, non_standard_instance_type=None, private_mac_address=None,
                 public_mac_address=None, region_id=None, resource_group_id=None, security_group_id_sets=None,
                 security_group_id_sets_after_transition=None, status=None, tags=None, target_vswitch_id=None, target_vpc_id=None, target_zone_id=None,
                 transition_time=None, zone_id=None):
        self.business_migration_type = business_migration_type  # type: str
        self.business_status = business_status  # type: str
        self.change_public_ip = change_public_ip  # type: bool
        self.finish_time = finish_time  # type: str
        self.has_local_disk = has_local_disk  # type: bool
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_ip = internet_ip  # type: str
        self.internet_ip_after_transition = internet_ip_after_transition  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.intranet_ip_after_transition = intranet_ip_after_transition  # type: str
        self.load_progress = load_progress  # type: str
        self.mac_address_after_transition = mac_address_after_transition  # type: str
        self.merge_progress = merge_progress  # type: str
        self.migration_plan_id = migration_plan_id  # type: str
        self.migration_status = migration_status  # type: str
        self.name = name  # type: str
        self.network_connectivity_status = network_connectivity_status  # type: bool
        self.network_migration_type = network_migration_type  # type: int
        self.non_standard_instance_type = non_standard_instance_type  # type: bool
        self.private_mac_address = private_mac_address  # type: str
        self.public_mac_address = public_mac_address  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.security_group_id_sets = security_group_id_sets  # type: DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSets
        self.security_group_id_sets_after_transition = security_group_id_sets_after_transition  # type: DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSetsAfterTransition
        self.status = status  # type: str
        self.tags = tags  # type: DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTags
        self.target_vswitch_id = target_vswitch_id  # type: str
        self.target_vpc_id = target_vpc_id  # type: str
        self.target_zone_id = target_zone_id  # type: str
        self.transition_time = transition_time  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.security_group_id_sets:
            self.security_group_id_sets.validate()
        if self.security_group_id_sets_after_transition:
            self.security_group_id_sets_after_transition.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_migration_type is not None:
            result['BusinessMigrationType'] = self.business_migration_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.change_public_ip is not None:
            result['ChangePublicIp'] = self.change_public_ip
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.has_local_disk is not None:
            result['HasLocalDisk'] = self.has_local_disk
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.internet_ip_after_transition is not None:
            result['InternetIpAfterTransition'] = self.internet_ip_after_transition
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.intranet_ip_after_transition is not None:
            result['IntranetIpAfterTransition'] = self.intranet_ip_after_transition
        if self.load_progress is not None:
            result['LoadProgress'] = self.load_progress
        if self.mac_address_after_transition is not None:
            result['MacAddressAfterTransition'] = self.mac_address_after_transition
        if self.merge_progress is not None:
            result['MergeProgress'] = self.merge_progress
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.migration_status is not None:
            result['MigrationStatus'] = self.migration_status
        if self.name is not None:
            result['Name'] = self.name
        if self.network_connectivity_status is not None:
            result['NetworkConnectivityStatus'] = self.network_connectivity_status
        if self.network_migration_type is not None:
            result['NetworkMigrationType'] = self.network_migration_type
        if self.non_standard_instance_type is not None:
            result['NonStandardInstanceType'] = self.non_standard_instance_type
        if self.private_mac_address is not None:
            result['PrivateMacAddress'] = self.private_mac_address
        if self.public_mac_address is not None:
            result['PublicMacAddress'] = self.public_mac_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group_id_sets is not None:
            result['SecurityGroupIdSets'] = self.security_group_id_sets.to_map()
        if self.security_group_id_sets_after_transition is not None:
            result['SecurityGroupIdSetsAfterTransition'] = self.security_group_id_sets_after_transition.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.target_vswitch_id is not None:
            result['TargetVSwitchId'] = self.target_vswitch_id
        if self.target_vpc_id is not None:
            result['TargetVpcId'] = self.target_vpc_id
        if self.target_zone_id is not None:
            result['TargetZoneId'] = self.target_zone_id
        if self.transition_time is not None:
            result['TransitionTime'] = self.transition_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessMigrationType') is not None:
            self.business_migration_type = m.get('BusinessMigrationType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ChangePublicIp') is not None:
            self.change_public_ip = m.get('ChangePublicIp')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('HasLocalDisk') is not None:
            self.has_local_disk = m.get('HasLocalDisk')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InternetIpAfterTransition') is not None:
            self.internet_ip_after_transition = m.get('InternetIpAfterTransition')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('IntranetIpAfterTransition') is not None:
            self.intranet_ip_after_transition = m.get('IntranetIpAfterTransition')
        if m.get('LoadProgress') is not None:
            self.load_progress = m.get('LoadProgress')
        if m.get('MacAddressAfterTransition') is not None:
            self.mac_address_after_transition = m.get('MacAddressAfterTransition')
        if m.get('MergeProgress') is not None:
            self.merge_progress = m.get('MergeProgress')
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('MigrationStatus') is not None:
            self.migration_status = m.get('MigrationStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkConnectivityStatus') is not None:
            self.network_connectivity_status = m.get('NetworkConnectivityStatus')
        if m.get('NetworkMigrationType') is not None:
            self.network_migration_type = m.get('NetworkMigrationType')
        if m.get('NonStandardInstanceType') is not None:
            self.non_standard_instance_type = m.get('NonStandardInstanceType')
        if m.get('PrivateMacAddress') is not None:
            self.private_mac_address = m.get('PrivateMacAddress')
        if m.get('PublicMacAddress') is not None:
            self.public_mac_address = m.get('PublicMacAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroupIdSets') is not None:
            temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSets()
            self.security_group_id_sets = temp_model.from_map(m['SecurityGroupIdSets'])
        if m.get('SecurityGroupIdSetsAfterTransition') is not None:
            temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceSecurityGroupIdSetsAfterTransition()
            self.security_group_id_sets_after_transition = temp_model.from_map(m['SecurityGroupIdSetsAfterTransition'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstanceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TargetVSwitchId') is not None:
            self.target_vswitch_id = m.get('TargetVSwitchId')
        if m.get('TargetVpcId') is not None:
            self.target_vpc_id = m.get('TargetVpcId')
        if m.get('TargetZoneId') is not None:
            self.target_zone_id = m.get('TargetZoneId')
        if m.get('TransitionTime') is not None:
            self.transition_time = m.get('TransitionTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeMigrationInstancesResponseBodyMigrationInstanceSet(TeaModel):
    def __init__(self, migration_instance=None):
        self.migration_instance = migration_instance  # type: list[DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstance]

    def validate(self):
        if self.migration_instance:
            for k in self.migration_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBodyMigrationInstanceSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MigrationInstance'] = []
        if self.migration_instance is not None:
            for k in self.migration_instance:
                result['MigrationInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.migration_instance = []
        if m.get('MigrationInstance') is not None:
            for k in m.get('MigrationInstance'):
                temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSetMigrationInstance()
                self.migration_instance.append(temp_model.from_map(k))
        return self


class DescribeMigrationInstancesResponseBody(TeaModel):
    def __init__(self, migration_instance_set=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.migration_instance_set = migration_instance_set  # type: DescribeMigrationInstancesResponseBodyMigrationInstanceSet
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.migration_instance_set:
            self.migration_instance_set.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_instance_set is not None:
            result['MigrationInstanceSet'] = self.migration_instance_set.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationInstanceSet') is not None:
            temp_model = DescribeMigrationInstancesResponseBodyMigrationInstanceSet()
            self.migration_instance_set = temp_model.from_map(m['MigrationInstanceSet'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeMigrationInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMigrationInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMigrationInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMigrationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrationPlansRequest(TeaModel):
    def __init__(self, migration_plan_id=None, name=None, owner_id=None, page_number=None, page_size=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, status=None, type=None):
        self.migration_plan_id = migration_plan_id  # type: str
        self.name = name  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationPlansRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlanSecurityGroupNos(TeaModel):
    def __init__(self, security_group_no=None):
        self.security_group_no = security_group_no  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlanSecurityGroupNos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_no is not None:
            result['SecurityGroupNo'] = self.security_group_no
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityGroupNo') is not None:
            self.security_group_no = m.get('SecurityGroupNo')
        return self


class DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlan(TeaModel):
    def __init__(self, create_time=None, enable_auto_create_vswitch=None, enable_network_connectivity=None,
                 finish_instance_count=None, migration_plan_id=None, name=None, remain_private_ip=None,
                 remain_public_mac_as_priority=None, security_group_nos=None, status=None, target_vswitch_id=None, target_vpc_id=None,
                 target_zone_id=None, total_instance_count=None, type=None):
        self.create_time = create_time  # type: str
        self.enable_auto_create_vswitch = enable_auto_create_vswitch  # type: bool
        self.enable_network_connectivity = enable_network_connectivity  # type: bool
        self.finish_instance_count = finish_instance_count  # type: int
        self.migration_plan_id = migration_plan_id  # type: str
        self.name = name  # type: str
        self.remain_private_ip = remain_private_ip  # type: bool
        self.remain_public_mac_as_priority = remain_public_mac_as_priority  # type: bool
        self.security_group_nos = security_group_nos  # type: DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlanSecurityGroupNos
        self.status = status  # type: str
        self.target_vswitch_id = target_vswitch_id  # type: str
        self.target_vpc_id = target_vpc_id  # type: str
        self.target_zone_id = target_zone_id  # type: str
        self.total_instance_count = total_instance_count  # type: int
        self.type = type  # type: str

    def validate(self):
        if self.security_group_nos:
            self.security_group_nos.validate()

    def to_map(self):
        _map = super(DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlan, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.enable_auto_create_vswitch is not None:
            result['EnableAutoCreateVSwitch'] = self.enable_auto_create_vswitch
        if self.enable_network_connectivity is not None:
            result['EnableNetworkConnectivity'] = self.enable_network_connectivity
        if self.finish_instance_count is not None:
            result['FinishInstanceCount'] = self.finish_instance_count
        if self.migration_plan_id is not None:
            result['MigrationPlanId'] = self.migration_plan_id
        if self.name is not None:
            result['Name'] = self.name
        if self.remain_private_ip is not None:
            result['RemainPrivateIp'] = self.remain_private_ip
        if self.remain_public_mac_as_priority is not None:
            result['RemainPublicMacAsPriority'] = self.remain_public_mac_as_priority
        if self.security_group_nos is not None:
            result['SecurityGroupNos'] = self.security_group_nos.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.target_vswitch_id is not None:
            result['TargetVSwitchId'] = self.target_vswitch_id
        if self.target_vpc_id is not None:
            result['TargetVpcId'] = self.target_vpc_id
        if self.target_zone_id is not None:
            result['TargetZoneId'] = self.target_zone_id
        if self.total_instance_count is not None:
            result['TotalInstanceCount'] = self.total_instance_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EnableAutoCreateVSwitch') is not None:
            self.enable_auto_create_vswitch = m.get('EnableAutoCreateVSwitch')
        if m.get('EnableNetworkConnectivity') is not None:
            self.enable_network_connectivity = m.get('EnableNetworkConnectivity')
        if m.get('FinishInstanceCount') is not None:
            self.finish_instance_count = m.get('FinishInstanceCount')
        if m.get('MigrationPlanId') is not None:
            self.migration_plan_id = m.get('MigrationPlanId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RemainPrivateIp') is not None:
            self.remain_private_ip = m.get('RemainPrivateIp')
        if m.get('RemainPublicMacAsPriority') is not None:
            self.remain_public_mac_as_priority = m.get('RemainPublicMacAsPriority')
        if m.get('SecurityGroupNos') is not None:
            temp_model = DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlanSecurityGroupNos()
            self.security_group_nos = temp_model.from_map(m['SecurityGroupNos'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetVSwitchId') is not None:
            self.target_vswitch_id = m.get('TargetVSwitchId')
        if m.get('TargetVpcId') is not None:
            self.target_vpc_id = m.get('TargetVpcId')
        if m.get('TargetZoneId') is not None:
            self.target_zone_id = m.get('TargetZoneId')
        if m.get('TotalInstanceCount') is not None:
            self.total_instance_count = m.get('TotalInstanceCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMigrationPlansResponseBodyMigrationPlanSet(TeaModel):
    def __init__(self, migration_plan=None):
        self.migration_plan = migration_plan  # type: list[DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlan]

    def validate(self):
        if self.migration_plan:
            for k in self.migration_plan:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMigrationPlansResponseBodyMigrationPlanSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MigrationPlan'] = []
        if self.migration_plan is not None:
            for k in self.migration_plan:
                result['MigrationPlan'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.migration_plan = []
        if m.get('MigrationPlan') is not None:
            for k in m.get('MigrationPlan'):
                temp_model = DescribeMigrationPlansResponseBodyMigrationPlanSetMigrationPlan()
                self.migration_plan.append(temp_model.from_map(k))
        return self


class DescribeMigrationPlansResponseBody(TeaModel):
    def __init__(self, migration_plan_set=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.migration_plan_set = migration_plan_set  # type: DescribeMigrationPlansResponseBodyMigrationPlanSet
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.migration_plan_set:
            self.migration_plan_set.validate()

    def to_map(self):
        _map = super(DescribeMigrationPlansResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_plan_set is not None:
            result['MigrationPlanSet'] = self.migration_plan_set.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationPlanSet') is not None:
            temp_model = DescribeMigrationPlansResponseBodyMigrationPlanSet()
            self.migration_plan_set = temp_model.from_map(m['MigrationPlanSet'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeMigrationPlansResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMigrationPlansResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMigrationPlansResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMigrationPlansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMigrationPreferencesRequest(TeaModel):
    def __init__(self, migration_network_type=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.migration_network_type = migration_network_type  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationPreferencesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_network_type is not None:
            result['MigrationNetworkType'] = self.migration_network_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationNetworkType') is not None:
            self.migration_network_type = m.get('MigrationNetworkType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeMigrationPreferencesResponseBodyTargetZoneIdSet(TeaModel):
    def __init__(self, target_zone_id=None):
        self.target_zone_id = target_zone_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMigrationPreferencesResponseBodyTargetZoneIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_zone_id is not None:
            result['TargetZoneId'] = self.target_zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetZoneId') is not None:
            self.target_zone_id = m.get('TargetZoneId')
        return self


class DescribeMigrationPreferencesResponseBody(TeaModel):
    def __init__(self, migration_network_type=None, region_id=None, request_id=None, target_zone_id_set=None):
        self.migration_network_type = migration_network_type  # type: str
        self.region_id = region_id  # type: str
        self.request_id = request_id  # type: str
        self.target_zone_id_set = target_zone_id_set  # type: DescribeMigrationPreferencesResponseBodyTargetZoneIdSet

    def validate(self):
        if self.target_zone_id_set:
            self.target_zone_id_set.validate()

    def to_map(self):
        _map = super(DescribeMigrationPreferencesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.migration_network_type is not None:
            result['MigrationNetworkType'] = self.migration_network_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.target_zone_id_set is not None:
            result['TargetZoneIdSet'] = self.target_zone_id_set.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MigrationNetworkType') is not None:
            self.migration_network_type = m.get('MigrationNetworkType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TargetZoneIdSet') is not None:
            temp_model = DescribeMigrationPreferencesResponseBodyTargetZoneIdSet()
            self.target_zone_id_set = temp_model.from_map(m['TargetZoneIdSet'])
        return self


class DescribeMigrationPreferencesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMigrationPreferencesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMigrationPreferencesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMigrationPreferencesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkInsightsAnalysisResultRequest(TeaModel):
    def __init__(self, dry_run=None, network_insights_analysis_id=None, region_id=None, resource_owner_id=None):
        self.dry_run = dry_run  # type: bool
        self.network_insights_analysis_id = network_insights_analysis_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.network_insights_analysis_id is not None:
            result['NetworkInsightsAnalysisId'] = self.network_insights_analysis_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NetworkInsightsAnalysisId') is not None:
            self.network_insights_analysis_id = m.get('NetworkInsightsAnalysisId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsNetworkAclEntry(TeaModel):
    def __init__(self, direction=None, network_acl_entry_id=None, network_acl_id=None, network_acl_name=None,
                 policy=None, port=None, protocol=None, source_cidr_ip=None, vpc_id=None):
        self.direction = direction  # type: str
        self.network_acl_entry_id = network_acl_entry_id  # type: str
        self.network_acl_id = network_acl_id  # type: str
        self.network_acl_name = network_acl_name  # type: str
        self.policy = policy  # type: str
        self.port = port  # type: str
        self.protocol = protocol  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsNetworkAclEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsRelativeGroupIds(TeaModel):
    def __init__(self, relative_group_id=None):
        self.relative_group_id = relative_group_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsRelativeGroupIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relative_group_id is not None:
            result['RelativeGroupId'] = self.relative_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RelativeGroupId') is not None:
            self.relative_group_id = m.get('RelativeGroupId')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsSecurityGroupAcl(TeaModel):
    def __init__(self, create_time=None, description=None, dest_cidr_ip=None, dest_group_id=None,
                 dest_port_range=None, inner_access_policy=None, nic_type=None, policy=None, source_cidr_ip=None,
                 source_port_range=None):
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_port_range = dest_port_range  # type: str
        self.inner_access_policy = inner_access_policy  # type: str
        self.nic_type = nic_type  # type: str
        self.policy = policy  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsSecurityGroupAcl, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.inner_access_policy is not None:
            result['InnerAccessPolicy'] = self.inner_access_policy
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('InnerAccessPolicy') is not None:
            self.inner_access_policy = m.get('InnerAccessPolicy')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsTopProcesses(TeaModel):
    def __init__(self, top_process=None):
        self.top_process = top_process  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsTopProcesses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.top_process is not None:
            result['TopProcess'] = self.top_process
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopProcess') is not None:
            self.top_process = m.get('TopProcess')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanations(TeaModel):
    def __init__(self, actual_ip=None, actual_port=None, expect_ip=None, expect_port=None, expire_date=None,
                 group_id=None, header=None, ip=None, missing_files=None, netmask=None, network_acl_entry=None,
                 network_interface_name=None, port=None, process_name=None, relative_group_ids=None, rule=None, security_group_acl=None,
                 top_processes=None, use_percent=None):
        self.actual_ip = actual_ip  # type: str
        self.actual_port = actual_port  # type: long
        self.expect_ip = expect_ip  # type: str
        self.expect_port = expect_port  # type: long
        self.expire_date = expire_date  # type: str
        self.group_id = group_id  # type: str
        self.header = header  # type: str
        self.ip = ip  # type: str
        self.missing_files = missing_files  # type: str
        self.netmask = netmask  # type: str
        self.network_acl_entry = network_acl_entry  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsNetworkAclEntry
        self.network_interface_name = network_interface_name  # type: str
        self.port = port  # type: long
        self.process_name = process_name  # type: str
        self.relative_group_ids = relative_group_ids  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsRelativeGroupIds
        self.rule = rule  # type: str
        self.security_group_acl = security_group_acl  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsSecurityGroupAcl
        self.top_processes = top_processes  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsTopProcesses
        self.use_percent = use_percent  # type: str

    def validate(self):
        if self.network_acl_entry:
            self.network_acl_entry.validate()
        if self.relative_group_ids:
            self.relative_group_ids.validate()
        if self.security_group_acl:
            self.security_group_acl.validate()
        if self.top_processes:
            self.top_processes.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_ip is not None:
            result['ActualIP'] = self.actual_ip
        if self.actual_port is not None:
            result['ActualPort'] = self.actual_port
        if self.expect_ip is not None:
            result['ExpectIP'] = self.expect_ip
        if self.expect_port is not None:
            result['ExpectPort'] = self.expect_port
        if self.expire_date is not None:
            result['ExpireDate'] = self.expire_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.header is not None:
            result['Header'] = self.header
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.missing_files is not None:
            result['MissingFiles'] = self.missing_files
        if self.netmask is not None:
            result['Netmask'] = self.netmask
        if self.network_acl_entry is not None:
            result['NetworkAclEntry'] = self.network_acl_entry.to_map()
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.port is not None:
            result['Port'] = self.port
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.relative_group_ids is not None:
            result['RelativeGroupIds'] = self.relative_group_ids.to_map()
        if self.rule is not None:
            result['Rule'] = self.rule
        if self.security_group_acl is not None:
            result['SecurityGroupAcl'] = self.security_group_acl.to_map()
        if self.top_processes is not None:
            result['TopProcesses'] = self.top_processes.to_map()
        if self.use_percent is not None:
            result['UsePercent'] = self.use_percent
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActualIP') is not None:
            self.actual_ip = m.get('ActualIP')
        if m.get('ActualPort') is not None:
            self.actual_port = m.get('ActualPort')
        if m.get('ExpectIP') is not None:
            self.expect_ip = m.get('ExpectIP')
        if m.get('ExpectPort') is not None:
            self.expect_port = m.get('ExpectPort')
        if m.get('ExpireDate') is not None:
            self.expire_date = m.get('ExpireDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Header') is not None:
            self.header = m.get('Header')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('MissingFiles') is not None:
            self.missing_files = m.get('MissingFiles')
        if m.get('Netmask') is not None:
            self.netmask = m.get('Netmask')
        if m.get('NetworkAclEntry') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsNetworkAclEntry()
            self.network_acl_entry = temp_model.from_map(m['NetworkAclEntry'])
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RelativeGroupIds') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsRelativeGroupIds()
            self.relative_group_ids = temp_model.from_map(m['RelativeGroupIds'])
        if m.get('Rule') is not None:
            self.rule = m.get('Rule')
        if m.get('SecurityGroupAcl') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsSecurityGroupAcl()
            self.security_group_acl = temp_model.from_map(m['SecurityGroupAcl'])
        if m.get('TopProcesses') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanationsTopProcesses()
            self.top_processes = temp_model.from_map(m['TopProcesses'])
        if m.get('UsePercent') is not None:
            self.use_percent = m.get('UsePercent')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItem(TeaModel):
    def __init__(self, code=None, explanations=None, item_name=None, reachable=None):
        self.code = code  # type: str
        self.explanations = explanations  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanations
        self.item_name = item_name  # type: str
        self.reachable = reachable  # type: str

    def validate(self):
        if self.explanations:
            self.explanations.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.explanations is not None:
            result['Explanations'] = self.explanations.to_map()
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.reachable is not None:
            result['Reachable'] = self.reachable
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Explanations') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItemExplanations()
            self.explanations = temp_model.from_map(m['Explanations'])
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Reachable') is not None:
            self.reachable = m.get('Reachable')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItems(TeaModel):
    def __init__(self, category_item=None):
        self.category_item = category_item  # type: list[DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItem]

    def validate(self):
        if self.category_item:
            for k in self.category_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CategoryItem'] = []
        if self.category_item is not None:
            for k in self.category_item:
                result['CategoryItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category_item = []
        if m.get('CategoryItem') is not None:
            for k in m.get('CategoryItem'):
                temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItemsCategoryItem()
                self.category_item.append(temp_model.from_map(k))
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategory(TeaModel):
    def __init__(self, category_items=None, category_name=None, reachable=None):
        self.category_items = category_items  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItems
        self.category_name = category_name  # type: str
        self.reachable = reachable  # type: str

    def validate(self):
        if self.category_items:
            self.category_items.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_items is not None:
            result['CategoryItems'] = self.category_items.to_map()
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.reachable is not None:
            result['Reachable'] = self.reachable
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryItems') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategoryCategoryItems()
            self.category_items = temp_model.from_map(m['CategoryItems'])
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('Reachable') is not None:
            self.reachable = m.get('Reachable')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategories(TeaModel):
    def __init__(self, diagnose_category=None):
        self.diagnose_category = diagnose_category  # type: list[DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategory]

    def validate(self):
        if self.diagnose_category:
            for k in self.diagnose_category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiagnoseCategory'] = []
        if self.diagnose_category is not None:
            for k in self.diagnose_category:
                result['DiagnoseCategory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.diagnose_category = []
        if m.get('DiagnoseCategory') is not None:
            for k in m.get('DiagnoseCategory'):
                temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategoriesDiagnoseCategory()
                self.diagnose_category.append(temp_model.from_map(k))
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentNetworkAclEntry(TeaModel):
    def __init__(self, creation_time=None, destination_cidr_ip=None, direction=None, network_acl_entry_id=None,
                 network_acl_entry_name=None, network_acl_id=None, network_acl_name=None, policy=None, port=None, protocol=None,
                 source_cidr_ip=None, vpc_id=None):
        self.creation_time = creation_time  # type: str
        self.destination_cidr_ip = destination_cidr_ip  # type: str
        self.direction = direction  # type: str
        self.network_acl_entry_id = network_acl_entry_id  # type: str
        self.network_acl_entry_name = network_acl_entry_name  # type: str
        self.network_acl_id = network_acl_id  # type: str
        self.network_acl_name = network_acl_name  # type: str
        self.policy = policy  # type: str
        self.port = port  # type: str
        self.protocol = protocol  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentNetworkAclEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.destination_cidr_ip is not None:
            result['DestinationCidrIp'] = self.destination_cidr_ip
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.network_acl_entry_id is not None:
            result['NetworkAclEntryId'] = self.network_acl_entry_id
        if self.network_acl_entry_name is not None:
            result['NetworkAclEntryName'] = self.network_acl_entry_name
        if self.network_acl_id is not None:
            result['NetworkAclId'] = self.network_acl_id
        if self.network_acl_name is not None:
            result['NetworkAclName'] = self.network_acl_name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DestinationCidrIp') is not None:
            self.destination_cidr_ip = m.get('DestinationCidrIp')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NetworkAclEntryId') is not None:
            self.network_acl_entry_id = m.get('NetworkAclEntryId')
        if m.get('NetworkAclEntryName') is not None:
            self.network_acl_entry_name = m.get('NetworkAclEntryName')
        if m.get('NetworkAclId') is not None:
            self.network_acl_id = m.get('NetworkAclId')
        if m.get('NetworkAclName') is not None:
            self.network_acl_name = m.get('NetworkAclName')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentRelativeGroupIds(TeaModel):
    def __init__(self, relative_group_id=None):
        self.relative_group_id = relative_group_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentRelativeGroupIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relative_group_id is not None:
            result['RelativeGroupId'] = self.relative_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RelativeGroupId') is not None:
            self.relative_group_id = m.get('RelativeGroupId')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentSecurityGroupAcl(TeaModel):
    def __init__(self, create_time=None, description=None, dest_cidr_ip=None, dest_group_id=None,
                 dest_group_name=None, dest_port_range=None, direction=None, inner_access_policy=None, ip_protocol=None,
                 ipv_6dest_cidr_ip=None, ipv_6source_cidr_ip=None, nic_type=None, permission_description=None, policy=None,
                 priority=None, security_group_id=None, source_cidr_ip=None, source_group_id=None, source_group_name=None,
                 source_port_range=None):
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_group_name = dest_group_name  # type: str
        self.dest_port_range = dest_port_range  # type: str
        self.direction = direction  # type: str
        self.inner_access_policy = inner_access_policy  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.permission_description = permission_description  # type: str
        self.policy = policy  # type: str
        self.priority = priority  # type: str
        self.security_group_id = security_group_id  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_group_name = source_group_name  # type: str
        self.source_port_range = source_port_range  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentSecurityGroupAcl, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_group_name is not None:
            result['DestGroupName'] = self.dest_group_name
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.inner_access_policy is not None:
            result['InnerAccessPolicy'] = self.inner_access_policy
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.permission_description is not None:
            result['PermissionDescription'] = self.permission_description
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_group_name is not None:
            result['SourceGroupName'] = self.source_group_name
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestGroupName') is not None:
            self.dest_group_name = m.get('DestGroupName')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('InnerAccessPolicy') is not None:
            self.inner_access_policy = m.get('InnerAccessPolicy')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('PermissionDescription') is not None:
            self.permission_description = m.get('PermissionDescription')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourceGroupName') is not None:
            self.source_group_name = m.get('SourceGroupName')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponent(TeaModel):
    def __init__(self, code=None, diagnose_categories=None, message=None, network_acl_entry=None, reachable=None,
                 relative_group_ids=None, resource_id=None, resource_type=None, security_group_acl=None, sequence=None):
        self.code = code  # type: str
        self.diagnose_categories = diagnose_categories  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategories
        self.message = message  # type: str
        self.network_acl_entry = network_acl_entry  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentNetworkAclEntry
        self.reachable = reachable  # type: str
        self.relative_group_ids = relative_group_ids  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentRelativeGroupIds
        self.resource_id = resource_id  # type: str
        self.resource_type = resource_type  # type: str
        self.security_group_acl = security_group_acl  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentSecurityGroupAcl
        self.sequence = sequence  # type: int

    def validate(self):
        if self.diagnose_categories:
            self.diagnose_categories.validate()
        if self.network_acl_entry:
            self.network_acl_entry.validate()
        if self.relative_group_ids:
            self.relative_group_ids.validate()
        if self.security_group_acl:
            self.security_group_acl.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.diagnose_categories is not None:
            result['DiagnoseCategories'] = self.diagnose_categories.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.network_acl_entry is not None:
            result['NetworkAclEntry'] = self.network_acl_entry.to_map()
        if self.reachable is not None:
            result['Reachable'] = self.reachable
        if self.relative_group_ids is not None:
            result['RelativeGroupIds'] = self.relative_group_ids.to_map()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.security_group_acl is not None:
            result['SecurityGroupAcl'] = self.security_group_acl.to_map()
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DiagnoseCategories') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentDiagnoseCategories()
            self.diagnose_categories = temp_model.from_map(m['DiagnoseCategories'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NetworkAclEntry') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentNetworkAclEntry()
            self.network_acl_entry = temp_model.from_map(m['NetworkAclEntry'])
        if m.get('Reachable') is not None:
            self.reachable = m.get('Reachable')
        if m.get('RelativeGroupIds') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentRelativeGroupIds()
            self.relative_group_ids = temp_model.from_map(m['RelativeGroupIds'])
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SecurityGroupAcl') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponentSecurityGroupAcl()
            self.security_group_acl = temp_model.from_map(m['SecurityGroupAcl'])
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        return self


class DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponents(TeaModel):
    def __init__(self, network_insights_analysis_component=None):
        self.network_insights_analysis_component = network_insights_analysis_component  # type: list[DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponent]

    def validate(self):
        if self.network_insights_analysis_component:
            for k in self.network_insights_analysis_component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkInsightsAnalysisComponent'] = []
        if self.network_insights_analysis_component is not None:
            for k in self.network_insights_analysis_component:
                result['NetworkInsightsAnalysisComponent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.network_insights_analysis_component = []
        if m.get('NetworkInsightsAnalysisComponent') is not None:
            for k in m.get('NetworkInsightsAnalysisComponent'):
                temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponentsNetworkInsightsAnalysisComponent()
                self.network_insights_analysis_component.append(temp_model.from_map(k))
        return self


class DescribeNetworkInsightsAnalysisResultResponseBody(TeaModel):
    def __init__(self, creation_time=None, destination=None, destination_ip=None, destination_port=None,
                 destination_type=None, network_insights_analysis_components=None, network_insights_analysis_id=None,
                 network_insights_path_id=None, network_path_found=None, protocol=None, request_id=None, source=None, source_ip=None,
                 source_type=None, status=None):
        self.creation_time = creation_time  # type: str
        self.destination = destination  # type: str
        self.destination_ip = destination_ip  # type: str
        self.destination_port = destination_port  # type: str
        self.destination_type = destination_type  # type: str
        self.network_insights_analysis_components = network_insights_analysis_components  # type: DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponents
        self.network_insights_analysis_id = network_insights_analysis_id  # type: str
        self.network_insights_path_id = network_insights_path_id  # type: str
        self.network_path_found = network_path_found  # type: str
        self.protocol = protocol  # type: str
        self.request_id = request_id  # type: str
        self.source = source  # type: str
        self.source_ip = source_ip  # type: str
        self.source_type = source_type  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.network_insights_analysis_components:
            self.network_insights_analysis_components.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_ip is not None:
            result['DestinationIp'] = self.destination_ip
        if self.destination_port is not None:
            result['DestinationPort'] = self.destination_port
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.network_insights_analysis_components is not None:
            result['NetworkInsightsAnalysisComponents'] = self.network_insights_analysis_components.to_map()
        if self.network_insights_analysis_id is not None:
            result['NetworkInsightsAnalysisId'] = self.network_insights_analysis_id
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.network_path_found is not None:
            result['NetworkPathFound'] = self.network_path_found
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationIp') is not None:
            self.destination_ip = m.get('DestinationIp')
        if m.get('DestinationPort') is not None:
            self.destination_port = m.get('DestinationPort')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('NetworkInsightsAnalysisComponents') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBodyNetworkInsightsAnalysisComponents()
            self.network_insights_analysis_components = temp_model.from_map(m['NetworkInsightsAnalysisComponents'])
        if m.get('NetworkInsightsAnalysisId') is not None:
            self.network_insights_analysis_id = m.get('NetworkInsightsAnalysisId')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('NetworkPathFound') is not None:
            self.network_path_found = m.get('NetworkPathFound')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNetworkInsightsAnalysisResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeNetworkInsightsAnalysisResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkInsightsAnalysisResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkInsightsAnalysisesRequest(TeaModel):
    def __init__(self, dry_run=None, max_results=None, network_insights_analysis_id=None,
                 network_insights_path_id=None, network_path_found=None, next_token=None, region_id=None, resource_owner_id=None,
                 status=None):
        self.dry_run = dry_run  # type: bool
        self.max_results = max_results  # type: int
        self.network_insights_analysis_id = network_insights_analysis_id  # type: list[str]
        self.network_insights_path_id = network_insights_path_id  # type: str
        self.network_path_found = network_path_found  # type: str
        self.next_token = next_token  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_insights_analysis_id is not None:
            result['NetworkInsightsAnalysisId'] = self.network_insights_analysis_id
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.network_path_found is not None:
            result['NetworkPathFound'] = self.network_path_found
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkInsightsAnalysisId') is not None:
            self.network_insights_analysis_id = m.get('NetworkInsightsAnalysisId')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('NetworkPathFound') is not None:
            self.network_path_found = m.get('NetworkPathFound')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSetsNetworkInsightsAnalysisSet(TeaModel):
    def __init__(self, creation_time=None, network_insights_analysis_id=None, network_insights_path_id=None,
                 network_path_found=None, status=None):
        self.creation_time = creation_time  # type: str
        self.network_insights_analysis_id = network_insights_analysis_id  # type: str
        self.network_insights_path_id = network_insights_path_id  # type: str
        self.network_path_found = network_path_found  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSetsNetworkInsightsAnalysisSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.network_insights_analysis_id is not None:
            result['NetworkInsightsAnalysisId'] = self.network_insights_analysis_id
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.network_path_found is not None:
            result['NetworkPathFound'] = self.network_path_found
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('NetworkInsightsAnalysisId') is not None:
            self.network_insights_analysis_id = m.get('NetworkInsightsAnalysisId')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('NetworkPathFound') is not None:
            self.network_path_found = m.get('NetworkPathFound')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSets(TeaModel):
    def __init__(self, network_insights_analysis_set=None):
        self.network_insights_analysis_set = network_insights_analysis_set  # type: list[DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSetsNetworkInsightsAnalysisSet]

    def validate(self):
        if self.network_insights_analysis_set:
            for k in self.network_insights_analysis_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkInsightsAnalysisSet'] = []
        if self.network_insights_analysis_set is not None:
            for k in self.network_insights_analysis_set:
                result['NetworkInsightsAnalysisSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.network_insights_analysis_set = []
        if m.get('NetworkInsightsAnalysisSet') is not None:
            for k in m.get('NetworkInsightsAnalysisSet'):
                temp_model = DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSetsNetworkInsightsAnalysisSet()
                self.network_insights_analysis_set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInsightsAnalysisesResponseBody(TeaModel):
    def __init__(self, max_results=None, network_insights_analysis_sets=None, next_token=None, request_id=None):
        self.max_results = max_results  # type: int
        self.network_insights_analysis_sets = network_insights_analysis_sets  # type: DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSets
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.network_insights_analysis_sets:
            self.network_insights_analysis_sets.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_insights_analysis_sets is not None:
            result['NetworkInsightsAnalysisSets'] = self.network_insights_analysis_sets.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkInsightsAnalysisSets') is not None:
            temp_model = DescribeNetworkInsightsAnalysisesResponseBodyNetworkInsightsAnalysisSets()
            self.network_insights_analysis_sets = temp_model.from_map(m['NetworkInsightsAnalysisSets'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNetworkInsightsAnalysisesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeNetworkInsightsAnalysisesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsAnalysisesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkInsightsAnalysisesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkInsightsPathsRequest(TeaModel):
    def __init__(self, dry_run=None, max_results=None, network_insights_path_id=None, network_path_found=None,
                 next_token=None, region_id=None, resource_owner_id=None, status=None):
        self.dry_run = dry_run  # type: bool
        self.max_results = max_results  # type: int
        self.network_insights_path_id = network_insights_path_id  # type: list[str]
        self.network_path_found = network_path_found  # type: str
        self.next_token = next_token  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsPathsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.network_path_found is not None:
            result['NetworkPathFound'] = self.network_path_found
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('NetworkPathFound') is not None:
            self.network_path_found = m.get('NetworkPathFound')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSetsNetworkInsightsPathSet(TeaModel):
    def __init__(self, creation_time=None, destination=None, destination_port=None, destination_type=None,
                 network_insights_path_id=None, network_insights_path_name=None, network_path_found=None, protocol=None, source=None,
                 source_type=None, status=None):
        self.creation_time = creation_time  # type: str
        self.destination = destination  # type: str
        self.destination_port = destination_port  # type: str
        self.destination_type = destination_type  # type: str
        self.network_insights_path_id = network_insights_path_id  # type: str
        self.network_insights_path_name = network_insights_path_name  # type: str
        self.network_path_found = network_path_found  # type: str
        self.protocol = protocol  # type: str
        self.source = source  # type: str
        self.source_type = source_type  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSetsNetworkInsightsPathSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_port is not None:
            result['DestinationPort'] = self.destination_port
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.network_insights_path_id is not None:
            result['NetworkInsightsPathId'] = self.network_insights_path_id
        if self.network_insights_path_name is not None:
            result['NetworkInsightsPathName'] = self.network_insights_path_name
        if self.network_path_found is not None:
            result['NetworkPathFound'] = self.network_path_found
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.source is not None:
            result['Source'] = self.source
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationPort') is not None:
            self.destination_port = m.get('DestinationPort')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('NetworkInsightsPathId') is not None:
            self.network_insights_path_id = m.get('NetworkInsightsPathId')
        if m.get('NetworkInsightsPathName') is not None:
            self.network_insights_path_name = m.get('NetworkInsightsPathName')
        if m.get('NetworkPathFound') is not None:
            self.network_path_found = m.get('NetworkPathFound')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSets(TeaModel):
    def __init__(self, network_insights_path_set=None):
        self.network_insights_path_set = network_insights_path_set  # type: list[DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSetsNetworkInsightsPathSet]

    def validate(self):
        if self.network_insights_path_set:
            for k in self.network_insights_path_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkInsightsPathSet'] = []
        if self.network_insights_path_set is not None:
            for k in self.network_insights_path_set:
                result['NetworkInsightsPathSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.network_insights_path_set = []
        if m.get('NetworkInsightsPathSet') is not None:
            for k in m.get('NetworkInsightsPathSet'):
                temp_model = DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSetsNetworkInsightsPathSet()
                self.network_insights_path_set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInsightsPathsResponseBody(TeaModel):
    def __init__(self, max_results=None, network_insights_path_sets=None, next_token=None, request_id=None):
        self.max_results = max_results  # type: int
        self.network_insights_path_sets = network_insights_path_sets  # type: DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSets
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.network_insights_path_sets:
            self.network_insights_path_sets.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsPathsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_insights_path_sets is not None:
            result['NetworkInsightsPathSets'] = self.network_insights_path_sets.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkInsightsPathSets') is not None:
            temp_model = DescribeNetworkInsightsPathsResponseBodyNetworkInsightsPathSets()
            self.network_insights_path_sets = temp_model.from_map(m['NetworkInsightsPathSets'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNetworkInsightsPathsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeNetworkInsightsPathsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeNetworkInsightsPathsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkInsightsPathsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOrderAutoRebootTimeRequest(TeaModel):
    def __init__(self, order_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.order_id = order_id  # type: long
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeOrderAutoRebootTimeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeOrderAutoRebootTimeResponseBodyDescribeOrderAutoRebootTimeInfo(TeaModel):
    def __init__(self, auto_reboot_time=None, instance_id=None, order_id=None):
        self.auto_reboot_time = auto_reboot_time  # type: str
        self.instance_id = instance_id  # type: str
        self.order_id = order_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeOrderAutoRebootTimeResponseBodyDescribeOrderAutoRebootTimeInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_reboot_time is not None:
            result['AutoRebootTime'] = self.auto_reboot_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRebootTime') is not None:
            self.auto_reboot_time = m.get('AutoRebootTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class DescribeOrderAutoRebootTimeResponseBody(TeaModel):
    def __init__(self, describe_order_auto_reboot_time_info=None, request_id=None):
        self.describe_order_auto_reboot_time_info = describe_order_auto_reboot_time_info  # type: DescribeOrderAutoRebootTimeResponseBodyDescribeOrderAutoRebootTimeInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.describe_order_auto_reboot_time_info:
            self.describe_order_auto_reboot_time_info.validate()

    def to_map(self):
        _map = super(DescribeOrderAutoRebootTimeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.describe_order_auto_reboot_time_info is not None:
            result['DescribeOrderAutoRebootTimeInfo'] = self.describe_order_auto_reboot_time_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DescribeOrderAutoRebootTimeInfo') is not None:
            temp_model = DescribeOrderAutoRebootTimeResponseBodyDescribeOrderAutoRebootTimeInfo()
            self.describe_order_auto_reboot_time_info = temp_model.from_map(m['DescribeOrderAutoRebootTimeInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOrderAutoRebootTimeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeOrderAutoRebootTimeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeOrderAutoRebootTimeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOrderAutoRebootTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrePaidResourceRefundPriceRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_id=None,
                 resource_owner_account=None, resource_owner_id=None, resource_type=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrePaidResourceRefundPriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribePrePaidResourceRefundPriceResponseBody(TeaModel):
    def __init__(self, currency=None, refunds=None, request_id=None):
        self.currency = currency  # type: str
        self.refunds = refunds  # type: float
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrePaidResourceRefundPriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.refunds is not None:
            result['Refunds'] = self.refunds
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('Refunds') is not None:
            self.refunds = m.get('Refunds')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePrePaidResourceRefundPriceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePrePaidResourceRefundPriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePrePaidResourceRefundPriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrePaidResourceRefundPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePriceRequest(TeaModel):
    def __init__(self, business_info=None, commodity=None, default_vpc=None, from_app=None, need_spot_price=None,
                 network_type=None, order_type=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, verbose=None):
        self.business_info = business_info  # type: str
        self.commodity = commodity  # type: str
        self.default_vpc = default_vpc  # type: str
        self.from_app = from_app  # type: str
        self.need_spot_price = need_spot_price  # type: bool
        self.network_type = network_type  # type: str
        self.order_type = order_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.verbose = verbose  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_info is not None:
            result['BusinessInfo'] = self.business_info
        if self.commodity is not None:
            result['Commodity'] = self.commodity
        if self.default_vpc is not None:
            result['DefaultVpc'] = self.default_vpc
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.need_spot_price is not None:
            result['NeedSpotPrice'] = self.need_spot_price
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.verbose is not None:
            result['Verbose'] = self.verbose
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessInfo') is not None:
            self.business_info = m.get('BusinessInfo')
        if m.get('Commodity') is not None:
            self.commodity = m.get('Commodity')
        if m.get('DefaultVpc') is not None:
            self.default_vpc = m.get('DefaultVpc')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('NeedSpotPrice') is not None:
            self.need_spot_price = m.get('NeedSpotPrice')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Verbose') is not None:
            self.verbose = m.get('Verbose')
        return self


class DescribePriceResponseBodyPriceInfoOrderCouponsCoupon(TeaModel):
    def __init__(self, coupon_no=None, description=None, discount_off=None, is_selected=None, name=None):
        self.coupon_no = coupon_no  # type: str
        self.description = description  # type: str
        self.discount_off = discount_off  # type: float
        self.is_selected = is_selected  # type: bool
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderCouponsCoupon, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coupon_no is not None:
            result['CouponNo'] = self.coupon_no
        if self.description is not None:
            result['Description'] = self.description
        if self.discount_off is not None:
            result['DiscountOff'] = self.discount_off
        if self.is_selected is not None:
            result['IsSelected'] = self.is_selected
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CouponNo') is not None:
            self.coupon_no = m.get('CouponNo')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiscountOff') is not None:
            self.discount_off = m.get('DiscountOff')
        if m.get('IsSelected') is not None:
            self.is_selected = m.get('IsSelected')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePriceResponseBodyPriceInfoOrderCoupons(TeaModel):
    def __init__(self, coupon=None):
        self.coupon = coupon  # type: list[DescribePriceResponseBodyPriceInfoOrderCouponsCoupon]

    def validate(self):
        if self.coupon:
            for k in self.coupon:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderCoupons, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Coupon'] = []
        if self.coupon is not None:
            for k in self.coupon:
                result['Coupon'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.coupon = []
        if m.get('Coupon') is not None:
            for k in m.get('Coupon'):
                temp_model = DescribePriceResponseBodyPriceInfoOrderCouponsCoupon()
                self.coupon.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRulesRule(TeaModel):
    def __init__(self, name=None, rule_id=None, title=None):
        self.name = name  # type: str
        self.rule_id = rule_id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRulesRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule  # type: list[DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRulesRule]

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModel(TeaModel):
    def __init__(self, discount_price=None, original_price=None, resource=None, sub_rules=None, trade_price=None):
        self.discount_price = discount_price  # type: float
        self.original_price = original_price  # type: float
        self.resource = resource  # type: str
        self.sub_rules = sub_rules  # type: DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRules
        self.trade_price = trade_price  # type: float

    def validate(self):
        if self.sub_rules:
            self.sub_rules.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.resource is not None:
            result['Resource'] = self.resource
        if self.sub_rules is not None:
            result['SubRules'] = self.sub_rules.to_map()
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        if m.get('SubRules') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModelSubRules()
            self.sub_rules = temp_model.from_map(m['SubRules'])
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribePriceResponseBodyPriceInfoOrderDetailInfos(TeaModel):
    def __init__(self, resource_price_model=None):
        self.resource_price_model = resource_price_model  # type: list[DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModel]

    def validate(self):
        if self.resource_price_model:
            for k in self.resource_price_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderDetailInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourcePriceModel'] = []
        if self.resource_price_model is not None:
            for k in self.resource_price_model:
                result['ResourcePriceModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource_price_model = []
        if m.get('ResourcePriceModel') is not None:
            for k in m.get('ResourcePriceModel'):
                temp_model = DescribePriceResponseBodyPriceInfoOrderDetailInfosResourcePriceModel()
                self.resource_price_model.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfoOrderRuleIdSet(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderRuleIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrderRuleIdSet(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrderRuleIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrder(TeaModel):
    def __init__(self, discount_price=None, instance_id=None, original_price=None, rule_id_set=None,
                 trade_price=None):
        self.discount_price = discount_price  # type: float
        self.instance_id = instance_id  # type: str
        self.original_price = original_price  # type: float
        self.rule_id_set = rule_id_set  # type: DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrderRuleIdSet
        self.trade_price = trade_price  # type: float

    def validate(self):
        if self.rule_id_set:
            self.rule_id_set.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrder, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.rule_id_set is not None:
            result['RuleIdSet'] = self.rule_id_set.to_map()
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('RuleIdSet') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrderRuleIdSet()
            self.rule_id_set = temp_model.from_map(m['RuleIdSet'])
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribePriceResponseBodyPriceInfoOrderSubOrders(TeaModel):
    def __init__(self, sub_order=None):
        self.sub_order = sub_order  # type: list[DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrder]

    def validate(self):
        if self.sub_order:
            for k in self.sub_order:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderSubOrders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubOrder'] = []
        if self.sub_order is not None:
            for k in self.sub_order:
                result['SubOrder'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_order = []
        if m.get('SubOrder') is not None:
            for k in m.get('SubOrder'):
                temp_model = DescribePriceResponseBodyPriceInfoOrderSubOrdersSubOrder()
                self.sub_order.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfoOrder(TeaModel):
    def __init__(self, coupons=None, currency=None, detail_infos=None, discount_price=None, original_price=None,
                 rule_id_set=None, spot_instance_type_original_price=None, spot_instance_type_price=None, sub_orders=None,
                 trade_price=None):
        self.coupons = coupons  # type: DescribePriceResponseBodyPriceInfoOrderCoupons
        self.currency = currency  # type: str
        self.detail_infos = detail_infos  # type: DescribePriceResponseBodyPriceInfoOrderDetailInfos
        self.discount_price = discount_price  # type: float
        self.original_price = original_price  # type: float
        self.rule_id_set = rule_id_set  # type: DescribePriceResponseBodyPriceInfoOrderRuleIdSet
        self.spot_instance_type_original_price = spot_instance_type_original_price  # type: float
        self.spot_instance_type_price = spot_instance_type_price  # type: float
        self.sub_orders = sub_orders  # type: DescribePriceResponseBodyPriceInfoOrderSubOrders
        self.trade_price = trade_price  # type: float

    def validate(self):
        if self.coupons:
            self.coupons.validate()
        if self.detail_infos:
            self.detail_infos.validate()
        if self.rule_id_set:
            self.rule_id_set.validate()
        if self.sub_orders:
            self.sub_orders.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrder, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coupons is not None:
            result['Coupons'] = self.coupons.to_map()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.detail_infos is not None:
            result['DetailInfos'] = self.detail_infos.to_map()
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.rule_id_set is not None:
            result['RuleIdSet'] = self.rule_id_set.to_map()
        if self.spot_instance_type_original_price is not None:
            result['SpotInstanceTypeOriginalPrice'] = self.spot_instance_type_original_price
        if self.spot_instance_type_price is not None:
            result['SpotInstanceTypePrice'] = self.spot_instance_type_price
        if self.sub_orders is not None:
            result['SubOrders'] = self.sub_orders.to_map()
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Coupons') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderCoupons()
            self.coupons = temp_model.from_map(m['Coupons'])
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DetailInfos') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderDetailInfos()
            self.detail_infos = temp_model.from_map(m['DetailInfos'])
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('RuleIdSet') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderRuleIdSet()
            self.rule_id_set = temp_model.from_map(m['RuleIdSet'])
        if m.get('SpotInstanceTypeOriginalPrice') is not None:
            self.spot_instance_type_original_price = m.get('SpotInstanceTypeOriginalPrice')
        if m.get('SpotInstanceTypePrice') is not None:
            self.spot_instance_type_price = m.get('SpotInstanceTypePrice')
        if m.get('SubOrders') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderSubOrders()
            self.sub_orders = temp_model.from_map(m['SubOrders'])
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribePriceResponseBodyPriceInfoOrderParams(TeaModel):
    def __init__(self, order_param=None):
        self.order_param = order_param  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoOrderParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_param is not None:
            result['OrderParam'] = self.order_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderParam') is not None:
            self.order_param = m.get('OrderParam')
        return self


class DescribePriceResponseBodyPriceInfoPriceWarning(TeaModel):
    def __init__(self, code=None, msg=None):
        self.code = code  # type: str
        self.msg = msg  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoPriceWarning, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.msg is not None:
            result['Msg'] = self.msg
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        return self


class DescribePriceResponseBodyPriceInfoRulesRule(TeaModel):
    def __init__(self, name=None, rule_id=None, title=None):
        self.name = name  # type: str
        self.rule_id = rule_id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoRulesRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribePriceResponseBodyPriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule  # type: list[DescribePriceResponseBodyPriceInfoRulesRule]

    def validate(self):
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfoRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule = []
        if m.get('Rule') is not None:
            for k in m.get('Rule'):
                temp_model = DescribePriceResponseBodyPriceInfoRulesRule()
                self.rule.append(temp_model.from_map(k))
        return self


class DescribePriceResponseBodyPriceInfo(TeaModel):
    def __init__(self, order=None, order_params=None, price_warning=None, rules=None):
        self.order = order  # type: DescribePriceResponseBodyPriceInfoOrder
        self.order_params = order_params  # type: DescribePriceResponseBodyPriceInfoOrderParams
        self.price_warning = price_warning  # type: DescribePriceResponseBodyPriceInfoPriceWarning
        self.rules = rules  # type: DescribePriceResponseBodyPriceInfoRules

    def validate(self):
        if self.order:
            self.order.validate()
        if self.order_params:
            self.order_params.validate()
        if self.price_warning:
            self.price_warning.validate()
        if self.rules:
            self.rules.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBodyPriceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        if self.order_params is not None:
            result['OrderParams'] = self.order_params.to_map()
        if self.price_warning is not None:
            result['PriceWarning'] = self.price_warning.to_map()
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrder()
            self.order = temp_model.from_map(m['Order'])
        if m.get('OrderParams') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoOrderParams()
            self.order_params = temp_model.from_map(m['OrderParams'])
        if m.get('PriceWarning') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoPriceWarning()
            self.price_warning = temp_model.from_map(m['PriceWarning'])
        if m.get('Rules') is not None:
            temp_model = DescribePriceResponseBodyPriceInfoRules()
            self.rules = temp_model.from_map(m['Rules'])
        return self


class DescribePriceResponseBody(TeaModel):
    def __init__(self, price_info=None, request_id=None):
        self.price_info = price_info  # type: DescribePriceResponseBodyPriceInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super(DescribePriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribePriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePriceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrivatePoolsRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None, type=None):
        self.ids = ids  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrivatePoolsRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePrivatePoolsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrivatePoolsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribePrivatePoolsRequest(TeaModel):
    def __init__(self, private_pool_options=None, instance_charge_type=None, instance_type=None, max_results=None,
                 next_token=None, owner_account=None, owner_id=None, platform=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, start_time_type=None, status=None, tag=None, zone_id=None):
        self.private_pool_options = private_pool_options  # type: DescribePrivatePoolsRequestPrivatePoolOptions
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time_type = start_time_type  # type: str
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribePrivatePoolsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time_type is not None:
            result['StartTimeType'] = self.start_time_type
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = DescribePrivatePoolsRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTimeType') is not None:
            self.start_time_type = m.get('StartTimeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribePrivatePoolsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, instance_type=None, total_amount=None, used_amount=None, zone_id=None):
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResourcesAllocatedResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: list[DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResourcesAllocatedResource]

    def validate(self):
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.allocated_resource = []
        if m.get('AllocatedResource') is not None:
            for k in m.get('AllocatedResource'):
                temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItem(TeaModel):
    def __init__(self, allocated_resources=None, description=None, end_time=None, end_time_type=None,
                 instance_charge_type=None, latest_start_time=None, platform=None, private_pool_options_id=None,
                 private_pool_options_match_criteria=None, private_pool_options_name=None, private_pool_options_type=None, region_id=None,
                 resource_group_id=None, start_time=None, start_time_type=None, status=None, tags=None, total_assurance_times=None,
                 used_assurance_times=None):
        self.allocated_resources = allocated_resources  # type: DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResources
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.end_time_type = end_time_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.latest_start_time = latest_start_time  # type: str
        self.platform = platform  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.private_pool_options_type = private_pool_options_type  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.start_time = start_time  # type: str
        self.start_time_type = start_time_type  # type: str
        self.status = status  # type: str
        self.tags = tags  # type: DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTags
        self.total_assurance_times = total_assurance_times  # type: str
        self.used_assurance_times = used_assurance_times  # type: int

    def validate(self):
        if self.allocated_resources:
            self.allocated_resources.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.latest_start_time is not None:
            result['LatestStartTime'] = self.latest_start_time
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        if self.private_pool_options_name is not None:
            result['PrivatePoolOptionsName'] = self.private_pool_options_name
        if self.private_pool_options_type is not None:
            result['PrivatePoolOptionsType'] = self.private_pool_options_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_time_type is not None:
            result['StartTimeType'] = self.start_time_type
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.total_assurance_times is not None:
            result['TotalAssuranceTimes'] = self.total_assurance_times
        if self.used_assurance_times is not None:
            result['UsedAssuranceTimes'] = self.used_assurance_times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocatedResources') is not None:
            temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(m['AllocatedResources'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimeType') is not None:
            self.end_time_type = m.get('EndTimeType')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('LatestStartTime') is not None:
            self.latest_start_time = m.get('LatestStartTime')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = m.get('PrivatePoolOptionsMatchCriteria')
        if m.get('PrivatePoolOptionsName') is not None:
            self.private_pool_options_name = m.get('PrivatePoolOptionsName')
        if m.get('PrivatePoolOptionsType') is not None:
            self.private_pool_options_type = m.get('PrivatePoolOptionsType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimeType') is not None:
            self.start_time_type = m.get('StartTimeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItemTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TotalAssuranceTimes') is not None:
            self.total_assurance_times = m.get('TotalAssuranceTimes')
        if m.get('UsedAssuranceTimes') is not None:
            self.used_assurance_times = m.get('UsedAssuranceTimes')
        return self


class DescribePrivatePoolsResponseBodyPrivatePoolSet(TeaModel):
    def __init__(self, private_pool_item=None):
        self.private_pool_item = private_pool_item  # type: list[DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItem]

    def validate(self):
        if self.private_pool_item:
            for k in self.private_pool_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBodyPrivatePoolSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrivatePoolItem'] = []
        if self.private_pool_item is not None:
            for k in self.private_pool_item:
                result['PrivatePoolItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.private_pool_item = []
        if m.get('PrivatePoolItem') is not None:
            for k in m.get('PrivatePoolItem'):
                temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSetPrivatePoolItem()
                self.private_pool_item.append(temp_model.from_map(k))
        return self


class DescribePrivatePoolsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, private_pool_set=None, request_id=None, total_count=None):
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.private_pool_set = private_pool_set  # type: DescribePrivatePoolsResponseBodyPrivatePoolSet
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.private_pool_set:
            self.private_pool_set.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.private_pool_set is not None:
            result['PrivatePoolSet'] = self.private_pool_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PrivatePoolSet') is not None:
            temp_model = DescribePrivatePoolsResponseBodyPrivatePoolSet()
            self.private_pool_set = temp_model.from_map(m['PrivatePoolSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePrivatePoolsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePrivatePoolsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePrivatePoolsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrivatePoolsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecommendProductRequest(TeaModel):
    def __init__(self, amount=None, cores=None, instance_charge_type=None, instance_family_level=None,
                 instance_type=None, instance_type_family=None, instance_type_support_ipv_6=None, io_optimized=None,
                 max_price=None, memory=None, network_type=None, owner_account=None, owner_id=None, priority_strategy=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, spot_strategy=None,
                 system_disk_category=None, zone_id=None, zone_match_mode=None):
        self.amount = amount  # type: int
        self.cores = cores  # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_family_level = instance_family_level  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: list[str]
        self.instance_type_support_ipv_6 = instance_type_support_ipv_6  # type: bool
        self.io_optimized = io_optimized  # type: str
        self.max_price = max_price  # type: float
        self.memory = memory  # type: float
        self.network_type = network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.priority_strategy = priority_strategy  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.spot_strategy = spot_strategy  # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.zone_id = zone_id  # type: str
        self.zone_match_mode = zone_match_mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecommendProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.instance_type_support_ipv_6 is not None:
            result['InstanceTypeSupportIPv6'] = self.instance_type_support_ipv_6
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority_strategy is not None:
            result['PriorityStrategy'] = self.priority_strategy
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_match_mode is not None:
            result['ZoneMatchMode'] = self.zone_match_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('InstanceTypeSupportIPv6') is not None:
            self.instance_type_support_ipv_6 = m.get('InstanceTypeSupportIPv6')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PriorityStrategy') is not None:
            self.priority_strategy = m.get('PriorityStrategy')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneMatchMode') is not None:
            self.zone_match_mode = m.get('ZoneMatchMode')
        return self


class DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceTypeInstanceType(TeaModel):
    def __init__(self, cores=None, generation=None, instance_family_level=None, instance_type=None,
                 instance_type_family=None, memory=None, support_io_optimized=None):
        self.cores = cores  # type: int
        self.generation = generation  # type: str
        self.instance_family_level = instance_family_level  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.memory = memory  # type: int
        self.support_io_optimized = support_io_optimized  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceTypeInstanceType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.generation is not None:
            result['Generation'] = self.generation
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.support_io_optimized is not None:
            result['SupportIoOptimized'] = self.support_io_optimized
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('Generation') is not None:
            self.generation = m.get('Generation')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('SupportIoOptimized') is not None:
            self.support_io_optimized = m.get('SupportIoOptimized')
        return self


class DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceType(TeaModel):
    def __init__(self, capacity_specification=None, instance_charge_type=None, instance_type=None,
                 network_type=None, price=None, priority=None, spot_strategy=None):
        self.capacity_specification = capacity_specification  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceTypeInstanceType
        self.network_type = network_type  # type: str
        self.price = price  # type: float
        self.priority = priority  # type: int
        self.spot_strategy = spot_strategy  # type: str

    def validate(self):
        if self.instance_type:
            self.instance_type.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_specification is not None:
            result['CapacitySpecification'] = self.capacity_specification
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type.to_map()
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.price is not None:
            result['Price'] = self.price
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacitySpecification') is not None:
            self.capacity_specification = m.get('CapacitySpecification')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            temp_model = DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceTypeInstanceType()
            self.instance_type = temp_model.from_map(m['InstanceType'])
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Price') is not None:
            self.price = m.get('Price')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        return self


class DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypes(TeaModel):
    def __init__(self, recommend_instance_type=None):
        self.recommend_instance_type = recommend_instance_type  # type: list[DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceType]

    def validate(self):
        if self.recommend_instance_type:
            for k in self.recommend_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecommendInstanceType'] = []
        if self.recommend_instance_type is not None:
            for k in self.recommend_instance_type:
                result['RecommendInstanceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.recommend_instance_type = []
        if m.get('RecommendInstanceType') is not None:
            for k in m.get('RecommendInstanceType'):
                temp_model = DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypesRecommendInstanceType()
                self.recommend_instance_type.append(temp_model.from_map(k))
        return self


class DescribeRecommendProductResponseBodyRecommendProductsRecommendProduct(TeaModel):
    def __init__(self, recommend_instance_types=None, zone_id=None):
        self.recommend_instance_types = recommend_instance_types  # type: DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypes
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.recommend_instance_types:
            self.recommend_instance_types.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBodyRecommendProductsRecommendProduct, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recommend_instance_types is not None:
            result['RecommendInstanceTypes'] = self.recommend_instance_types.to_map()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecommendInstanceTypes') is not None:
            temp_model = DescribeRecommendProductResponseBodyRecommendProductsRecommendProductRecommendInstanceTypes()
            self.recommend_instance_types = temp_model.from_map(m['RecommendInstanceTypes'])
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeRecommendProductResponseBodyRecommendProducts(TeaModel):
    def __init__(self, recommend_product=None):
        self.recommend_product = recommend_product  # type: list[DescribeRecommendProductResponseBodyRecommendProductsRecommendProduct]

    def validate(self):
        if self.recommend_product:
            for k in self.recommend_product:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBodyRecommendProducts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecommendProduct'] = []
        if self.recommend_product is not None:
            for k in self.recommend_product:
                result['RecommendProduct'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.recommend_product = []
        if m.get('RecommendProduct') is not None:
            for k in m.get('RecommendProduct'):
                temp_model = DescribeRecommendProductResponseBodyRecommendProductsRecommendProduct()
                self.recommend_product.append(temp_model.from_map(k))
        return self


class DescribeRecommendProductResponseBody(TeaModel):
    def __init__(self, recommend_products=None, request_id=None):
        self.recommend_products = recommend_products  # type: DescribeRecommendProductResponseBodyRecommendProducts
        self.request_id = request_id  # type: str

    def validate(self):
        if self.recommend_products:
            self.recommend_products.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recommend_products is not None:
            result['RecommendProducts'] = self.recommend_products.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecommendProducts') is not None:
            temp_model = DescribeRecommendProductResponseBodyRecommendProducts()
            self.recommend_products = temp_model.from_map(m['RecommendProducts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRecommendProductResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeRecommendProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRecommendProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecommendProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservationDemandCommittedAmountRequestDemandPlan(TeaModel):
    def __init__(self, amount=None, instance_type=None):
        self.amount = amount  # type: long
        self.instance_type = instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservationDemandCommittedAmountRequestDemandPlan, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeReservationDemandCommittedAmountRequest(TeaModel):
    def __init__(self, demand_plan=None, instance_family=None, instance_family_set=None, offering_type=None,
                 owner_account=None, owner_id=None, period=None, period_unit=None, plan_type=None, platform=None,
                 purchase_method=None, region_id=None, resource_owner_account=None):
        self.demand_plan = demand_plan  # type: list[DescribeReservationDemandCommittedAmountRequestDemandPlan]
        self.instance_family = instance_family  # type: str
        self.instance_family_set = instance_family_set  # type: str
        self.offering_type = offering_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.plan_type = plan_type  # type: str
        self.platform = platform  # type: str
        self.purchase_method = purchase_method  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str

    def validate(self):
        if self.demand_plan:
            for k in self.demand_plan:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandCommittedAmountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DemandPlan'] = []
        if self.demand_plan is not None:
            for k in self.demand_plan:
                result['DemandPlan'].append(k.to_map() if k else None)
        if self.instance_family is not None:
            result['InstanceFamily'] = self.instance_family
        if self.instance_family_set is not None:
            result['InstanceFamilySet'] = self.instance_family_set
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.purchase_method is not None:
            result['PurchaseMethod'] = self.purchase_method
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.demand_plan = []
        if m.get('DemandPlan') is not None:
            for k in m.get('DemandPlan'):
                temp_model = DescribeReservationDemandCommittedAmountRequestDemandPlan()
                self.demand_plan.append(temp_model.from_map(k))
        if m.get('InstanceFamily') is not None:
            self.instance_family = m.get('InstanceFamily')
        if m.get('InstanceFamilySet') is not None:
            self.instance_family_set = m.get('InstanceFamilySet')
        if m.get('OfferingType') is not None:
            self.offering_type = m.get('OfferingType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('PurchaseMethod') is not None:
            self.purchase_method = m.get('PurchaseMethod')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class DescribeReservationDemandCommittedAmountResponseBodyCommittedAmountInfo(TeaModel):
    def __init__(self, committed_amount=None, currency=None):
        self.committed_amount = committed_amount  # type: float
        self.currency = currency  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservationDemandCommittedAmountResponseBodyCommittedAmountInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.committed_amount is not None:
            result['CommittedAmount'] = self.committed_amount
        if self.currency is not None:
            result['Currency'] = self.currency
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommittedAmount') is not None:
            self.committed_amount = m.get('CommittedAmount')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        return self


class DescribeReservationDemandCommittedAmountResponseBody(TeaModel):
    def __init__(self, committed_amount_info=None, request_id=None):
        self.committed_amount_info = committed_amount_info  # type: DescribeReservationDemandCommittedAmountResponseBodyCommittedAmountInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.committed_amount_info:
            self.committed_amount_info.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandCommittedAmountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.committed_amount_info is not None:
            result['CommittedAmountInfo'] = self.committed_amount_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommittedAmountInfo') is not None:
            temp_model = DescribeReservationDemandCommittedAmountResponseBodyCommittedAmountInfo()
            self.committed_amount_info = temp_model.from_map(m['CommittedAmountInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeReservationDemandCommittedAmountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservationDemandCommittedAmountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandCommittedAmountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservationDemandCommittedAmountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservationDemandsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservationDemandsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeReservationDemandsRequest(TeaModel):
    def __init__(self, demand_id=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 page_number=None, page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 status=None, tag=None):
        self.demand_id = demand_id  # type: list[str]
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeReservationDemandsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservationDemandsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResourceCapacityReservations(TeaModel):
    def __init__(self, instance_amount=None, instance_type=None, match_criteria=None, plan_id=None,
                 private_pool_options_id=None, start_time=None, status=None, zone_id=None):
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.match_criteria = match_criteria  # type: str
        self.plan_id = plan_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResourceCapacityReservations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResource(TeaModel):
    def __init__(self, capacity_reservations=None):
        self.capacity_reservations = capacity_reservations  # type: list[DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResourceCapacityReservations]

    def validate(self):
        if self.capacity_reservations:
            for k in self.capacity_reservations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CapacityReservations'] = []
        if self.capacity_reservations is not None:
            for k in self.capacity_reservations:
                result['CapacityReservations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.capacity_reservations = []
        if m.get('CapacityReservations') is not None:
            for k in m.get('CapacityReservations'):
                temp_model = DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResourceCapacityReservations()
                self.capacity_reservations.append(temp_model.from_map(k))
        return self


class DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResourceCapacityReservations(TeaModel):
    def __init__(self, approve_code=None, approve_notes=None, instance_amount=None, instance_type=None,
                 match_criteria=None, plan_id=None, private_pool_options_id=None, start_time=None, status=None, zone_id=None):
        self.approve_code = approve_code  # type: str
        self.approve_notes = approve_notes  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.match_criteria = match_criteria  # type: str
        self.plan_id = plan_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResourceCapacityReservations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_code is not None:
            result['ApproveCode'] = self.approve_code
        if self.approve_notes is not None:
            result['ApproveNotes'] = self.approve_notes
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApproveCode') is not None:
            self.approve_code = m.get('ApproveCode')
        if m.get('ApproveNotes') is not None:
            self.approve_notes = m.get('ApproveNotes')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResource(TeaModel):
    def __init__(self, capacity_reservations=None):
        self.capacity_reservations = capacity_reservations  # type: list[DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResourceCapacityReservations]

    def validate(self):
        if self.capacity_reservations:
            for k in self.capacity_reservations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CapacityReservations'] = []
        if self.capacity_reservations is not None:
            for k in self.capacity_reservations:
                result['CapacityReservations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.capacity_reservations = []
        if m.get('CapacityReservations') is not None:
            for k in m.get('CapacityReservations'):
                temp_model = DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResourceCapacityReservations()
                self.capacity_reservations.append(temp_model.from_map(k))
        return self


class DescribeReservationDemandsResponseBodyDataDemandOrders(TeaModel):
    def __init__(self, confirm_type=None, coupon_auto=None, coupon_type=None, demand_id=None, description=None,
                 instance_charge_type=None, instance_cpu_core_count=None, instance_types=None, match_criteria=None, name=None,
                 period=None, period_unit=None, phone_number=None, platform=None, product_type=None,
                 recommend_resource=None, region_id=None, reservation_resource=None, reserved_instance_description=None,
                 reserved_instance_id=None, reserved_instance_name=None, reserved_instance_offering_type=None,
                 resource_supply_type=None, saving_plan_description=None, saving_plan_hour_fee=None, saving_plan_id=None,
                 saving_plan_instance_type_family_group=None, saving_plan_name=None, saving_plan_pay_mode=None, saving_plan_saving_type=None,
                 saving_plan_spec_type=None, start_time=None, status=None, zone_ids=None):
        self.confirm_type = confirm_type  # type: str
        self.coupon_auto = coupon_auto  # type: str
        self.coupon_type = coupon_type  # type: str
        self.demand_id = demand_id  # type: str
        self.description = description  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.instance_types = instance_types  # type: str
        self.match_criteria = match_criteria  # type: str
        self.name = name  # type: str
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.phone_number = phone_number  # type: str
        self.platform = platform  # type: str
        self.product_type = product_type  # type: str
        self.recommend_resource = recommend_resource  # type: DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResource
        self.region_id = region_id  # type: str
        self.reservation_resource = reservation_resource  # type: DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResource
        self.reserved_instance_description = reserved_instance_description  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.reserved_instance_offering_type = reserved_instance_offering_type  # type: str
        self.resource_supply_type = resource_supply_type  # type: str
        self.saving_plan_description = saving_plan_description  # type: str
        self.saving_plan_hour_fee = saving_plan_hour_fee  # type: float
        self.saving_plan_id = saving_plan_id  # type: str
        self.saving_plan_instance_type_family_group = saving_plan_instance_type_family_group  # type: str
        self.saving_plan_name = saving_plan_name  # type: str
        self.saving_plan_pay_mode = saving_plan_pay_mode  # type: str
        self.saving_plan_saving_type = saving_plan_saving_type  # type: str
        self.saving_plan_spec_type = saving_plan_spec_type  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.zone_ids = zone_ids  # type: str

    def validate(self):
        if self.recommend_resource:
            self.recommend_resource.validate()
        if self.reservation_resource:
            self.reservation_resource.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyDataDemandOrders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confirm_type is not None:
            result['ConfirmType'] = self.confirm_type
        if self.coupon_auto is not None:
            result['CouponAuto'] = self.coupon_auto
        if self.coupon_type is not None:
            result['CouponType'] = self.coupon_type
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.name is not None:
            result['Name'] = self.name
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.recommend_resource is not None:
            result['RecommendResource'] = self.recommend_resource.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reservation_resource is not None:
            result['ReservationResource'] = self.reservation_resource.to_map()
        if self.reserved_instance_description is not None:
            result['ReservedInstanceDescription'] = self.reserved_instance_description
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.reserved_instance_offering_type is not None:
            result['ReservedInstanceOfferingType'] = self.reserved_instance_offering_type
        if self.resource_supply_type is not None:
            result['ResourceSupplyType'] = self.resource_supply_type
        if self.saving_plan_description is not None:
            result['SavingPlanDescription'] = self.saving_plan_description
        if self.saving_plan_hour_fee is not None:
            result['SavingPlanHourFee'] = self.saving_plan_hour_fee
        if self.saving_plan_id is not None:
            result['SavingPlanId'] = self.saving_plan_id
        if self.saving_plan_instance_type_family_group is not None:
            result['SavingPlanInstanceTypeFamilyGroup'] = self.saving_plan_instance_type_family_group
        if self.saving_plan_name is not None:
            result['SavingPlanName'] = self.saving_plan_name
        if self.saving_plan_pay_mode is not None:
            result['SavingPlanPayMode'] = self.saving_plan_pay_mode
        if self.saving_plan_saving_type is not None:
            result['SavingPlanSavingType'] = self.saving_plan_saving_type
        if self.saving_plan_spec_type is not None:
            result['SavingPlanSpecType'] = self.saving_plan_spec_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_ids is not None:
            result['ZoneIds'] = self.zone_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfirmType') is not None:
            self.confirm_type = m.get('ConfirmType')
        if m.get('CouponAuto') is not None:
            self.coupon_auto = m.get('CouponAuto')
        if m.get('CouponType') is not None:
            self.coupon_type = m.get('CouponType')
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = m.get('InstanceCpuCoreCount')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RecommendResource') is not None:
            temp_model = DescribeReservationDemandsResponseBodyDataDemandOrdersRecommendResource()
            self.recommend_resource = temp_model.from_map(m['RecommendResource'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservationResource') is not None:
            temp_model = DescribeReservationDemandsResponseBodyDataDemandOrdersReservationResource()
            self.reservation_resource = temp_model.from_map(m['ReservationResource'])
        if m.get('ReservedInstanceDescription') is not None:
            self.reserved_instance_description = m.get('ReservedInstanceDescription')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = m.get('ReservedInstanceName')
        if m.get('ReservedInstanceOfferingType') is not None:
            self.reserved_instance_offering_type = m.get('ReservedInstanceOfferingType')
        if m.get('ResourceSupplyType') is not None:
            self.resource_supply_type = m.get('ResourceSupplyType')
        if m.get('SavingPlanDescription') is not None:
            self.saving_plan_description = m.get('SavingPlanDescription')
        if m.get('SavingPlanHourFee') is not None:
            self.saving_plan_hour_fee = m.get('SavingPlanHourFee')
        if m.get('SavingPlanId') is not None:
            self.saving_plan_id = m.get('SavingPlanId')
        if m.get('SavingPlanInstanceTypeFamilyGroup') is not None:
            self.saving_plan_instance_type_family_group = m.get('SavingPlanInstanceTypeFamilyGroup')
        if m.get('SavingPlanName') is not None:
            self.saving_plan_name = m.get('SavingPlanName')
        if m.get('SavingPlanPayMode') is not None:
            self.saving_plan_pay_mode = m.get('SavingPlanPayMode')
        if m.get('SavingPlanSavingType') is not None:
            self.saving_plan_saving_type = m.get('SavingPlanSavingType')
        if m.get('SavingPlanSpecType') is not None:
            self.saving_plan_spec_type = m.get('SavingPlanSpecType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneIds') is not None:
            self.zone_ids = m.get('ZoneIds')
        return self


class DescribeReservationDemandsResponseBodyData(TeaModel):
    def __init__(self, demand_orders=None):
        self.demand_orders = demand_orders  # type: list[DescribeReservationDemandsResponseBodyDataDemandOrders]

    def validate(self):
        if self.demand_orders:
            for k in self.demand_orders:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DemandOrders'] = []
        if self.demand_orders is not None:
            for k in self.demand_orders:
                result['DemandOrders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.demand_orders = []
        if m.get('DemandOrders') is not None:
            for k in m.get('DemandOrders'):
                temp_model = DescribeReservationDemandsResponseBodyDataDemandOrders()
                self.demand_orders.append(temp_model.from_map(k))
        return self


class DescribeReservationDemandsResponseBody(TeaModel):
    def __init__(self, data=None, next_token=None, request_id=None, total_count=None):
        self.data = data  # type: DescribeReservationDemandsResponseBodyData
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeReservationDemandsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeReservationDemandsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservationDemandsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservationDemandsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservationDemandsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservedInstanceAllocationsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeReservedInstanceAllocationsRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 reserved_instance_id=None, resource_owner_account=None, resource_owner_id=None, tag=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeReservedInstanceAllocationsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservedInstanceAllocationsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeReservedInstanceAllocationsResponseBodyAllocationsAllocation(TeaModel):
    def __init__(self, be_allocated_account_id=None, reserved_instance_id=None, resource_owner_id=None):
        self.be_allocated_account_id = be_allocated_account_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.resource_owner_id = resource_owner_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsResponseBodyAllocationsAllocation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.be_allocated_account_id is not None:
            result['BeAllocatedAccountId'] = self.be_allocated_account_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeAllocatedAccountId') is not None:
            self.be_allocated_account_id = m.get('BeAllocatedAccountId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeReservedInstanceAllocationsResponseBodyAllocations(TeaModel):
    def __init__(self, allocation=None):
        self.allocation = allocation  # type: list[DescribeReservedInstanceAllocationsResponseBodyAllocationsAllocation]

    def validate(self):
        if self.allocation:
            for k in self.allocation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsResponseBodyAllocations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Allocation'] = []
        if self.allocation is not None:
            for k in self.allocation:
                result['Allocation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.allocation = []
        if m.get('Allocation') is not None:
            for k in m.get('Allocation'):
                temp_model = DescribeReservedInstanceAllocationsResponseBodyAllocationsAllocation()
                self.allocation.append(temp_model.from_map(k))
        return self


class DescribeReservedInstanceAllocationsResponseBody(TeaModel):
    def __init__(self, allocations=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.allocations = allocations  # type: DescribeReservedInstanceAllocationsResponseBodyAllocations
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.allocations:
            self.allocations.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocations is not None:
            result['Allocations'] = self.allocations.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Allocations') is not None:
            temp_model = DescribeReservedInstanceAllocationsResponseBodyAllocations()
            self.allocations = temp_model.from_map(m['Allocations'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeReservedInstanceAllocationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservedInstanceAllocationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceAllocationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservedInstanceAllocationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservedInstanceCategoriesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeReservedInstanceCategoriesRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, scope=None, tag=None, zone_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.scope = scope  # type: str
        self.tag = tag  # type: list[DescribeReservedInstanceCategoriesRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scope is not None:
            result['Scope'] = self.scope
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservedInstanceCategoriesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategoriesReservedInstanceCategory(TeaModel):
    def __init__(self, amount=None, instance_amount=None, instance_type=None, platform=None, region_id=None,
                 scope=None, zone_id=None):
        self.amount = amount  # type: int
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.scope = scope  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategoriesReservedInstanceCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategories(TeaModel):
    def __init__(self, reserved_instance_category=None):
        self.reserved_instance_category = reserved_instance_category  # type: list[DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategoriesReservedInstanceCategory]

    def validate(self):
        if self.reserved_instance_category:
            for k in self.reserved_instance_category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReservedInstanceCategory'] = []
        if self.reserved_instance_category is not None:
            for k in self.reserved_instance_category:
                result['ReservedInstanceCategory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.reserved_instance_category = []
        if m.get('ReservedInstanceCategory') is not None:
            for k in m.get('ReservedInstanceCategory'):
                temp_model = DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategoriesReservedInstanceCategory()
                self.reserved_instance_category.append(temp_model.from_map(k))
        return self


class DescribeReservedInstanceCategoriesResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, reserved_instance_categories=None,
                 total_count=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.reserved_instance_categories = reserved_instance_categories  # type: DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategories
        self.total_count = total_count  # type: int

    def validate(self):
        if self.reserved_instance_categories:
            self.reserved_instance_categories.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.reserved_instance_categories is not None:
            result['ReservedInstanceCategories'] = self.reserved_instance_categories.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ReservedInstanceCategories') is not None:
            temp_model = DescribeReservedInstanceCategoriesResponseBodyReservedInstanceCategories()
            self.reserved_instance_categories = temp_model.from_map(m['ReservedInstanceCategories'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeReservedInstanceCategoriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservedInstanceCategoriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservedInstanceCategoriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservedInstanceCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservedInstancePriceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstancePriceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeReservedInstancePriceRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 reserved_instance_id=None, resource_owner_account=None, resource_owner_id=None, tag=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: list[str]
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeReservedInstancePriceRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancePriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservedInstancePriceRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancePriceResponseBodyPriceInfoOrder(TeaModel):
    def __init__(self, currency=None, reserved_instance_hour_price=None, trade_price=None):
        self.currency = currency  # type: str
        self.reserved_instance_hour_price = reserved_instance_hour_price  # type: float
        self.trade_price = trade_price  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstancePriceResponseBodyPriceInfoOrder, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.reserved_instance_hour_price is not None:
            result['ReservedInstanceHourPrice'] = self.reserved_instance_hour_price
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('ReservedInstanceHourPrice') is not None:
            self.reserved_instance_hour_price = m.get('ReservedInstanceHourPrice')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class DescribeReservedInstancePriceResponseBodyPriceInfo(TeaModel):
    def __init__(self, order=None):
        self.order = order  # type: DescribeReservedInstancePriceResponseBodyPriceInfoOrder

    def validate(self):
        if self.order:
            self.order.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancePriceResponseBodyPriceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribeReservedInstancePriceResponseBodyPriceInfoOrder()
            self.order = temp_model.from_map(m['Order'])
        return self


class DescribeReservedInstancePriceResponseBody(TeaModel):
    def __init__(self, price_info=None, request_id=None):
        self.price_info = price_info  # type: DescribeReservedInstancePriceResponseBodyPriceInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancePriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PriceInfo') is not None:
            temp_model = DescribeReservedInstancePriceResponseBodyPriceInfo()
            self.price_info = temp_model.from_map(m['PriceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeReservedInstancePriceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservedInstancePriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancePriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservedInstancePriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeReservedInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstancesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeReservedInstancesRequest(TeaModel):
    def __init__(self, allocation_type=None, expired_time=None, instance_type=None, instance_type_family=None,
                 lock_reason=None, offering_type=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 region_id=None, reserved_instance_id=None, reserved_instance_name=None, resource_owner_account=None,
                 resource_owner_id=None, scope=None, status=None, tag=None, zone_id=None):
        self.allocation_type = allocation_type  # type: str
        self.expired_time = expired_time  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.lock_reason = lock_reason  # type: str
        self.offering_type = offering_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: list[str]
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.scope = scope  # type: str
        self.status = status  # type: list[str]
        self.tag = tag  # type: list[DescribeReservedInstancesRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_type is not None:
            result['AllocationType'] = self.allocation_type
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationType') is not None:
            self.allocation_type = m.get('AllocationType')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('OfferingType') is not None:
            self.offering_type = m.get('OfferingType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = m.get('ReservedInstanceName')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservedInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocksOperationLock, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        return self


class DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: list[DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocksOperationLock]

    def validate(self):
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.operation_lock = []
        if m.get('OperationLock') is not None:
            for k in m.get('OperationLock'):
                temp_model = DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancesResponseBodyReservedInstancesReservedInstance(TeaModel):
    def __init__(self, allocation_status=None, creation_time=None, description=None, expired_time=None,
                 instance_amount=None, instance_type=None, offering_type=None, operation_locks=None, platform=None, region_id=None,
                 reserved_instance_id=None, reserved_instance_name=None, resource_group_id=None, scope=None, start_time=None,
                 status=None, tags=None, zone_id=None):
        self.allocation_status = allocation_status  # type: str
        self.creation_time = creation_time  # type: str
        self.description = description  # type: str
        self.expired_time = expired_time  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.offering_type = offering_type  # type: str
        self.operation_locks = operation_locks  # type: DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocks
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.scope = scope  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.tags = tags  # type: DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTags
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.operation_locks:
            self.operation_locks.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstancesReservedInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationStatus') is not None:
            self.allocation_status = m.get('AllocationStatus')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OfferingType') is not None:
            self.offering_type = m.get('OfferingType')
        if m.get('OperationLocks') is not None:
            temp_model = DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceOperationLocks()
            self.operation_locks = temp_model.from_map(m['OperationLocks'])
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = m.get('ReservedInstanceName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeReservedInstancesResponseBodyReservedInstancesReservedInstanceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeReservedInstancesResponseBodyReservedInstances(TeaModel):
    def __init__(self, reserved_instance=None):
        self.reserved_instance = reserved_instance  # type: list[DescribeReservedInstancesResponseBodyReservedInstancesReservedInstance]

    def validate(self):
        if self.reserved_instance:
            for k in self.reserved_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBodyReservedInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReservedInstance'] = []
        if self.reserved_instance is not None:
            for k in self.reserved_instance:
                result['ReservedInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.reserved_instance = []
        if m.get('ReservedInstance') is not None:
            for k in m.get('ReservedInstance'):
                temp_model = DescribeReservedInstancesResponseBodyReservedInstancesReservedInstance()
                self.reserved_instance.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancesResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, reserved_instances=None, total_count=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.reserved_instances = reserved_instances  # type: DescribeReservedInstancesResponseBodyReservedInstances
        self.total_count = total_count  # type: int

    def validate(self):
        if self.reserved_instances:
            self.reserved_instances.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.reserved_instances is not None:
            result['ReservedInstances'] = self.reserved_instances.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ReservedInstances') is not None:
            temp_model = DescribeReservedInstancesResponseBodyReservedInstances()
            self.reserved_instances = temp_model.from_map(m['ReservedInstances'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeReservedInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeReservedInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeReservedInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeReservedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceAggregationsRequestFilter(TeaModel):
    def __init__(self, attribute_name=None, attribute_value=None, operation=None):
        self.attribute_name = attribute_name  # type: str
        self.attribute_value = attribute_value  # type: str
        self.operation = operation  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeResourceAggregationsRequestFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_value is not None:
            result['AttributeValue'] = self.attribute_value
        if self.operation is not None:
            result['Operation'] = self.operation
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValue') is not None:
            self.attribute_value = m.get('AttributeValue')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        return self


class DescribeResourceAggregationsRequestTagFilter(TeaModel):
    def __init__(self, operation=None, tag_key=None, tag_values=None):
        self.operation = operation  # type: str
        self.tag_key = tag_key  # type: str
        self.tag_values = tag_values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeResourceAggregationsRequestTagFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_values is not None:
            result['TagValues'] = self.tag_values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValues') is not None:
            self.tag_values = m.get('TagValues')
        return self


class DescribeResourceAggregationsRequest(TeaModel):
    def __init__(self, aggregators=None, filter=None, global_=None, keyword=None, marker=None, max_items=None,
                 owner_account=None, owner_id=None, product=None, region_id=None, region_no=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, resource_type=None, tag_filter=None):
        self.aggregators = aggregators  # type: list[str]
        self.filter = filter  # type: list[DescribeResourceAggregationsRequestFilter]
        self.global_ = global_  # type: str
        self.keyword = keyword  # type: str
        self.marker = marker  # type: str
        self.max_items = max_items  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.region_no = region_no  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str
        self.tag_filter = tag_filter  # type: list[DescribeResourceAggregationsRequestTagFilter]

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeResourceAggregationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregators is not None:
            result['Aggregators'] = self.aggregators
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.global_ is not None:
            result['Global'] = self.global_
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.marker is not None:
            result['Marker'] = self.marker
        if self.max_items is not None:
            result['MaxItems'] = self.max_items
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Aggregators') is not None:
            self.aggregators = m.get('Aggregators')
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeResourceAggregationsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('Global') is not None:
            self.global_ = m.get('Global')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Marker') is not None:
            self.marker = m.get('Marker')
        if m.get('MaxItems') is not None:
            self.max_items = m.get('MaxItems')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag_filter = []
        if m.get('TagFilter') is not None:
            for k in m.get('TagFilter'):
                temp_model = DescribeResourceAggregationsRequestTagFilter()
                self.tag_filter.append(temp_model.from_map(k))
        return self


class DescribeResourceAggregationsResponseBodyAggregationsAggregation(TeaModel):
    def __init__(self, count=None, keys=None):
        self.count = count  # type: str
        self.keys = keys  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeResourceAggregationsResponseBodyAggregationsAggregation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.keys is not None:
            result['Keys'] = self.keys
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Keys') is not None:
            self.keys = m.get('Keys')
        return self


class DescribeResourceAggregationsResponseBodyAggregations(TeaModel):
    def __init__(self, aggregation=None):
        self.aggregation = aggregation  # type: list[DescribeResourceAggregationsResponseBodyAggregationsAggregation]

    def validate(self):
        if self.aggregation:
            for k in self.aggregation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeResourceAggr