bl_info = {
    "name": "goad-blender",
    "author": "Harry",
    "version": (1, 0, 5),
    "blender": (3, 0, 0),
    "location": "View3D > Sidebar > Custom Panel",
    "description": "An add-on that imports a Rust-backed Python module",
    "category": "Development",
}

import bpy
import sys

def cleanse_modules():
    """search for your plugin modules in blender python sys.modules and remove them"""

    for module_name in sorted(sys.modules.keys()):
        if module_name.startswith(__name__):
            del sys.modules[module_name]

cleanse_modules()

# Import other add-on parts
from . import panel, operators

# Register functions
def register():
    panel.register()
    operators.register()

def unregister():
    panel.unregister()
    operators.unregister()

if __name__ == "__main__":
    register()
