# coding: utf-8

"""
    Vantage

    Vantage API  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@vantage.sh
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vantage.api_client import ApiClient


class CostsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_costs(self, report_id, **kwargs):  # noqa: E501
        """get_costs  # noqa: E501

        Return available Costs for the specified Cost Report and optional time period. If no time period is specified it will return all available costs for the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_costs(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str report_id: (required)
        :param str start_date: Query costs by the first date you would like to filter from. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00.
        :param str end_date: Query costs by the last date you would like to filter to. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00.
        :return: Costs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_costs_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_costs_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def get_costs_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """get_costs  # noqa: E501

        Return available Costs for the specified Cost Report and optional time period. If no time period is specified it will return all available costs for the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_costs_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str report_id: (required)
        :param str start_date: Query costs by the first date you would like to filter from. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00.
        :param str end_date: Query costs by the last date you would like to filter to. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00.
        :return: Costs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_costs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if self.api_client.client_side_validation and ('report_id' not in params or
                                                       params['report_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `report_id` when calling `get_costs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['report_id'] = params['report_id']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v1/reports/{report_id}/costs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Costs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report(self, report_id, **kwargs):  # noqa: E501
        """get_report  # noqa: E501

        Return a Cost Report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str report_id: (required)
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_with_http_info(report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_with_http_info(report_id, **kwargs)  # noqa: E501
            return data

    def get_report_with_http_info(self, report_id, **kwargs):  # noqa: E501
        """get_report  # noqa: E501

        Return a Cost Report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_with_http_info(report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str report_id: (required)
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'report_id' is set
        if self.api_client.client_side_validation and ('report_id' not in params or
                                                       params['report_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `report_id` when calling `get_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'report_id' in params:
            path_params['report_id'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v1/reports/{report_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Report',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reports(self, **kwargs):  # noqa: E501
        """get_reports  # noqa: E501

        Return all Cost Reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Reports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_reports  # noqa: E501

        Return all Cost Reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Reports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v1/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
