# Generated by Django 4.0.6 on 2022-07-28 14:49

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import medux.common.models
import medux.core.fields
import medux.core.models.devices
import medux.core.models.geo
import medux.core.models.medication
import medux.core.models.observations
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("core", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                ("street", models.CharField(blank=True, max_length=255)),
                (
                    "aux_street",
                    models.CharField(
                        blank=True,
                        help_text="hints like postal box directions in CA, or c/o, etc.",
                        max_length=255,
                    ),
                ),
                (
                    "number",
                    models.CharField(
                        blank=True,
                        help_text="Street number, evtl. with additions like stair number, etc.",
                        max_length=50,
                    ),
                ),
                ("subunit", models.CharField(blank=True, max_length=255)),
                ("postcode", models.CharField(blank=True, max_length=10)),
                ("city", models.CharField(blank=True, max_length=255)),
                (
                    "addendum",
                    models.CharField(
                        blank=True,
                        help_text="Any additional information that did not fit anywhere else",
                        max_length=255,
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        blank=True,
                        help_text="The exact location of this address in latitude-longitude",
                        max_length=255,
                    ),
                ),
                ("period_start", models.DateTimeField(blank=True, null=True)),
                ("period_end", models.DateTimeField(blank=True, null=True)),
                ("weight", models.PositiveIntegerField(default=1)),
            ],
            options={
                "verbose_name_plural": "Addresses",
                "ordering": ["weight"],
            },
        ),
        migrations.CreateModel(
            name="AddressMapper",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "address_id",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="core.address"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AddressType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="AdministrativeGender",
            fields=[
                (
                    "tag",
                    models.CharField(max_length=2, primary_key=True, serialize=False),
                ),
                ("label", models.CharField(max_length=50)),
                ("sort_weight", models.IntegerField(default=0)),
                ("comment", models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="CarePlan",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                (
                    "status",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.medication.CarePlan.Status,
                    ),
                ),
                (
                    "intent",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.medication.CarePlan.Intents,
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Human-friendly name for the care plan",
                        max_length=255,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True, help_text="Summary of plan", max_length=255
                    ),
                ),
                ("period_start", models.DateTimeField(blank=True, null=True)),
                ("period_end", models.DateTimeField(blank=True, null=True)),
                (
                    "note",
                    models.TextField(blank=True, help_text="Comments about the plan"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="City",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "verbose_name_plural": "Cities",
            },
        ),
        migrations.CreateModel(
            name="ContactPoint",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                (
                    "system",
                    models.CharField(
                        choices=[
                            ("phone", "Telefon"),
                            ("fax", "Fax"),
                            ("email", "E-Mail-Adresse"),
                            ("pager", "Pager"),
                            ("url", "URL"),
                            ("sms", "SMS"),
                            ("other", "Andere"),
                        ],
                        max_length=20,
                    ),
                ),
                ("value", models.CharField(blank=True, max_length=255)),
                (
                    "use",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("home", "Privat"),
                            ("work", "Geschäftlich"),
                            ("temp", "Termporär"),
                            ("old", "Veraltet"),
                            ("mobile", "Mobil"),
                        ],
                        max_length=20,
                    ),
                ),
                ("weight", models.PositiveIntegerField(blank=True, default=1)),
                ("period_start", models.DateTimeField(blank=True, null=True)),
                ("period_end", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Country",
            fields=[
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="ISO 3166-1 code",
                        max_length=2,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Official English short name", max_length=255
                    ),
                ),
                ("flag", models.CharField(blank=True, max_length=5)),
            ],
            options={
                "verbose_name_plural": "Countries",
            },
            bases=(medux.core.models.geo.UpperCodeMixin, models.Model),
        ),
        migrations.CreateModel(
            name="CourseOfTherapy",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=50)),
                ("display", models.CharField(max_length=50)),
                ("definition", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DataPack",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "name",
                    models.CharField(
                        help_text="Name for this data pack (computer friendly)",
                        max_length=100,
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        help_text="Name for this data pack (human friendly)",
                        max_length=255,
                    ),
                ),
                (
                    "description",
                    medux.core.fields.MarkdownField(
                        help_text="Natural description, in MarkDown", max_length=255
                    ),
                ),
                ("license", models.CharField(max_length=20)),
                ("version", models.CharField(max_length=25)),
                ("experimental", models.BooleanField(default=False)),
                ("publisher", models.CharField(blank=True, max_length=255)),
                ("model", models.CharField(max_length=255)),
                ("downloaded", models.BooleanField(default=False)),
                ("installed", models.BooleanField(default=False)),
                ("data_file", models.FileField(upload_to="datapacks")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Department",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("telecom", models.ManyToManyField(to="core.contactpoint")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Device",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                (
                    "status",
                    medux.core.fields.CodeField(
                        default="active",
                        help_text="Status of the device availability",
                        max_length=32,
                        terminology_binding=medux.core.models.devices.Device.Status,
                    ),
                ),
                (
                    "statusReason",
                    medux.core.fields.CodeField(
                        default="online",
                        help_text="reason for the status of the device availability",
                        max_length=32,
                        terminology_binding=medux.core.models.devices.Device.StatusReason,
                    ),
                ),
                (
                    "distinct_identifier",
                    models.CharField(
                        blank=True,
                        help_text="The distinct identification string",
                        max_length=255,
                    ),
                ),
                (
                    "manufacturer",
                    models.CharField(
                        blank=True,
                        help_text="Name of device manufacturer",
                        max_length=255,
                    ),
                ),
                (
                    "manufacture_date",
                    models.DateField(
                        blank=True, help_text="Date when the device was made", null=True
                    ),
                ),
                (
                    "expiration_date",
                    models.DateField(
                        blank=True,
                        help_text="Date and time of expiry of this device (if applicable)",
                        null=True,
                    ),
                ),
                (
                    "lot_number",
                    models.CharField(
                        blank=True,
                        help_text="Lot number assigned by the manufacturer",
                        max_length=255,
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        help_text="Serial number assigned by the manufacturer",
                        max_length=255,
                    ),
                ),
                (
                    "device_name",
                    models.CharField(
                        blank=True,
                        help_text="The name of the device as given by the manufacturer",
                        max_length=255,
                    ),
                ),
                (
                    "model_number",
                    models.CharField(
                        blank=True,
                        help_text="The model number for the device",
                        max_length=255,
                    ),
                ),
                (
                    "part_number",
                    models.CharField(
                        blank=True,
                        help_text="The part number for the device",
                        max_length=255,
                    ),
                ),
                ("location", models.CharField(blank=True, max_length=255)),
                ("url", models.URLField(blank=True)),
                ("contact", models.ManyToManyField(blank=True, to="core.contactpoint")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DeviceType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Dosage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "dose_rate_numerator_value",
                    models.DecimalField(
                        blank=True, decimal_places=1, max_digits=1, null=True
                    ),
                ),
                (
                    "dose_rate_numerator_unit",
                    medux.core.fields.UnitField(blank=True, max_length=10),
                ),
                (
                    "dose_rate_numerator_system",
                    models.CharField(blank=True, max_length=255),
                ),
                (
                    "dose_rate_numerator_comparator",
                    models.CharField(
                        blank=True,
                        choices=[("<", "<"), ("<=", "<="), (">=", ">="), (">", ">")],
                        max_length=2,
                    ),
                ),
                (
                    "dose_rate_denominator_value",
                    models.DecimalField(decimal_places=1, max_digits=1),
                ),
                (
                    "dose_rate_denominator_unit",
                    medux.core.fields.UnitField(blank=True, max_length=10),
                ),
                (
                    "dose_rate_denominator_system",
                    models.CharField(blank=True, max_length=255),
                ),
                (
                    "dose_rate_denominator_comparator",
                    models.CharField(
                        blank=True,
                        choices=[("<", "<"), ("<=", "<="), (">=", ">="), (">", ">")],
                        max_length=2,
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        help_text="Free text dosage instructions e.g. '1x/day'",
                        max_length=255,
                    ),
                ),
                (
                    "additional_instructions",
                    models.CharField(
                        blank=True,
                        help_text="Supplemental instruction or warnings to the patient - e.g. 'with meals', 'may cause drowsiness'",
                        max_length=255,
                    ),
                ),
                (
                    "patient_instructions",
                    models.CharField(
                        blank=True,
                        help_text="Instructions in terms that are understood by the patient",
                        max_length=255,
                    ),
                ),
                (
                    "as_needed",
                    models.BooleanField(
                        default=False, help_text="Take 'as needed' (for ...)"
                    ),
                ),
                (
                    "dose_type",
                    medux.core.fields.CodeField(
                        default="ordered",
                        max_length=32,
                        terminology_binding=medux.core.models.medication.Dosage.DoseAndRateType,
                    ),
                ),
                (
                    "dose_quantity_value",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                (
                    "dose_quantity_unit",
                    medux.core.fields.UnitField(blank=True, max_length=10),
                ),
                ("dose_quantity_system", models.CharField(blank=True, max_length=255)),
                (
                    "dose_quantity_comparator",
                    models.CharField(
                        blank=True,
                        choices=[("<", "<"), ("<=", "<="), (">=", ">="), (">", ">")],
                        max_length=2,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Encounter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                ("date", models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EpisodeOfCare",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EpisodeStatus",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=50)),
                ("display", models.CharField(max_length=50)),
                ("definition", models.CharField(max_length=255)),
            ],
            options={
                "verbose_name_plural": "Episode Statuses",
            },
        ),
        migrations.CreateModel(
            name="EpisodeStatusHistory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("period_start", models.DateTimeField(blank=True, null=True)),
                ("period_end", models.DateTimeField(blank=True, null=True)),
                (
                    "episode",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.episodeofcare",
                    ),
                ),
                (
                    "status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.episodestatus",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Episode Status Histories",
            },
        ),
        migrations.CreateModel(
            name="Firstname",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                (
                    "sex",
                    models.CharField(
                        choices=[
                            ("M", "Male"),
                            (
                                "1M",
                                "male if first part of name, otherwise mostly female",
                            ),
                            ("?M", "mostly male"),
                            ("F", "Female"),
                            (
                                "1F",
                                "female if first part of name, otherwise mostly male",
                            ),
                            ("?F", "mostly female"),
                            ("?", "unisex"),
                        ],
                        max_length=2,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Ingredient",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Language",
            fields=[
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="ISO 639-1 language code",
                        max_length=2,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="ISO 639-1 English language name", max_length=50
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(medux.core.models.geo.UpperCodeMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Medication",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="The medication code within this coding system",
                        max_length=64,
                    ),
                ),
                (
                    "status",
                    medux.core.fields.CodeField(
                        default="active",
                        max_length=32,
                        terminology_binding=medux.core.models.medication.Medication.Status,
                    ),
                ),
                (
                    "amount_value",
                    models.DecimalField(
                        decimal_places=3,
                        help_text="Amount of drug in package",
                        max_digits=10,
                    ),
                ),
                (
                    "amount_unit",
                    models.CharField(help_text="Unit representation", max_length=25),
                ),
                ("amount_unit_code", models.CharField(max_length=255)),
                (
                    "batch_lot_number",
                    models.CharField(
                        blank=True,
                        help_text="Identifier assigned to batch",
                        max_length=255,
                    ),
                ),
                (
                    "batch_expiration_date",
                    models.DateField(blank=True, help_text="When batch will expire"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationForm",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="MedicationMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=50)),
                ("display", models.CharField(max_length=50)),
                ("definition", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationRoute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationStatus",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=50)),
                ("display", models.CharField(max_length=50)),
                ("definition", models.CharField(max_length=255)),
            ],
            options={
                "verbose_name_plural": "Medication Statuses",
            },
        ),
        migrations.CreateModel(
            name="MedicationTerminologySystem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("name", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Name",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                ("last_name", models.CharField(max_length=255)),
                ("first_name", models.CharField(max_length=255)),
                (
                    "preferred",
                    models.CharField(
                        blank=True,
                        help_text="preferred first name, the name a person is usually called (nickname)",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "comment",
                    models.CharField(
                        blank=True,
                        help_text="a comment regarding this name, useful in things like 'name before marriage' etc.",
                        max_length=255,
                        null=True,
                    ),
                ),
                ("weight", models.PositiveIntegerField(default=1)),
            ],
            options={
                "ordering": ["weight"],
            },
        ),
        migrations.CreateModel(
            name="Narrative",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                ("narrative", models.TextField()),
                (
                    "encounter",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="core.encounter"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="NarrativeType",
            fields=[
                (
                    "shortcut",
                    models.CharField(max_length=2, primary_key=True, serialize=False),
                ),
                ("name", models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name="Observation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                (
                    "status",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.observations.Observation.Status,
                    ),
                ),
                (
                    "effective_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="Clinically relevant time for observation",
                        null=True,
                    ),
                ),
                ("effective_period_start", models.DateTimeField(blank=True, null=True)),
                ("effective_period_end", models.DateTimeField(blank=True, null=True)),
                ("issued", models.DateTimeField(blank=True, null=True)),
                ("comment", models.CharField(blank=True, max_length=255)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="core.device",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="core.encounter",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("name", models.CharField(max_length=255)),
                ("alias", medux.core.fields.StringListField(blank=True)),
                (
                    "address",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="core.address",
                    ),
                ),
                ("telecom", models.ManyToManyField(blank=True, to="core.contactpoint")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="OrganizationType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=50)),
                ("display", models.CharField(max_length=50)),
                ("definition", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Person",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                (
                    "title",
                    models.CharField(
                        blank=True, help_text="Academic title", max_length=50, null=True
                    ),
                ),
                (
                    "birth_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of birth"
                    ),
                ),
                (
                    "birth_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Time of birth"
                    ),
                ),
                ("birth_date_is_estimated", models.BooleanField(default=False)),
                (
                    "deceased_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of death"
                    ),
                ),
                (
                    "deceased_time",
                    models.TimeField(
                        blank=True, null=True, verbose_name="Time of death"
                    ),
                ),
                ("deceased_is_estimated", models.BooleanField(default=False)),
                ("photo", models.ImageField(blank=True, upload_to="")),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Whether this person's record is in active use.",
                    ),
                ),
                (
                    "addresses",
                    models.ManyToManyField(
                        through="core.AddressMapper", to="core.address"
                    ),
                ),
                (
                    "country_of_birth",
                    models.ForeignKey(
                        help_text="ISO code of Country of Birth",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="core.country",
                    ),
                ),
                (
                    "gender",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="core.administrativegender",
                    ),
                ),
                ("names", models.ManyToManyField(to="core.name")),
                (
                    "telecom",
                    models.ManyToManyField(
                        help_text="A contact detail for the person, e.g. a telephone number or an email address",
                        to="core.contactpoint",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Problem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
                ("name", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Relationship",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RelationType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="Request",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        default=django.utils.timezone.now, editable=False
                    ),
                ),
                (
                    "modified",
                    medux.common.models.AutoDateTimeField(
                        default=django.utils.timezone.now
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
                ("row_version", models.PositiveIntegerField(default=0, editable=False)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Specialty",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("name", models.CharField(max_length=255)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ZipCode",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                (
                    "maintainer",
                    models.SmallIntegerField(
                        choices=[(1, "User"), (10, "Admin"), (99, "Vendor")], default=1
                    ),
                ),
                ("code", models.CharField(max_length=10)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="BloodPressure",
            fields=[
                (
                    "observation_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.observation",
                    ),
                ),
                ("systolic", models.PositiveSmallIntegerField()),
                ("diastolic", models.PositiveSmallIntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=("core.observation",),
        ),
        migrations.CreateModel(
            name="BodyTemperature",
            fields=[
                (
                    "observation_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.observation",
                    ),
                ),
                ("value_value", models.DecimalField(decimal_places=1, max_digits=3)),
                ("value_unit", medux.core.fields.UnitField(blank=True, max_length=10)),
                ("value_system", models.CharField(blank=True, max_length=255)),
                (
                    "value_comparator",
                    models.CharField(
                        blank=True,
                        choices=[("<", "<"), ("<=", "<="), (">=", ">="), (">", ">")],
                        max_length=2,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.observation",),
        ),
        migrations.CreateModel(
            name="BodyWeight",
            fields=[
                (
                    "observation_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.observation",
                    ),
                ),
                ("value_value", models.DecimalField(decimal_places=2, max_digits=8)),
                ("value_unit", medux.core.fields.UnitField(blank=True, max_length=10)),
                ("value_system", models.CharField(blank=True, max_length=255)),
                (
                    "value_comparator",
                    models.CharField(
                        blank=True,
                        choices=[("<", "<"), ("<=", "<="), (">=", ">="), (">", ">")],
                        max_length=2,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.observation",),
        ),
        migrations.CreateModel(
            name="Company",
            fields=[
                (
                    "organization_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.organization",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Companies",
            },
            bases=("core.organization",),
        ),
        migrations.CreateModel(
            name="ContactPerson",
            fields=[
                (
                    "person_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.person",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="contact_persons",
                        to="core.organization",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.person",),
        ),
        migrations.CreateModel(
            name="HealthServiceProvider",
            fields=[
                (
                    "organization_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.organization",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.organization",),
        ),
        migrations.CreateModel(
            name="MedicationPlan",
            fields=[
                (
                    "careplan_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.careplan",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.careplan",),
        ),
        migrations.CreateModel(
            name="MedicationRequest",
            fields=[
                (
                    "request_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.request",
                    ),
                ),
                (
                    "status",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.medication.MedicationRequest.Status,
                    ),
                ),
                (
                    "intent",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.medication.MedicationRequest.Intents,
                    ),
                ),
                (
                    "priority",
                    medux.core.fields.CodeField(
                        max_length=32,
                        terminology_binding=medux.core.models.medication.MedicationRequest.Priority,
                    ),
                ),
                (
                    "do_not_perform",
                    models.BooleanField(
                        default=False, help_text="True if request is prohibiting action"
                    ),
                ),
                ("reported", models.BooleanField(default=False)),
                (
                    "note",
                    models.CharField(
                        help_text="Information about the prescription", max_length=255
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.request",),
        ),
        migrations.CreateModel(
            name="Patient",
            fields=[
                (
                    "person",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        parent_link=True,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="core.person",
                    ),
                ),
                (
                    "marital_status",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("A", "Annulled"),
                            ("D", "Divorced"),
                            ("I", "Interlocutory"),
                            ("L", "Legally Separated"),
                            ("M", "Married"),
                            ("P", "Polygamous"),
                            ("S", "Never Married"),
                            ("T", "Domestic partner"),
                            ("U", "Unmarried"),
                            ("W", "Widowed"),
                            ("UNK", "Unknown"),
                        ],
                        max_length=3,
                        null=True,
                    ),
                ),
                (
                    "emergency_contact_freetext",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "comment",
                    models.CharField(
                        blank=True,
                        help_text="Generic comment for this patient, e.g. to identify him/her.",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "emergency_contact",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Persons who should be contacted in case of an emergency",
                        related_name="+",
                        to="core.person",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.person",),
        ),
        migrations.DeleteModel(
            name="User",
        ),
        migrations.AddField(
            model_name="relationship",
            name="relation_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.relationtype"
            ),
        ),
        migrations.AddField(
            model_name="narrative",
            name="problem",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.problem"
            ),
        ),
        migrations.AddField(
            model_name="narrative",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.narrativetype"
            ),
        ),
        migrations.AddField(
            model_name="medication",
            name="code_system",
            field=models.ForeignKey(
                help_text="The defining coding system",
                on_delete=django.db.models.deletion.PROTECT,
                to="core.medicationterminologysystem",
            ),
        ),
        migrations.AddField(
            model_name="medication",
            name="form",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.medicationform"
            ),
        ),
        migrations.AddField(
            model_name="medication",
            name="ingredients",
            field=models.ManyToManyField(to="core.ingredient"),
        ),
        migrations.AddField(
            model_name="episodeofcare",
            name="status",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="core.episodestatus",
            ),
        ),
        migrations.AddField(
            model_name="episodeofcare",
            name="status_history",
            field=models.ManyToManyField(
                through="core.EpisodeStatusHistory", to="core.episodestatus"
            ),
        ),
        migrations.AddField(
            model_name="dosage",
            name="method",
            field=models.ForeignKey(
                blank=True,
                help_text="Technique for administering medication",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.medicationmethod",
            ),
        ),
        migrations.AddField(
            model_name="dosage",
            name="route",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.medicationroute"
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="owner",
            field=models.ForeignKey(
                help_text="Organization responsible for device",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.organization",
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.device",
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="type",
            field=models.ForeignKey(
                blank=True,
                help_text="The kind or type of device",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="core.devicetype",
            ),
        ),
        migrations.AddField(
            model_name="datapack",
            name="language",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.language"
            ),
        ),
        migrations.AddField(
            model_name="country",
            name="default_language",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="core.language",
            ),
        ),
        migrations.AddField(
            model_name="city",
            name="zipcodes",
            field=models.ManyToManyField(to="core.zipcode"),
        ),
        migrations.AddField(
            model_name="careplan",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.encounter",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="replaces",
            field=models.ForeignKey(
                help_text="CarePlan replaced by this CarePlan",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="replaced_by",
                to="core.careplan",
            ),
        ),
        migrations.AddField(
            model_name="addressmapper",
            name="address_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.addresstype"
            ),
        ),
        migrations.AddField(
            model_name="addressmapper",
            name="person_id",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="core.person"
            ),
        ),
        migrations.AddField(
            model_name="address",
            name="state",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="core.country",
            ),
        ),
        migrations.CreateModel(
            name="Hospital",
            fields=[
                (
                    "healthserviceprovider_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.healthserviceprovider",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.healthserviceprovider",),
        ),
        migrations.CreateModel(
            name="InsuranceCompany",
            fields=[
                (
                    "company_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.company",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.company",),
        ),
        migrations.AddField(
            model_name="relationship",
            name="from_patient_id",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="relationship",
            name="to_patient_id",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="patient",
            name="related_persons",
            field=models.ManyToManyField(
                related_name="+", through="core.Relationship", to="core.patient"
            ),
        ),
        migrations.AddField(
            model_name="observation",
            name="performer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="core.healthserviceprovider",
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="based_on",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.careplan",
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="course_of_therapy_type",
            field=models.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="core.courseoftherapy",
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="dosage_instruction",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.PROTECT, to="core.dosage"
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="encounter",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="core.encounter"
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="medication",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="core.medication"
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="recorder",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="replaces",
            field=models.ForeignKey(
                help_text="An order/prescription that is being replaced",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="replaced_by",
                to="core.medicationrequest",
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="requester",
            field=models.ForeignKey(
                help_text="Who requested the request",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.healthserviceprovider",
            ),
        ),
        migrations.AddField(
            model_name="medicationrequest",
            name="subject",
            field=models.ForeignKey(
                help_text="Who medication request is for",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="medicationplan",
            name="medications",
            field=models.ManyToManyField(to="core.medicationrequest"),
        ),
        migrations.AddField(
            model_name="medication",
            name="manufacturer",
            field=models.ForeignKey(
                help_text="Manufacturer of the medication product. (Not the distributor.)",
                on_delete=django.db.models.deletion.PROTECT,
                to="core.healthserviceprovider",
            ),
        ),
        migrations.AddField(
            model_name="encounter",
            name="provider",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                to="core.healthserviceprovider",
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="patient",
            field=models.ForeignKey(
                blank=True,
                help_text="Patient to whom Device is affixed",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="author",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.healthserviceprovider",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="core.patient"
            ),
        ),
        migrations.AddField(
            model_name="bodyweight",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="bodytemperature",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AddField(
            model_name="bloodpressure",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="core.patient",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="address",
            unique_together={("street", "number", "postcode", "city", "state")},
        ),
        migrations.CreateModel(
            name="Physician",
            fields=[
                (
                    "healthserviceprovider_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.healthserviceprovider",
                    ),
                ),
                (
                    "personal_salutation",
                    models.CharField(
                        blank=True,
                        help_text="if you know this physician personally, you can choose to customize his salutation, like 'Dear Thomas,'",
                        max_length=100,
                    ),
                ),
                (
                    "person",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="core.person"
                    ),
                ),
                (
                    "speciality",
                    models.ForeignKey(
                        help_text="Medical field",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="physicians",
                        to="core.specialty",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.healthserviceprovider",),
        ),
        migrations.AddField(
            model_name="patient",
            name="general_practitioner",
            field=models.ForeignKey(
                blank=True,
                help_text="The patient's general practitioner",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="core.physician",
            ),
        ),
        migrations.AddField(
            model_name="patient",
            name="physicians",
            field=models.ManyToManyField(
                blank=True,
                help_text="Physicians the patient consults regularly",
                related_name="+",
                to="core.physician",
            ),
        ),
        migrations.AddField(
            model_name="department",
            name="hospital",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="departments",
                to="core.hospital",
            ),
        ),
    ]
