# Generated by Django 4.1 on 2022-10-17 08:37
import uuid

from django.contrib.auth import get_user_model
from django.db import migrations
from django.db.migrations import RunPython


def create_tenant(apps, schema_editor):
    Tenant = apps.get_model("common", "Tenant")
    # create a new admin tenant
    Tenant.objects.create(
        id=1,
        uuid=uuid.uuid4(),  # random Admin UID for this site.
        first_name="Admin",
        last_name="Admin",
        address="Nowhere 42, 12345 Wherever",
        sex="f",
    )


def modify_admin(apps, schema_editor):
    User = get_user_model()
    # create admin and set its tenant to newly created tenant
    User.objects.create_superuser(
        pk=1,
        username="admin",
        password="admin",
        first_name="Admin",
        last_name="Admin",
        tenant_id=1,
    )


class Migration(migrations.Migration):

    dependencies = [
        ("common", "0001_initial"),
    ]

    operations = [
        RunPython(create_tenant),
        RunPython(modify_admin),
    ]
