# coding: utf-8

"""
    42di API Reference

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: support@42docs.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DatasetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_dataset(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Delete Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
            return data

    def delete_dataset_with_http_info(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Delete Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_with_http_info(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `delete_dataset`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_dataset`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `delete_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Get Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param bool schema: get schema
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
            return data

    def get_dataset_with_http_info(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Get Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_with_http_info(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param bool schema: get schema
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'schema']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `get_dataset`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_dataset`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501

        query_params = []
        if 'schema' in params:
            query_params.append(('schema', params['schema']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dataset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_data_file(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Get Dataset DataFile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_data_file(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
            return data

    def get_dataset_data_file_with_http_info(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Get Dataset DataFile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'data_file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_data_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `get_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'data_file_name' is set
        if ('data_file_name' not in params or
                params['data_file_name'] is None):
            raise ValueError("Missing the required parameter `data_file_name` when calling `get_dataset_data_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501
        if 'data_file_name' in params:
            path_params['data_file_name'] = params['data_file_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}/data/{data_file_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_data_file_meta(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Get Dataset DataFile meta  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_data_file_meta(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :return: DataFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_data_file_meta_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_data_file_meta_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
            return data

    def get_dataset_data_file_meta_with_http_info(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Get Dataset DataFile meta  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_data_file_meta_with_http_info(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :return: DataFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'data_file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_data_file_meta" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `get_dataset_data_file_meta`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_dataset_data_file_meta`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset_data_file_meta`")  # noqa: E501
        # verify the required parameter 'data_file_name' is set
        if ('data_file_name' not in params or
                params['data_file_name'] is None):
            raise ValueError("Missing the required parameter `data_file_name` when calling `get_dataset_data_file_meta`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501
        if 'data_file_name' in params:
            path_params['data_file_name'] = params['data_file_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}/data/{data_file_name}/meta', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dataset_data_files(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """List Dataset data files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_data_files(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :return: list[DataFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_dataset_data_files_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_dataset_data_files_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
            return data

    def list_dataset_data_files_with_http_info(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """List Dataset data files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_data_files_with_http_info(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :return: list[DataFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dataset_data_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `list_dataset_data_files`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `list_dataset_data_files`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `list_dataset_data_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_datasets(self, team_id, project_id, **kwargs):  # noqa: E501
        """List Datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datasets(team_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :return: list[Dataset]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_datasets_with_http_info(team_id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_datasets_with_http_info(team_id, project_id, **kwargs)  # noqa: E501
            return data

    def list_datasets_with_http_info(self, team_id, project_id, **kwargs):  # noqa: E501
        """List Datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datasets_with_http_info(team_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :return: list[Dataset]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_datasets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `list_datasets`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `list_datasets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Dataset]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_dataset_data_file(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Upload data to dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_dataset_data_file(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :param Object body:
        :param str x_di_tag: File tag.
        :param str content_type: Content-Type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, **kwargs)  # noqa: E501
            return data

    def put_dataset_data_file_with_http_info(self, team_id, project_id, dataset_id, data_file_name, **kwargs):  # noqa: E501
        """Upload data to dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_dataset_data_file_with_http_info(team_id, project_id, dataset_id, data_file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param str data_file_name: File name. (required)
        :param Object body:
        :param str x_di_tag: File tag.
        :param str content_type: Content-Type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'data_file_name', 'body', 'x_di_tag', 'content_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_dataset_data_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `put_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `put_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `put_dataset_data_file`")  # noqa: E501
        # verify the required parameter 'data_file_name' is set
        if ('data_file_name' not in params or
                params['data_file_name'] is None):
            raise ValueError("Missing the required parameter `data_file_name` when calling `put_dataset_data_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501
        if 'data_file_name' in params:
            path_params['data_file_name'] = params['data_file_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_di_tag' in params:
            header_params['X-DI-Tag'] = params['x_di_tag']  # noqa: E501
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        #header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
        #    ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}/data/{data_file_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Update Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param Dataset body: The **Dataset** object will be updated/created.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
            return data

    def update_dataset_with_http_info(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Update Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_with_http_info(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param Dataset body: The **Dataset** object will be updated/created.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `update_dataset`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_dataset`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset_property(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Update Dataset property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_property(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param PatchAction body: PATCH Action
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_property_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_property_with_http_info(team_id, project_id, dataset_id, **kwargs)  # noqa: E501
            return data

    def update_dataset_property_with_http_info(self, team_id, project_id, dataset_id, **kwargs):  # noqa: E501
        """Update Dataset property  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_property_with_http_info(team_id, project_id, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str team_id: the **Team** identity (required)
        :param str project_id: the **Project** identity (required)
        :param str dataset_id: the **Dataset** name (required)
        :param PatchAction body: PATCH Action
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['team_id', 'project_id', 'dataset_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'team_id' is set
        if ('team_id' not in params or
                params['team_id'] is None):
            raise ValueError("Missing the required parameter `team_id` when calling `update_dataset_property`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_dataset_property`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_dataset_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'team_id' in params:
            path_params['team_id'] = params['team_id']  # noqa: E501
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'dataset_id' in params:
            path_params['dataset_id'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/teams/{team_id}/projects/{project_id}/datasets/{dataset_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
