# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SegmentArgs', 'Segment']

@pulumi.input_type
class SegmentArgs:
    def __init__(__self__, *,
                 env_key: pulumi.Input[str],
                 key: pulumi.Input[str],
                 project_key: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Segment resource.
        :param pulumi.Input[str] env_key: The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] key: The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] project_key: The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] description: The description of the segment's purpose.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludeds: List of user keys excluded from the segment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includeds: List of user keys included in the segment.
        :param pulumi.Input[str] name: The human-friendly name for the segment.
        :param pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the segment.
        """
        pulumi.set(__self__, "env_key", env_key)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_key", project_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excludeds is not None:
            pulumi.set(__self__, "excludeds", excludeds)
        if includeds is not None:
            pulumi.set(__self__, "includeds", includeds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> pulumi.Input[str]:
        """
        The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @env_key.setter
    def env_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "env_key", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[str]:
        """
        The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the segment's purpose.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user keys excluded from the segment.
        """
        return pulumi.get(self, "excludeds")

    @excludeds.setter
    def excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludeds", value)

    @property
    @pulumi.getter
    def includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user keys included in the segment.
        """
        return pulumi.get(self, "includeds")

    @includeds.setter
    def includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includeds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-friendly name for the segment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]]:
        """
        List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SegmentState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_key: Optional[pulumi.Input[str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Segment resources.
        :param pulumi.Input[int] creation_date: The segment's creation date represented as a UNIX epoch timestamp.
        :param pulumi.Input[str] description: The description of the segment's purpose.
        :param pulumi.Input[str] env_key: The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludeds: List of user keys excluded from the segment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includeds: List of user keys included in the segment.
        :param pulumi.Input[str] key: The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-friendly name for the segment.
        :param pulumi.Input[str] project_key: The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the segment.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env_key is not None:
            pulumi.set(__self__, "env_key", env_key)
        if excludeds is not None:
            pulumi.set(__self__, "excludeds", excludeds)
        if includeds is not None:
            pulumi.set(__self__, "includeds", includeds)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[int]]:
        """
        The segment's creation date represented as a UNIX epoch timestamp.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the segment's purpose.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> Optional[pulumi.Input[str]]:
        """
        The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @env_key.setter
    def env_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_key", value)

    @property
    @pulumi.getter
    def excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user keys excluded from the segment.
        """
        return pulumi.get(self, "excludeds")

    @excludeds.setter
    def excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludeds", value)

    @property
    @pulumi.getter
    def includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user keys included in the segment.
        """
        return pulumi.get(self, "includeds")

    @includeds.setter
    def includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includeds", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-friendly name for the segment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[str]]:
        """
        The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]]:
        """
        List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SegmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags for the segment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Segment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_key: Optional[pulumi.Input[str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SegmentRuleArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly segment resource.

        This resource allows you to create and manage segments within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Segment("example",
            key="example-segment-key",
            project_key=launchdarkly_project["example"]["key"],
            env_key=launchdarkly_environment["example"]["key"],
            description="This segment is managed by Terraform",
            tags=[
                "segment-tag-1",
                "segment-tag-2",
            ],
            includeds=[
                "user1",
                "user2",
            ],
            excludeds=[
                "user3",
                "user4",
            ],
            rules=[launchdarkly.SegmentRuleArgs(
                clauses=[launchdarkly.SegmentRuleClauseArgs(
                    attribute="country",
                    op="startsWith",
                    values=[
                        "en",
                        "de",
                        "un",
                    ],
                    negate=False,
                )],
            )])
        ```

        ## Import

        LaunchDarkly segments can be imported using the segment's ID in the form `project_key/env_key/segment_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/segment:Segment example example-project/example-environment/example-segment-key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the segment's purpose.
        :param pulumi.Input[str] env_key: The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludeds: List of user keys excluded from the segment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includeds: List of user keys included in the segment.
        :param pulumi.Input[str] key: The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-friendly name for the segment.
        :param pulumi.Input[str] project_key: The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SegmentRuleArgs']]]] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the segment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SegmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly segment resource.

        This resource allows you to create and manage segments within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Segment("example",
            key="example-segment-key",
            project_key=launchdarkly_project["example"]["key"],
            env_key=launchdarkly_environment["example"]["key"],
            description="This segment is managed by Terraform",
            tags=[
                "segment-tag-1",
                "segment-tag-2",
            ],
            includeds=[
                "user1",
                "user2",
            ],
            excludeds=[
                "user3",
                "user4",
            ],
            rules=[launchdarkly.SegmentRuleArgs(
                clauses=[launchdarkly.SegmentRuleClauseArgs(
                    attribute="country",
                    op="startsWith",
                    values=[
                        "en",
                        "de",
                        "un",
                    ],
                    negate=False,
                )],
            )])
        ```

        ## Import

        LaunchDarkly segments can be imported using the segment's ID in the form `project_key/env_key/segment_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/segment:Segment example example-project/example-environment/example-segment-key
        ```

        :param str resource_name: The name of the resource.
        :param SegmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SegmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_key: Optional[pulumi.Input[str]] = None,
                 excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SegmentRuleArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SegmentArgs.__new__(SegmentArgs)

            __props__.__dict__["description"] = description
            if env_key is None and not opts.urn:
                raise TypeError("Missing required property 'env_key'")
            __props__.__dict__["env_key"] = env_key
            __props__.__dict__["excludeds"] = excludeds
            __props__.__dict__["includeds"] = includeds
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            if project_key is None and not opts.urn:
                raise TypeError("Missing required property 'project_key'")
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["rules"] = rules
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_date"] = None
        super(Segment, __self__).__init__(
            'launchdarkly:index/segment:Segment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            env_key: Optional[pulumi.Input[str]] = None,
            excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            includeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_key: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SegmentRuleArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Segment':
        """
        Get an existing Segment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] creation_date: The segment's creation date represented as a UNIX epoch timestamp.
        :param pulumi.Input[str] description: The description of the segment's purpose.
        :param pulumi.Input[str] env_key: The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludeds: List of user keys excluded from the segment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includeds: List of user keys included in the segment.
        :param pulumi.Input[str] key: The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-friendly name for the segment.
        :param pulumi.Input[str] project_key: The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SegmentRuleArgs']]]] rules: List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Set of tags for the segment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SegmentState.__new__(_SegmentState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["description"] = description
        __props__.__dict__["env_key"] = env_key
        __props__.__dict__["excludeds"] = excludeds
        __props__.__dict__["includeds"] = includeds
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["rules"] = rules
        __props__.__dict__["tags"] = tags
        return Segment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[int]:
        """
        The segment's creation date represented as a UNIX epoch timestamp.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the segment's purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> pulumi.Output[str]:
        """
        The segment's environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @property
    @pulumi.getter
    def excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of user keys excluded from the segment.
        """
        return pulumi.get(self, "excludeds")

    @property
    @pulumi.getter
    def includeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of user keys included in the segment.
        """
        return pulumi.get(self, "includeds")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The unique key that references the segment. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-friendly name for the segment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[str]:
        """
        The segment's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.SegmentRule']]]:
        """
        List of nested custom rule blocks to apply to the segment. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of tags for the segment.
        """
        return pulumi.get(self, "tags")

