# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_host: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] access_token: The LaunchDarkly API key
        :param pulumi.Input[str] api_host: The LaunchDarkly host address, e.g. https://app.launchdarkly.com
        :param pulumi.Input[str] oauth_token: The LaunchDarkly OAuth token
        """
        if access_token is None:
            access_token = _utilities.get_env('LAUNCHDARKLY_ACCESS_TOKEN')
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if api_host is not None:
            pulumi.set(__self__, "api_host", api_host)
        if oauth_token is None:
            oauth_token = _utilities.get_env('LAUNCHDARKLY_OAUTH_TOKEN')
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly API key
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="apiHost")
    def api_host(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly host address, e.g. https://app.launchdarkly.com
        """
        return pulumi.get(self, "api_host")

    @api_host.setter
    def api_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_host", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The LaunchDarkly OAuth token
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth_token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_host: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the launchdarkly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: The LaunchDarkly API key
        :param pulumi.Input[str] api_host: The LaunchDarkly host address, e.g. https://app.launchdarkly.com
        :param pulumi.Input[str] oauth_token: The LaunchDarkly OAuth token
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the launchdarkly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 api_host: Optional[pulumi.Input[str]] = None,
                 oauth_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if access_token is None:
                access_token = _utilities.get_env('LAUNCHDARKLY_ACCESS_TOKEN')
            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["api_host"] = api_host
            if oauth_token is None:
                oauth_token = _utilities.get_env('LAUNCHDARKLY_OAUTH_TOKEN')
            __props__.__dict__["oauth_token"] = oauth_token
        super(Provider, __self__).__init__(
            'launchdarkly',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[str]]:
        """
        The LaunchDarkly API key
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="apiHost")
    def api_host(self) -> pulumi.Output[Optional[str]]:
        """
        The LaunchDarkly host address, e.g. https://app.launchdarkly.com
        """
        return pulumi.get(self, "api_host")

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> pulumi.Output[Optional[str]]:
        """
        The LaunchDarkly OAuth token
        """
        return pulumi.get(self, "oauth_token")

