# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeatureFlagEnvironmentArgs', 'FeatureFlagEnvironment']

@pulumi.input_type
class FeatureFlagEnvironmentArgs:
    def __init__(__self__, *,
                 env_key: pulumi.Input[str],
                 fallthrough: pulumi.Input['FeatureFlagEnvironmentFallthroughArgs'],
                 flag_id: pulumi.Input[str],
                 off_variation: pulumi.Input[int],
                 on: Optional[pulumi.Input[bool]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]] = None,
                 track_events: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a FeatureFlagEnvironment resource.
        :param pulumi.Input[str] env_key: The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input['FeatureFlagEnvironmentFallthroughArgs'] fallthrough: - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        :param pulumi.Input[str] flag_id: The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[int] off_variation: The index of the variation to serve if targeting is disabled.
        :param pulumi.Input[bool] on: - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]] targets: - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        :param pulumi.Input[bool] track_events: Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        pulumi.set(__self__, "env_key", env_key)
        pulumi.set(__self__, "fallthrough", fallthrough)
        pulumi.set(__self__, "flag_id", flag_id)
        pulumi.set(__self__, "off_variation", off_variation)
        if on is not None:
            pulumi.set(__self__, "on", on)
        if prerequisites is not None:
            pulumi.set(__self__, "prerequisites", prerequisites)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if track_events is not None:
            pulumi.set(__self__, "track_events", track_events)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> pulumi.Input[str]:
        """
        The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @env_key.setter
    def env_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "env_key", value)

    @property
    @pulumi.getter
    def fallthrough(self) -> pulumi.Input['FeatureFlagEnvironmentFallthroughArgs']:
        """
        - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        """
        return pulumi.get(self, "fallthrough")

    @fallthrough.setter
    def fallthrough(self, value: pulumi.Input['FeatureFlagEnvironmentFallthroughArgs']):
        pulumi.set(self, "fallthrough", value)

    @property
    @pulumi.getter(name="flagId")
    def flag_id(self) -> pulumi.Input[str]:
        """
        The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "flag_id")

    @flag_id.setter
    def flag_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flag_id", value)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> pulumi.Input[int]:
        """
        The index of the variation to serve if targeting is disabled.
        """
        return pulumi.get(self, "off_variation")

    @off_variation.setter
    def off_variation(self, value: pulumi.Input[int]):
        pulumi.set(self, "off_variation", value)

    @property
    @pulumi.getter
    def on(self) -> Optional[pulumi.Input[bool]]:
        """
        - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        """
        return pulumi.get(self, "on")

    @on.setter
    def on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on", value)

    @property
    @pulumi.getter
    def prerequisites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]]:
        """
        List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        """
        return pulumi.get(self, "prerequisites")

    @prerequisites.setter
    def prerequisites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]]):
        pulumi.set(self, "prerequisites", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]]:
        """
        List of logical targeting rules. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]]:
        """
        - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="trackEvents")
    def track_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        return pulumi.get(self, "track_events")

    @track_events.setter
    def track_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_events", value)


@pulumi.input_type
class _FeatureFlagEnvironmentState:
    def __init__(__self__, *,
                 env_key: Optional[pulumi.Input[str]] = None,
                 fallthrough: Optional[pulumi.Input['FeatureFlagEnvironmentFallthroughArgs']] = None,
                 flag_id: Optional[pulumi.Input[str]] = None,
                 off_variation: Optional[pulumi.Input[int]] = None,
                 on: Optional[pulumi.Input[bool]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]] = None,
                 track_events: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering FeatureFlagEnvironment resources.
        :param pulumi.Input[str] env_key: The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input['FeatureFlagEnvironmentFallthroughArgs'] fallthrough: - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        :param pulumi.Input[str] flag_id: The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[int] off_variation: The index of the variation to serve if targeting is disabled.
        :param pulumi.Input[bool] on: - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]] targets: - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        :param pulumi.Input[bool] track_events: Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        if env_key is not None:
            pulumi.set(__self__, "env_key", env_key)
        if fallthrough is not None:
            pulumi.set(__self__, "fallthrough", fallthrough)
        if flag_id is not None:
            pulumi.set(__self__, "flag_id", flag_id)
        if off_variation is not None:
            pulumi.set(__self__, "off_variation", off_variation)
        if on is not None:
            pulumi.set(__self__, "on", on)
        if prerequisites is not None:
            pulumi.set(__self__, "prerequisites", prerequisites)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if track_events is not None:
            pulumi.set(__self__, "track_events", track_events)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> Optional[pulumi.Input[str]]:
        """
        The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @env_key.setter
    def env_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_key", value)

    @property
    @pulumi.getter
    def fallthrough(self) -> Optional[pulumi.Input['FeatureFlagEnvironmentFallthroughArgs']]:
        """
        - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        """
        return pulumi.get(self, "fallthrough")

    @fallthrough.setter
    def fallthrough(self, value: Optional[pulumi.Input['FeatureFlagEnvironmentFallthroughArgs']]):
        pulumi.set(self, "fallthrough", value)

    @property
    @pulumi.getter(name="flagId")
    def flag_id(self) -> Optional[pulumi.Input[str]]:
        """
        The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "flag_id")

    @flag_id.setter
    def flag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flag_id", value)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the variation to serve if targeting is disabled.
        """
        return pulumi.get(self, "off_variation")

    @off_variation.setter
    def off_variation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "off_variation", value)

    @property
    @pulumi.getter
    def on(self) -> Optional[pulumi.Input[bool]]:
        """
        - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        """
        return pulumi.get(self, "on")

    @on.setter
    def on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on", value)

    @property
    @pulumi.getter
    def prerequisites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]]:
        """
        List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        """
        return pulumi.get(self, "prerequisites")

    @prerequisites.setter
    def prerequisites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentPrerequisiteArgs']]]]):
        pulumi.set(self, "prerequisites", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]]:
        """
        List of logical targeting rules. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]]:
        """
        - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureFlagEnvironmentTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="trackEvents")
    def track_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        return pulumi.get(self, "track_events")

    @track_events.setter
    def track_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_events", value)


class FeatureFlagEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_key: Optional[pulumi.Input[str]] = None,
                 fallthrough: Optional[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentFallthroughArgs']]] = None,
                 flag_id: Optional[pulumi.Input[str]] = None,
                 off_variation: Optional[pulumi.Input[int]] = None,
                 on: Optional[pulumi.Input[bool]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentPrerequisiteArgs']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentRuleArgs']]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentTargetArgs']]]]] = None,
                 track_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly environment-specific feature flag resource.

        This resource allows you to create and manage environment-specific feature flags attributes within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        number_env = launchdarkly.FeatureFlagEnvironment("numberEnv",
            flag_id=launchdarkly_feature_flag["number"]["id"],
            env_key=launchdarkly_environment["staging"]["key"],
            on=True,
            prerequisites=[launchdarkly.FeatureFlagEnvironmentPrerequisiteArgs(
                flag_key=launchdarkly_feature_flag["basic"]["key"],
                variation=0,
            )],
            targets=[
                launchdarkly.FeatureFlagEnvironmentTargetArgs(
                    values=["user0"],
                    variation=0,
                ),
                launchdarkly.FeatureFlagEnvironmentTargetArgs(
                    values=[
                        "user1",
                        "user2",
                    ],
                    variation=1,
                ),
            ],
            rules=[launchdarkly.FeatureFlagEnvironmentRuleArgs(
                clauses=[
                    launchdarkly.FeatureFlagEnvironmentRuleClauseArgs(
                        attribute="country",
                        op="startsWith",
                        values=[
                            "aus",
                            "de",
                            "united",
                        ],
                        negate=False,
                    ),
                    launchdarkly.FeatureFlagEnvironmentRuleClauseArgs(
                        attribute="segmentMatch",
                        op="segmentMatch",
                        values=[launchdarkly_segment["example"]["key"]],
                        negate=False,
                    ),
                ],
                variation=0,
            )],
            fallthrough=launchdarkly.FeatureFlagEnvironmentFallthroughArgs(
                rollout_weights=[
                    60000,
                    40000,
                    0,
                ],
            ),
            off_variation=2)
        ```

        ## Import

        LaunchDarkly feature flag environments can be imported using the resource's ID in the form `project_key/env_key/flag_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/featureFlagEnvironment:FeatureFlagEnvironment example example-project/example-env/example-flag-key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] env_key: The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentFallthroughArgs']] fallthrough: - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        :param pulumi.Input[str] flag_id: The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[int] off_variation: The index of the variation to serve if targeting is disabled.
        :param pulumi.Input[bool] on: - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentPrerequisiteArgs']]]] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentRuleArgs']]]] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentTargetArgs']]]] targets: - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        :param pulumi.Input[bool] track_events: Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureFlagEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly environment-specific feature flag resource.

        This resource allows you to create and manage environment-specific feature flags attributes within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        number_env = launchdarkly.FeatureFlagEnvironment("numberEnv",
            flag_id=launchdarkly_feature_flag["number"]["id"],
            env_key=launchdarkly_environment["staging"]["key"],
            on=True,
            prerequisites=[launchdarkly.FeatureFlagEnvironmentPrerequisiteArgs(
                flag_key=launchdarkly_feature_flag["basic"]["key"],
                variation=0,
            )],
            targets=[
                launchdarkly.FeatureFlagEnvironmentTargetArgs(
                    values=["user0"],
                    variation=0,
                ),
                launchdarkly.FeatureFlagEnvironmentTargetArgs(
                    values=[
                        "user1",
                        "user2",
                    ],
                    variation=1,
                ),
            ],
            rules=[launchdarkly.FeatureFlagEnvironmentRuleArgs(
                clauses=[
                    launchdarkly.FeatureFlagEnvironmentRuleClauseArgs(
                        attribute="country",
                        op="startsWith",
                        values=[
                            "aus",
                            "de",
                            "united",
                        ],
                        negate=False,
                    ),
                    launchdarkly.FeatureFlagEnvironmentRuleClauseArgs(
                        attribute="segmentMatch",
                        op="segmentMatch",
                        values=[launchdarkly_segment["example"]["key"]],
                        negate=False,
                    ),
                ],
                variation=0,
            )],
            fallthrough=launchdarkly.FeatureFlagEnvironmentFallthroughArgs(
                rollout_weights=[
                    60000,
                    40000,
                    0,
                ],
            ),
            off_variation=2)
        ```

        ## Import

        LaunchDarkly feature flag environments can be imported using the resource's ID in the form `project_key/env_key/flag_key`, e.g.

        ```sh
         $ pulumi import launchdarkly:index/featureFlagEnvironment:FeatureFlagEnvironment example example-project/example-env/example-flag-key
        ```

        :param str resource_name: The name of the resource.
        :param FeatureFlagEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureFlagEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_key: Optional[pulumi.Input[str]] = None,
                 fallthrough: Optional[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentFallthroughArgs']]] = None,
                 flag_id: Optional[pulumi.Input[str]] = None,
                 off_variation: Optional[pulumi.Input[int]] = None,
                 on: Optional[pulumi.Input[bool]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentPrerequisiteArgs']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentRuleArgs']]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentTargetArgs']]]]] = None,
                 track_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureFlagEnvironmentArgs.__new__(FeatureFlagEnvironmentArgs)

            if env_key is None and not opts.urn:
                raise TypeError("Missing required property 'env_key'")
            __props__.__dict__["env_key"] = env_key
            if fallthrough is None and not opts.urn:
                raise TypeError("Missing required property 'fallthrough'")
            __props__.__dict__["fallthrough"] = fallthrough
            if flag_id is None and not opts.urn:
                raise TypeError("Missing required property 'flag_id'")
            __props__.__dict__["flag_id"] = flag_id
            if off_variation is None and not opts.urn:
                raise TypeError("Missing required property 'off_variation'")
            __props__.__dict__["off_variation"] = off_variation
            __props__.__dict__["on"] = on
            __props__.__dict__["prerequisites"] = prerequisites
            __props__.__dict__["rules"] = rules
            __props__.__dict__["targets"] = targets
            __props__.__dict__["track_events"] = track_events
        super(FeatureFlagEnvironment, __self__).__init__(
            'launchdarkly:index/featureFlagEnvironment:FeatureFlagEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            env_key: Optional[pulumi.Input[str]] = None,
            fallthrough: Optional[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentFallthroughArgs']]] = None,
            flag_id: Optional[pulumi.Input[str]] = None,
            off_variation: Optional[pulumi.Input[int]] = None,
            on: Optional[pulumi.Input[bool]] = None,
            prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentPrerequisiteArgs']]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentRuleArgs']]]]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentTargetArgs']]]]] = None,
            track_events: Optional[pulumi.Input[bool]] = None) -> 'FeatureFlagEnvironment':
        """
        Get an existing FeatureFlagEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] env_key: The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentFallthroughArgs']] fallthrough: - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        :param pulumi.Input[str] flag_id: The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[int] off_variation: The index of the variation to serve if targeting is disabled.
        :param pulumi.Input[bool] on: - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentPrerequisiteArgs']]]] prerequisites: List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentRuleArgs']]]] rules: List of logical targeting rules. To learn more, read Nested Rules Blocks.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureFlagEnvironmentTargetArgs']]]] targets: - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        :param pulumi.Input[bool] track_events: Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeatureFlagEnvironmentState.__new__(_FeatureFlagEnvironmentState)

        __props__.__dict__["env_key"] = env_key
        __props__.__dict__["fallthrough"] = fallthrough
        __props__.__dict__["flag_id"] = flag_id
        __props__.__dict__["off_variation"] = off_variation
        __props__.__dict__["on"] = on
        __props__.__dict__["prerequisites"] = prerequisites
        __props__.__dict__["rules"] = rules
        __props__.__dict__["targets"] = targets
        __props__.__dict__["track_events"] = track_events
        return FeatureFlagEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="envKey")
    def env_key(self) -> pulumi.Output[str]:
        """
        The environment key. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "env_key")

    @property
    @pulumi.getter
    def fallthrough(self) -> pulumi.Output['outputs.FeatureFlagEnvironmentFallthrough']:
        """
        - (Required) Nested block describing the default variation to serve if no `prerequisites`, `target`, or `rules` apply.To learn more, read Nested Fallthrough Block.
        """
        return pulumi.get(self, "fallthrough")

    @property
    @pulumi.getter(name="flagId")
    def flag_id(self) -> pulumi.Output[str]:
        """
        The feature flag's unique `id` in the format `project_key/flag_key`. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "flag_id")

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> pulumi.Output[int]:
        """
        The index of the variation to serve if targeting is disabled.
        """
        return pulumi.get(self, "off_variation")

    @property
    @pulumi.getter
    def on(self) -> pulumi.Output[Optional[bool]]:
        """
        - (Optional) Whether targeting is enabled. Defaults to `false` if not set.
        """
        return pulumi.get(self, "on")

    @property
    @pulumi.getter
    def prerequisites(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureFlagEnvironmentPrerequisite']]]:
        """
        List of nested blocks describing prerequisite feature flags rules. To learn more, read Nested Prequisites Blocks.
        """
        return pulumi.get(self, "prerequisites")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureFlagEnvironmentRule']]]:
        """
        List of logical targeting rules. To learn more, read Nested Rules Blocks.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureFlagEnvironmentTarget']]]:
        """
        - (Optional) Set of nested blocks describing the individual user targets for each variation. To learn more, read Nested Target Blocks.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="trackEvents")
    def track_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to send event data back to LaunchDarkly. Defaults to `false` if not set.
        """
        return pulumi.get(self, "track_events")

