# fseval

[![build status](https://github.com/dunnkers/fseval/actions/workflows/python-app.yml/badge.svg)](https://github.com/dunnkers/fseval/actions/workflows/python-app.yml)
[![pypi badge](https://img.shields.io/pypi/v/fseval.svg?maxAge=3600)](https://pypi.org/project/fseval/)
[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Downloads](https://pepy.tech/badge/fseval/month)](https://pepy.tech/project/fseval) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/fseval)
[![codecov](https://codecov.io/gh/dunnkers/fseval/branch/master/graph/badge.svg?token=R5ZXH8UPCI)](https://codecov.io/gh/dunnkers/fseval)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/dunnkers/fseval.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/dunnkers/fseval/context:python) ![PyPI - License](https://img.shields.io/pypi/l/fseval)
[![DOI](https://zenodo.org/badge/274001213.svg)](https://zenodo.org/badge/latestdoi/274001213)
[![Open in Remote - Containers](https://img.shields.io/static/v1?label=Remote%20-%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/dunnkers/fseval)


Benchmarking framework for Feature Selection and Feature Ranking algorithms 🚀

## Demo
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1Bsuxxuw0-mEsYRSnNbmvD_wNUAkOPiQa?usp=sharing)

## Install

1. Installation through [PyPi](https://pypi.org/project/fseval/)
    <sup><sub>
    ⭐️ RECOMMENDED OPTION
    </sub></sup>

    ```shell
    pip install fseval
    ```


2. Installation from source 

    ```shell
    git clone https://github.com/dunnkers/fseval.git
    cd fseval
    pip install -r requirements.txt
    pip install .
    ```

You can now import fseval `import fseval` in your Python code, or use the `fseval` command in your terminal. For an example, run `fseval --help`. For more information, see the documentation link below ⌄. 

## Documentation

[![docs preview](./website/static/img/docs-preview.png)](https://dunnkers.com/fseval)

See the [documentation](https://dunnkers.com/fseval).

## About
Built at the University of Groningen. It stemmed from a previous project that proposed the feature selection algorithm called FeatBoost (see full citation below). The open source Python code of FeatBoost is available in https://github.com/amjams/FeatBoost.


A. Alsahaf, N. Petkov, V. Shenoy, G. Azzopardi, "A framework for feature selection through boosting", Expert Systems with Applications,
Volume 187, 2022, 115895, ISSN 0957-4174, https://doi.org/10.1016/j.eswa.2021.115895.


---

<p align="center">2022 — <a href="https://dunnkers.com/">Jeroen Overschie</a></p>
