"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionNewRelic = exports.Function = exports.NEW_RELIC_LAYERS_ACCOUNT_ID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const env_1 = require("../../common/env");
const env = require("../../common/env");
const utils_1 = require("../../common/utils");
exports.NEW_RELIC_LAYERS_ACCOUNT_ID = '451483290750'; // AWS account id of NewRelic where exposed layers https://layers.newrelic-external.com/
function getConstructId(id, stage) {
    return id + '-construct-' + stage;
}
class BaseFunction extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, getConstructId(id, props.stage));
        this.stage = props.stage;
        this.function = this.createFunction(scope, id, props);
        this.addEnvironment({
            ENVIRONMENT: this.stage,
            TIMESTAMP_DEPLOY_CDK: env.TIMESTAMP_DEPLOY_CDK,
            BUSINESS_UNIT: env.BUSINESS_UNIT,
            DOMAIN: env.DOMAIN,
            REPOSITORY_NAME: env.REPOSITORY_NAME,
            REPOSITORY_VERSION: env.REPOSITORY_VERSION,
        });
        utils_1.addBaseTags(this.function);
    }
    addEnvironment(props) {
        let keys = Object.keys(props);
        for (let index = 0; index < keys.length; index++) {
            let key = keys[index];
            this.function.addEnvironment(key.toUpperCase(), props[key]);
        }
    }
}
class Function extends BaseFunction {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    createFunction(scope, id, props) {
        return new lambda.Function(scope, id, props);
    }
}
exports.Function = Function;
_a = JSII_RTTI_SYMBOL_1;
Function[_a] = { fqn: "neulabs-cdk-constructs.constructs.aws_lambda.Function", version: "0.1.4" };
class FunctionNewRelic extends BaseFunction {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    createFunction(scope, id, props) {
        let handler = 'newrelic_lambda_wrapper.handler';
        let app_handler = props.handler;
        let lambdaFunction = new lambda.Function(scope, id, { ...props, handler });
        lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['secretsmanager:GetSecretValue'],
            resources: [`arn:aws:secretsmanager:eu-west-1:${env_1.CDK_ACCOUNT_ID}:secret:NEW_RELIC_LICENSE_KEY-??????`],
        }));
        lambdaFunction.addEnvironment('NEW_RELIC_ACCOUNT_ID', props.newRelicAccountId);
        lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_HANDLER', app_handler);
        lambdaFunction.addEnvironment('NEW_RELIC_LAMBDA_EXTENSION_ENABLED', 'true');
        if (props.newRelicwithExtensionSendLogs) {
            lambdaFunction.addEnvironment('NEW_RELIC_EXTENSION_SEND_FUNCTION_LOGS', 'true');
        }
        lambdaFunction.addLayers(this.getNewRelicLayer(scope, lambdaFunction.functionName, props.newRelicLayerName, props.newRelicLayerVersion, env_1.CDK_REGION));
        return lambdaFunction;
    }
    getNewRelicLayer(scope, functionName, layerName, layerVersion, region) {
        return lambda.LayerVersion.fromLayerVersionArn(scope, `new-relic-layer-${functionName}`, `arn:aws:lambda:${region}:${exports.NEW_RELIC_LAYERS_ACCOUNT_ID}:layer:${layerName}:${layerVersion}`);
    }
}
exports.FunctionNewRelic = FunctionNewRelic;
_b = JSII_RTTI_SYMBOL_1;
FunctionNewRelic[_b] = { fqn: "neulabs-cdk-constructs.constructs.aws_lambda.FunctionNewRelic", version: "0.1.4" };
//# sourceMappingURL=data:application/json;base64,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