import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export declare const NEW_RELIC_LAYERS_ACCOUNT_ID = "451483290750";
export interface FunctionProps extends lambda.FunctionProps {
    readonly stage: string;
}
export interface FunctionNewRelicProps extends FunctionProps {
    readonly newRelicLayerName: string;
    readonly newRelicLayerVersion: number;
    readonly newRelicAccountId: string;
    readonly newRelicwithExtensionSendLogs?: boolean;
}
declare abstract class BaseFunction extends Construct {
    readonly stage: string;
    readonly function: lambda.Function;
    constructor(scope: Construct, id: string, props: FunctionProps);
    abstract createFunction(scope: Construct, id: string, props: FunctionProps): lambda.Function;
    addEnvironment(props: {
        [key: string]: string;
    }): void;
}
export declare class Function extends BaseFunction {
    constructor(scope: Construct, id: string, props: FunctionProps);
    createFunction(scope: Construct, id: string, props: FunctionNewRelicProps): lambda.Function;
}
export declare class FunctionNewRelic extends BaseFunction {
    constructor(scope: Construct, id: string, props: FunctionNewRelicProps);
    createFunction(scope: Construct, id: string, props: FunctionNewRelicProps): lambda.Function;
    getNewRelicLayer(scope: Construct, functionName: string, layerName: string, layerVersion: number, region: string): lambda.ILayerVersion;
}
export {};
