"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addBaseTags = exports.TagsKey = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const env = require("./env");
var TagsKey;
(function (TagsKey) {
    TagsKey["ENVIRONMENT"] = "Environment";
    TagsKey["TIMESTAMP_DEPLOY_CDK"] = "TimestampDeployCDK";
    TagsKey["BUSINESS_UNIT"] = "BusinessUnit";
    TagsKey["DOMAIN"] = "Domain";
    TagsKey["REPOSITORY_NAME"] = "RepositoryName";
    TagsKey["REPOSITORY_VERSION"] = "RepositoryVersion";
})(TagsKey = exports.TagsKey || (exports.TagsKey = {}));
function addBaseTags(module, props) {
    aws_cdk_lib_1.Tags.of(module).add(TagsKey.ENVIRONMENT, env.ENVIRONMENT);
    aws_cdk_lib_1.Tags.of(module).add(TagsKey.TIMESTAMP_DEPLOY_CDK, env.TIMESTAMP_DEPLOY_CDK);
    let businessUnit = props?.businessUnit ?? env.BUSINESS_UNIT;
    if (businessUnit) {
        aws_cdk_lib_1.Tags.of(module).add(TagsKey.BUSINESS_UNIT, businessUnit);
    }
    let domain = props?.domain ?? env.DOMAIN;
    if (domain) {
        aws_cdk_lib_1.Tags.of(module).add(TagsKey.DOMAIN, domain);
    }
    let repositoryName = props?.repositoryName ?? env.REPOSITORY_NAME;
    if (repositoryName) {
        aws_cdk_lib_1.Tags.of(module).add(TagsKey.REPOSITORY_NAME, repositoryName);
    }
    let repositoryVersion = props?.repositoryVersion ?? env.REPOSITORY_VERSION;
    if (repositoryVersion) {
        aws_cdk_lib_1.Tags.of(module).add(TagsKey.REPOSITORY_VERSION, repositoryVersion);
    }
}
exports.addBaseTags = addBaseTags;
//# sourceMappingURL=data:application/json;base64,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