import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Adds Okta users to groups
 *
 * @schema CfnMembershipProps
 */
export interface CfnMembershipProps {
    /**
     * @schema CfnMembershipProps#GroupId
     */
    readonly groupId: string;
    /**
     * @schema CfnMembershipProps#UserId
     */
    readonly userId: string;
}
/**
 * Converts an object of type 'CfnMembershipProps' to JSON representation.
 */
export declare function toJson_CfnMembershipProps(obj: CfnMembershipProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Okta::Group::Membership`
 *
 * @cloudformationResource Okta::Group::Membership
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-okta-resource-providers.git
 */
export declare class CfnMembership extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Okta::Group::Membership";
    /**
     * Resource props.
     */
    readonly props: CfnMembershipProps;
    /**
     * Create a new `Okta::Group::Membership`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMembershipProps);
}
