# MIT License
# (C) Copyright 2022 Hewlett Packard Enterprise Development LP.
#
# subnets : ECOS subnet sharing

# Though not marked as deprecated in Swagger
# /subnets/configured/{neId} only applies to appliances running ECOS
# 8.1.7.0 or older and as such has not been built in pyedgeconnect


def get_appliance_subnets(
    self,
    ne_id: str,
    cached: bool,
    subnet_filter: str = None,
) -> dict:
    """Get an appliance's subnets information

    .. list-table::
        :header-rows: 1

        * - Swagger Section
          - Method
          - Endpoint
        * - subnets
          - GET
          - /subnets/{getCachedData}/{neId}

    .. note::
        Without use of the ``subnet_filter`` parameter, the response
        data from this query can be quite large if the appliance has
        many routes stored

    :param ne_id: Appliance id in the format of integer.NE e.g. ``3.NE``
    :type ne_id: str
    :param cached: ``True`` retrieves last known value to Orchestrator,
        ``False`` retrieves values directly from Appliance
    :type cached: bool
    :param subnet_filter: The subnet to filter routes received from
        the appliance. Supports IPv4 and IPv6 address types,
        Defaults to None
    :type subnet_filter: str, optional
    :return: Returns dictionary of subnet information \n
        * keyword **subnets** (`dict`): Subnets' statistic information\n
            * keyword **count** (`int`): The current number of the
              subnets on the appliance
            * keyword **max** (`int`): The max number of the subnets
              this appliance can have
            * keyword **entries** (`list`): Each element of this array
              is one object describing a subnet's detail information,
              and the minimum number of the elements is 0 \n
                * keyword **state** (`dict`): IP route data object \n
                    * keyword **version** (`int`): IP version ``4`` or
                      ``6``
                    * keyword **prefix** (`str`): IP CIDR prefix
                    * keyword **nextHop** (`str`): Next hop address, if
                      applicable
                    * keyword **metric** (`int`): Metric for route,
                    * keyword **ifName** (`str`): Interface, if
                      applicable
                    * keyword **peerid** (`int`): NEEDS DESCRIPTION,
                      e.g. ``1849089``
                    * keyword **saas** (`int`): NEEDS DESCRIPTION,
                      e.g. ``0``
                    * keyword **community** (`str`): BGP Community
                      string, e.g. ``1918:111``
                    * keyword **aspath** (`str`): BGP AS-Path, e.g.
                      ``64675,64449``
                    * keyword **learned** (`bool`): ``True`` if learned
                      dynamically
                    * keyword **configured** (`bool`): ``True`` if
                      locally configured
                    * keyword **advert** (`bool`): ``True`` if
                      advertised to peers
                    * keyword **automatic** (`bool`): ``True`` if
                      generated by system
                    * keyword **local** (`bool`): ``True`` if locally
                      configured
                    * keyword **learnedFromIp** (`str`): "3.17.241.185",
                    * keyword **cloudApp** (`bool`): NEEDS DESCRIPTION
                    * keyword **advert_bgp** (`bool`): ``True`` if set
                      to advertise to BGP peers
                    * keyword **advert_ospf** (`bool`): ``True`` if set
                      to advertise to OSPF peers
                    * keyword **learned_bgp** (`bool`): ``True`` if
                      learned via BGP
                    * keyword **learned_ospf** (`bool`): ``True`` if
                      learned via OSPF
                    * keyword **state** (`str`): State of route, e.g.
                      ``UP``
                    * keyword **routeTag** (`str`): Route tag, e.g.
                      ``0``
                    * keyword **learnFrom** (`str`): NEEDS DESCRIPTION
                      e.g. "LRN_SPS_HUB",
                    * keyword **resolvedNexthop** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **resolvedInterface** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **peerType** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **nexthopTunnel** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **networkRegionId** (`str`): Network
                      region ID and name as string e.g. ``1,CENTRAL``
                    * keyword **subnetMessage** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **zone_id** (`str`): "0",
                    * keyword **advOSPFTag** (`str`): "0",
                    * keyword **saasAppName** (`str`): NEEDS DESCRIPTION
                    * keyword **peername** (`str`): Peer appliance
                      hostname for route, e.g. ``DataCenter-EC1``
                    * keyword **peerPriority** (`int`): Peer priority
                      for route, e.g. ``10``
                    * keyword **adminDistance** (`int`): Admin distance
                      for route, e.g. ``10``
        * kewyord **peers** (`list[dict]`): Each element of this array
          is an object describing one peer's detail information, and the
          minimum number of the elements is 0 \n
            * keyword **index** (`str`): "2",
            * keyword **peerid** (`int`): 1861584,
            * keyword **peerName** (`str`): Peer appliance hostname,
              e.g. ``DataCenter-EC1``,
            * keyword **role** (`str`): Role ID, e.g. ``1``
            * keyword **roleName** (`str`): Role name, e.g. ``Hub``
            * keyword **metric** (`int`): Metric, e.g. ``0``
            * keyword **peerPriority** (`int`): Peer priority,
              e.g. ``20``
            * keyword **txtrans** (`int`): NEEDS DESCRIPTION
            * keyword **txsecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxtrans** (`int`): NEEDS DESCRIPTION
            * keyword **rxsecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxrecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxtabs** (`int`): NEEDS DESCRIPTION
            * keyword **outOfOrderCount** (`int`): 0,
            * keyword **majorVersion** (`str`): Major software version
            * keyword **minorVersion** (`str`): Minor software version
            * keyword **pointVersion** (`str`): Point software version
            * keyword **subVersion** (`str`): Sub version
            * keyword **region** (`str`): Region ID, e.g. ``1``
            * keyword **regionName** (`str`): Region name, e.g.
              ``CENTRAL``
            * keyword **messageVersion** (`str`): "6",
            * keyword **message** (`str`): Submsg Ver6 (>= Rel9.0 or
              main)
            * keyword **priorTxSec** (`str`): NEEDS DESCRIPTION
            * keyword **mainVerAndRegion** (`str`): Software version and
              region in (), e.g. ``9.1.1.0 (1)``
            * keyword **peername** (`str`): Peer name, e.g.
              ``DataCenter-EC1``,
            * keyword **prio** (`int`): Peer priority as int,
              e.g. ``20``
        * keyword **moduleInfo** (`dict`): Module information from
          appliance \n
            * keyword **my system id** (`str`): System ID,
              e.g. ``1193616``
            * keyword **network region** (`str`): Network region name
              and region ID, e.g. ``CENTRAL (1)``
            * keyword **network role** (`str`): Network role, e.g.
              ``Hub`` or ``Spoke``
            * keyword **allow management to leak** (`str`): NEEDS
              DESCRIPTION, string bool e.g. ``false``
            * keyword **last peer index** (`str`): NEEDS DESCRIPTION
            * keyword **local change** (`str`): NEEDS DESCRIPTION
            * keyword **last time** (`str`): NEEDS DESCRIPTION, e.g.
              ``424265 ms after boot``
            * keyword **last change** (`str`): NEEDS DESCRIPTION, e.g.
              ``171923 ms after boot``
            * keyword **time since change** (`str`): NEEDS DESCRIPTION,
              e.g. ``252 seconds``
            * keyword **last tx trans** (`str`): NEEDS DESCRIPTION
            * keyword **last tx rec count** (`str`): NEEDS DESCRIPTION
            * keyword **last tx msg count** (`str`): NEEDS DESCRIPTION
            * keyword **rx invalid msg** (`str`): NEEDS DESCRIPTION
            * keyword **rx unknown msg** (`str`): NEEDS DESCRIPTION
            * keyword **IP tracking** (`str`): NEEDS DESCRIPTION,
              e.g. ``ENABLED``
            * keyword **IP track delta** (`str`): NEEDS DESCRIPTION,
              e.g. ``0``
            * keyword **Active READER index** (`str`): NEEDS
              DESCRIPTION, e.g. ``0``
    :rtype: dict
    """
    path = "/subnets/{}/{}".format(cached, ne_id)

    if subnet_filter is not None:
        path = path + "?subnet={}".format(subnet_filter)

    return self._get(path)


def get_discovered_appliance_subnets(
    self,
    discovered_id: str,
) -> dict:
    """Get an appliance's subnets information

    .. list-table::
        :header-rows: 1

        * - Swagger Section
          - Method
          - Endpoint
        * - subnets
          - GET
          - /subnets/forDiscovered/{discoveredId}

    :param discovered_id: Appliance discovered id, e.g. ``1462``
    :type discovered_id: str
    :return: Returns dictionary of subnet information \n
        * keyword **subnets** (`dict`): Subnets' statistic information\n
            * keyword **count** (`int`): The current number of the
              subnets on the appliance
            * keyword **max** (`int`): The max number of the subnets
              this appliance can have
            * keyword **entries** (`list`): Each element of this array
              is one object describing a subnet's detail information,
              and the minimum number of the elements is 0 \n
                * keyword **state** (`dict`): IP route data object \n
                    * keyword **version** (`int`): IP version ``4`` or
                      ``6``
                    * keyword **prefix** (`str`): IP CIDR prefix
                    * keyword **nextHop** (`str`): Next hop address, if
                      applicable
                    * keyword **metric** (`int`): Metric for route,
                    * keyword **ifName** (`str`): Interface, if
                      applicable
                    * keyword **peerid** (`int`): NEEDS DESCRIPTION,
                      e.g. ``1849089``
                    * keyword **saas** (`int`): NEEDS DESCRIPTION,
                      e.g. ``0``
                    * keyword **community** (`str`): BGP Community
                      string, e.g. ``1918:111``
                    * keyword **aspath** (`str`): BGP AS-Path, e.g.
                      ``64675,64449``
                    * keyword **learned** (`bool`): ``True`` if learned
                      dynamically
                    * keyword **configured** (`bool`): ``True`` if
                      locally configured
                    * keyword **advert** (`bool`): ``True`` if
                      advertised to peers
                    * keyword **automatic** (`bool`): ``True`` if
                      generated by system
                    * keyword **local** (`bool`): ``True`` if locally
                      configured
                    * keyword **learnedFromIp** (`str`): "3.17.241.185",
                    * keyword **cloudApp** (`bool`): NEEDS DESCRIPTION
                    * keyword **advert_bgp** (`bool`): ``True`` if set
                      to advertise to BGP peers
                    * keyword **advert_ospf** (`bool`): ``True`` if set
                      to advertise to OSPF peers
                    * keyword **learned_bgp** (`bool`): ``True`` if
                      learned via BGP
                    * keyword **learned_ospf** (`bool`): ``True`` if
                      learned via OSPF
                    * keyword **state** (`str`): State of route, e.g.
                      ``UP``
                    * keyword **routeTag** (`str`): Route tag, e.g.
                      ``0``
                    * keyword **learnFrom** (`str`): NEEDS DESCRIPTION
                      e.g. "LRN_SPS_HUB",
                    * keyword **resolvedNexthop** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **resolvedInterface** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **peerType** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **nexthopTunnel** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **networkRegionId** (`str`): Network
                      region ID and name as string e.g. ``1,CENTRAL``
                    * keyword **subnetMessage** (`str`):
                      NEEDS DESCRIPTION
                    * keyword **zone_id** (`str`): "0",
                    * keyword **advOSPFTag** (`str`): "0",
                    * keyword **saasAppName** (`str`): NEEDS DESCRIPTION
                    * keyword **peername** (`str`): Peer appliance
                      hostname for route, e.g. ``DataCenter-EC1``
                    * keyword **peerPriority** (`int`): Peer priority
                      for route, e.g. ``10``
                    * keyword **adminDistance** (`int`): Admin distance
                      for route, e.g. ``10``
            * keyword **disabledByIPSLA** (`bool`): ``True`` if routes
              have been disabled by an IPSLA, ``False`` if not
            * keyword **metricAddedByIPSLA** (`int`): Metric added to
              routes by IPSLA, e.g. ``0``
        * kewyord **peers** (`list[dict]`): Each element of this array
          is an object describing one peer's detail information, and the
          minimum number of the elements is 0 \n
            * keyword **index** (`str`): "2",
            * keyword **peerid** (`int`): 1861584,
            * keyword **peerName** (`str`): Peer appliance hostname,
              e.g. ``DataCenter-EC1``,
            * keyword **role** (`str`): Role ID, e.g. ``1``
            * keyword **roleName** (`str`): Role name, e.g. ``Hub``
            * keyword **metric** (`int`): Metric, e.g. ``0``
            * keyword **peerPriority** (`int`): Peer priority,
              e.g. ``20``
            * keyword **txtrans** (`int`): NEEDS DESCRIPTION
            * keyword **txsecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxtrans** (`int`): NEEDS DESCRIPTION
            * keyword **rxsecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxrecs** (`int`): NEEDS DESCRIPTION
            * keyword **rxtabs** (`int`): NEEDS DESCRIPTION
            * keyword **outOfOrderCount** (`int`): 0,
            * keyword **majorVersion** (`str`): Major software version
            * keyword **minorVersion** (`str`): Minor software version
            * keyword **pointVersion** (`str`): Point software version
            * keyword **subVersion** (`str`): Sub version
            * keyword **region** (`str`): Region ID, e.g. ``1``
            * keyword **regionName** (`str`): Region name, e.g.
              ``CENTRAL``
            * keyword **messageVersion** (`str`): "6",
            * keyword **message** (`str`): Submsg Ver6 (>= Rel9.0 or
              main)
            * keyword **priorTxSec** (`str`): NEEDS DESCRIPTION
            * keyword **mainVerAndRegion** (`str`): Software version and
              region in (), e.g. ``9.1.1.0 (1)``
            * keyword **peername** (`str`): Peer name, e.g.
              ``DataCenter-EC1``,
            * keyword **prio** (`int`): Peer priority as int,
              e.g. ``20``
        * keyword **moduleInfo** (`dict`): Module information from
          appliance \n
            * keyword **my system id** (`str`): System ID,
              e.g. ``1193616``
            * keyword **network region** (`str`): Network region name
              and region ID, e.g. ``CENTRAL (1)``
            * keyword **network role** (`str`): Network role, e.g.
              ``Hub`` or ``Spoke``
            * keyword **allow management to leak** (`str`): NEEDS
              DESCRIPTION, string bool e.g. ``false``
            * keyword **last peer index** (`str`): NEEDS DESCRIPTION
            * keyword **local change** (`str`): NEEDS DESCRIPTION
            * keyword **last time** (`str`): NEEDS DESCRIPTION, e.g.
              ``424265 ms after boot``
            * keyword **last change** (`str`): NEEDS DESCRIPTION, e.g.
              ``171923 ms after boot``
            * keyword **time since change** (`str`): NEEDS DESCRIPTION,
              e.g. ``252 seconds``
            * keyword **last tx trans** (`str`): NEEDS DESCRIPTION
            * keyword **last tx rec count** (`str`): NEEDS DESCRIPTION
            * keyword **last tx msg count** (`str`): NEEDS DESCRIPTION
            * keyword **rx invalid msg** (`str`): NEEDS DESCRIPTION
            * keyword **rx unknown msg** (`str`): NEEDS DESCRIPTION
            * keyword **IP tracking** (`str`): NEEDS DESCRIPTION,
              e.g. ``ENABLED``
            * keyword **IP track delta** (`str`): NEEDS DESCRIPTION,
              e.g. ``0``
            * keyword **Active READER index** (`str`): NEEDS
              DESCRIPTION, e.g. ``0``
    :rtype: dict
    """
    return self._get("/subnets/forDiscovered/{}".format(discovered_id))


def set_appliance_subnet_sharing_options(
    self,
    ne_id: str,
    use_sdwan_routes: bool,
    advertise_local: bool,
    advertise_local_lan: bool,
    advertise_local_wan: bool,
) -> bool:
    """Configure appliance's subnet sharing options

    .. list-table::
        :header-rows: 1

        * - Swagger Section
          - Method
          - Endpoint
        * - subnets
          - GET
          - /subnets/setSubnetSharingOptions/{neId}

    :param ne_id: Appliance id in the format of integer.NE e.g. ``3.NE``
    :type ne_id: str
    :param use_sdwan_routes: Whether or not to Use SD-WAN Fabric Learned
        Routes
    :type use_sdwan_routes: bool
    :param advertise_local: Flag to control Automatically Advertising
        local subnets. This field is only applicable for older
        appliances whose version is less than 8.1.4.
    :type advertise_local: bool
    :param advertise_local_lan: Flag to control Automatically advertise
        local LAN subnets. This field is only applicable for appliances
        whose version is greater than or equal to 8.1.4.,
    :type advertise_local_lan: bool
    :param advertise_local_wan: Flag to control Automatically advertise
        local WAN subnets. This field is only applicable for appliances
        whose version is greater than or equal to 8.1.4.
    :type advertise_local_wan: bool
    :return: Returns True/False based on successful call
    :rtype: bool
    """
    data = {
        "auto_subnet": {
            "self": use_sdwan_routes,
            "add_local": advertise_local,
            "add_local_lan": advertise_local_lan,
            "add_local_wan": advertise_local_wan,
        }
    }
    return self._post(
        "/subnets/setSubnetSharingOptions/{}".format(ne_id),
        data=data,
        expected_status=[204],
        return_type="bool",
    )
